var SERVICE_REVIEW = SERVICE_REVIEW || {};

(function ($) {
  "use strict";

  SERVICE_REVIEW = {
    init: function () {
      SERVICE_REVIEW.submit_review();
      SERVICE_REVIEW.clearErrorHandlers();
    },

    clearErrorHandlers: function() {
      function clearErrorOnForm($form) {
        var $errorMsg = $form.find('.felan-message-error');
        if ($errorMsg.length) {
          $errorMsg.fadeOut().html('');
        }
      }

      $(document).on('input change', '.reviewForm textarea[name="message"]', function() {
        var $form = $(this).closest('.reviewForm');
        clearErrorOnForm($form);
      });

      $(document).on('change', '.reviewForm input[type="radio"][name^="rating_"]', function() {
        var $form = $(this).closest('.reviewForm');
        clearErrorOnForm($form);
      });

      $(document).on('click', '.reviewForm .btn-close, .reviewForm .bg-overlay, .reviewForm .button-cancel', function (e) {
        var $form = $(this).closest('.reviewForm');
        if ($form.length) {
          clearErrorOnForm($form);
        }
      });
    },

    submit_review: function () {
      var ajax_url = felan_service_review_vars.ajax_url;
      var service_review = $(".service-review-details");

      service_review.find("input:file").change(function () {
        $(".fileList span").remove();
        for (var i = 0; i < this.files.length; i++) {
          var fileName = this.files[i].name;
          $(".fileList").append("<span>" + fileName + "</span>");
        }
      });

      service_review.find(".entry-nav .reply").on("click", function (e) {
        e.preventDefault();
        $(".author-review").removeClass("active");
        $(".author-review .form-reply").html("");
        var $this = $(this);
        var form_reply = $(".duplicate-form-reply").html();
        var comment_id = $this
          .parents(".author-review")
          .find(".form-reply")
          .data("id");
        $(".add-new-review").hide();
        $this.parents(".author-review").addClass("active");
        $this.parents(".author-review").find(".form-reply").html(form_reply);
        $this
          .parents(".author-review")
          .find('.form-reply input[name="comment_id"]')
          .val(comment_id);
      });

      $("body").on(
        "click",
        ".form-reply .felan-submit-service-reply",
        function (e) {
          e.preventDefault();
          var $this = $(this);
          var $form = $this.parents("form");
          var message = $form.find("textarea").val();
          if (message == "") {
            $form.find("#message-error").fadeIn();
          } else {
            $form.find("#message-error").fadeOut();

            $.ajax({
              type: "POST",
              url: ajax_url,
              data: $form.serialize(),
              dataType: "json",
              beforeSend: function () {
                $this.attr("disabled", true);
                $this.children("i").remove();
                $this.append(
                  '<i class="fa-left fal fa-spinner fa-spin large"></i>'
                );
              },
              success: function () {
                window.location.reload();
              },
              complete: function () {
                $this.children("i").removeClass("fal fa-spinner fa-spin large");
                $this.children("i").addClass("fa fa-check");
              },
            });
          }
        }
      );

      $("body").on("click", ".cancel-reply", function (e) {
        e.preventDefault();
        service_review.find(".author-review").removeClass("active");
        service_review.find(".author-review .form-reply").html("");
        service_review.find(".add-new-review").show();
      });

      $(document).on("submit", ".reviewForm", function(e) {
        var $form = $(this);
        var action = $form.find('input[name="action"]').val();
        
        if (action === 'felan_service_submit_review_ajax') {
          e.preventDefault();
          e.stopImmediatePropagation();
          e.stopPropagation();
          
          if ($form.data('validator')) {
            $form.removeData('validator');
            $form.unbind('submit');
          }
          
          var service_id = $form.find('input[name="service_id"]').val();
          var order_id = $form.find('input[name="order_id"]').val();
          var message = $form.find('textarea[name="message"]').val();
          var rating_salary = $form.find('input[name="rating_salary"]:checked').val();
          var rating_service = $form.find('input[name="rating_service"]:checked').val();
          var rating_skill = $form.find('input[name="rating_skill"]:checked').val();
          var rating_work = $form.find('input[name="rating_work"]:checked').val();
          var nonce = $form.find('input[name="nonce"]').val();
          
          var $errorMsg = $form.find('.felan-message-error');
          
          function showError(message) {
            if ($errorMsg.length) {
              $errorMsg.html('<span class="error-text">' + message + '</span>').fadeIn();
            } else {
              alert(message);
            }
          }
          
          function hideError() {
            if ($errorMsg.length) {
              $errorMsg.fadeOut().html('');
            }
          }
          
          if (!service_id) {
            showError(felan_service_review_vars.errors.service_id_missing);
            return false;
          }
          hideError();
          
          if (!message || message.trim() === '') {
            showError(felan_service_review_vars.errors.message_required);
            return false;
          }
          hideError();
          
          if (!rating_salary || !rating_service || !rating_skill || !rating_work) {
            showError(felan_service_review_vars.errors.ratings_required);
            return false;
          }
          
          var $this = $form.find("#btn-submit-review, .felan-submit-service-rating");
          var formDataToSend = $form.serialize();
          
          $.ajax({
            type: "POST",
            url: ajax_url,
            data: formDataToSend,
            dataType: "json",
            beforeSend: function () {
              $this.children("i").remove();
              $this.append(
                '<i class="fa-left fal fa-spinner fa-spin large"></i>'
              );
            },
            success: function (data) {
              if (data.success) {
                hideError();
                window.location.reload();
              } else {
                var errorMessage = data.data && data.data.message ? data.data.message : felan_service_review_vars.errors.submission_failed;
                showError(errorMessage);
              }
            },
            error: function (xhr, status, error) {
              var errorMsg = felan_service_review_vars.errors.submit_error;
              if (xhr.responseText) {
                try {
                  var response = JSON.parse(xhr.responseText);
                  if (response.data && response.data.message) {
                    errorMsg = response.data.message;
                  }
                } catch (e) {
                }
              }
              showError(errorMsg);
            },
            complete: function () {
              $this.children("i").removeClass("fal fa-spinner fa-spin large");
              $this.children("i").addClass("fa fa-check");
            },
          });
          
          return false;
        }
        
      });
    },
  };

  $(document).ready(SERVICE_REVIEW.init());
})(jQuery);


