Civi Theme - One Click Demo Import Implementation Review
Tài liệu này xem xét và mô tả chi tiết cách thức triển khai tính năng Import Demo Data trong theme Civi, sử dụng plugin One Click Demo Import (OCDI).

1. Tổng quan
Theme Civi không tự xây dựng lại toàn bộ quy trình import mà tích hợp sâu với plugin One Click Demo Import. Theme sử dụng các "hooks" (filters và actions) của OCDI để:

Định nghĩa các gói demo (content, widgets, theme options).
Thực hiện các thao tác xử lý dữ liệu trước và sau khi import (ví dụ: cài đặt trang chủ, menu, Elementor setting).
2. Cấu trúc File & Class chính
Các file cốt lõi chịu trách nhiệm cho tính năng này bao gồm:

2.1.
class-plugins.php
Vị trí:
src/civi/includes/class-plugins.php
Chức năng: Khai báo và yêu cầu cài đặt plugin One Click Demo Import. Đây là bước đầu tiên để đảm bảo môi trường có đủ công cụ hỗ trợ import.
2.2.
class-civi-import.php
Vị trí:
plugins/civi-framework/includes/class-civi-import.php
Class:
Civi_Demo_Importer
Chức năng: Đây là "bộ não" của quá trình import. Class này thực hiện các nhiệm vụ:
Đăng ký Demo: Sử dụng filter ocdi/import_files để khai báo các file demo (XML, JSON, DAT).
Import Theme Options: Xử lý import các thiết lập của theme.
Import Elementor: Import các cấu hình Global và Kit của Elementor.
Hậu xử lý (After Import): Cài đặt Menu, Trang chủ (Homepage), Trang Blog, và dọn dẹp URL.
2.3.
class-civi-admin-setup.php
Vị trí:
plugins/civi-framework/includes/admin/class-civi-admin-setup.php
Chức năng: Tạo trang Welcome trong Dashboard (Civi > Welcome). Trang này chứa nút "Install Sample Data" dẫn người dùng trực tiếp đến giao diện của plugin OCDI (Appearance > Import Demo Data).
3. Quy trình hoạt động chi tiết
Bước 1: Khởi tạo và Đăng ký Demo
Khi theme được kích hoạt,
Civi_Demo_Importer
 được khởi tạo. Nó móc (hook) vào ocdi/import_files để trả về danh sách các demo khả dụng:

Civi Jobs Board: Demo mặc định cho trang tuyển dụng.
Civi Freelancer: Demo cho nền tảng freelancer.
Mỗi demo bao gồm đường dẫn đến các file dữ liệu nằm trong thư mục plugins/civi-framework/assets/import/:

content.xml: Nội dung bài viết, trang, sản phẩm.
widgets.json: Cấu hình Widget.
customizer.dat: Cấu hình Customizer.
theme-options.json: Cấu hình Theme Options.
elementor.json: Cấu hình Elementor (được xử lý riêng).
Bước 2: Import Nội dung (OCDI xử lý)
Khi người dùng bấm "Import" trên giao diện OCDI, plugin này sẽ tải xuống và import các file XML, JSON, DAT đã định nghĩa.

Bước 3: Import Theme Options & Elementor (Custom Logic)
Trong quá trình import, Civi_Demo_Importer can thiệp vào:

import_theme_options: Đọc file theme-options.json, xử lý thay thế URL (thay URL demo bằng URL site hiện tại) và lưu vào database.
setElementorSettings: Được gọi tại hook ocdi/after_content_import (hoặc hook tương đương khi OCDI chạy xong). Hàm này đọc elementor.json, import các Global Settings (màu sắc, font chữ) và Kit Settings của Elementor.
Bước 4: Hậu xử lý (After Import Setup)
Sau khi OCDI hoàn tất việc import cơ bản, hook ocdi/after_import kích hoạt hàm afterImportSetup. Các tác vụ quan trọng được thực hiện:

Thiết lập Menu (setMenus):

Tìm các menu có tên "Main Menu", "Mobile Menu".
Gán chúng vào các vị trí (locations) tương ứng trong theme (main_menu, mobile_menu).
Nếu không tìm thấy, hệ thống sẽ tự tạo menu mặc định.
Thiết lập Trang (setPages):

Tìm trang "Home 01" (hoặc "Freelance 01") và đặt làm Trang chủ (Front Page).
Tìm trang "Blogs" và đặt làm Trang bài viết (Posts Page).
Lưu ID của các trang chức năng quan trọng (Dashboard, Post Job, Profile...) vào Theme Options để hệ thống hoạt động đúng.
Xử lý Dữ liệu Elementor & URL:

civi_replace_demo_domain: Quét toàn bộ nội dung post, meta, options để thay thế URL của site demo cũ bằng URL hiện tại của người dùng.
refresh_elementor_cache: Xóa cache Elementor để CSS mới được tái tạo.
Các tác vụ dọn dẹp khác:

fix_fontawesome_icons: Đảm bảo icon hiển thị đúng.
Xóa các transient cache.
4. Frontend Script (import.js)
File plugins/civi-framework/assets/js/import.js chứa các đoạn script xử lý UI phụ trợ. Mặc dù OCDI có UI riêng, nhưng file này có vẻ hỗ trợ các tính năng như:

Refresh Transients: Nút làm mới dữ liệu tạm.
Plugin Actions: Kích hoạt/Vô hiệu hóa plugin từ giao diện theme.
Custom Import Popup (Legacy/Advanced): Có code xử lý popup import riêng (#civi-import-demo-popup), có thể được sử dụng trong các ngữ cảnh setup wizard cụ thể hoặc là phương án dự phòng/nâng cao ngoài luồng OCI chuẩn.
5. Kết luận
Triển khai import của Civi tuân theo chuẩn WordPress hiện đại: Tận dụng plugin chuyên dụng (OCDI) thay vì tự viết lại từ đầu (Reinventing the wheel), nhưng vẫn bổ sung logic tùy chỉnh mạnh mẽ để xử lý các phần phức tạp như Elementor và liên kết trang (Page Mapping). Điều này giúp quá trình import ổn định và dễ bảo trì.
