# Kế hoạch Triển khai One Click Demo Import (OCDI) cho Felan Theme

## 1. Mô tả (Description)
Chuyển đổi hệ thống nhập dữ liệu demo của theme Felan từ Custom Importer hiện tại sang sử dụng plugin **One Click Demo Import (OCDI)**.

**Mục tiêu:**
- **Chuẩn hóa quy trình:** Sử dụng plugin phổ biến, giúp người dùng dễ dàng làm quen và thao tác.
- **Giảm tải bảo trì:** Tận dụng core của OCDI để xử lý việc upload, parsing XML, và các lỗi timeout/AJAX, thay vì phải tự duy trì code custom phức tạp.
- **Khả năng mở rộng:** Dễ dàng tích hợp thêm các bước xử lý sau khi import (After Import) thông qua hooks.

**Phạm vi công việc:**
Tích hợp OCDI vào `felan-framework` plugin, thay thế (hoặc chạy song song) với importer cũ.

## 2. Các bước triển khai (Implementation Tasks)

### 2.1. Chuẩn bị (Preparation)
- [ ] **Xác minh Data Demo:** Đảm bảo đã có các file dữ liệu mẫu trong thư mục `plugins/felan-framework/assets/import/{demo_key}/`:
    - `content.xml`: Dữ liệu bài viết, trang, sản phẩm.
    - `widgets.wie` (hoặc `.json`): Cấu hình Widget.
    - `theme-options.json`: Cấu hình Redux Framework.
    - `customizer.dat`: Cấu hình Customizer (nếu có).
    - `preview.jpg`: Ảnh preview của demo.

### 2.2. Cấu hình Plugin Dependencies
- [ ] **Cập nhật TGM Plugin Activation (`src/felan/includes/class-plugins.php`):**
    ```php
    [
        'name'     => 'One Click Demo Import',
        'slug'     => 'one-click-demo-import',
        'required' => false, // Recommended
    ]
    ```

### 2.3. Tạo Class xử lý OCDI Import
- [ ] **Tạo file mới:** `plugins/felan-framework/includes/class-felan-ocdi-import.php`
- [ ] **Implement các hook chính:**

#### Hook 1: Đăng ký Demo Files (`ocdi/import_files`)
```php
add_filter('ocdi/import_files', [$this, 'import_files']);

public function import_files() {
    return [
        [
            'import_file_name'           => 'Felan Jobboard',
            'import_file_url'            => FELAN_PLUGIN_URL . 'assets/import/01/content.xml',
            'import_widget_file_url'     => FELAN_PLUGIN_URL . 'assets/import/01/widgets.wie',
            'import_redux'               => [
                [
                    'file_url'    => FELAN_PLUGIN_URL . 'assets/import/01/theme-options.json',
                    'option_name' => 'felan-framework',
                ],
            ],
            'import_preview_image_url'   => FELAN_PLUGIN_URL . 'assets/import/01/preview.jpg',
            'preview_url'                => 'https://felan.ricetheme.com',
        ],
        [
            'import_file_name'           => 'Felan Freelance',
            'import_file_url'            => FELAN_PLUGIN_URL . 'assets/import/02/content.xml',
            'import_widget_file_url'     => FELAN_PLUGIN_URL . 'assets/import/02/widgets.wie',
            'import_redux'               => [
                [
                    'file_url'    => FELAN_PLUGIN_URL . 'assets/import/02/theme-options.json',
                    'option_name' => 'felan-framework',
                ],
            ],
            'import_preview_image_url'   => FELAN_PLUGIN_URL . 'assets/import/02/preview.jpg',
            'preview_url'                => 'https://felan.ricetheme.com/freelance',
        ],
    ];
}
```

#### Hook 2: Xử lý After Import (`ocdi/after_import`)
- [ ] **Set Menu Locations:**
    ```php
    $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');
    $mobile_menu = get_term_by('name', 'Mobile Menu', 'nav_menu');

    set_theme_mod('nav_menu_locations', [
        'primary'     => $main_menu->term_id,
        'mobile_menu' => $mobile_menu->term_id,
    ]);
    ```

- [ ] **Set Front Page & Posts Page:**
    ```php
    $front_page = get_page_by_title('Home 01');
    $blog_page = get_page_by_title('Blogs');

    update_option('show_on_front', 'page');
    update_option('page_on_front', $front_page->ID);
    update_option('page_for_posts', $blog_page->ID);
    ```

- [ ] **Import Elementor Settings (nếu cần):**
    ```php
    \Elementor\Plugin::$instance->files_manager->clear_cache();
    ```

- [ ] **Replace URLs (tùy chọn):**
    - Thay thế URL demo cũ thành URL site hiện tại trong postmeta, options.

### 2.4. Tích hợp vào Core
- [ ] **Require class trong `class-felan-core.php`:**
    ```php
    // OCDI Integration
    if (class_exists('OCDI_Plugin')) {
        require_once FELAN_PLUGIN_DIR . 'includes/class-felan-ocdi-import.php';
        Felan_OCDI_Import::instance();
    }
    ```

### 2.5. Kiểm thử (Testing)
- [ ] **Test Import trên site local:**
    - Cài đặt OCDI plugin
    - Vào `Appearance > Import Demo Data`
    - Chọn demo "Jobboard" hoặc "Freelance"
    - Click Import
    - Verify:
        - [ ] Menu hiển thị đúng
        - [ ] Front page là "Home 01"
        - [ ] Blog page là "Blogs"
        - [ ] Widgets hiển thị ở sidebar
        - [ ] Theme options được import (check Redux panel)

### 2.6. Dọn dẹp (Cleanup)
- [ ] **Quyết định với Custom Importer cũ:**
    - **Tùy chọn 1:** Giữ lại để phục vụ user cũ (đã từng dùng), ẩn menu trong admin.
    - **Tùy chọn 2:** Xóa hoàn toàn code của `Felan_Importer` để giảm codebase.

- [ ] **Update documentation:**
    - Cập nhật hướng dẫn cài đặt trong theme documentation.

## 3. Cấu trúc File Dự kiến

```
plugins/felan-framework/
├── includes/
│   ├── class-felan-ocdi-import.php      [NEW] Class chính xử lý OCDI hooks
│   ├── class-felan-core.php              [MODIFY] Require OCDI class
├── assets/
│   ├── import/
│       ├── 01/                           [Demo Jobboard]
│       │   ├── content.xml
│       │   ├── widgets.wie
│       │   ├── theme-options.json
│       │   └── preview.jpg
│       ├── 02/                           [Demo Freelance]
│           ├── content.xml
│           ├── widgets.wie
│           ├── theme-options.json
│           └── preview.jpg

src/felan/
├── includes/
    ├── class-plugins.php                 [MODIFY] Thêm OCDI vào TGM list
```

## 4. Tham khảo (References)
- **OCDI Documentation:** https://github.com/awesomemotive/one-click-demo-import/wiki
- **Civi Theme Implementation:** `plugins/felan-framework/docs/civi-ocdi.md`
- **OCDI Redux Extension:** https://github.com/awesomemotive/one-click-demo-import#redux-framework-import

## 5. Lưu ý (Notes)
- OCDI tự động xử lý Redux import nếu dùng key `import_redux` trong config.
- Nếu cần import Revolution Slider, phải dùng hook riêng hoặc manual import sau.
- Có thể tùy chỉnh giao diện OCDI bằng CSS hoặc sử dụng Grid mode.
