<?php
/**
 * Felan Metaboxes Trait
 * Extracted from class-felan-admin.php for better maintainability
 *
 * @package Felan_Framework
 */

if (!defined('ABSPATH')) {
    exit;
}

trait Felan_Metaboxes_Trait
{
    /**
     * Register meta boxes
     * @param $configs
     * @return mixed
     */
		public function register_meta_boxes($configs)
		{
			$meta_prefix = FELAN_METABOX_PREFIX;
			$dec_point = felan_get_option('decimal_separator', '.');
			$format_number = '^[0-9]+([' . $dec_point . '][0-9]+)?$';

			//Custom field jobs
			$render_custom_field_jobs = felan_render_custom_field('jobs');
			$custom_field_jobs = array();
			if (count($render_custom_field_jobs) > 0) {
				$custom_field_jobs = array(
					array(
						'id' => "{$meta_prefix}custom_field_jobs_tab",
						'title' => esc_html__('Additional Fields', 'felan-framework'),
						'icon' => 'dashicons dashicons-welcome-add-page',
						'fields' => $render_custom_field_jobs
					),
				);
			}

			//Custom field company
			$render_custom_field_company = felan_render_custom_field('company');

			//Custom field project
			$render_custom_field_project = felan_render_custom_field('project');

			$render_custom_field_service = felan_render_custom_field('service');


			//Custom field freelancer
			$render_custom_field_freelancer = felan_render_custom_field('freelancer');
			$custom_field_freelancer = array();
			if (count($render_custom_field_freelancer) > 0) {
				$custom_field_freelancer = array(
					array(
						'id' => "{$meta_prefix}custom_field_freelancer_tab",
						'title' => esc_html__('Additional Fields', 'felan-framework'),
						'icon' => 'dashicons dashicons-welcome-add-page',
						'fields' => $render_custom_field_freelancer
					),
				);
			}

			$freelancer_package_service = $freelancer_package_service_featured = $freelancer_package_jobs_apply = $freelancer_package_jobs_wishlist =
				$freelancer_package_project_apply = $freelancer_package_project_alerts = $freelancer_package_company_follow = $freelancer_package_contact_company = $freelancer_package_info_company =
				$freelancer_package_send_message = $freelancer_package_review_and_commnent = array();


			//Package Service
			$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
			if ($enable_post_type_service == '1') {
				$freelancer_package_service = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}enable_package_service_unlimited",
							'title' => esc_html__('Unlimited Service', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "{$meta_prefix}freelancer_package_number_service",
							'title' => esc_html__('Number Service', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array("{$meta_prefix}enable_package_service_unlimited", '=', '0'),
						),
					)
				);
				$freelancer_package_service_featured = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}enable_package_service_featured_unlimited",
							'title' => esc_html__('Unlimited Service Featured', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "{$meta_prefix}freelancer_package_number_service_featured",
							'title' => esc_html__('Number Featured Service', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array("{$meta_prefix}enable_package_service_featured_unlimited", '=', '0'),
						),
					)
				);
			}

			//Single Service
			$services_custom_package = array();
			$package_service = felan_get_option('package_service');
			$service_id = get_the_ID();
			if (is_array($package_service) && !empty($package_service)) {
				foreach ($package_service as $key => $value) {
					//                    $service_package_title_key = FELAN_METABOX_PREFIX . 'service_package_title' . $key;
					//                    $service_package_title = get_post_meta($service_id, $service_package_title_key, true);

					$default_value = array();
					$services_custom_package[] = array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}service_package_title{$key}",
								'title' => esc_html__('Title', 'felan-framework'),
								'default' => $value['package_service_title'],
								'type' => 'text',
								'col' => '6',
							),
							array(
								'id' => "{$meta_prefix}service_package_list{$key}",
								'type' => 'checkbox_list',
								'title' => esc_html__('Package', 'felan-framework'),
								'options' =>  array(
									'basic' => esc_html__('Basic', 'felan-framework'),
									'standard' => esc_html__('Standard', 'felan-framework'),
									'premium' => esc_html__('Premium', 'felan-framework'),
								),
								'value_inline' => true,
								'default' => $default_value,
								'col' => '6',
							),
						),
					);
				}
			}

			$services_custom_package0 = isset($services_custom_package[0]) ? $services_custom_package[0] : array();
			$services_custom_package1 = isset($services_custom_package[1]) ? $services_custom_package[1] : array();
			$services_custom_package2 = isset($services_custom_package[2]) ? $services_custom_package[2] : array();
			$services_custom_package3 = isset($services_custom_package[3]) ? $services_custom_package[3] : array();
			$services_custom_package4 = isset($services_custom_package[4]) ? $services_custom_package[4] : array();
			$services_custom_package5 = isset($services_custom_package[5]) ? $services_custom_package[5] : array();
			$services_custom_package6 = isset($services_custom_package[6]) ? $services_custom_package[6] : array();
			$services_custom_package7 = isset($services_custom_package[7]) ? $services_custom_package[7] : array();
			$services_custom_package8 = isset($services_custom_package[8]) ? $services_custom_package[8] : array();

			$service_location_city =  array(
				'id' => "{$meta_prefix}service_location_city",
				'title' => esc_html__('Locations City', 'felan-framework'),
				'type' => 'select',
				'options'  => felan_get_option_city(),
				'col' => '4',
			);

			$configs['service_meta_boxes'] = apply_filters('felan_register_meta_boxes_service', array(
				'name' => esc_html__('Service Information', 'felan-framework'),
				'post_type' => array('service'),
				'section' => array_merge(
					apply_filters('felan_register_meta_boxes_service_top', array()),
					apply_filters(
						'felan_register_meta_boxes_service_main',
						array_merge(
							array(
								array(
									'id' => "{$meta_prefix}details_service_basic",
									'title' => esc_html__('Basic', 'felan-framework'),
									'icon' => 'dashicons dashicons-admin-home',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}service_featured",
											'title' => esc_html__('Mark this service as featured ?', 'felan-framework'),
											'type' => 'button_set',
											'col' => '4',
											'options' => array(
												'1' => esc_html__('Yes', 'felan-framework'),
												'0' => esc_html__('No', 'felan-framework'),
											),
											'default' => '0',
										),
									)
								),
								array(
									'id' => "{$meta_prefix}details_service_pricing",
									'title' => esc_html__('Pricing', 'felan-framework'),
									'icon' => 'dashicons dashicons-buddicons-replies',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}service_quantity",
													'title' => esc_html__('Package Quantity', 'felan-framework'),
													'type' => 'select',
													'options'  => array(
														'1' => '1',
														'2' => '2',
														'3' => '3',
													),
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}service_time",
													'title' => esc_html__('Time Type', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'hr' => esc_html__('Hour', 'felan-framework'),
														'day' => esc_html__('Day', 'felan-framework'),
														'week' => esc_html__('Week', 'felan-framework'),
														'month' => esc_html__('Month', 'felan-framework'),
													),
													'col' => '4',
													'default' => 'hr',
												),
											)
										),
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}service_basic_price",
													'title' => esc_html__('Price(Basic))', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
												),
												array(
													'id' => "{$meta_prefix}service_basic_time",
													'title' => esc_html__('Delivery Time(Basic)', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
												),
												array(
													'id' => "{$meta_prefix}service_basic_revisions",
													'title' => esc_html__('Revisions(Basic)', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'none' => esc_html__('None', 'felan-framework'),
														'unlimited' => esc_html__('Unlimited', 'felan-framework'),
														'custom' => esc_html__('Custom', 'felan-framework'),
													),
													'col' => '3',
													'default' => 'none',
												),
												array(
													'id' => "{$meta_prefix}service_basic_number_revisions",
													'title' => esc_html__('Number Of Revisions(Basic)', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
													'required' => array("{$meta_prefix}service_basic_revisions", '=', 'custom'),
												),
												array(
													'id' => "{$meta_prefix}service_basic_des",
													'title' => esc_html__('Description (Basic)', 'felan-framework'),
													'type' => 'textarea',
													'col' => '12',
												),
											)
										),
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}service_standard_price",
													'title' => esc_html__('Price(Standard))', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
													'required' => array(
														"{$meta_prefix}service_quantity",
														'!=',
														'1',
														"{$meta_prefix}service_quantity",
														'=',
														'2'
													),
												),
												array(
													'id' => "{$meta_prefix}service_standard_time",
													'title' => esc_html__('Delivery Time(Standard)', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
													'required' => array(
														"{$meta_prefix}service_quantity",
														'!=',
														'1',
														"{$meta_prefix}service_quantity",
														'=',
														'2'
													),
												),
												array(
													'id' => "{$meta_prefix}service_standard_revisions",
													'title' => esc_html__('Revisions(Standard)', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'none' => esc_html__('None', 'felan-framework'),
														'unlimited' => esc_html__('Unlimited', 'felan-framework'),
														'custom' => esc_html__('Custom', 'felan-framework'),
													),
													'col' => '3',
													'default' => 'none',
													'required' => array(
														"{$meta_prefix}service_quantity",
														'!=',
														'1',
														"{$meta_prefix}service_quantity",
														'=',
														'2'
													),
												),
												array(
													'id' => "{$meta_prefix}service_standard_number_revisions",
													'title' => esc_html__('Number Of Revisions(Standard)', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
													'required' => array(
														"{$meta_prefix}service_standard_revisions",
														'=',
														'custom',
														"{$meta_prefix}service_quantity",
														'!=',
														'1',
														"{$meta_prefix}service_quantity",
														'=',
														'2'
													),
												),
												array(
													'id' => "{$meta_prefix}service_standard_des",
													'title' => esc_html__('Description (Standard)', 'felan-framework'),
													'type' => 'textarea',
													'col' => '12',
													'required' => array(
														"{$meta_prefix}service_quantity",
														'!=',
														'1',
														"{$meta_prefix}service_quantity",
														'=',
														'2'
													),
												),
											)
										),
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}service_premium_price",
													'title' => esc_html__('Price(Premium))', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
													'required' => array("{$meta_prefix}service_quantity", '=', '3'),
												),
												array(
													'id' => "{$meta_prefix}service_premium_time",
													'title' => esc_html__('Delivery Time(Premium)', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
													'required' => array("{$meta_prefix}service_quantity", '=', '3'),
												),
												array(
													'id' => "{$meta_prefix}service_premium_revisions",
													'title' => esc_html__('Revisions(Premium)', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'none' => esc_html__('None', 'felan-framework'),
														'unlimited' => esc_html__('Unlimited', 'felan-framework'),
														'custom' => esc_html__('Custom', 'felan-framework'),
													),
													'col' => '3',
													'default' => 'none',
													'required' => array("{$meta_prefix}service_quantity", '=', '3'),
												),
												array(
													'id' => "{$meta_prefix}service_number_premium_revisions",
													'title' => esc_html__('Number Of Revisions(Premium)', 'felan-framework'),
													'type' => 'text',
													'col' => '3',
													'required' => array(
														"{$meta_prefix}service_premium_revisions",
														'=',
														'custom',
														"{$meta_prefix}service_quantity",
														'=',
														'3'
													),
												),
												array(
													'id' => "{$meta_prefix}service_premium_des",
													'title' => esc_html__('Description (Premium)', 'felan-framework'),
													'type' => 'textarea',
													'col' => '12',
													'required' => array("{$meta_prefix}service_quantity", '=', '3'),
												),
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}details_service_package_new",
									'title' => esc_html__('Package', 'felan-framework'),
									'icon' => 'dashicons dashicons-excerpt-view',
									'fields' => array(

										$services_custom_package0,
										$services_custom_package1,
										$services_custom_package2,
										$services_custom_package3,
										$services_custom_package4,
										$services_custom_package5,
										$services_custom_package6,
										$services_custom_package7,
										$services_custom_package8,

										array(
											'id' => "{$meta_prefix}service_package_new",
											'type' => 'panel',
											'title' => esc_html__('Package New', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}service_package_new_title",
															'title' => esc_html__('Title', 'felan-framework'),
															'type' => 'text',
															'col' => '6',
														),
														array(
															'id' => "{$meta_prefix}service_package_new_list",
															'type' => 'checkbox_list',
															'title' => esc_html__('Package', 'felan-framework'),
															'options' =>  array(
																'basic' => esc_html__('Basic', 'felan-framework'),
																'standard' => esc_html__('Standard', 'felan-framework'),
																'premium' => esc_html__('Premium', 'felan-framework'),
															),
															'value_inline' => true,
															'default' => array(),
															'col' => '6',
														),
													)
												)
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}details_service_addons",
									'title' => esc_html__('Add-ons', 'felan-framework'),
									'icon' => 'dashicons dashicons-carrot',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}service_tab_addon",
											'type' => 'panel',
											'title' => esc_html__('Add ons', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}service_addons_title",
															'title' => esc_html__('Title', 'felan-framework'),
															'type' => 'text',
															'col' => '4',
														),
														array(
															'id' => "{$meta_prefix}service_addons_price",
															'title' => esc_html__('Price', 'felan-framework'),
															'type' => 'text',
															'col' => '4',
														),
														array(
															'id' => "{$meta_prefix}service_addons_time",
															'title' => esc_html__('Delivery Time', 'felan-framework'),
															'type' => 'text',
															'col' => '4',
														),
													)
												)
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}details_service_faq",
									'title' => esc_html__('Faqs', 'felan-framework'),
									'icon' => 'dashicons dashicons-palmtree',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}service_tab_faq",
											'type' => 'panel',
											'title' => esc_html__('Faqs', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}service_faq_title",
															'title' => esc_html__('Title', 'felan-framework'),
															'type' => 'text',
															'col' => '12',
														),
														array(
															'id' => "{$meta_prefix}service_faq_description",
															'title' => esc_html__('Description', 'felan-framework'),
															'type' => 'textarea',
															'col' => '12',
														),
													)
												)
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}location_tab",
									'title' => esc_html__('Location', 'felan-framework'),
									'icon' => 'dashicons-location-alt',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												$service_location_city,
												array(
													'id' => "{$meta_prefix}service_address",
													'title' => esc_html__('Maps location', 'felan-framework'),
													'desc' => esc_html__('Full Address', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}service_latitude",
													'title' => esc_html__('Latitude', 'felan-framework'),
													'desc' => esc_html__('Latitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}service_longtitude",
													'title' => esc_html__('Longtitude', 'felan-framework'),
													'desc' => esc_html__('Longtitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}service_location",
													'title' => esc_html__('Service Location at Google Map', 'felan-framework'),
													'desc' => esc_html__('Drag the google map marker to point your service location.', 'felan-framework'),
													'type' => 'map',
													'address_field' => "{$meta_prefix}service_address",
												),
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}gallery_service_tab",
									'title' => esc_html__('Gallery Images', 'felan-framework'),
									'icon' => 'dashicons-format-gallery',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}service_images",
											'title' => esc_html__('Gallery', 'felan-framework'),
											'type' => 'gallery',
										),
									)
								),
								array(
									'id' => "{$meta_prefix}video_service_tab",
									'title' => esc_html__('Video', 'felan-framework'),
									'icon' => 'dashicons-video-alt3',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}service_video_url",
											'title' => esc_html__('Video URL', 'felan-framework'),
											'desc' => esc_html__('Input only URL. YouTube, Vimeo, SWF File and MOV File', 'felan-framework'),
											'type' => 'text',
											'col' => 12,
										),
										array(
											'id' => "{$meta_prefix}service_video_image",
											'title' => esc_html__('Video Image', 'felan-framework'),
											'type' => 'gallery',
											'col' => 12,
										),
									)
								),
								array(
									'id' => "{$meta_prefix}custom_field_service_tab",
									'title' => esc_html__('Additional Fields', 'felan-framework'),
									'icon' => 'dashicons dashicons-welcome-add-page',
									'fields' => $render_custom_field_service
								)
							)
						)
					),
					apply_filters('felan_register_meta_boxes_service_bottom', array())
				),
			));
			//Order Service
			$configs['service_order_meta_boxes'] = array(
				'name' => esc_html__('Service Order Settings', 'felan-framework'),
				'post_type' => array('service_order'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}service_order_payment_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'pending' => esc_html__('Pending', 'felan-framework'),
									'inprogress' => esc_html__('In Process', 'felan-framework'),
									'canceled' => esc_html__('Canceled', 'felan-framework'),
									'completed' => esc_html__('Completed', 'felan-framework'),
								),
								'default' => 'pending',
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}service_order_user_id",
								'title' => esc_html__('User Order id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}service_order_author_service",
								'title' => esc_html__('Author Service', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}service_order_item_id",
								'title' => esc_html__('Package id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}service_order_price",
								'title' => esc_html__('Price', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}service_order_date",
								'title' => esc_html__('Activate Date', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}service_order_payment_method",
								'title' => esc_html__('Payment Method', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
						)
					),
				),
			);

			//Disputes
			$configs['disputes_meta_boxes'] = array(
				'name' => esc_html__('Disputes Settings', 'felan-framework'),
				'post_type' => array('disputes'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}disputes_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'open' => esc_html__('Open', 'felan-framework'),
									'close' => esc_html__('Close', 'felan-framework'),
									'refund' => esc_html__('Refunded', 'felan-framework'),
								),
								'default' => 'open',
							),
						)
					),
				),
			);

			//Project Disputes
			$configs['project_disputes_meta_boxes'] = array(
				'name' => esc_html__('Disputes Settings', 'felan-framework'),
				'post_type' => array('project_disputes'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}project_disputes_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'open' => esc_html__('Open', 'felan-framework'),
									'close' => esc_html__('Close', 'felan-framework'),
									'refund' => esc_html__('Refunded', 'felan-framework'),
								),
								'default' => 'open',
							),
						)
					),
				),
			);

			//Withdrawals
			$configs['freelancer_withdraw_meta_boxes'] = array(
				'name' => esc_html__('Freelancer Withdraw Settings', 'felan-framework'),
				'post_type' => array('freelancer_withdraw'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}freelancer_withdraw_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'pending' => esc_html__('Pending', 'felan-framework'),
									'completed' => esc_html__('Completed', 'felan-framework'),
									'canceled' => esc_html__('Canceled', 'felan-framework'),
								),
								'default' => 'pending',
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}freelancer_withdraw_user_id",
								'title' => esc_html__('User Id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '6',
							),
							array(
								'id' => "{$meta_prefix}freelancer_withdraw_payment_method",
								'title' => esc_html__('Payment method refund', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '6',
							),
							array(
								'id' => "{$meta_prefix}freelancer_withdraw_price",
								'title' => esc_html__('Price', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '6',
							),
							array(
								'id' => "{$meta_prefix}freelancer_withdraw_total_price",
								'title' => esc_html__('Available Balance', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '6',
							),
						)
					),
				),
			);

			//Employer Withdrawals
			$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');
			if ($enable_wallet_mode == '1') {
				$configs['employer_withdraw_meta_boxes'] = array(
					'name' => esc_html__('Freelancer Withdraw Settings', 'felan-framework'),
					'post_type' => array('employer_withdraw'),
					'fields' => array(
						array(
							'type' => 'row',
							'col' => '12',
							'fields' => array(
								array(
									'id' => "{$meta_prefix}employer_withdraw_status",
									'title' => esc_html__('Status', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'pending' => esc_html__('Pending', 'felan-framework'),
										'completed' => esc_html__('Completed', 'felan-framework'),
										'canceled' => esc_html__('Canceled', 'felan-framework'),
									),
									'default' => 'pending',
								),
							)
						),
						array(
							'type' => 'row',
							'col' => '12',
							'fields' => array(
								array(
									'id' => "{$meta_prefix}employer_withdraw_user_id",
									'title' => esc_html__('User Id', 'felan-framework'),
									'default' => '',
									'type' => 'text',
									'col' => '6',
								),
								array(
									'id' => "{$meta_prefix}employer_withdraw_payment_method",
									'title' => esc_html__('Payment method refund', 'felan-framework'),
									'default' => '',
									'type' => 'text',
									'col' => '6',
								),
								array(
									'id' => "{$meta_prefix}employer_withdraw_price",
									'title' => esc_html__('Price', 'felan-framework'),
									'default' => '',
									'type' => 'text',
									'col' => '6',
								),
								array(
									'id' => "{$meta_prefix}employer_withdraw_total_price",
									'title' => esc_html__('Available Balance', 'felan-framework'),
									'default' => '',
									'type' => 'text',
									'col' => '6',
								),
							)
						),
					),
				);
			}

			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			if (felan_get_option('enable_freelancer_package_jobs_apply') === '1' && $enable_post_type_jobs == '1') {
				$freelancer_package_jobs_apply = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}show_package_jobs_apply",
							'title' => esc_html__('Show Jobs Apply', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "{$meta_prefix}enable_package_jobs_apply_unlimited",
							'title' => esc_html__('Unlimited Jobs Apply', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
							'required' => array("{$meta_prefix}show_package_jobs_apply", '=', '1'),
						),
						array(
							'id' => "{$meta_prefix}freelancer_package_number_jobs_apply",
							'title' => esc_html__('Number Jobs Apply', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array(
								array("{$meta_prefix}show_package_jobs_apply", '=', '1'),
								array("{$meta_prefix}enable_package_jobs_apply_unlimited", '!=', '1')
							),
						),
					)
				);
			}

			if (felan_get_option('enable_freelancer_package_jobs_wishlist') === '1' && $enable_post_type_jobs == '1') {
				$freelancer_package_jobs_wishlist = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}show_package_jobs_wishlist",
							'title' => esc_html__('Show Jobs Wishlist', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "{$meta_prefix}enable_package_jobs_wishlist_unlimited",
							'title' => esc_html__('Unlimited Jobs Wishlist', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
							'required' => array(
								array("{$meta_prefix}show_package_jobs_wishlist", '=', '1'),
							),
						),
						array(
							'id' => "{$meta_prefix}freelancer_package_number_jobs_wishlist",
							'title' => esc_html__('Number Jobs Wishlist', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array(
								array("{$meta_prefix}show_package_jobs_wishlist", '=', '1'),
								array("{$meta_prefix}enable_package_jobs_wishlist_unlimited", '!=', '1')
							),
						),
					)
				);
			}

			if (felan_get_option('enable_freelancer_package_company_follow') === '1') {
				$freelancer_package_company_follow = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}show_package_company_follow",
							'title' => esc_html__('Show Company Follow', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "{$meta_prefix}enable_package_freelancer_follow_unlimited",
							'title' => esc_html__('Unlimited Company Follow', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
							'required' => array(
								array("{$meta_prefix}show_package_company_follow", '=', '1'),
							),
						),
						array(
							'id' => "{$meta_prefix}freelancer_package_number_company_follow",
							'title' => esc_html__('Number Company Follow', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array(
								array("{$meta_prefix}show_package_company_follow", '=', '1'),
								array("{$meta_prefix}enable_package_freelancer_follow_unlimited", '!=', '1')
							),
						),
					)
				);
			}

			if (felan_get_option('enable_freelancer_package_contact_company') === '1' && $enable_post_type_jobs == '1') {
				$freelancer_package_contact_company = array(
					'id' => "{$meta_prefix}show_package_contact_company",
					'title' => esc_html__('View contact company in jobs', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			if (felan_get_option('enable_freelancer_package_info_company') === '1') {
				$freelancer_package_info_company =  array(
					'id' => "{$meta_prefix}show_package_info_company",
					'title' => esc_html__('View info company', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			if (felan_get_option('enable_freelancer_package_send_message') === '1') {
				$freelancer_package_send_message =  array(
					'id' => "{$meta_prefix}show_package_send_message",
					'title' => esc_html__('Send messages', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			if (felan_get_option('enable_freelancer_package_review_and_commnent') === '1') {
				$freelancer_package_review_and_commnent =  array(
					'id' => "{$meta_prefix}show_package_review_and_commnent",
					'title' => esc_html__('Review and Comment', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '',
				);
			}

			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			if (felan_get_option('enable_freelancer_package_project_apply') === '1' && $enable_post_type_project == '1') {
				$freelancer_package_project_apply = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}show_package_project_apply",
							'title' => esc_html__('Show Project Apply', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "{$meta_prefix}enable_package_project_apply_unlimited",
							'title' => esc_html__('Unlimited Project Apply', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
							'required' => array("{$meta_prefix}show_package_project_apply", '=', '1'),
						),
						array(
							'id' => "{$meta_prefix}freelancer_package_number_project_apply",
							'title' => esc_html__('Number Project Apply', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array(
								array("{$meta_prefix}show_package_project_apply", '=', '1'),
								array("{$meta_prefix}enable_package_project_apply_unlimited", '!=', '1')
							),
						),
					)
				);
			}

			// Project Alerts Package Fields
			$enable_project_package_alerts = felan_get_option('enable_project_package_alerts', '1');
			$enable_package_specific_settings = felan_get_option('enable_project_package_specific_settings', '1');
			// Only show package fields if package-specific settings are enabled
			if ($enable_post_type_project == '1' && $enable_project_package_alerts == '1' && $enable_package_specific_settings == '1') {
				// Get allowed taxonomies from Theme Options (when package-specific is enabled, use all available)
				$allowed_taxonomies = array('categories', 'skills', 'language', 'career', 'location');

				// Add 'state' if enable_option_state is enabled
				$enable_option_state = felan_get_option('enable_option_state', '0');
				if ($enable_option_state === '1') {
					$allowed_taxonomies[] = 'state';
				}

				// Define taxonomy fields mapping
				$taxonomy_fields_map = array(
					'categories' => array(
						'max' => array(
							'id' => "{$meta_prefix}package_project_alerts_max_categories",
							'title' => esc_html__('Max Categories per Alert', 'felan-framework'),
							'default' => '5',
							'desc' => esc_html__('Maximum number of categories that can be selected per alert (0 for unlimited)', 'felan-framework'),
						),
						'unlimited' => array(
							'id' => "{$meta_prefix}enable_package_project_alerts_unlimited_categories",
							'title' => esc_html__('Unlimited Categories', 'felan-framework'),
							'desc' => esc_html__('Allow unlimited categories per alert', 'felan-framework'),
						),
					),
					'skills' => array(
						'max' => array(
							'id' => "{$meta_prefix}package_project_alerts_max_skills",
							'title' => esc_html__('Max Skills per Alert', 'felan-framework'),
							'default' => '10',
							'desc' => esc_html__('Maximum number of skills that can be selected per alert (0 for unlimited)', 'felan-framework'),
						),
						'unlimited' => array(
							'id' => "{$meta_prefix}enable_package_project_alerts_unlimited_skills",
							'title' => esc_html__('Unlimited Skills', 'felan-framework'),
							'desc' => esc_html__('Allow unlimited skills per alert', 'felan-framework'),
						),
					),
					'language' => array(
						'max' => array(
							'id' => "{$meta_prefix}package_project_alerts_max_language",
							'title' => esc_html__('Max Languages per Alert', 'felan-framework'),
							'default' => '5',
							'desc' => esc_html__('Maximum number of languages that can be selected per alert (0 for unlimited)', 'felan-framework'),
						),
						'unlimited' => array(
							'id' => "{$meta_prefix}enable_package_project_alerts_unlimited_language",
							'title' => esc_html__('Unlimited Languages', 'felan-framework'),
							'desc' => esc_html__('Allow unlimited languages per alert', 'felan-framework'),
						),
					),
					'career' => array(
						'max' => array(
							'id' => "{$meta_prefix}package_project_alerts_max_career",
							'title' => esc_html__('Max Careers per Alert', 'felan-framework'),
							'default' => '5',
							'desc' => esc_html__('Maximum number of careers that can be selected per alert (0 for unlimited)', 'felan-framework'),
						),
						'unlimited' => array(
							'id' => "{$meta_prefix}enable_package_project_alerts_unlimited_career",
							'title' => esc_html__('Unlimited Careers', 'felan-framework'),
							'desc' => esc_html__('Allow unlimited careers per alert', 'felan-framework'),
						),
					),
					'location' => array(
						'max' => array(
							'id' => "{$meta_prefix}package_project_alerts_max_location",
							'title' => esc_html__('Max Locations per Alert', 'felan-framework'),
							'default' => '3',
							'desc' => esc_html__('Maximum number of locations that can be selected per alert (0 for unlimited)', 'felan-framework'),
						),
						'unlimited' => array(
							'id' => "{$meta_prefix}enable_package_project_alerts_unlimited_location",
							'title' => esc_html__('Unlimited Locations', 'felan-framework'),
							'desc' => esc_html__('Allow unlimited locations per alert', 'felan-framework'),
						),
					),
					'state' => array(
						'max' => array(
							'id' => "{$meta_prefix}package_project_alerts_max_state",
							'title' => esc_html__('Max States per Alert', 'felan-framework'),
							'default' => '3',
							'desc' => esc_html__('Maximum number of states that can be selected per alert (0 for unlimited)', 'felan-framework'),
						),
						'unlimited' => array(
							'id' => "{$meta_prefix}enable_package_project_alerts_unlimited_state",
							'title' => esc_html__('Unlimited States', 'felan-framework'),
							'desc' => esc_html__('Allow unlimited states per alert', 'felan-framework'),
						),
					),
				);

				// Build fields array - organize like jobs_apply pattern
				// Each taxonomy is a separate row with col='4' (Show -> Unlimited -> Number)
				$package_rows = array();

				// First row: Number of Project Alerts (keep as is)
				$package_rows[] = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}package_number_project_alerts",
							'title' => esc_html__('Number of Project Alerts', 'felan-framework'),
							'type' => 'text',
							'default' => '3',
							'pattern' => '[0-9]*',
							'required' => array('enable_project_package_alerts', '=', '1'),
						),
					)
				);

				// Each taxonomy gets its own row: Show -> Unlimited -> Number (only show when Unlimited = No)
				foreach ($allowed_taxonomies as $taxonomy) {
					if (isset($taxonomy_fields_map[$taxonomy])) {
						$tax_config = $taxonomy_fields_map[$taxonomy];

						// Build taxonomy label for field titles
						$taxonomy_labels = array(
							'categories' => esc_html__('Categories', 'felan-framework'),
							'skills' => esc_html__('Skills', 'felan-framework'),
							'language' => esc_html__('Languages', 'felan-framework'),
							'career' => esc_html__('Careers', 'felan-framework'),
							'location' => esc_html__('Locations', 'felan-framework'),
							'state' => esc_html__('States', 'felan-framework'),
						);
						$taxonomy_label = isset($taxonomy_labels[$taxonomy]) ? $taxonomy_labels[$taxonomy] : ucfirst($taxonomy);

						$show_field_id = "{$meta_prefix}show_package_project_alerts_{$taxonomy}";
						$unlimited_field_id = $tax_config['unlimited']['id'];
						$max_field_id = $tax_config['max']['id'];

						$package_rows[] = array(
							'type' => 'row',
							'col' => '4',
							'fields' => array(
								array(
									'id' => $show_field_id,
									'title' => sprintf(esc_html__('Show %s', 'felan-framework'), $taxonomy_label),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '0',
									'required' => array('enable_project_package_alerts', '=', '1'),
								),
								array(
									'id' => $unlimited_field_id,
									'title' => sprintf(esc_html__('Unlimited %s', 'felan-framework'), $taxonomy_label),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '0',
									'required' => array($show_field_id, '=', '1'),
								),
								array(
									'id' => $max_field_id,
									'title' => sprintf(esc_html__('Max %s per Alert', 'felan-framework'), $taxonomy_label),
									'type' => 'text',
									'default' => isset($tax_config['max']['default']) ? $tax_config['max']['default'] : '5',
									'pattern' => '[0-9]*',
									'required' => array(
										array($show_field_id, '=', '1'),
										array($unlimited_field_id, '!=', '1'),
									),
								),
							)
						);
					}
				}

				$freelancer_package_project_alerts = $package_rows;
			}
			//Company Package
			$company_package_download_cv_freelancer = $company_package_freelancer_follow  = $company_package_invite_freelancer = $company_package_send_message_freelancer =
				$company_package_print_freelancer = $company_package_review_freelancer = $company_package_info_freelancer = array();

			if (felan_get_option('enable_company_package_download_cv') === '1') {
				$company_package_download_cv_freelancer = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}show_package_company_download_cv",
							'title' => esc_html__('Download CV', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "{$meta_prefix}enable_package_download_cv_unlimited",
							'title' => esc_html__('Unlimited Download CV', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
							'required' => array("{$meta_prefix}show_package_company_download_cv", '=', '1'),
						),
						array(
							'id' => "{$meta_prefix}company_package_number_download_cv",
							'title' => esc_html__('Number Download CV', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array(
								array("{$meta_prefix}show_package_company_download_cv", '=', '1'),
								array("{$meta_prefix}enable_package_download_cv_unlimited", '!=', '1')
							),
						),
					)
				);
			}

			if (felan_get_option('enable_company_package_freelancer_follow') === '1') {
				$company_package_freelancer_follow = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						array(
							'id' => "{$meta_prefix}show_package_company_freelancer_follow",
							'title' => esc_html__('Show Freelancer Follow', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "{$meta_prefix}enable_package_freelancer_follow_unlimited",
							'title' => esc_html__('Unlimited Freelancer Follow', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
							'required' => array("{$meta_prefix}show_package_company_freelancer_follow", '=', '1'),
						),
						array(
							'id' => "{$meta_prefix}company_package_number_freelancer_follow",
							'title' => esc_html__('Number Freelancer Follow', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'pattern' => '[0-9]*',
							'required' => array(
								array("{$meta_prefix}show_package_company_freelancer_follow", '=', '1'),
								array("{$meta_prefix}enable_package_freelancer_follow_unlimited", '!=', '1')
							),
						),
					)
				);
			}


			if (felan_get_option('enable_company_package_invite') === '1') {
				$company_package_invite_freelancer =  array(
					'id' => "{$meta_prefix}show_package_company_invite",
					'title' => esc_html__('Invite Freelancers', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			if (felan_get_option('enable_company_package_send_message') === '1') {
				$company_package_send_message_freelancer =  array(
					'id' => "{$meta_prefix}show_package_company_send_message",
					'title' => esc_html__('Send Messages Freelancer', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			if (felan_get_option('enable_company_package_print') === '1') {
				$company_package_print_freelancer =  array(
					'id' => "{$meta_prefix}show_package_company_print",
					'title' => esc_html__('Print Freelancer Profile', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			if (felan_get_option('enable_company_package_review_and_commnent') === '1') {
				$company_package_review_freelancer =  array(
					'id' => "{$meta_prefix}show_package_company_review_and_commnent",
					'title' => esc_html__('Review And Commnent', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			if (felan_get_option('enable_company_package_info') === '1') {
				$company_package_info_freelancer =  array(
					'id' => "{$meta_prefix}show_package_company_info",
					'title' => esc_html__('View Freelancer Information', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}


			$freelancer_custom_social = array();
			$felan_social_fields = felan_get_option('felan_social_fields');
			if (is_array($felan_social_fields) && !empty($felan_social_fields)) {
				foreach ($felan_social_fields as $key => $value) {
					$freelancer_custom_social[] = array(
						'id' => "{$meta_prefix}freelancer_{$value['social_name']}",
						'title' => $value['social_name'],
						'type' => 'text',
						'col' => '6',
					);
				}
			}

			$freelancer_custom_social0 = isset($freelancer_custom_social[0]) ? $freelancer_custom_social[0] : array();
			$freelancer_custom_social1 = isset($freelancer_custom_social[1]) ? $freelancer_custom_social[1] : array();
			$freelancer_custom_social2 = isset($freelancer_custom_social[2]) ? $freelancer_custom_social[2] : array();
			$freelancer_custom_social3 = isset($freelancer_custom_social[3]) ? $freelancer_custom_social[3] : array();

			$jobs_location_city =  array(
				'id' => "{$meta_prefix}jobs_location_city",
				'title' => esc_html__('Locations City', 'felan-framework'),
				'type' => 'select',
				'options'  => felan_get_option_city(),
				'col' => '4',
			);
			$company_location_city =  array(
				'id' => "{$meta_prefix}company_location_city",
				'title' => esc_html__('Locations City', 'felan-framework'),
				'type' => 'select',
				'options'  => felan_get_option_city(),
				'col' => '4',
			);
			$freelancer_location_city =  array(
				'id' => "{$meta_prefix}freelancer_location_city",
				'title' => esc_html__('Locations City', 'felan-framework'),
				'type' => 'select',
				'options'  => felan_get_option_city(),
				'col' => '4',
			);
			$project_location_city =  array(
				'id' => "{$meta_prefix}project_location_city",
				'title' => esc_html__('Locations City', 'felan-framework'),
				'type' => 'select',
				'options'  => felan_get_option_city(),
				'col' => '4',
			);

			$configs['jobs_meta_boxes'] = apply_filters('felan_register_meta_boxes_jobs', array(
				'name' => esc_html__('Jobs Information', 'felan-framework'),
				'post_type' => array('jobs'),
				'section' => array_merge(
					apply_filters('felan_register_meta_boxes_jobs_top', array()),
					apply_filters(
						'felan_register_meta_boxes_jobs_main',
						array_merge(
							array(
								array(
									'id' => "{$meta_prefix}details_tab",
									'title' => esc_html__('Basic Infomation', 'felan-framework'),
									'icon' => 'dashicons-admin-home',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}enable_jobs_package_expires",
													'type' => 'button_set',
													'title' => esc_html__('Enable package expires', 'felan-framework'),
													'desc' => esc_html__('Turn on when you want package to expire', 'felan-framework'),
													'options' => array(
														'1' => esc_html__('On', 'felan-framework'),
														'0' => esc_html__('Off', 'felan-framework'),
													),
													'col' => '4',
													'default' => '0'
												),

												array(
													'id' => "{$meta_prefix}enable_jobs_expires",
													'type' => 'button_set',
													'title' => esc_html__('Enable jobs expires', 'felan-framework'),
													'desc' => esc_html__('Turn on when you want jobs to expire', 'felan-framework'),
													'options' => array(
														'1' => esc_html__('On', 'felan-framework'),
														'0' => esc_html__('Off', 'felan-framework'),
													),
													'col' => '4',
													'default' => '0'
												),
												array(
													'id' => "{$meta_prefix}jobs_days_closing",
													'title' => esc_html__('Number of days to apply', 'felan-framework'),
													'desc' => esc_html__('Enter the number of days to apply for jobs', 'felan-framework'),
													'default' => '',
													'type' => 'text',
													'col' => '4',
													'required' => array(
														array("{$meta_prefix}enable_jobs_expires", '=', '0'),
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_featured",
													'title' => esc_html__('Mark this jobs as featured ?', 'felan-framework'),
													'type' => 'button_set',
													'col' => '4',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'default' => '0',
												),
												array(
													'id' => "{$meta_prefix}jobs_quantity",
													'title' => esc_html__('Quantity to be recruited ', 'felan-framework'),
													'type' => 'select',
													'desc' => esc_html__('Select quantity', 'felan-framework'),
													'options' => array(
														'' => 'None',
														'1' => '1',
														'2' => '2',
														'3' => '3',
														'4' => '4',
														'5' => '5',
														'6' => '6',
														'7' => '7',
														'8' => '8',
														'9' => '9',
														'10' => '10+',
													),
													'col' => '4',
													'default' => 'quantity1',
												),
											)
										),
									)
								),
							),
							array(
								array(
									'id' => "{$meta_prefix}details_salary",
									'title' => esc_html__('Salary', 'felan-framework'),
									'icon' => 'dashicons dashicons-money-alt',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}jobs_salary_show",
													'title' => esc_html__('Show pay by', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'range' => 'Range',
														'starting_amount' => 'Starting amount',
														'maximum_amount' => 'Maximum amount',
														'agree' => 'Negotiable Price',
													),
													'col' => '4',
													'default' => 'range',
												),
												array(
													'id' => "{$meta_prefix}jobs_salary_rate",
													'title' => esc_html__('Rate', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'' => esc_html('None', 'felan-framework'),
														'hour' => esc_html('Per Hour', 'felan-framework'),
														'day' => esc_html('Per Day', 'felan-framework'),
														'week' => esc_html('Per Week', 'felan-framework'),
														'month' => esc_html('Per Month', 'felan-framework'),
														'year' => esc_html('Per Year', 'felan-framework'),
													),
													'col' => '4',
													'default' => 'hour',
													'required' => array(
														array("{$meta_prefix}jobs_salary_show", '!=', 'agree')
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_currency_type",
													'title' => esc_html__('Currency Type', 'felan-framework'),
													'type' => 'select',
													'options' => felan_get_select_currency_type(),
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}jobs_salary_minimum",
													'title' => esc_html__('Minimum', 'felan-framework'),
													'desc' => esc_html__('Example Value: 450', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '450',
													'col' => '4',
													'required' => array(
														array("{$meta_prefix}jobs_salary_show", '=', 'range')
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_salary_maximum",
													'title' => esc_html__('Maximum', 'felan-framework'),
													'desc' => esc_html__('Example Value: 900', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '900',
													'col' => '4',
													'required' => array(
														array("{$meta_prefix}jobs_salary_show", '=', 'range')
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_maximum_price",
													'title' => esc_html__('Maximum Price', 'felan-framework'),
													'desc' => esc_html__('Example Value: 1000', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '',
													'col' => '4',
													'required' => array(
														array("{$meta_prefix}jobs_salary_show", '=', 'maximum_amount')
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_minimum_price",
													'title' => esc_html__('Minimum Price', 'felan-framework'),
													'desc' => esc_html__('Example Value: 100', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '',
													'col' => '4',
													'required' => array(
														array("{$meta_prefix}jobs_salary_show", '=', 'starting_amount')
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_salary_convert_min",
													'title' => esc_html__('Convert Min', 'felan-framework'),
													'type' => 'text',
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}jobs_salary_convert_max",
													'title' => esc_html__('Convert Max', 'felan-framework'),
													'type' => 'text',
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}jobs_price_convert_min",
													'title' => esc_html__('Convert Min', 'felan-framework'),
													'type' => 'text',
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}jobs_price_convert_max",
													'title' => esc_html__('Convert Max', 'felan-framework'),
													'type' => 'text',
													'col' => '4',
												),
											)
										),
									)
								)
							),
							array(
								array(
									'id' => "{$meta_prefix}jobs_apply",
									'title' => esc_html__('Apply', 'felan-framework'),
									'icon' => 'dashicons-email',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}jobs_select_apply",
													'title' => esc_html__('Select Type', 'felan-framework'),
													'type' => 'select',
													'col' => 6,
													'options' => apply_filters(
														'felan_fields_select_apply_jobs',
														array(
															'email' => esc_html__('By email', 'felan-framework'),
															'external' => esc_html__('External Apply', 'felan-framework'),
															'internal' => esc_html__('Internal Apply', 'felan-framework'),
															'call-to' => esc_html__('Call To Apply', 'felan-framework'),
														)
													)
												),
												array(
													'id' => "{$meta_prefix}jobs_apply_email",
													'title' => esc_html__('Job apply email', 'felan-framework'),
													'type' => 'text',
													'col' => 6,
													'required' => array(
														array("{$meta_prefix}jobs_select_apply", '=', 'email'),
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_apply_external",
													'title' => esc_html__('Job apply external', 'felan-framework'),
													'type' => 'text',
													'col' => 6,
													'required' => array(
														array("{$meta_prefix}jobs_select_apply", '=', 'external'),
													),
												),
												array(
													'id' => "{$meta_prefix}jobs_apply_call_to",
													'title' => esc_html__('Job Call To Apply', 'felan-framework'),
													'type' => 'text',
													'col' => 6,
													'required' => array(
														array("{$meta_prefix}jobs_select_apply", '=', 'call-to'),
													),
												),
											)
										)
									)
								)
							),
							array(
								array(
									'id' => "{$meta_prefix}jobs_company",
									'title' => esc_html__('Company', 'felan-framework'),
									'icon' => 'dashicons dashicons-building',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}jobs_select_company",
											'title' => esc_html__('Select company', 'felan-framework'),
											'type' => 'select',
											'options' => felan_select_post_company(),
										),
									)
								)
							),
							array(
								array(
									'id' => "{$meta_prefix}location_tab",
									'title' => esc_html__('Location', 'felan-framework'),
									'icon' => 'dashicons-location-alt',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												$jobs_location_city,
												array(
													'id' => "{$meta_prefix}jobs_address",
													'title' => esc_html__('Maps location', 'felan-framework'),
													'desc' => esc_html__('Address Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}jobs_latitude",
													'title' => esc_html__('Latitude', 'felan-framework'),
													'desc' => esc_html__('Latitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}jobs_longtitude",
													'title' => esc_html__('Longtitude', 'felan-framework'),
													'desc' => esc_html__('Longtitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}jobs_location",
													'title' => esc_html__('Jobs Location at Google Map', 'felan-framework'),
													'desc' => esc_html__('Drag the google map marker to point your jobs location. You can also use the address field above to search for your jobs', 'felan-framework'),
													'type' => 'map',
													'address_field' => "{$meta_prefix}jobs_address",
												),
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}gallery_tab",
									'title' => esc_html__('Gallery Images', 'felan-framework'),
									'icon' => 'dashicons-format-gallery',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}jobs_images",
											'title' => esc_html__('Gallery Images', 'felan-framework'),
											'type' => 'gallery',
										),
									)
								),
								array(
									'id' => "{$meta_prefix}video_tab",
									'title' => esc_html__('Video', 'felan-framework'),
									'icon' => 'dashicons-video-alt3',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}jobs_video_url",
											'title' => esc_html__('Video URL', 'felan-framework'),
											'desc' => esc_html__('Input only URL. YouTube, Vimeo, SWF File and MOV File', 'felan-framework'),
											'type' => 'text',
											'col' => 12,
										),
										array(
											'id' => "{$meta_prefix}jobs_video_image",
											'title' => esc_html__('Video Image', 'felan-framework'),
											'type' => 'gallery',
											'col' => 12,
										),
									)
								),
							),
							$custom_field_jobs
						)
					),
					apply_filters('felan_register_meta_boxes_jobs_bottom', array())
				),
			));

			$configs['company_meta_boxes'] = apply_filters('felan_register_meta_boxes_company', array(
				'name' => esc_html__('Company Information', 'felan-framework'),
				'post_type' => array('company'),
				'section' => array_merge(
					apply_filters('felan_register_meta_boxes_company_top', array()),
					apply_filters(
						'felan_register_meta_boxes_company_main',
						array_merge(
							array(
								array(
									'id' => "{$meta_prefix}details_company_tab",
									'title' => esc_html__('Basic Infomation', 'felan-framework'),
									'icon' => 'dashicons-admin-home',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}company_green_tick",
													'type' => 'button_set',
													'title' => esc_html__('Enable Green Tick', 'felan-framework'),
													'subtitle' => esc_html__('Enable/Disable Green Tick', 'felan-framework'),
													'options' => array(
														'1' => esc_html__('On', 'felan-framework'),
														'0' => esc_html__('Off', 'felan-framework'),
													),
													'default' => '0',
												),
												array(
													'id' => "{$meta_prefix}company_website",
													'title' => esc_html__(' Website ', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}company_phone",
													'title' => esc_html__('Phone number', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}company_email",
													'title' => esc_html__('Email', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}company_founded",
													'title' => esc_html__('Founded In', 'felan-framework'),
													'type' => 'select',
													'options' => felan_get_company_founded(false),
													'col' => '6',
												),
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}details_company_social",
									'title' => esc_html__('Social Network', 'felan-framework'),
									'icon' => 'dashicons dashicons-networking',
									'fields' => array(
										array(
											'type' => 'row',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}company_twitter",
													'title' => esc_html__('Twitter', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}company_linkedin",
													'title' => esc_html__('Linkedin', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),

												array(
													'id' => "{$meta_prefix}company_facebook",
													'title' => esc_html__('Facebook', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}company_instagram",
													'title' => esc_html__('Instagram', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
											)
										),
										array(
											'type' => 'divide'
										),
										array(
											'id' => "{$meta_prefix}company_social_tabs",
											'type' => 'panel',
											'title' => esc_html__('Social Network', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}company_social_name",
															'type' => 'select',
															'options' => felan_get_repeater_social(''),
															'col' => '6',
															'title' => esc_html__('Name', 'felan-framework'),
														),
														array(
															'id' => "{$meta_prefix}company_social_url",
															'type' => 'text',
															'col' => '6',
															'title' => esc_html__('Url', 'felan-framework'),
														),
													)
												)
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}company_logo_tab",
									'title' => esc_html__('Logo', 'felan-framework'),
									'icon' => 'dashicons dashicons-format-image',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}company_logo",
													'title' => esc_html__('Logo', 'felan-framework'),
													'type' => 'image',
												),
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}location_tab",
									'title' => esc_html__('Location', 'felan-framework'),
									'icon' => 'dashicons-location-alt',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												$company_location_city,
												array(
													'id' => "{$meta_prefix}company_address",
													'title' => esc_html__('Maps location', 'felan-framework'),
													'desc' => esc_html__('Full Address', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}company_latitude",
													'title' => esc_html__('Latitude', 'felan-framework'),
													'desc' => esc_html__('Latitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}company_longtitude",
													'title' => esc_html__('Longtitude', 'felan-framework'),
													'desc' => esc_html__('Longtitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}company_location",
													'title' => esc_html__('Company Location at Google Map', 'felan-framework'),
													'desc' => esc_html__('Drag the google map marker to point your company location. You can also use the address field above to search for your company', 'felan-framework'),
													'type' => 'map',
													'address_field' => "{$meta_prefix}company_address",
												),
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}gallery_company_tab",
									'title' => esc_html__('Gallery Images', 'felan-framework'),
									'icon' => 'dashicons-format-gallery',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}company_images",
											'title' => esc_html__('Felan Gallery Images', 'felan-framework'),
											'type' => 'gallery',
										),
									)
								),
								array(
									'id' => "{$meta_prefix}video_company_tab",
									'title' => esc_html__('Video', 'felan-framework'),
									'icon' => 'dashicons-video-alt3',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}company_video_url",
											'title' => esc_html__('Video URL', 'felan-framework'),
											'desc' => esc_html__('Input only URL. YouTube, Vimeo, SWF File and MOV File', 'felan-framework'),
											'type' => 'text',
											'col' => 12,
										),
										array(
											'id' => "{$meta_prefix}company_video_image",
											'title' => esc_html__('Video Image', 'felan-framework'),
											'type' => 'gallery',
											'col' => 12,
										),
									)
								),
								array(
									'id' => "{$meta_prefix}custom_field_company_tab",
									'title' => esc_html__('Additional Fields', 'felan-framework'),
									'icon' => 'dashicons dashicons-welcome-add-page',
									'fields' => $render_custom_field_company,
								)
							)
						)
					),
					apply_filters('felan_register_meta_boxes_company_bottom', array())
				),
			));
			$configs['freelancer_meta_boxes'] = apply_filters('felan_register_meta_boxes_freelancer', array(
				'name' => esc_html__('Freelancer Information', 'felan-framework'),
				'post_type' => array('freelancer'),
				'section' => array_merge(
					apply_filters('jobi_register_meta_boxes_freelancer_top', array()),
					apply_filters(
						'jobi_register_meta_boxes_freelancer_main',
						array_merge(
							array(
								array(
									'id' => "{$meta_prefix}details_tab",
									'title' => esc_html__('Basic Infomation', 'felan-framework'),
									'icon' => 'dashicons-admin-home',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}freelancer_first_name",
													'title' => esc_html__('First Name', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}freelancer_last_name",
													'title' => esc_html__('Last Name', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}freelancer_email",
													'title' => esc_html__('Email Address', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}freelancer_phone",
													'title' => esc_html__('Phone Number', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}freelancer_current_position",
													'title' => esc_html__('Current Position', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}freelancer_dob",
													'title' => esc_html__('Date Of Birth', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'pattern' => '(?:19|20)[0-9]{2}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-9])|(?:(?!02)(?:0[1-9]|1[0-2])-(?:30))|(?:(?:0[13578]|1[02])-31))',
													'placeholder' => 'yyyy-mm-dd',
													'maxlength' => '10',
													'col' => '6',
												),
											)
										),


										array(
											'type' => 'divide'
										),

										array(
											'type' => 'row',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}freelancer_offer_salary",
													'title' => esc_html__('Offered Salary', 'felan-framework'),
													'type' => 'text',
													'pattern' => '^[0-9]+([.][0-9]+)?$',
													'default' => '',
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}freelancer_salary_type",
													'title' => esc_html__('Salary Type', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'' => esc_html__('None', 'felan-framework'),
														'hr' => esc_html__('Hourly', 'felan-framework'),
														'day' => esc_html__('Daily', 'felan-framework'),
														'month' => esc_html__('Monthly', 'felan-framework'),
														'year' => esc_html__('Yearly', 'felan-framework'),
													),
													'col' => '4',
													'default' => 'hr',
												),
												array(
													'id' => "{$meta_prefix}freelancer_currency_type",
													'title' => esc_html__('Currency Type', 'felan-framework'),
													'type' => 'select',
													'options' => felan_get_select_currency_type(),
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}freelancer_featured",
													'title' => esc_html__('Mark this freelancer as featured ?', 'felan-framework'),
													'type' => 'button_set',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'default' => '0',
												),
											)
										)
									)
								)
							),

							array(
								array(
									'id' => "{$meta_prefix}details_freelancer_social",
									'title' => esc_html__('Social Network', 'felan-framework'),
									'icon' => 'dashicons dashicons-networking',
									'fields' => array(
										array(
											'type' => 'row',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}freelancer_twitter",
													'title' => esc_html__('Twitter', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}freelancer_linkedin",
													'title' => esc_html__('Linkedin', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),

												array(
													'id' => "{$meta_prefix}freelancer_facebook",
													'title' => esc_html__('Facebook', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),
												array(
													'id' => "{$meta_prefix}freelancer_instagram",
													'title' => esc_html__('Instagram', 'felan-framework'),
													'type' => 'text',
													'col' => '6',
												),

												$freelancer_custom_social0,
												$freelancer_custom_social1,
												$freelancer_custom_social2,
												$freelancer_custom_social3,
											)
										),
										array(
											'type' => 'divide'
										),
										array(
											'id' => "{$meta_prefix}freelancer_social_tabs",
											'type' => 'panel',
											'title' => esc_html__('Social Network', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}freelancer_social_name",
															'type' => 'select',
															'options' => felan_get_repeater_social(''),
															'col' => '6',
															'title' => esc_html__('Name', 'felan-framework'),
														),
														array(
															'id' => "{$meta_prefix}freelancer_social_url",
															'type' => 'text',
															'col' => '6',
															'title' => esc_html__('Url', 'felan-framework'),
														),
													)
												)
											)
										),
									)
								)
							),

							array(
								array(
									'id' => "{$meta_prefix}freelancer_resume_tab",
									'title' => esc_html__('My Resume', 'felan-framework'),
									'icon' => 'dashicons-format-gallery',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}freelancer_resume_id_list",
											'title' => esc_html__('Freelancer Resume', 'felan-framework'),
											'type' => 'file',
										),
									)
								),
								array(
									'id' => "{$meta_prefix}freelancer_location_tab",
									'title' => esc_html__('Location', 'felan-framework'),
									'icon' => 'dashicons-location-alt',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												$freelancer_location_city,
												array(
													'id' => "{$meta_prefix}freelancer_address",
													'title' => esc_html__('Maps location', 'felan-framework'),
													'desc' => esc_html__('Address Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}freelancer_latitude",
													'title' => esc_html__('Latitude', 'felan-framework'),
													'desc' => esc_html__('Latitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}freelancer_longtitude",
													'title' => esc_html__('Longtitude', 'felan-framework'),
													'desc' => esc_html__('Longtitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}freelancer_location",
													'title' => esc_html__('Location at Google Map', 'felan-framework'),
													'desc' => esc_html__('Drag the google map marker to point your freelancer location. You can also use the address field above to search for your freelancer', 'felan-framework'),
													'type' => 'map',
													'address_field' => "{$meta_prefix}freelancer_address",
												),
											)
										)

									)
								),
								array(
									'id' => "{$meta_prefix}freelancer_education_tabs",
									'title' => esc_html__('Education', 'felan-framework'),
									'icon' => 'dashicons-editor-ul',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}freelancer_education_list",
											'type' => 'panel',
											'title' => esc_html__('Education', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}freelancer_education_title",
															'title' => esc_html__('Title', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_education_level",
															'title' => esc_html__('Level of Education', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_education_from",
															'title' => esc_html__('From', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_education_to",
															'title' => esc_html__('To', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_education_description",
															'title' => esc_html__('Description', 'felan-framework'),
															'type' => 'textarea',
															'default' => '',
															'col' => '12'
														),
													)
												)
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}freelancer_experience_tab",
									'title' => esc_html__('Experiencies', 'felan-framework'),
									'icon' => 'dashicons-location-alt',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}freelancer_experience_list",
											'type' => 'panel',
											'title' => esc_html__('Work Experience', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}freelancer_experience_job",
															'title' => esc_html__('Job Title', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_experience_company",
															'title' => esc_html__('Company', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_experience_from",
															'title' => esc_html__('From', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_experience_to",
															'title' => esc_html__('To', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_experience_description",
															'title' => esc_html__('Description', 'felan-framework'),
															'type' => 'textarea',
															'default' => '',
															'col' => '12'
														),
													)
												)
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}freelancer_project_tab",
									'title' => esc_html__('Portfolio', 'felan-framework'),
									'icon' => 'dashicons-format-gallery',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}freelancer_project_list",
											'type' => 'panel',
											'title' => esc_html__('Portfolio', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}freelancer_project_image_id",
															'title' => esc_html__('A screenshot of Portfolio', 'felan-framework'),
															'type' => 'image',
															'default' => '',
															'col' => '12'
														),
														array(
															'id' => "{$meta_prefix}freelancer_project_title",
															'title' => esc_html__('Portfolio Title', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_project_link",
															'title' => esc_html__('Link', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_project_description",
															'title' => esc_html__('Description', 'felan-framework'),
															'type' => 'textarea',
															'default' => '',
															'col' => '12'
														),
													)
												)
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}freelancer_award_tab",
									'title' => esc_html__('Awards', 'felan-framework'),
									'icon' => 'dashicons-video-alt3',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}freelancer_award_list",
											'type' => 'panel',
											'title' => esc_html__('Awards', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}freelancer_award_title",
															'title' => esc_html__('Title', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_award_date",
															'title' => esc_html__('Date Awarded', 'felan-framework'),
															'type' => 'text',
															'default' => '',
															'col' => '6'
														),
														array(
															'id' => "{$meta_prefix}freelancer_award_description",
															'title' => esc_html__('Description', 'felan-framework'),
															'type' => 'textarea',
															'default' => '',
															'col' => '12'
														),
													)
												)
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}freelancer_video_gallery_tab",
									'title' => esc_html__('Video and Gallery', 'felan-framework'),
									'icon' => 'dashicons-video-alt3',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}freelancer_galleries",
											'title' => esc_html__('Gallery', 'felan-framework'),
											'type' => 'gallery',
											'default' => '',
											'col' => '12'
										),
										array(
											'id' => "{$meta_prefix}freelancer_video_url",
											'title' => esc_html__('Video URL', 'felan-framework'),
											'type' => 'text',
											'default' => '',
											'col' => '6'
										),
									)
								),
							),
							$custom_field_freelancer
						)
					),
					apply_filters('jobi_register_meta_boxes_freelancer_bottom', array())
				),
			));


			$package_unlimited_job = $package_number_job = $package_unlimited_job_featured = $package_number_featured
				= $package_unlimited_project = $package_number_project = $package_unlimited_project_featured = $package_number_project_featured = array();
			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			if ($enable_post_type_jobs == '1') {
				$package_unlimited_job = array(
					'id' => "{$meta_prefix}package_unlimited_job",
					'title' => esc_html__('Unlimited Job', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);

				$package_number_job = array(
					'id' => "{$meta_prefix}package_number_job",
					'title' => esc_html__('Number Listings', 'felan-framework'),
					'type' => 'text',
					'default' => '',
					'pattern' => '[0-9]*',
					'required' => array("{$meta_prefix}package_unlimited_job", '=', '0'),
				);
				$package_unlimited_job_featured = array(
					'id' => "{$meta_prefix}package_unlimited_job_featured",
					'title' => esc_html__('Unlimited Job Featured', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
				$package_number_featured = array(
					'id' => "{$meta_prefix}package_number_featured",
					'title' => esc_html__('Number Featured Listings', 'felan-framework'),
					'type' => 'text',
					'default' => '',
					'pattern' => '[0-9]*',
					'required' => array("{$meta_prefix}package_unlimited_job_featured", '=', '0'),
				);
			}

			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			if ($enable_post_type_project == '1') {
				$package_unlimited_project = array(
					'id' => "{$meta_prefix}package_unlimited_project",
					'title' => esc_html__('Unlimited project', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);

				$package_number_project = array(
					'id' => "{$meta_prefix}package_number_project",
					'title' => esc_html__('Number Listings', 'felan-framework'),
					'type' => 'text',
					'default' => '',
					'pattern' => '[0-9]*',
					'required' => array("{$meta_prefix}package_unlimited_project", '=', '0'),
				);

				$package_unlimited_project_featured = array(
					'id' => "{$meta_prefix}package_unlimited_project_featured",
					'title' => esc_html__('Unlimited project Featured', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);

				$package_number_project_featured = array(
					'id' => "{$meta_prefix}package_number_project_featured",
					'title' => esc_html__('Number Featured Listings', 'felan-framework'),
					'type' => 'text',
					'default' => '',
					'pattern' => '[0-9]*',
					'required' => array("{$meta_prefix}package_unlimited_project_featured", '=', '0'),
				);
			}


			$configs['package_meta_boxes'] = array(
				'name' => esc_html__('Package Settings', 'felan-framework'),
				'post_type' => array('package'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							$package_unlimited_job,
							$package_number_job,
						)
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							$package_unlimited_job_featured,
							$package_number_featured,
						)
					),

					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							$package_unlimited_project,
							$package_number_project,
						)
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							$package_unlimited_project_featured,
							$package_number_project_featured,
						)
					),

					$company_package_freelancer_follow,
					$company_package_download_cv_freelancer,
					$result_package = apply_filters('felan_register_field_package_jobs', array()),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							$company_package_invite_freelancer,
							$company_package_send_message_freelancer,
							$company_package_print_freelancer,
							$company_package_review_freelancer,
							$company_package_info_freelancer,
						)
					),
					array(
						'type' => 'divide'
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}package_free",
								'title' => esc_html__('Free package', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '0',
							),
							array(
								'id' => "{$meta_prefix}package_price",
								'title' => esc_html__('Package Price', 'felan-framework'),
								'type' => 'text',
								'required' => array("{$meta_prefix}package_free", '=', '0'),
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}package_unlimited_time",
								'title' => esc_html__('Unlimited time', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '0',
							),
							array(
								'id' => "{$meta_prefix}package_time_unit",
								'title' => esc_html__('Time Unit', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'Day' => esc_html__('Day', 'felan-framework'),
									'Week' => esc_html__('Week', 'felan-framework'),
									'Month' => esc_html__('Month', 'felan-framework'),
									'Year' => esc_html__('Year', 'felan-framework'),
								),
								'default' => 'Day',
								'required' => array("{$meta_prefix}package_unlimited_time", '=', '0'),
							),
							array(
								'id' => "{$meta_prefix}package_period",
								'title' => esc_html__('Number Time', 'felan-framework'),
								'type' => 'text',
								'default' => '1',
								'pattern' => '[0-9]*',
								'required' => array("{$meta_prefix}package_unlimited_time", '=', '0'),
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}package_order_display",
								'title' => esc_html__('Order Number Display Via Frontend', 'felan-framework'),
								'type' => 'text',
								'default' => '1',
								'pattern' => '[0-9]*',
							),
							array(
								'id' => "{$meta_prefix}package_featured",
								'title' => esc_html__('Is Featured?', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '0',
							),
							array(
								'id' => "{$meta_prefix}package_visible",
								'title' => esc_html__('Is Visible?', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '1',
							),
						)
					),
					array(
						'type' => 'divide'
					),
					array(
						'id' => "{$meta_prefix}package_additional_details",
						'type' => 'repeater',
						'title' => esc_html__('Additional details:', 'felan-framework'),
						'col' => '6',
						'sort' => true,
						'fields' => array(
							array(
								'id' => "{$meta_prefix}package_details_text",
								'type' => 'text',
								'default' => esc_html__('Limited support', 'felan-framework'),
							),
						)
					),
				),
			);

			// Build fields array - only include non-empty package sections
			$freelancer_package_fields = array(
				$freelancer_package_service,
				$freelancer_package_service_featured,
				$freelancer_package_jobs_apply,
				$freelancer_package_jobs_wishlist,
				$freelancer_package_company_follow,
				$freelancer_package_project_apply,
			);

			// Add info company field before project alerts (outside project section)
			if (!empty($freelancer_package_info_company)) {
				$freelancer_package_fields[] = array(
					'type' => 'row',
					'col' => '4',
					'fields' => array(
						$freelancer_package_info_company,
					)
				);
			}

			// Only add project alerts fields if package-specific settings are enabled
			if (!empty($freelancer_package_project_alerts)) {
				// Add divider before Project Alert section to match other sections
				$freelancer_package_fields[] = array(
					'type' => 'divide'
				);
				// Merge multiple rows (freelancer_package_project_alerts is now an array of rows)
				if (is_array($freelancer_package_project_alerts) && isset($freelancer_package_project_alerts[0])) {
					$freelancer_package_fields = array_merge($freelancer_package_fields, $freelancer_package_project_alerts);
				} else {
					$freelancer_package_fields[] = $freelancer_package_project_alerts;
				}
			}

			$freelancer_package_fields = array_merge(
				$freelancer_package_fields,
				array(
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							$freelancer_package_contact_company,
							$freelancer_package_send_message,
							$freelancer_package_review_and_commnent,
						)
					),
					array(
						'type' => 'divide'
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}freelancer_package_free",
								'title' => esc_html__('Free Package', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '0',
							),
							array(
								'id' => "{$meta_prefix}freelancer_package_price",
								'title' => esc_html__('Package Price', 'felan-framework'),
								'type' => 'text',
								'required' => array("{$meta_prefix}freelancer_package_free", '=', '0'),
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}enable_package_service_unlimited_time",
								'title' => esc_html__('Unlimited time', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '0',
							),
							array(
								'id' => "{$meta_prefix}freelancer_package_time_unit",
								'title' => esc_html__('Time Unit', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'Day' => esc_html__('Day', 'felan-framework'),
									'Week' => esc_html__('Week', 'felan-framework'),
									'Month' => esc_html__('Month', 'felan-framework'),
									'Year' => esc_html__('Year', 'felan-framework'),
								),
								'default' => 'Day',
								'required' => array("{$meta_prefix}enable_package_service_unlimited_time", '=', '0'),
							),
							array(
								'id' => "{$meta_prefix}freelancer_package_period",
								'title' => esc_html__('Number Time', 'felan-framework'),
								'type' => 'text',
								'default' => '1',
								'pattern' => '[0-9]*',
								'required' => array("{$meta_prefix}enable_package_service_unlimited_time", '=', '0'),
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '4',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}freelancer_package_order_display",
								'title' => esc_html__('Order Number Display Via Frontend', 'felan-framework'),
								'type' => 'text',
								'default' => '1',
								'pattern' => '[0-9]*',
							),
							array(
								'id' => "{$meta_prefix}freelancer_package_featured",
								'title' => esc_html__('Is Featured?', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '0',
							),
							array(
								'id' => "{$meta_prefix}freelancer_package_visible",
								'title' => esc_html__('Is Visible?', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'1' => esc_html__('Yes', 'felan-framework'),
									'0' => esc_html__('No', 'felan-framework'),
								),
								'default' => '1',
							),
						)
					),
					array(
						'type' => 'divide'
					),
					array(
						'id' => "{$meta_prefix}freelancer_package_additional_details",
						'type' => 'repeater',
						'title' => esc_html__('Custom Field Package', 'felan-framework'),
						'col' => '6',
						'sort' => true,
						'fields' => array(
							array(
								'id' => "{$meta_prefix}freelancer_package_details_text",
								'type' => 'text',
								'default' => esc_html__('Limited support', 'felan-framework'),
							),
						)
					),
				),
			);

			$configs['freelancer_package_meta_boxes'] = array(
				'name' => esc_html__('Freelancer Package', 'felan-framework'),
				'post_type' => array('freelancer_package'),
				'fields' => $freelancer_package_fields,
			);

			$configs['freelancer_order_meta_boxes'] = array(
				'name' => esc_html__('Service Order Settings', 'felan-framework'),
				'post_type' => array('freelancer_order'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}freelancer_order_payment_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'col' => '4',
								'options' => array(
									'0' => esc_html__('Pending', 'felan-framework'),
									'1' => esc_html__('Active', 'felan-framework'),
								),
								'default' => 'pending',
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}freelancer_order_user_id",
								'title' => esc_html__('User Buyer id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}freelancer_order_item_id",
								'title' => esc_html__('Package id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}freelancer_order_price",
								'title' => esc_html__('Price', 'felan-framework'),
								'default' => '30',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}freelancer_order_date",
								'title' => esc_html__('Activate Date', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}freelancer_order_payment_method",
								'title' => esc_html__('Payment Method', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
						)
					),
				),
			);
			$date_applicants = get_the_date(get_option('date_format'));
			$configs['applicants_meta_boxes'] = array(
				'name' => esc_html__('Applicants Settings', 'felan-framework'),
				'post_type' => array('applicants'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '6',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}applicants_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'pending' => esc_html__('Pending', 'felan-framework'),
									'approved' => esc_html__('Approved', 'felan-framework'),
									'rejected' => esc_html__('Rejected', 'felan-framework'),
								),
								'default' => 'pending',
							),
							array(
								'id' => "{$meta_prefix}applicants_type",
								'title' => esc_html__('Type Apply', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'email' => esc_html__('Email', 'felan-framework'),
									'internal' => esc_html__('Internal', 'felan-framework'),
								),
								'default' => 'email',
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '6',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}applicants_author",
								'title' => esc_html__('Name Apply', 'felan-framework'),
								'type' => 'text',
								'default' => '',
								'required' => array("{$meta_prefix}applicants_type", '=', 'email'),
							),
							array(
								'id' => "{$meta_prefix}applicants_phone",
								'title' => esc_html__('Phone', 'felan-framework'),
								'type' => 'text',
								'default' => '',
								'required' => array("{$meta_prefix}applicants_type", '=', 'email'),
							),
							array(
								'id' => "{$meta_prefix}applicants_email",
								'title' => esc_html__('Email Address', 'felan-framework'),
								'type' => 'text',
								'default' => '',
								'required' => array("{$meta_prefix}applicants_type", '=', 'email'),
							),
							array(
								'id' => "{$meta_prefix}applicants_cv",
								'title' => esc_html__('Cv Url', 'felan-framework'),
								'type' => 'text',
								'default' => '',
							),
						)
					),
					array(
						'id' => "{$meta_prefix}applicants_message",
						'title' => esc_html__('Message', 'felan-framework'),
						'type' => 'textarea',
						'default' => '',
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}applicants_jobs_id",
								'title' => esc_html__('Jobs ID', 'felan-framework'),
								'type' => 'text',
								'col' => '6',
								'default' => '',
							),
							array(
								'id' => "{$meta_prefix}applicants_date",
								'title' => esc_html__('Post Date', 'felan-framework'),
								'type' => 'text',
								'col' => '6',
								'default' => $date_applicants,
							),
						)
					),
				),
			);

			$configs['proposal_meta_boxes'] = array(
				'name' => esc_html__('Proposal Settings', 'felan-framework'),
				'post_type' => array('project-proposal'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}proposal_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'pending' => esc_html__('Pending', 'felan-framework'),
									'inprogress' => esc_html__('In Process', 'felan-framework'),
									'canceled' => esc_html__('Canceled', 'felan-framework'),
									'reject' => esc_html__('Rejected', 'felan-framework'),
									'completed' => esc_html__('Completed', 'felan-framework'),
								),
								'default' => 'pending',
							),
							array(
								'id' => "{$meta_prefix}proposal_price",
								'title' => esc_html__('Price', 'felan-framework'),
								'type' => 'text',
								'default' => '',
							),
							array(
								'id' => "{$meta_prefix}proposal_time",
								'title' => esc_html__('Time', 'felan-framework'),
								'type' => 'text',
								'default' => '',
							),
						)
					),
					array(
						'id' => "{$meta_prefix}proposal_message",
						'title' => esc_html__('Message', 'felan-framework'),
						'type' => 'textarea',
						'default' => '',
					),
					array(
						'type' => 'divide',
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}project_refund_payment_method",
								'title' => esc_html__('Payment method refund', 'felan-framework'),
								'type' => 'select',
								'options' => array(
									'wire_transfer' => esc_html('Wire Transfer', 'felan-framework'),
									'stripe' => esc_html('Pay With Stripe', 'felan-framework'),
									'paypal' => esc_html('Pay With Paypal', 'felan-framework'),
								),
								'col' => '4',
								'default' => 'wire_transfer',
								'required' => array("{$meta_prefix}proposal_status", '=', 'refund'),

							),
							array(
								'id' => "{$meta_prefix}project_refund_content",
								'title' => esc_html__('Content refund', 'felan-framework'),
								'type' => 'textarea',
								'default' => '',
								'col' => '12',
								'required' => array("{$meta_prefix}proposal_status", '=', 'refund'),
							),
						)
					),
				),
			);

			//Order Project
			$configs['project_order_meta_boxes'] = array(
				'name' => esc_html__('Service Order Settings', 'felan-framework'),
				'post_type' => array('project_order'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}project_order_payment_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'pending' => esc_html__('Pending', 'felan-framework'),
									'inprogress' => esc_html__('Approve', 'felan-framework'),
								),
								'default' => 'pending',
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}project_order_user_id",
								'title' => esc_html__('User Order id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}project_order_author_project",
								'title' => esc_html__('Author Service', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}project_order_item_id",
								'title' => esc_html__('Package id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}project_order_price",
								'title' => esc_html__('Price', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}project_order_date",
								'title' => esc_html__('Activate Date', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}project_order_payment_method",
								'title' => esc_html__('Payment Method', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
						)
					),
					array(
						'type' => 'divide',
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}project_refund_payment_method",
								'title' => esc_html__('Payment method refund', 'felan-framework'),
								'type' => 'select',
								'options' => array(
									'wire_transfer' => esc_html('Wire Transfer', 'felan-framework'),
									'stripe' => esc_html('Pay With Stripe', 'felan-framework'),
									'paypal' => esc_html('Pay With Paypal', 'felan-framework'),
								),
								'col' => '4',
								'default' => 'wire_transfer',
								'required' => array("{$meta_prefix}project_order_payment_status", '=', 'refund'),

							),
							array(
								'id' => "{$meta_prefix}project_refund_content",
								'title' => esc_html__('Content refund', 'felan-framework'),
								'type' => 'textarea',
								'default' => '',
								'col' => '12',
								'required' => array("{$meta_prefix}project_order_payment_status", '=', 'refund'),
							),
						)
					),
				),
			);

			//Order Wallet
			$configs['wallet_order_meta_boxes'] = array(
				'name' => esc_html__('Wallet Order Settings', 'felan-framework'),
				'post_type' => array('wallet_order'),
				'fields' => array(
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}wallet_order_payment_status",
								'title' => esc_html__('Status', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'pending' => esc_html__('Pending', 'felan-framework'),
									'approve' => esc_html__('Approve', 'felan-framework'),
								),
								'default' => 'pending',
							),
						)
					),
					array(
						'type' => 'row',
						'col' => '12',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}wallet_order_user_id",
								'title' => esc_html__('User Order id', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}wallet_order_author",
								'title' => esc_html__('Author Wallet', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}wallet_order_user_role",
								'title' => esc_html__('User Role', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}wallet_order_price",
								'title' => esc_html__('Price', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}wallet_order_date",
								'title' => esc_html__('Activate Date', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
							array(
								'id' => "{$meta_prefix}wallet_order_payment_method",
								'title' => esc_html__('Payment Method', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'col' => '4',
							),
						)
					),
				),
			);

			$configs['meetings_meta_boxes'] = array(
				'name' => esc_html__('Meetings Settings', 'felan-framework'),
				'post_type' => array('meetings'),
				'fields' => array(
					array(
						'id' => "{$meta_prefix}meeting_status",
						'title' => esc_html__('Status', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'upcoming' => esc_html__('Upcoming', 'felan-framework'),
							'completed' => esc_html__('Completed', 'felan-framework'),
						),
						'default' => 'upcoming',
					),
					array(
						'type' => 'row',
						'col' => '6',
						'fields' => array(
							array(
								'id' => "{$meta_prefix}meeting_with",
								'title' => esc_html__('Meeting With', 'felan-framework'),
								'type' => 'text',
								'default' => '',
							),
							array(
								'id' => "{$meta_prefix}meeting_date",
								'title' => esc_html__('Date', 'felan-framework'),
								'type' => 'text',
								'default' => '',
							),
							array(
								'id' => "{$meta_prefix}meeting_time",
								'title' => esc_html__('Time', 'felan-framework'),
								'type' => 'text',
								'default' => '',
							),
							array(
								'id' => "{$meta_prefix}meeting_time_duration",
								'title' => esc_html__('Time Duration', 'felan-framework'),
								'type' => 'text',
								'default' => '',
							),
						)
					),
					array(
						'id' => "{$meta_prefix}meeting_message",
						'title' => esc_html__('Message', 'felan-framework'),
						'type' => 'textarea',
						'default' => '',
					),
				),
			);

			if (post_type_exists('job_alerts')) {
				$configs['job_alerts_meta_boxes'] = array(
					'name' => esc_html__('Job Alerts Infomation', 'felan-framework'),
					'post_type' => array('job_alerts'),
					'fields' => array(
						array(
							'type' => 'row',
							'fields' => array(
								array(
									'id' => "{$meta_prefix}job_alerts_email",
									'title' => esc_html__('Email', 'felan-framework'),
									'type' => 'text',
									'default' => '',
									'col' => '12',
								),
								array(
									'id' => "{$meta_prefix}job_alerts_location",
									'title' => esc_html__('Location', 'felan-framework'),
									'type' => 'select',
									'options' => felan_get_taxonomy('felan_location', false, true, true),
									'default' => '',
									'col' => '3',
								),
								array(
									'id' => "{$meta_prefix}job_alerts_categories",
									'title' => esc_html__('Categories', 'felan-framework'),
									'type' => 'select',
									'options' => felan_get_taxonomy('jobs-categories', false, true, true),
									'default' => '',
									'col' => '3',
								),
								array(
									'id' => "{$meta_prefix}job_alerts_experience",
									'title' => esc_html('Experience', 'felan-framework'),
									'type' => 'select',
									'options' => felan_get_taxonomy('jobs-experience', false, true, true),
									'default' => '',
									'col' => '3',
								),
								array(
									'id' => "{$meta_prefix}job_alerts_frequency",
									'title' => esc_html__('Frequency', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										''	=> esc_html('Select an option', 'felan-framework'),
										'daily'	=> esc_html('Daily', 'felan-framework'),
										'weekly'	=> esc_html('Weekly', 'felan-framework'),
										'monthly'	=> esc_html('Monthly', 'felan-framework'),
									),
									'default' => '',
									'col' => '3',
								),
								array(
									'id' => "{$meta_prefix}job_alerts_skill",
									'type' => 'checkbox_list',
									'title' => esc_html__('Skills', 'felan-framework'),
									'options' => felan_get_taxonomy('jobs-skills', false, true, true),
									'value_inline' => true,
									'default' => array(),
									'col' => '12',
								),
								array(
									'id' => "{$meta_prefix}job_alerts_type",
									'type' => 'checkbox_list',
									'title' => esc_html__('Type', 'felan-framework'),
									'options' => felan_get_taxonomy('jobs-type', false, true, true),
									'value_inline' => true,
									'default' => array(),
									'col' => '12',
								),
							)
						),
					),
				);
			}

			// Project Alerts Meta Boxes
			if (post_type_exists('project_alerts')) {
				$configs['project_alerts_meta_boxes'] = array(
					'name' => esc_html__('Project Alert Information', 'felan-framework'),
					'post_type' => array('project_alerts'),
					'fields' => array(
						array(
							'id' => "{$meta_prefix}project_alerts_user_type",
							'title' => esc_html__('User Type', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'registered' => esc_html__('Registered User', 'felan-framework'),
								'non_registered' => esc_html__('Non-Registered User', 'felan-framework'),
							),
							'default' => 'registered',
							'desc' => esc_html__('Choose whether this alert is for a registered user or a non-registered user', 'felan-framework'),
						),
						array(
							'type' => 'row',
							'fields' => array(
								array(
									'id' => "{$meta_prefix}project_alerts_user_id",
									'title' => esc_html__('User', 'felan-framework'),
									'type' => 'selectize',
									'options' => array(), // Options loaded via AJAX
									'multiple' => false,
									'placeholder' => esc_html__('Type to search user...', 'felan-framework'),
									'default' => '',
									'col' => '6',
									'desc' => esc_html__('Type to search and select a freelancer user', 'felan-framework'),
									'class' => 'felan-user-field-registered',
									'data-ajax-user-search' => '1', // Flag for AJAX loading
								),
								array(
									'id' => "{$meta_prefix}project_alerts_email",
									'title' => esc_html__('Email', 'felan-framework') . ' <span class="required">*</span>',
									'type' => 'text',
									'default' => '',
									'col' => '6',
									'pattern' => '^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$',
									'desc' => esc_html__('Email address to receive alerts', 'felan-framework'),
									'class' => 'felan-email-field',
								),
								array(
									'id' => "{$meta_prefix}project_alerts_match_type",
									'title' => esc_html__('Match Type', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'OR' => esc_html__('OR - Match any selected taxonomy', 'felan-framework'),
										'AND' => esc_html__('AND - Match all selected taxonomies', 'felan-framework'),
									),
									'default' => 'OR',
									'col' => '6',
								),
								array(
									'id' => "{$meta_prefix}project_alerts_frequency",
									'title' => esc_html__('Frequency', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'daily' => esc_html__('Daily', 'felan-framework'),
										'weekly' => esc_html__('Weekly', 'felan-framework'),
										'monthly' => esc_html__('Monthly', 'felan-framework'),
									),
									'default' => 'daily',
									'col' => '6',
								),
								array(
									'id' => "{$meta_prefix}project_alerts_categories",
									'type' => 'selectize',
									'title' => esc_html__('Categories', 'felan-framework'),
									'data' => 'taxonomy',
									'data_args' => array(
										'taxonomy' => 'project-categories',
										'hide_empty' => false,
										'number' => 50, // Limit initial load
									),
									'multiple' => true,
									'placeholder' => esc_html__('Type to search categories...', 'felan-framework'),
									'default' => array(),
									'col' => '6',
									'desc' => esc_html__('Type to search and select multiple categories', 'felan-framework'),
									'data-taxonomy' => 'project-categories', // For AJAX loading
								),
								array(
									'id' => "{$meta_prefix}project_alerts_skills",
									'type' => 'selectize',
									'title' => esc_html__('Skills', 'felan-framework'),
									'data' => 'taxonomy',
									'data_args' => array(
										'taxonomy' => 'project-skills',
										'hide_empty' => false,
										'number' => 50,
									),
									'multiple' => true,
									'placeholder' => esc_html__('Type to search skills...', 'felan-framework'),
									'default' => array(),
									'col' => '6',
									'data-taxonomy' => 'project-skills',
								),
								array(
									'id' => "{$meta_prefix}project_alerts_language",
									'type' => 'selectize',
									'title' => esc_html__('Languages', 'felan-framework'),
									'data' => 'taxonomy',
									'data_args' => array(
										'taxonomy' => 'project-language',
										'hide_empty' => false,
										'number' => 50,
									),
									'multiple' => true,
									'placeholder' => esc_html__('Type to search languages...', 'felan-framework'),
									'default' => array(),
									'col' => '6',
									'data-taxonomy' => 'project-language',
								),
								array(
									'id' => "{$meta_prefix}project_alerts_career",
									'type' => 'selectize',
									'title' => esc_html__('Careers', 'felan-framework'),
									'data' => 'taxonomy',
									'data_args' => array(
										'taxonomy' => 'project-career',
										'hide_empty' => false,
										'number' => 50,
									),
									'multiple' => true,
									'placeholder' => esc_html__('Type to search careers...', 'felan-framework'),
									'default' => array(),
									'col' => '6',
									'data-taxonomy' => 'project-career',
								),
								array(
									'id' => "{$meta_prefix}project_alerts_location",
									'type' => 'selectize',
									'title' => esc_html__('Location', 'felan-framework'),
									'data' => 'taxonomy',
									'data_args' => array(
										'taxonomy' => 'felan_location',
										'hide_empty' => false,
										'number' => 50,
									),
									'multiple' => true,
									'placeholder' => esc_html__('Type to search locations...', 'felan-framework'),
									'default' => array(),
									'col' => '6',
									'data-taxonomy' => 'felan_location',
								),
							)
						),
					),
				);

				// Add State field if enabled
				$enable_state = felan_get_option('enable_option_state', '0');
				if ($enable_state === '1') {
					$configs['project_alerts_meta_boxes']['fields'][0]['fields'][] = array(
						'id' => "{$meta_prefix}project_alerts_state",
						'type' => 'selectize',
						'title' => esc_html__('State/Province', 'felan-framework'),
						'data' => 'taxonomy',
						'data_args' => array(
							'taxonomy' => 'felan_state',
							'hide_empty' => false,
							'number' => 50,
						),
						'multiple' => true,
						'placeholder' => esc_html__('Type to search states...', 'felan-framework'),
						'default' => array(),
						'col' => '6',
						'data-taxonomy' => 'felan_state',
					);
				}
			}
			// Page
			$configs['felan_page_options'] = array(
				'name' => esc_html__('Page Options', 'felan-framework'),
				'post_type' => array('page'),
				'section' => array_merge(
					apply_filters('felan_register_meta_boxes_page_top', array()),
					apply_filters(
						'felan_register_meta_boxes_page_main',
						array_merge(
							array(
								array(
									'id' => "{$meta_prefix}page_Layout",
									'title' => esc_html__('Page Layout', 'felan-framework'),
									'icon' => 'dashicons-admin-home',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}page_body_bg",
													'title' => esc_html__('Body Background', 'felan-framework'),
													'type' => 'color',
													'col' => '6',
													'default' => '',
												),
												array(
													'id' => "{$meta_prefix}show_page_rtl",
													'title' => esc_html__('Page Rtl', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'' => esc_html__('Default', 'felan-framework'),
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '6',
													'default' => '',
												),
												array(
													'id' => "{$meta_prefix}page_pt_deskop",
													'title' => esc_html__('Padding Top (Deskop)', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
													'pattern' => '[0-9]*',
												),
												array(
													'id' => "{$meta_prefix}page_pb_deskop",
													'title' => esc_html__('Padding Bottom (Deskop)', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
													'pattern' => '[0-9]*',
												),
												array(
													'id' => "{$meta_prefix}page_pt_mobie",
													'title' => esc_html__('Padding Top (Mobie)', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
													'pattern' => '[0-9]*',
												),
												array(
													'id' => "{$meta_prefix}page_pb_mobie",
													'title' => esc_html__('Padding Bottom (Mobie)', 'felan-framework'),
													'type' => 'text',
													'default' => '',
													'col' => '6',
													'pattern' => '[0-9]*',
												),
											)
										),

									)
								)
							),
							array(
								array(
									'id' => "{$meta_prefix}page_header",
									'title' => esc_html__('Page Header', 'felan-framework'),
									'icon' => 'dashicons-before dashicons-smiley',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}header_show",
													'title' => esc_html__('Show Header', 'felan-framework'),
													'type' => 'button_set',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '1',
												),
												array(
													'id' => "{$meta_prefix}header_style",
													'title' => esc_html__('Header Style', 'felan-framework'),
													'type' => 'button_set',
													'options' => array(
														'dark' => esc_html__('Dark', 'felan-framework'),
														'light' => esc_html__('Light', 'felan-framework'),
													),
													'col' => '4',
													'default' => 'dark',
													'required' => array("{$meta_prefix}header_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}show_top_bar",
													'title' => esc_html__('Show Top Bar', 'felan-framework'),
													'type' => 'button_set',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '0',
													'required' => array("{$meta_prefix}header_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}show_border_bottom",
													'title' => esc_html__('Show Border Bottom', 'felan-framework'),
													'type' => 'button_set',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '1',
													'required' => array("{$meta_prefix}header_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}header_type",
													'title' => esc_html__('Header Type', 'felan-framework'),
													'type' => 'select',
													'default' => '',
													// Guard against missing helper load to prevent fatal error
													'options' => function_exists('felan_get_header_elementor')
														? felan_get_header_elementor()
														: array('' => esc_html__('Default', 'felan-framework')),
													'col' => '4',
													'required' => array("{$meta_prefix}header_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}show_header_float",
													'title' => esc_html__('Header Float', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'' => esc_html__('Default', 'felan-framework'),
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '',
													'required' => array("{$meta_prefix}header_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}show_header_sticky",
													'title' => esc_html__('Header Sticky', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'' => esc_html__('Default', 'felan-framework'),
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '',
													'required' => array("{$meta_prefix}header_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}show_header_cate",
													'title' => esc_html__('Header Categories', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'' => esc_html__('Default', 'felan-framework'),
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '',
													'required' => array("{$meta_prefix}header_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}cate_border_color",
													'title' => esc_html__('Categories Border Color', 'felan-framework'),
													'type' => 'color',
													'col' => '4',
													'default' => '',
													'required' => array(
														"{$meta_prefix}header_show",
														'=',
														'1',
														"{$meta_prefix}show_header_cate",
														'!=',
														'0'
													),
												),
											)
										),

									)
								)
							),
							array(
								array(
									'id' => "{$meta_prefix}page_footer",
									'title' => esc_html__('Page Footer', 'felan-framework'),
									'icon' => 'dashicons-excerpt-view',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}footer_show",
													'title' => esc_html__('Show Footer', 'felan-framework'),
													'type' => 'button_set',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '1',
												),
												array(
													'id' => "{$meta_prefix}footer_type",
													'title' => esc_html__('Footer Type', 'felan-framework'),
													'type' => 'select',
													'default' => '',
													'options' => felan_get_footer_elementor(),
													'col' => '4',
													'required' => array("{$meta_prefix}footer_show", '=', '1'),
												)
											)
										),

									)
								)
							),
							array(
								array(
									'id' => "{$meta_prefix}page_title",
									'title' => esc_html__('Page Title', 'felan-framework'),
									'icon' => 'dashicons-analytics',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}page_title_show",
													'title' => esc_html__('Show Page Title', 'felan-framework'),
													'type' => 'button_set',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'col' => '4',
													'default' => '0',
												),
												array(
													'id' => "{$meta_prefix}page_title_color",
													'title' => esc_html__('Text Color', 'felan-framework'),
													'type' => 'color',
													'col' => '4',
													'default' => '',
													'required' => array("{$meta_prefix}page_title_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}page_title_bg",
													'title' => esc_html__('Background Color', 'felan-framework'),
													'type' => 'color',
													'col' => '4',
													'default' => '',
													'required' => array("{$meta_prefix}page_title_show", '=', '1'),
												),
												array(
													'id' => "{$meta_prefix}page_title_image",
													'title' => esc_html__('Background Image', 'felan-framework'),
													'type' => 'image',
													'default' => '',
													'required' => array("{$meta_prefix}page_title_show", '=', '1'),
												)
											)
										),

									)
								)
							)
						)
					),
					apply_filters('felan_register_meta_boxes_page_bottom', array())
				),
			);

			//Meta box project
			$configs['project_meta_boxes'] = apply_filters('felan_register_meta_boxes_project', array(
				'name' => esc_html__('Project Information', 'felan-framework'),
				'post_type' => array('project'),
				'section' => array_merge(
					apply_filters('felan_register_meta_boxes_project_top', array()),
					apply_filters(
						'felan_register_meta_boxes_project_main',
						array_merge(
							array(
								array(
									'id' => "{$meta_prefix}details_project_basic",
									'title' => esc_html__('Basic', 'felan-framework'),
									'icon' => 'dashicons dashicons-admin-home',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}project_featured",
													'title' => esc_html__('Mark this project as featured ?', 'felan-framework'),
													'type' => 'button_set',
													'col' => '12',
													'options' => array(
														'1' => esc_html__('Yes', 'felan-framework'),
														'0' => esc_html__('No', 'felan-framework'),
													),
													'default' => '0',
												),
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}details_budget",
									'title' => esc_html__('Budget', 'felan-framework'),
									'icon' => 'dashicons dashicons-money-alt',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												array(
													'id' => "{$meta_prefix}project_budget_show",
													'title' => esc_html__('Project Type', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'fixed' =>  esc_html('Fixed Price', 'felan-framework'),
														'hourly' =>  esc_html('Hourly Rate', 'felan-framework'),
													),
													'col' => '4',
													'default' => 'fixed',
												),
												array(
													'id' => "{$meta_prefix}project_budget_minimum",
													'title' => esc_html__('Minimum Price', 'felan-framework'),
													'desc' => esc_html__('Example Value: 450', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '450',
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}project_budget_maximum",
													'title' => esc_html__('Maximum Price', 'felan-framework'),
													'desc' => esc_html__('Example Value: 900', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '900',
													'col' => '4',
												),
												array(
													'id' => "{$meta_prefix}project_maximum_hours",
													'title' => esc_html__('Estimated maximum hours', 'felan-framework'),
													'desc' => esc_html__('Example Value: 30', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '',
													'col' => '4',
													'required' => array(
														array("{$meta_prefix}project_budget_show", '=', 'hourly')
													),
												),
												array(
													'id' => "{$meta_prefix}project_value_rate",
													'title' => esc_html__('Value Rate', 'felan-framework'),
													'desc' => esc_html__('Example Value: 3', 'felan-framework'),
													'type' => 'text',
													'pattern' => "{$format_number}",
													'default' => '',
													'col' => '4',
													'required' => array(
														array("{$meta_prefix}project_budget_show", '!=', 'hourly')
													),
												),
												array(
													'id' => "{$meta_prefix}project_budget_rate",
													'title' => esc_html__('Rate', 'felan-framework'),
													'type' => 'select',
													'options' => array(
														'' => esc_html('None', 'felan-framework'),
														'hour' => esc_html('Per Hour', 'felan-framework'),
														'day' => esc_html('Per Day', 'felan-framework'),
														'week' => esc_html('Per Week', 'felan-framework'),
														'month' => esc_html('Per Month', 'felan-framework'),
														'year' => esc_html('Per Year', 'felan-framework'),
													),
													'col' => '4',
													'default' => 'hour',
													'required' => array(
														array("{$meta_prefix}project_budget_show", '!=', 'hourly')
													),
												),
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}project_company",
									'title' => esc_html__('Company', 'felan-framework'),
									'icon' => 'dashicons dashicons-building',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}project_select_company",
											'title' => esc_html__('Select company', 'felan-framework'),
											'type' => 'select',
											'options' => felan_select_project_company(),
										),
									)
								),
								array(
									'id' => "{$meta_prefix}details_project_faq",
									'title' => esc_html__('Faqs', 'felan-framework'),
									'icon' => 'dashicons dashicons-palmtree',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}project_tab_faq",
											'type' => 'panel',
											'title' => esc_html__('Faqs', 'felan-framework'),
											'sort' => true,
											'panel_title' => 'label',
											'fields' => array(
												array(
													'type' => 'row',
													'col' => '12',
													'fields' => array(
														array(
															'id' => "{$meta_prefix}project_faq_title",
															'title' => esc_html__('Title', 'felan-framework'),
															'type' => 'text',
															'col' => '12',
														),
														array(
															'id' => "{$meta_prefix}project_faq_description",
															'title' => esc_html__('Description', 'felan-framework'),
															'type' => 'textarea',
															'col' => '12',
														),
													)
												)
											)
										),
									)
								),
								array(
									'id' => "{$meta_prefix}location_tab",
									'title' => esc_html__('Location', 'felan-framework'),
									'icon' => 'dashicons-location-alt',
									'fields' => array(
										array(
											'type' => 'row',
											'col' => '12',
											'fields' => array(
												$project_location_city,
												array(
													'id' => "{$meta_prefix}project_address",
													'title' => esc_html__('Maps location', 'felan-framework'),
													'desc' => esc_html__('Full Address', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}project_latitude",
													'title' => esc_html__('Latitude', 'felan-framework'),
													'desc' => esc_html__('Latitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}project_longtitude",
													'title' => esc_html__('Longtitude', 'felan-framework'),
													'desc' => esc_html__('Longtitude Details', 'felan-framework'),
													'type' => 'text',
													'col' => 4
												),
												array(
													'id' => "{$meta_prefix}project_location",
													'title' => esc_html__('Service Location at Google Map', 'felan-framework'),
													'desc' => esc_html__('Drag the google map marker to point your project location.', 'felan-framework'),
													'type' => 'map',
													'address_field' => "{$meta_prefix}project_address",
												),
											)
										)
									)
								),
								array(
									'id' => "{$meta_prefix}gallery_project_tab",
									'title' => esc_html__('Gallery Images', 'felan-framework'),
									'icon' => 'dashicons-format-gallery',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}project_images",
											'title' => esc_html__('Gallery', 'felan-framework'),
											'type' => 'gallery',
										),
									)
								),
								array(
									'id' => "{$meta_prefix}video_project_tab",
									'title' => esc_html__('Video', 'felan-framework'),
									'icon' => 'dashicons-video-alt3',
									'fields' => array(
										array(
											'id' => "{$meta_prefix}project_video_url",
											'title' => esc_html__('Video URL', 'felan-framework'),
											'desc' => esc_html__('Input only URL. YouTube, Vimeo, SWF File and MOV File', 'felan-framework'),
											'type' => 'text',
											'col' => 12,
										),
										array(
											'id' => "{$meta_prefix}project_video_image",
											'title' => esc_html__('Video Image', 'felan-framework'),
											'type' => 'gallery',
											'col' => 12,
										),
									)
								),
								array(
									'id' => "{$meta_prefix}custom_field_project_tab",
									'title' => esc_html__('Additional Fields', 'felan-framework'),
									'icon' => 'dashicons dashicons-welcome-add-page',
									'fields' => $render_custom_field_project
								),
							)
						)
					),
					apply_filters('felan_register_meta_boxes_project_bottom', array())
				),
			));

			return apply_filters('felan_register_meta_boxes', $configs);
		}
}
