<?php
/**
 * Felan Email Options Trait
 * Extracted from class-felan-admin.php
 * Contains: email_management_option
 *
 * @package Felan_Framework
 */

if (!defined('ABSPATH')) {
    exit;
}

trait Felan_Email_Options_Trait
{
		private function email_management_option()
		{

			$new_jobs_apply = $jobs_activated_listing = $jobs_approved_listing = $jobs_expired_listing
				= $job_alerts = $job_approved_apply = $job_invite = $user_approved = array();

			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			if ($enable_post_type_jobs == '1') {
				$new_jobs_apply = array(
					'id' => 'new-jobs-apply',
					'title' => esc_html__('Apply Jobs', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_info_mail_freelancer_apply',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_freelancer_apply',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('You have successfully applied on %website_url', 'felan-framework'),
						),
						array(
							'id' => 'mail_freelancer_apply',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %user_apply, %website_url, %jobs_apply, %jobs_url', 'felan-framework'),
							'default' => esc_html__(
								'Hi %user_apply,
                                        You have applied for 1 job on %website_url.
                                        Jobs Title: %jobs_apply
                                        Jobs Url: %jobs_url',
								'felan-framework'
							),
						),
						array(
							'id' => 'felan_info_mail_employer_apply',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Admin Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_employer_apply',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('There is 1 freelancer applied for your job', 'felan-framework'),
						),
						array(
							'id' => 'mail_employer_apply',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %website_url, %jobs_apply, %jobs_url, %cv_url, %user_apply, %user_url', 'felan-framework'),
							'default' => esc_html__(
								'Hi,
                                        Your jobs on %website_url has been applied.
                                        Jobs Title: %jobs_apply
                                        Jobs Url: %jobs_url
                                        Cv Url: %cv_url
                                        User Apply: %user_apply
                                        User Info: %user_url',
								'felan-framework'
							),
						),
						array(
							'id' => 'felan_info_mail_freelancer_apply_nlogin',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Freelancer Email (Not Login)', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_freelancer_apply_nlogin',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('There is 1 freelancer applied for your job', 'felan-framework'),
						),
						array(
							'id' => 'mail_freelancer_apply_nlogin',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %website_url, %jobs_apply, %jobs_url, %cv_url, %message', 'felan-framework'),
							'default' => esc_html__(
								'Hi,
                                        Your jobs on %website_url has been applied.
                                        Jobs Title: %jobs_apply
                                        Jobs Url: %jobs_url
                                        CV Url: %cv_url
                                        Message: %message',
								'felan-framework'
							),
						),
					)
				);

				$jobs_activated_listing = array(
					'id' => 'email-activated-listing',
					'title' => esc_html__('Activated Jobs', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_user_mail_activated_listing',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_activated_listing',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('Your purchase was activated', 'felan-framework'),
						),
						array(
							'id' => 'mail_activated_listing',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %your_name, %website_url', 'felan-framework'),
							'default' => esc_html__('Hi %your_name, Your purchase on %website_url is activated! You should go and check it out.', 'felan-framework'),
						)
					)
				);

				$jobs_approved_listing = array(
					'id' => 'email-approved-listing',
					'title' => esc_html__('Approved Jobs', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_user_mail_approved_listing',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_approved_listing',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('Your listing approved', 'felan-framework'),
						),
						array(
							'id' => 'mail_approved_listing',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %your_name, %website_url, %listing_title, %listing_url', 'felan-framework'),
							'default' => esc_html__(
								"Hi thfelan,
                                        Your jobs on %website_url has been approved.
                                        Your Name:%your_name
                                        Jobs Title:%listing_title
                                        Jobs Url: %listing_url",
								'felan-framework'
							),
						)
					)
				);

				$jobs_expired_listing = array(
					'id' => 'email-expired-listing',
					'title' => esc_html__('Expired Jobs', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_user_mail_expired_listing',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_expired_listing',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('Your listing expired', 'felan-framework'),
						),
						array(
							'id' => 'mail_expired_listing',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %website_url, %listing_title, %listing_url', 'felan-framework'),
							'default' => esc_html__(
								"Hi,
                                        Your jobs on %website_url has expired.

                                        Jobs Title:%listing_title
                                        Jobs Url: %listing_url",
								'felan-framework'
							),
						)
					)
				);

				$job_alerts = array(
					'id' => 'email-job-alerts',
					'title' => esc_html__('Job Alerts', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_first_mail_job_alerts',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('First Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_first_mail_job_alerts',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('New Job Announcement', 'felan-framework'),
						),
						array(
							'id' => 'first_mail_job_alerts',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'default' => esc_html__(
								'Hello,
												Thank you for signing up, you will receive %frequency job related information.
												Best regards,
												Do not notify me anymore? <a href="%unregister_link">Click here</a>',
							),
						),
						array(
							'id' => 'felan_last_mail_job_alerts',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Last Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_last_mail_job_alerts',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('New Job Announcement', 'felan-framework'),
						),
						array(
							'id' => 'last_mail_job_alerts',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'default' => esc_html__(
								'Hello,
												There are %number jobs found at your request, job listing below:
												%list_job
												Best regards,
												Do not notify me anymore? <a href="%unregister_link">Click here</a>',
							),
						),
					)
				);

				$job_approved_apply = array(
					'id' => 'email-approved-apply',
					'title' => esc_html__('Approved Applicants', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_user_mail_approved_applicants',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_approved_applicants',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('Your Applicants approved', 'felan-framework'),
						),
						array(
							'id' => 'mail_approved_applicants',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %employer_name, %jobs_apply, %jobs_url', 'felan-framework'),
							'default' => esc_html__(
								"Hi,
                                        You have been approved by the employer: %employer_name
                                        Jobs Apply: %jobs_apply
                                        Jobs Url: %jobs_url",
								'felan-framework'
							),
						)
					)
				);

				$job_invite = array(
					'id' => 'email-job-invite',
					'title' => esc_html__('Invite Jobs', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_user_mail_job_invite',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_job_invite',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => esc_html__('Your Jobs Invite', 'felan-framework'),
						),
						array(
							'id' => 'mail_job_invite',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Content', 'felan-framework'),
							'subtitle' => esc_html__('Available shortcodes: %employer_name, %jobs_invite', 'felan-framework'),
							'default' => esc_html__(
								"Hi, You have been invited by the employer: %employer_name
                                                Jobs Invite: %jobs_invite",
								'felan-framework'
							),
						)
					)
				);
			}

			$user_approved = array();
			$project_invite = array();

			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			if ($enable_post_type_project == '1') {
				$project_invite = array(
					'id' => 'email-project-invite',
					'title' => esc_html__('Invite Projects', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_user_mail_project_invite',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_project_invite',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default', 'felan-framework'),
						),
						array(
							'id' => 'mail_project_invite_heading',
							'type' => 'text',
							'title' => esc_html__('Email Heading', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default: "You Have Been Invited!"', 'felan-framework'),
						),
						array(
							'id' => 'mail_project_invite_greeting',
							'type' => 'textarea',
							'title' => esc_html__('Greeting Message', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default. Use %employer_name for employer name', 'felan-framework'),
						),
						array(
							'id' => 'mail_project_invite_footer',
							'type' => 'textarea',
							'title' => esc_html__('Footer Message', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default. Use %website_name, %website_url', 'felan-framework'),
						),
						array(
							'id' => 'use_custom_mail_project_invite',
							'type' => 'button_set',
							'title' => esc_html__('Use Full Custom Template', 'felan-framework'),
							'subtitle' => esc_html__('Enable to replace entire email with your custom content', 'felan-framework'),
							'options' => array(
								'0' => esc_html__('No', 'felan-framework'),
								'1' => esc_html__('Yes', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'mail_project_invite',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Custom Template Content', 'felan-framework'),
							'subtitle' => esc_html__('Only used when "Use Full Custom Template" is enabled. Placeholders: %employer_name, %project_list, %project_link, %website_name, %website_url', 'felan-framework'),
							'default' => '',
							'required' => array('use_custom_mail_project_invite', '=', '1'),
						)
					)
				);
			}

			$project_alerts = array();
			$enable_project_alerts = felan_get_option('enable_project_alerts', '1');
			if ($enable_project_alerts == '1') {
				$project_alerts = array(
					'id' => 'email-project-alerts',
					'title' => esc_html__('Project Alerts', 'felan-framework'),
					'type' => 'group',
					'toggle_default' => false,
					'fields' => array(
						array(
							'id' => 'felan_user_mail_project_alerts',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('User Email', 'felan-framework'),
						),
						array(
							'id' => 'subject_mail_project_alerts',
							'type' => 'text',
							'title' => esc_html__('Subject', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default. Use %count for number of projects', 'felan-framework'),
						),
						array(
							'id' => 'mail_project_alerts_heading',
							'type' => 'text',
							'title' => esc_html__('Email Heading', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default: "New Projects Matching Your Criteria"', 'felan-framework'),
						),
						array(
							'id' => 'mail_project_alerts_greeting',
							'type' => 'textarea',
							'title' => esc_html__('Greeting Message', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default. Use %user_name for user display name', 'felan-framework'),
						),
						array(
							'id' => 'mail_project_alerts_footer',
							'type' => 'textarea',
							'title' => esc_html__('Footer Message', 'felan-framework'),
							'default' => '',
							'subtitle' => esc_html__('Leave empty to use default. Use %website_name, %website_url', 'felan-framework'),
						),
						array(
							'id' => 'use_custom_mail_project_alerts',
							'type' => 'button_set',
							'title' => esc_html__('Use Full Custom Template', 'felan-framework'),
							'subtitle' => esc_html__('Enable to replace entire email with your custom content', 'felan-framework'),
							'options' => array(
								'0' => esc_html__('No', 'felan-framework'),
								'1' => esc_html__('Yes', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'mail_project_alerts',
							'type' => 'editor',
							'args' => array(
								'media_buttons' => true,
								'quicktags' => true,
							),
							'title' => esc_html__('Custom Template Content', 'felan-framework'),
							'subtitle' => esc_html__('Only used when "Use Full Custom Template" is enabled. Placeholders: %user_name, %project_list, %project_count, %website_name, %website_url, %manage_alerts_link', 'felan-framework'),
							'default' => '',
							'required' => array('use_custom_mail_project_alerts', '=', '1'),
						),
					)
				);
			}

			return apply_filters('felan_register_option_email_management', array(
				'id' => 'felan_email_management_option',
				'title' => esc_html__('Email Template', 'felan-framework'),
				'icon' => 'dashicons-email-alt',
				'fields' => array_merge(
					apply_filters('felan_register_option_email_management_top', array()),
					array(
						//Header
						array(
							'id' => 'email-header',
							'title' => esc_html__('Header Email', 'felan-framework'),
							'type' => 'group',
							'toggle_default' => false,
							'fields' => array(
								array(
									'id' => 'logo_email',
									'type' => 'text',
									'title' => esc_html__('Logo Email', 'felan-framework'),
									'default' => '',
									'subtitle' => esc_html__('Choose link logo for email', 'felan-framework'),
								),
								array(
									'id' => 'title_email',
									'type' => 'text',
									'title' => esc_html__('Title', 'felan-framework'),
									'default' => esc_html__('Welcome to %website_url!', 'felan-framework'),
								),
							)
						),
						//Content
						array(
							'id' => 'email-content',
							'title' => esc_html__('Content Email', 'felan-framework'),
							'type' => 'group',
							'toggle_default' => false,
							'fields' => array(
								array(
									'id' => 'email-new-user',
									'title' => esc_html__('New Registed User', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_register_user',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_register_user',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Your username and password on %website_url', 'felan-framework'),
										),
										array(
											'id' => 'mail_register_user',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %your_name, %user_pass_register, %website_url', 'felan-framework'),
											'default' => esc_html__(
												'You can log in now using the below credentials:
                                        Username: %your_name
                                        Password: %user_pass_register
                                        If you have any problems, please contact us.
                                        Thank you!',
												'felan-framework'
											),
										),
										array(
											'id' => 'felan_admin_mail_register_user',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Admin Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_admin_mail_register_user',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New User Registration', 'felan-framework'),
										),
										array(
											'id' => 'admin_mail_register_user',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_url, %user_login_register', 'felan-framework'),
											'default' => esc_html__(
												'New user registration on %website_url.
                                                E-mail: %user_login_register',
												'felan-framework'
											),
										)
									)
								),

								array(
									'id' => 'mail-verify-user',
									'title' => esc_html__('Verify User', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_verify_user',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_verify_user',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Account Verification', 'felan-framework'),
										),
										array(
											'id' => 'mail_verify_user',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %code_verify_user', 'felan-framework'),
											'default' => esc_html__(
												"To verify your email address, please use the following One Time Password (OTP):
													%code_verify_user
												If you have any problems, please contact us.
                                        		Thank you!",
												'felan-framework'
											),
										)
									)
								),

								array(
									'id' => 'mail-user-approved',
									'title' => esc_html__('User Approved', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_approved',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_approved',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Your account has been approved', 'felan-framework'),
										),
										array(
											'id' => 'mail_approved',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %your_name, %website_url', 'felan-framework'),
											'default' => esc_html__(
												'Hi %your_name,
                                                Your account on %website_url has been approved by the administrator. You can now log in and start using your account.
                                                If you have any questions, please contact us.
                                                Thank you!',
												'felan-framework'
											),
										)
									)
								),

								array(
									'id' => 'mail-identity-verify',
									'title' => esc_html__('Identity Verify', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_identity_mail_verify_user',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Send to User when submit', 'felan-framework'),
										),
										array(
											'id' => 'subject_identity_mail_verify_user',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Identity Verification', 'felan-framework'),
										),
										array(
											'id' => 'identity_mail_verify_user',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %your_name, %website_url', 'felan-framework'),
											'default' => esc_html__('Thank you for submitting your information, please wait for our review.', 'felan-framework'),
										),
										array(
											'id' => 'felan_admin_identity_mail_verify_user',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Send to Admin when submit', 'felan-framework'),
										),
										array(
											'id' => 'subject_admin_identity_mail_verify_user',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Identity Verification', 'felan-framework'),
										),
										array(
											'id' => 'admin_identity_mail_verify_user',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %your_name, %website_url', 'felan-framework'),
											'default' => esc_html__('%your_name has submitted their information for verification.', 'felan-framework'),
										),
										array(
											'id' => 'felan_user_identity_mail_verified',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Send to User when admin verified','felan-framework'),
										),
										array(
											'id' => 'subject_identity_mail_verified',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Verified Information', 'felan-framework'),
										),
										array(
											'id' => 'identity_mail_verified',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %your_name, %website_url', 'felan-framework'),
											'default' => esc_html__('Congratulations! Your information has been verified and approved.', 'felan-framework'),
										),
										array(
											'id' => 'felan_user_identity_mail_cancel_verify',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Send to User when admin cancel verifiy', 'felan-framework'),
										),
										array(
											'id' => 'subject_identity_mail_cancel_verify',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Your Information was canceled', 'felan-framework'),
										),
										array(
											'id' => 'identity_mail_cancel_verify',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %your_name, %website_url', 'felan-framework'),
											'default' => esc_html__(
												'Your information has been canceled. Please submit again.',
												'felan-framework'
											),
										),
									)
								),

								array(
									'id' => 'email-activated-package',
									'title' => esc_html__('Activated Package', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_activated_package',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_activated_package',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Your purchase was activated', 'felan-framework'),
										),
										array(
											'id' => 'mail_activated_package',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_name, %package_name', 'felan-framework'),
											'default' => esc_html__(
												'Your plan on %website_name is now activated! You can now access all features according to your plan.
                                                If you have any questions, feel free to contact our support team.
                                                Best regards,
                                                The %website_name Team',
												'felan-framework'
											),
										)
									)
								),

								array(
									'id' => 'email-activated-freelancer-package',
									'title' => esc_html__('Activated Freelancer Package', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_activated_freelancer_package',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_activated_freelancer_package',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Freelancer Package Activated - %website_name', 'felan-framework'),
										),
										array(
											'id' => 'mail_activated_freelancer_package',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_name, %website_url, %package_name, %order_no, %package_price', 'felan-framework'),
											'default' => esc_html__(
												'PACKAGE DETAILS:
• Package Name: %package_name
• Order Number: %order_no
• Package Price: %package_price

												Your freelancer package on %website_name is now activated! You can now access all features according to your plan.

If you have any questions, feel free to contact our support team.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										)
									)
								),

								$new_jobs_apply,
								$jobs_activated_listing,
								$jobs_approved_listing,
								$jobs_expired_listing,
								$job_alerts,
								$job_approved_apply,
								$job_invite,
								$project_invite,
								$project_alerts,

								array(
									'id' => 'email-new-wire-transfer',
									'title' => esc_html__('New Wire Transfer', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_new_wire_transfer',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_new_wire_transfer',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('You ordered a new Wire Transfer', 'felan-framework'),
										),
										array(
											'id' => 'mail_new_wire_transfer',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_name, %invoice_no, %total_price', 'felan-framework'),
											'default' => esc_html__(
												'We received your Wire Transfer payment request on %website_name !
                                        Please follow the instructions below in order to start submitting properties as soon as possible.
                                        The invoice number is: %invoice_no, Amount: %total_price.',
												'felan-framework'
											),
										),
										array(
											'id' => 'felan_admin_mail_new_wire_transfer',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Admin Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_admin_mail_new_wire_transfer',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Somebody ordered a new Wire Transfer', 'felan-framework'),
										),
										array(
											'id' => 'admin_mail_new_wire_transfer',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_name, %website_url, %invoice_no, %total_price', 'felan-framework'),
											'default' => esc_html__(
												'We received your Wire Transfer payment request on %website_url!
                                        The invoice number is: %invoice_no, Amount: %total_price.',
												'felan-framework'
											),
										)
									)
								),

								// Service Package Payment Confirmation Email
								array(
									'id' => 'email-service-package-payment',
									'title' => esc_html__('Service Package Payment Confirmation', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_activated_service_package',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_activated_service_package',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Service Package Payment Confirmed - %website_name', 'felan-framework'),
										),
										array(
											'id' => 'mail_activated_service_package',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_name, %service_title, %service_author, %employer_order_url', 'felan-framework'),
											'default' => esc_html__(
												'🎉 SERVICE PACKAGE PURCHASE CONFIRMED!

Hi there!

We are pleased to confirm that your payment for the service package \"%service_title\" from %service_author has been successfully processed.

NEXT STEPS:
• Contact the freelancer to discuss project details
• Review your order in the dashboard
• Start collaborating on your project

View Order Details: %employer_order_url

If you have any questions, feel free to contact our support team.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										)
									)
								),

								// Project Package Payment Confirmation Email
								array(
									'id' => 'email-project-package-payment',
									'title' => esc_html__('Project Package Payment Confirmation', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_activated_project_package',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_activated_project_package',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Project Package Payment Confirmed - %website_name', 'felan-framework'),
										),
										array(
											'id' => 'mail_activated_project_package',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_name, %project_title, %project_author, %employer_order_url', 'felan-framework'),
											'default' => esc_html__(
												'🎉 PROJECT PACKAGE PURCHASE CONFIRMED!

Hi there!

We are pleased to confirm that your payment for the project package \"%project_title\" from %project_author has been successfully processed.

NEXT STEPS:
• Contact the freelancer to discuss project details
• Review your order in the dashboard
• Start collaborating on your project

View Order Details: %employer_order_url

If you have any questions, feel free to contact our support team.
Best regards,
The %website_name Team',
												'felan-framework'
											),
										)
									)
								),

								// Wallet Package Activation Email
								array(
									'id' => 'email-wallet-package-activation',
									'title' => esc_html__('Wallet Package Activation', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_user_mail_activated_wallet_package',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User Email', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_activated_wallet_package',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Wallet Top-up Successful - %website_name', 'felan-framework'),
										),
										array(
											'id' => 'mail_activated_wallet_package',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'subtitle' => esc_html__('Available shortcodes: %website_name, %wallet_amount, %user_role', 'felan-framework'),
											'title' => esc_html__('Content', 'felan-framework'),
											'default' => esc_html__(
												"💰 WALLET TOP-UP SUCCESSFUL!

Hi there!

Your wallet has been successfully topped up with %wallet_amount.

WALLET DETAILS:
• Amount Added: %wallet_amount
• Account Type: %user_role
• Status: Active

You can now use your wallet balance to purchase services and projects on our platform.

Best regards,
The %website_name Team",
												'felan-framework'
											),
										)
									)
								),

								array(
									'id' => 'email-meetings',
									'title' => esc_html__('Notification Meetings', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_info_mail_notification_meetings',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Notification Meetings', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_notification_meetings',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('You have a notification about the meeting', 'felan-framework'),
										),
										array(
											'id' => 'mail_notification_meetings',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %website_url, %jobs_meetings, %date_time', 'felan-framework'),
											'default' => esc_html__(
												'There is a meeting coming up at %website_url!
                                                Job related meeting: %jobs_meetings!
                                                Time for the meeting to start %date_time.',
												'felan-framework'
											),
										),
									)
								),

								// Withdrawal Notifications
								array(
									'id' => 'email-withdrawal-notifications',
									'title' => esc_html__('Withdrawal Notifications', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										// User confirmation for submitted withdrawal request
										array(
											'id' => 'felan_info_mail_withdrawal_request_submitted',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User - Withdrawal Request Submitted', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_withdrawal_request_submitted',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Withdrawal Request #%withdraw_id Submitted Successfully', 'felan-framework'),
										),
										array(
											'id' => 'mail_withdrawal_request_submitted',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %user_name, %withdraw_amount, %withdraw_fee, %receive_amount, %payment_method, %withdraw_id, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'✅ WITHDRAWAL REQUEST SUBMITTED

Hi %user_name,

Your withdrawal request has been submitted successfully and is now pending admin review.

💰 Withdrawal Amount: %withdraw_amount
📊 Service Fee: %withdraw_fee
💵 Amount to Receive: %receive_amount
💳 Payment Method: %payment_method
🆔 Withdrawal ID: #%withdraw_id

We will process your request within 1-3 business days. You will receive a notification once your request is approved.

⚠️ Note: The requested amount has been reserved in your account. If the withdrawal is canceled, the full amount will be refunded to your balance.

If you have any questions, please contact our support team.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),

										// Admin notification for new withdrawal request
										array(
											'id' => 'felan_info_admin_mail_new_withdrawal_request',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Admin - New Withdrawal Request', 'felan-framework'),
										),
										array(
											'id' => 'subject_admin_mail_new_withdrawal_request',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Withdrawal Request #%withdraw_id', 'felan-framework'),
										),
										array(
											'id' => 'admin_mail_new_withdrawal_request',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %user_name, %withdraw_amount, %withdraw_fee, %receive_amount, %payment_method, %withdraw_id, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'🔔 NEW WITHDRAWAL REQUEST

A freelancer has submitted a new withdrawal request.

👤 User: %user_name
💰 Withdrawal Amount: %withdraw_amount
📊 Service Fee: %withdraw_fee
💵 Amount to Receive: %receive_amount
💳 Payment Method: %payment_method
🆔 Withdrawal ID: #%withdraw_id

Please review and process this withdrawal request in the admin panel.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),

										// User notification for approved withdrawal
										array(
											'id' => 'felan_info_mail_withdrawal_completed',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User - Withdrawal Approved', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_withdrawal_completed',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Your Withdrawal Request #%withdraw_id Has Been Approved', 'felan-framework'),
										),
										array(
											'id' => 'mail_withdrawal_completed',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %user_name, %withdraw_amount, %withdraw_fee, %receive_amount, %payment_method, %withdraw_id, %process_date, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'✅ WITHDRAWAL APPROVED

Hi %user_name,

Good news! Your withdrawal request has been approved and processed.

💰 Withdrawal Amount: %withdraw_amount
📊 Service Fee: %withdraw_fee
💵 Amount Received: %receive_amount
💳 Payment Method: %payment_method
🆔 Withdrawal ID: #%withdraw_id
📅 Processed Date: %process_date

The funds should arrive in your account within 3-5 business days depending on your payment method.

If you have any questions, please contact our support team.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),

										// User notification for canceled withdrawal
										array(
											'id' => 'felan_info_mail_withdrawal_canceled',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('User - Withdrawal Canceled', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_withdrawal_canceled',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Your Withdrawal Request #%withdraw_id Has Been Canceled', 'felan-framework'),
										),
										array(
											'id' => 'mail_withdrawal_canceled',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'subtitle' => esc_html__('Available shortcodes: %user_name, %withdraw_amount, %withdraw_fee, %receive_amount, %payment_method, %withdraw_id, %process_date, %website_name', 'felan-framework'),
											'title' => esc_html__('Content', 'felan-framework'),
											'default' => esc_html__(
												'❌ WITHDRAWAL CANCELED

Hi %user_name,

We regret to inform you that your withdrawal request has been canceled.

💰 Withdrawal Amount: %withdraw_amount
📊 Service Fee: %withdraw_fee
💵 Refunded Amount: %receive_amount
💳 Payment Method: %payment_method
🆔 Withdrawal ID: #%withdraw_id
📅 Canceled Date: %process_date

The full amount has been returned to your account balance. You can submit a new withdrawal request at any time.

If you have any questions or concerns, please contact our support team.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),
									)
								),

								array(
									'id' => 'new-freelancer-send-proposal',
									'title' => esc_html__('Freelancer send a proposal', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_info_mail_project_send_proposal',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Send proposal', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_project_send_proposal',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Proposal Submitted for Your Project', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_send_proposal',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %project_name, %proposal_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'📋 NEW PROPOSAL RECEIVED - Review Required

Hi %employer_name,

%freelancer_name has submitted a new proposal for your project: "%project_name".

Please review the proposal details and respond to the freelancer.

📋 Review Proposal: %proposal_url

💡 Tip: Quick response helps maintain good relationships with freelancers.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),
										array(
											'id' => 'felan_info_mail_project_update_proposal',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Update proposal', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_project_update_proposal',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('A Proposal has been updated', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_update_proposal',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %project_name, %proposal_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'📋 PROPOSAL UPDATED - Review Required

Hi %employer_name,

%freelancer_name has updated their proposal for your project: "%project_name".

Please review the updated proposal details and respond to the freelancer.

📋 Review Updated Proposal: %proposal_url

💡 Tip: Consider the freelancer\'s improvements and provide constructive feedback.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-freelancer-send-message-dispute',
									'title' => esc_html__('Freelancer sends a message in the dispute activity detail for project', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_project_send_message_dispute',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Dispute for Project', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_send_message_dispute',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %project_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has sent a new message regarding the dispute for project: %project_name.
												You can view the message and respond here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-freelancer-approves-dispute-project',
									'title' => esc_html__('Freelancer approves a dispute project', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_approve_dispute_project',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('A Freelancer has approved a dispute', 'felan-framework'),
										),
										array(
											'id' => 'mail_approve_dispute_project',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %project_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has approved dispute for your project: %project_name.
												You can review here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-freelancer-denies-dispute-project',
									'title' => esc_html__('Freelancer denies a dispute project', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_denies_dispute_project',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('A Freelancer has denied a dispute', 'felan-framework'),
										),
										array(
											'id' => 'mail_denies_dispute_project',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %project_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has denied dispute for your project: %project_name.
												You can review here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-freelancer-approves-dispute-service',
									'title' => esc_html__('Freelancer approves a dispute service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_approve_dispute_service',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('A Freelancer has approved a dispute', 'felan-framework'),
										),
										array(
											'id' => 'mail_approve_dispute_service',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %service_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has approved dispute for your service: %service_name.
												You can review here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-freelancer-denies-dispute-service',
									'title' => esc_html__('Freelancer denies a dispute service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_denies_dispute_service',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('A Freelancer has denied a dispute', 'felan-framework'),
										),
										array(
											'id' => 'mail_denies_dispute_service',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %service_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has denied dispute for your service: %service_name.
												You can review here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-freelancer-send-message-proposal',
									'title' => esc_html__('Freelancer sends a message in the proposal activity detail', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_info_mail_project_send_message_proposal',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Send message', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_project_send_message_proposal',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Proposal for Your Project', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_send_message_proposal',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %project_name, %proposal_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has sent a new message regarding the proposal for your project: %project_name.
												You can view the message and respond here:
												View Message
												Best regards',
												'felan-framework'
											),
										),

									)
								),
								array(
									'id' => 'new-freelancer-send-message-service',
									'title' => esc_html__('Freelancer send message in service activity detail', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_service_freelancer_send_message',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Service', 'felan-framework'),
										),
										array(
											'id' => 'mail_service_freelancer_send_message',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %service_name, %service_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has sent a new message for service: %service_name.
												You can review the details and respond directly here:
												View message
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-freelancer-send-message-dispute-service',
									'title' => esc_html__('Freelancer sends a message in the dispute activity detail for service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_service_send_message_dispute',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Dispute for service', 'felan-framework'),
										),
										array(
											'id' => 'mail_service_send_message_dispute',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %employer_name, %freelancer_name, %service_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %employer_name,
												%freelancer_name has sent a new message regarding the dispute for service: %service_name.
												You can view the message and respond here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-place-order-service',
									'title' => esc_html__('Employer Orders New Service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(

										array(
											'id' => 'subject_mail_service_employer_place_order',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('🎯 New Service Order - Action Required', 'felan-framework'),
										),
										array(
											'id' => 'mail_service_employer_place_order',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %service_name, %order_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'🎯 SERVICE ORDER ALERT - Immediate Action Required!

Hi %freelancer_name,

Great news! Your service "%service_name" has just been purchased by %employer_name.

IMMEDIATE ACTION REQUIRED:
• Contact the employer within 24 hours to discuss requirements
• Review the service specifications and delivery timeline
• Start working on the project immediately
• Update order status as you progress

📋 Order Details: %order_url

💡 Tip: Quick response = Happy clients = More orders!

Remember to provide excellent service to maintain your reputation on our platform.
Best regards,
The %website_name Team',
												'felan-framework'
											),
										),
									)
								),

								array(
									'id' => 'new-employer-place-order-project',
									'title' => esc_html__('Employer Orders New Project', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(

										array(
											'id' => 'subject_mail_project_employer_place_order',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('🚀 New Project Order - Action Required', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_employer_place_order',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
																						'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %project_name, %order_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'🚀 PROJECT ORDER ALERT - New Opportunity!

Hi %freelancer_name,

Excellent news! Your project "%project_name" has been purchased by %employer_name.

IMMEDIATE ACTION REQUIRED:
• Contact the employer within 24 hours to discuss project scope
• Review the project requirements and milestones
• Plan your project timeline and deliverables
• Update order status as you progress

📋 Project Details: %order_url

💡 Tip: Clear communication = Successful projects = Great reviews!

Remember to provide excellent service to maintain your reputation on our platform.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										)
									)
								),


								array(
									'id' => 'new-employer-complete-service',
									'title' => esc_html__('Employer Complete Service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_employer_complete_service',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Service Completed', 'felan-framework'),
										),
										array(
											'id' => 'mail_employer_complete_service',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %service_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has marked the service: %service_name as completed.
												Please review the order details here:
												View Order Details
												Thank you',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-cancel-service',
									'title' => esc_html__('Employer Cancel Service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_employer_cancel_service',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Service Canceled', 'felan-framework'),
										),
										array(
											'id' => 'mail_employer_cancel_service',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %service_name', 'felan-framework'),
											'title' => esc_html__('Content', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has marked the service: %service_name as canceled.
												Please review the order details here:
												View Order Details
												Thank you',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-create-dispute-service',
									'title' => esc_html__('Employer create dispute for service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_service_employer_create_dispute',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Employer create dispute service', 'felan-framework'),
										),
										array(
											'id' => 'mail_service_employer_create_dispute',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %service_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has created a dispute for service: %service_name.
												You can review the details and respond directly here:
												View dispute
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-send-message-dispute-service',
									'title' => esc_html__('Employer sends a message in the dispute activity detail for service', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_service_employer_send_message_dispute',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Dispute for service', 'felan-framework'),
										),
										array(
											'id' => 'mail_service_employer_send_message_dispute',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %service_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has sent a new message regarding the dispute for service: %service_name.
												You can view the message and respond here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-send-message-dispute',
									'title' => esc_html__('Employer sends a message in the dispute activity detail for project', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_project_employer_send_message_dispute',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Dispute for Project', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_employer_send_message_dispute',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %project_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has sent a new message regarding the dispute for project: %project_name.
												You can view the message and respond here:
												View Dispute Details
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-approve-proposal',
									'title' => esc_html__('Employer Approve proposal', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_project_employer_approve_proposal',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Employer Approve proposal', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_employer_approve_proposal',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %project_name, %proposal_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'🎉 PROPOSAL APPROVED - Project Started!

Hi %freelancer_name,

Great news! %employer_name has approved your proposal for project "%project_name".

Your project is now officially started! Here\'s what happens next:

NEXT STEPS:
• Contact the employer to confirm project details
• Review the approved proposal and requirements
• Begin working on the project deliverables
• Update project status as you progress

📋 Project Details: %proposal_url

💡 Tip: Maintain regular communication with the employer to ensure project success.

Congratulations on getting your proposal approved!

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-rejected-proposal',
									'title' => esc_html__('Employer rejected proposal', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_project_employer_rejected_proposal',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Employer rejected proposal', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_employer_rejected_proposal',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %project_name, %proposal_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'📋 PROPOSAL REJECTED - Review Required

Hi %freelancer_name,

%employer_name has rejected your proposal for project: "%project_name".

Please review the rejection details and consider revising your proposal if needed.

📋 Review Proposal: %proposal_url

💡 Tip: Consider the employer\'s feedback and submit an improved proposal to increase your chances of acceptance.

Best regards,
The %website_name Team',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-create-dispute-proposal',
									'title' => esc_html__('Employer create dispute proposal', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_project_employer_create_dispute_proposal',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('Employer create dispute proposal', 'felan-framework'),
										),
										array(
											'id' => 'mail_project_employer_create_dispute_proposal',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %project_name, %dispute_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has created a dispute proposal for project: %project_name.
												You can review the details and respond directly here:
												View dispute
												Best regards',
												'felan-framework'
											),
										),
									)
								),
								array(
									'id' => 'new-employer-send-message-proposal',
									'title' => esc_html__('Employer sends a message in the proposal activity detail', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'felan_info_mail_employer_send_message_proposal',
											'type' => 'info',
											'style' => 'info',
											'title' => esc_html__('Send message', 'felan-framework'),
										),
										array(
											'id' => 'subject_mail_employer_send_message_proposal',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Proposal for Project', 'felan-framework'),
										),
										array(
											'id' => 'mail_employer_send_message_proposal',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %project_name, %proposal_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has sent a new message regarding the proposal for project: %project_name.
												You can view the message and respond here:
												View Message
												Best regards',
												'felan-framework'
											),
										),

									)
								),
								array(
									'id' => 'new-employer-send-message-service',
									'title' => esc_html__('Employer send message in service activity detail', 'felan-framework'),
									'type' => 'group',
									'toggle_default' => false,
									'fields' => array(
										array(
											'id' => 'subject_mail_service_employer_send_message',
											'type' => 'text',
											'title' => esc_html__('Subject', 'felan-framework'),
											'default' => esc_html__('New Message in Service', 'felan-framework'),
										),
										array(
											'id' => 'mail_service_employer_send_message',
											'type' => 'editor',
											'args' => array(
												'media_buttons' => true,
												'quicktags' => true,
											),
											'title' => esc_html__('Content', 'felan-framework'),
											'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %service_name, %service_url, %website_name', 'felan-framework'),
											'default' => esc_html__(
												'Hello %freelancer_name,
												%employer_name has sent a new message for service: %service_name.
												You can review the details and respond directly here:
												View message
												Best regards',
												'felan-framework'
											),
										),
									)
								),
							)
						),
						//Footer
						array(
							'id' => 'email-footer',
							'title' => esc_html__('Footer Email', 'felan-framework'),
							'type' => 'group',
							'toggle_default' => false,
							'fields' => array(
								array(
									'id' => 'mail_footer_user',
									'type' => 'editor',
									'args' => array(
										'media_buttons' => true,
										'quicktags' => true,
									),
									'title' => esc_html__('Content', 'felan-framework'),
									'subtitle' => esc_html__('Available shortcodes: %freelancer_name, %employer_name, %website_name', 'felan-framework'),
									'default' => esc_html__(
										'Do you need help? Contact us
                                        T. (00) 658 54332
                                        E. hello@ricetheme.com
                                        © ' . date('Y') . ' RiceTheme. All Right Reserved.',
										'felan-framework'
									),
								),
							)
						),
					),
					apply_filters('felan_register_option_email_management_bottom', array())
				)
			));
		}
}
