<?php
/**
 * Felan General Options Trait
 * Extracted from class-felan-admin.php
 * Contains: general_option, payout_option, setup_page
 *
 * @package Felan_Framework
 */

if (!defined('ABSPATH')) {
    exit;
}

trait Felan_General_Options_Trait
{
		private function general_option()
		{
			$prefix_code = phone_prefix_code();
			$keys = $values = array();
			foreach ($prefix_code as $key => $value) {
				$keys[] = $key;
				$values[] = $value['name'];
			}
			$phone_code_select = array_combine($keys, $values);

			return apply_filters('felan_register_option_general', array(
				'id' => 'felan_general_option',
				'title' => esc_html__('General Option', 'felan-framework'),
				'icon' => 'dashicons-admin-multisite',
				'fields' => array_merge(
					apply_filters('felan_register_option_general_top', array()),
					array(
						array(
							'id' => 'enable_post_type_jobs',
							'type' => 'button_set',
							'title' => esc_html__('Enable post type jobs', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable post type jobs', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => 'enable_post_type_service',
							'type' => 'button_set',
							'title' => esc_html__('Enable post type services', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable post type services', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => 'enable_post_type_project',
							'type' => 'button_set',
							'title' => esc_html__('Enable post type projects', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable post type projects', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						/* Temporay disable wallet mode due to it under developing, need recheck affect of it to other functions*/
						// array(
						// 	'id' => 'enable_wallet_mode',
						// 	'type' => 'button_set',
						// 	'title' => esc_html__('Enable wallet mode', 'felan-framework'),
						// 	'subtitle' => esc_html__('Enable/Disable wallet mode', 'felan-framework'),
						// 	'desc' => '',
						// 	'options' => array(
						// 		'1' => esc_html__('On', 'felan-framework'),
						// 		'0' => esc_html__('Off', 'felan-framework'),
						// 	),
						// 	'default' => '0',
						// ),
						array(
							'id' => 'enable_admin_approval_package',
							'type' => 'button_set',
							'title' => esc_html__('Enable admin approval for package', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Pending admin approval for package purchase', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => 'enable_switch_account',
							'type' => 'button_set',
							'title' => esc_html__('Enable Switch Account', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Switch Account', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'enable_24_time_format',
							'type' => 'button_set',
							'title' => esc_html__('Enable Time Format', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Time Format (24H)', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'enable_cookie',
							'type' => 'button_set',
							'title' => esc_html__('Enable Cookie Notice', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Popup Cookie Notice', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "enable_back_top",
							'type' => 'button_set',
							'title' => esc_html__('Enable Back To Top', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Enable Back To Top', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'enable_search_box_dropdown',
							'type' => 'button_set',
							'title' => esc_html__('Enable Search Box', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Search Box for Dropdown', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'limit_search_box',
							'title' => esc_html__('Limit Search Box', 'felan-framework'),
							'type' => 'text',
							'default' => '6',
							'pattern' => '[0-9]*',
							'subtitle' => 'If the option selects more than the set number, a search box will be displayed.',
							'required' => array(
								array("enable_search_box_dropdown", '=', '1')
							),
						),
						array(
							'id' => 'enable_rtl_mode',
							'type' => 'button_set',
							'title' => esc_html__('Enable RTL Mode', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable RTL mode', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0'
						),
						array(
							'id' => 'default_phone_number',
							'type' => 'selectize',
							'title' => esc_html__('Default Phone Number', 'felan-framework'),
							'subtitle' => esc_html__('Chosse Default Phone Number', 'felan-framework'),
							'options' => $phone_code_select,
							'allow_clear' => true,
							'default' => '0',
						),
						array(
							'id' => 'felan-cv-type',
							'title' => esc_html__('Cv Types', 'felan-framework'),
							'type' => 'text',
							'default' => 'doc,docx,pdf',
							'subtitle' => 'Add "," to separate file formats',
						),
						array(
							'id' => 'felan_image_type',
							'title' => esc_html__('Types Upload Image', 'felan-framework'),
							'type' => 'text',
							'default' => 'jpg,jpeg,png,gif,webp',
							'subtitle' => 'Add "," to separate file formats',
						),
						array(
							'id' => 'felan_max_gallery_images',
							'type' => 'text',
							'title' => esc_html__('Maximum Images', 'felan-framework'),
							'subtitle' => esc_html__('Maximum images allowed for single jobs.', 'felan-framework'),
							'default' => '5',
						),
						array(
							'id' => 'felan_image_max_file_size',
							'type' => 'text',
							'title' => esc_html__('Maximum File Size', 'felan-framework'),
							'subtitle' => esc_html__('Maximum upload image size. For example 10kb, 500kb, 1mb, 10mb, 100mb', 'felan-framework'),
							'default' => '1000kb',
						),
						array(
							'id' => 'felan_price_min',
							'type' => 'text',
							'title' => esc_html__('Price Min', 'felan-framework'),
							'subtitle' => esc_html__('Enter Price Min', 'felan-framework'),
							'pattern' => '[0-9]*',
							'default' => '0',
						),
						array(
							'id' => 'felan_price_max',
							'type' => 'text',
							'title' => esc_html__('Price Max', 'felan-framework'),
							'subtitle' => esc_html__('Enter Price Max', 'felan-framework'),
							'pattern' => '[0-9]*',
							'default' => '1000',
						),
						array(
							'id' => "felan_distance_unit",
							'title' => esc_html__('Distance unit on location', 'felan-framework'),
							'subtitle' => esc_html__('Select the distance unit in the location', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'km' => 'Kilometers (km)',
								'mi' => 'Miles (mi)',
							),
						),
						array(
							'id' => 'social_sharing',
							'type' => 'checkbox_list',
							'title' => esc_html__('Show Social Sharing', 'felan-framework'),
							'subtitle' => esc_html__('Choose which fields you want to show on social sharing?', 'felan-framework'),
							'options' => array(
								'facebook' => esc_html__('Facebook', 'felan-framework'),
								'twitter' => esc_html__('Twitter', 'felan-framework'),
								'linkedin' => esc_html__('Linkedin', 'felan-framework'),
								'tumblr' => esc_html__('Tumblr', 'felan-framework'),
								'pinterest' => esc_html__('Pinterest', 'felan-framework'),
								'whatapp' => esc_html__('Whatapp', 'felan-framework'),
							),
							'value_inline' => false,
							'default' => array('facebook', 'twitter', 'linkedin', 'tumblr', 'pinterest', 'whatapp')
						),
						array(
							'id' => 'auto_add_nofollow_links',
							'type' => 'button_set',
							'title' => esc_html__('Auto Add Nofollow to User Links', 'felan-framework'),
							'subtitle' => esc_html__('Automatically add rel="nofollow ugc" attribute to all external links in user-submitted content (jobs, projects, services, freelancers, companies, comments)', 'felan-framework'),
							'desc' => esc_html__('Helps prevent spam backlinks, maintains your site SEO authority, and ensures compliance with Google guidelines for user-generated content', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => 'header_script',
							'type' => 'ace_editor',
							'title' => esc_html__('Header Script', 'felan-framework'),
							'subtitle' => esc_html__('Add custom scripts inside HEAD tag. You need to have a SCRIPT tag around scripts.', 'felan-framework'),
							'default' => ''
						),
						array(
							'id' => 'footer_script',
							'type' => 'ace_editor',
							'title' => esc_html__('Footer Script', 'felan-framework'),
							'subtitle' => esc_html__('Add custom scripts you might want to be loaded in the footer of your website. You need to have a SCRIPT tag around scripts.', 'felan-framework'),
							'default' => ''
						),
					),
					apply_filters('felan_register_option_general_bottom', array())
				)
			));
		}

		/**
		 * @return mixed|void
		 */
		private function payout_option()
		{
			return apply_filters('felan_register_option_payout', array(
				'id' => 'felan_payout_option',
				'title' => esc_html__('Payout Option', 'felan-framework'),
				'icon' => 'dashicons dashicons-index-card',
				'fields' => array_merge(
					apply_filters('felan_register_option_payout_top', array()),
					apply_filters('felan_register_option_payout_main', array(
						array(
							'id' => "enable_payout_paypal",
							'type' => 'button_set',
							'title' => esc_html__('Enable Payout Paypal', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Payout Paypal', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "enable_payout_stripe",
							'type' => 'button_set',
							'title' => esc_html__('Enable Payout Stripe', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Payout Stripe', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "enable_payout_bank_transfer",
							'type' => 'button_set',
							'title' => esc_html__('Enable Payout Bank Transfer', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Bank Transfer', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "custom_payout_setting",
							'type' => 'panel',
							'title' => esc_html__('Custom Payout', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'title' => esc_html__('Name Payout', 'felan-framework'),
									'id' => "name",
									'type' => 'text',
									'subtitle' => esc_html__('Enter Same "Name Payout" if you want multiple fields in Payout', 'felan-framework'),
									'default' => '',
								),
								array(
									'title' => esc_html__('Label', 'felan-framework'),
									'id' => "label",
									'type' => 'text',
									'default' => '',
								),
								array(
									'title' => esc_html__('ID', 'felan-framework'),
									'id' => "id",
									'type' => 'text',
									'placeholder' => esc_html__('Enter field ID', 'felan-framework'),
									'desc' => esc_html__('ID cannot be duplicated', 'felan-framework'),
									'default' => '',
								),
								array(
									'title' => esc_html__('Field Type', 'felan-framework'),
									'id' => "type",
									'type' => 'select',
									'default' => 'text',
									'options' => array(
										'text' => esc_html__('Text', 'felan-framework'),
										'number' => esc_html__('Number', 'felan-framework'),
										'email' => esc_html__('Email', 'felan-framework'),
									)
								),
							)
						)
					)),
					apply_filters('felan_register_option_payout_bottom', array())
				)
			));
		}

		/**
		 * @return mixed|void
		 */
		private function setup_page()
		{
			$service_page_id = $payment_service_page_id = $service_payment_completed_page_id = $freelancer_service_page_id = $submit_service_page_id
				= $jobs_dashboard_page_id = $jobs_submit_page_id = $meetings_page_id = $freelancer_meetings_page_id = $my_jobs_page_id
				= $projects_submit_page_id = $projects_page_id = $payment_project_page_id = $project_payment_completed_page_id = $my_project_page_id
				= $disputes_page_id = $freelancer_disputes_page_id = $employer_user_package_page = $employer_package_page = $employer_wallet
				= $freelancer_user_package_page = $freelancer_package_page = $employer_payment_page = $employer_payment_completed_page
				= $freelancer_payment_page = $freelancer_payment_completed_page = $payment_thank_you_id = array();

			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');

			if ($enable_post_type_jobs == '1') {
				$jobs_dashboard_page_id = array(
					'id' => 'felan_jobs_dashboard_page_id',
					'title' => esc_html__('Jobs Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$jobs_submit_page_id = array(
					'id' => 'felan_jobs_submit_page_id',
					'title' => esc_html__('Jobs Submit Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$meetings_page_id =  array(
					'id' => 'felan_meetings_page_id',
					'title' => esc_html__('Meetings Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$freelancer_meetings_page_id = array(
					'id' => 'felan_freelancer_meetings_page_id',
					'title' => esc_html__('Meetings Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				$my_jobs_page_id = array(
					'id' => 'felan_my_jobs_page_id',
					'title' => esc_html__('My Jobs Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
			}

			if ($enable_post_type_service == '1') {
				$service_page_id =  array(
					'id' => 'felan_employer_service_page_id',
					'title' => esc_html__('Services Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				if ($enable_wallet_mode == '0') {
					$payment_service_page_id =  array(
						'id' => 'felan_payment_service_page_id',
						'title' => esc_html__('Payment Service Page', 'felan-framework'),
						'type' => 'selectize',
						'data' => 'page',
						'allow_clear' => true,
						'data_args' => array(
							'numberposts' => -1,
						)
					);
					$service_payment_completed_page_id = array(
						'id' => 'felan_service_payment_completed_page_id',
						'title' => esc_html__('Payment Service Completed Page', 'felan-framework'),
						'type' => 'selectize',
						'data' => 'page',
						'allow_clear' => true,
						'data_args' => array(
							'numberposts' => -1,
						)
					);
				}

				$freelancer_service_page_id = array(
					'id' => 'felan_freelancer_service_page_id',
					'title' => esc_html__('Services Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$submit_service_page_id = array(
					'id' => 'felan_submit_service_page_id',
					'title' => esc_html__('Submit Service', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
			}

			if ($enable_post_type_project == '1') {
				$projects_submit_page_id = array(
					'id' => 'felan_projects_submit_page_id',
					'title' => esc_html__('Projects Submit Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$projects_page_id = array(
					'id' => 'felan_projects_page_id',
					'title' => esc_html__('Projects Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				$proposals_page_id = array(
					'id' => 'felan_proposal_page_id',
					'title' => esc_html__('Proposals Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				if ($enable_wallet_mode == '0') {
					$payment_project_page_id = array(
						'id' => 'felan_payment_project_page_id',
						'title' => esc_html__('Payment Project Page', 'felan-framework'),
						'type' => 'selectize',
						'allow_clear' => true,
						'data' => 'page',
						'data_args' => array(
							'numberposts' => -1,
						)
					);
					$project_payment_completed_page_id = array(
						'id' => 'felan_project_payment_completed_page_id',
						'title' => esc_html__('Payment Project Completed Page', 'felan-framework'),
						'type' => 'selectize',
						'allow_clear' => true,
						'data' => 'page',
						'data_args' => array(
							'numberposts' => -1,
						)
					);
				} else {
					// Initialize payment project variables as empty arrays when wallet mode is enabled
					$payment_project_page_id = array();
					$project_payment_completed_page_id = array();
				}
				$my_project_page_id =  array(
					'id' => 'felan_my_project_page_id',
					'title' => esc_html__('My project Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
			} else {
				// Initialize project-related variables as empty arrays when project post type is disabled
				$projects_submit_page_id = array();
				$projects_page_id = array();
				$proposals_page_id = array();
				$payment_project_page_id = array();
				$project_payment_completed_page_id = array();
				$my_project_page_id = array();
			}

			if ($enable_post_type_service == '1' || $enable_post_type_project == '1') {
				$disputes_page_id =  array(
					'id' => 'felan_disputes_page_id',
					'title' => esc_html__('Disputes Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				$freelancer_disputes_page_id = array(
					'id' => 'felan_freelancer_disputes_page_id',
					'title' => esc_html__('Disputes Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
			}

			if ($enable_wallet_mode == '0') {
				$employer_user_package_page = array(
					'id' => 'felan_user_package_page_id',
					'title' => esc_html__('User Package Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				$employer_package_page = array(
					'id' => 'felan_package_page_id',
					'title' => esc_html__('Package Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				$freelancer_user_package_page = array(
					'id' => 'felan_freelancer_user_package_page_id',
					'title' => esc_html__('User Package Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				$freelancer_package_page = array(
					'id' => 'felan_freelancer_package_page_id',
					'title' => esc_html__('Package Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$employer_payment_page =  array(
					'id' => 'felan_payment_page_id',
					'title' => esc_html__('Payment Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$employer_payment_completed_page = array(
					'id' => 'felan_payment_completed_page_id',
					'title' => esc_html__('Payment Completed Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$freelancer_payment_page = array(
					'id' => 'felan_freelancer_payment_page_id',
					'title' => esc_html__('Payment Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);

				$freelancer_payment_completed_page = array(
					'id' => 'felan_freelancer_payment_completed_page_id',
					'title' => esc_html__('Payment Completed Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
			}

			if ($enable_wallet_mode == '1') {
				$employer_wallet = array(
					'id' => 'felan_wallet_page_id',
					'title' => esc_html__('Wallet Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
				$payment_thank_you_id = array(
					'id' => 'felan_thank_you_page_id',
					'title' => esc_html__('Thank You Page', 'felan-framework'),
					'type' => 'selectize',
					'data' => 'page',
					'allow_clear' => true,
					'data_args' => array(
						'numberposts' => -1,
					)
				);
			}

			$title_freelancers = esc_html__('Freelancers Page', 'felan-framework');
			$title_freelancer_settings = esc_html__('Freelancer Settings', 'felan-framework');
			if ($enable_post_type_jobs == '1' && $enable_post_type_service !== '1' && $enable_post_type_project !== '1') {
				$title_freelancers = esc_html__('Candidate Page', 'felan-framework');
				$title_freelancer_settings = esc_html__('Candidate Settings', 'felan-framework');
			}
			return apply_filters('felan_register_setup_page', array(
				'id' => 'felan_setup_page',
				'title' => esc_html__('Setup Page', 'felan-framework'),
				'icon' => 'dashicons-admin-page',
				'fields' => array_merge(
					apply_filters('felan_register_setup_page_employer_top', array()),
					array(
						array(
							'id' => 'sp_sign_in',
							'title' => esc_html__('Sign In', 'felan-framework'),
							'type' => 'selectize',
							'data' => 'page',
							'allow_clear' => true,
							'data_args' => array(
								'numberposts' => -1,
							)
						),
						array(
							'id' => 'sp_sign_up',
							'title' => esc_html__('Sign Up', 'felan-framework'),
							'type' => 'selectize',
							'data' => 'page',
							'allow_clear' => true,
							'data_args' => array(
								'numberposts' => -1,
							)
						),
						array(
							'id' => 'terms_condition',
							'title' => esc_html__('Terms & Conditions', 'felan-framework'),
							'type' => 'selectize',
							'data' => 'page',
							'allow_clear' => true,
							'data_args' => array(
								'numberposts' => -1,
							)
						),
						array(
							'id' => 'privacy_policy',
							'title' => esc_html__('Privacy Policy', 'felan-framework'),
							'type' => 'selectize',
							'data' => 'page',
							'allow_clear' => true,
							'data_args' => array(
								'numberposts' => -1,
							)
						),
						array(
							'id' => 'felan_update_profile_page_id',
							'title' => esc_html__('Update Profile', 'felan-framework'),
							'type' => 'selectize',
							'data' => 'page',
							'allow_clear' => true,
							'data_args' => array(
								'numberposts' => -1,
							)
						),
						array(
							'id' => 'felan_add_project_page_id',
							'title' => esc_html__('Post Project/Job (Login)', 'felan-framework'),
							'type' => 'selectize',
							'data' => 'page',
							'allow_clear' => true,
							'data_args' => array(
								'numberposts' => -1,
							)
						),
						array(
							'id' => 'felan_add_project_not_page_id',
							'title' => esc_html__('Post Project/Job (Not Login)', 'felan-framework'),
							'type' => 'selectize',
							'data' => 'page',
							'allow_clear' => true,
							'data_args' => array(
								'numberposts' => -1,
							)
						),

						$payment_thank_you_id,

						apply_filters('felan_register_setup_page_employer_option_main', array(
							'id' => 'felan_register_setup_page_employer_option_main',
							'type' => 'group',
							'title' => esc_html__('Employer Setting', 'felan-framework'),
							'fields' => array(
								array(
									'id' => 'felan_dashboard_page_id',
									'title' => esc_html__('Dashboard Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_freelancers_page_id',
									'title' => $title_freelancers,
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_company_page_id',
									'title' => esc_html__('Company Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_submit_company_page_id',
									'title' => esc_html__('Submit Company Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_messages_page_id',
									'title' => esc_html__('Messages Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_verification_page_id',
									'title' => esc_html__('Identity Verification Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_settings_page_id',
									'title' => esc_html__('Settings Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),

								$employer_user_package_page,
								$employer_package_page,
								$employer_wallet,

								$employer_payment_page,
								$employer_payment_completed_page,

								$disputes_page_id,
								$meetings_page_id,

								$jobs_dashboard_page_id,
								$jobs_submit_page_id,

								$service_page_id,
								$payment_service_page_id,
								$service_payment_completed_page_id,

								$projects_submit_page_id,
								$projects_page_id,
								$proposals_page_id,
								$payment_project_page_id,
								$project_payment_completed_page_id,
							),
						))
					),
					apply_filters('felan_register_setup_page_employer_bottom', array()),
					apply_filters('felan_register_setup_page_freelancer_top', array()),
					array(
						apply_filters('felan_register_setup_page_freelancer_option_main', array(
							'id' => 'felan_register_setup_page_freelancer_option_main',
							'type' => 'group',
							'title' => $title_freelancer_settings,
							'fields' => array(
								array(
									'id' => 'felan_freelancer_dashboard_page_id',
									'title' => esc_html__('Dashboard Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_freelancer_profile_page_id',
									'title' => esc_html__('Profile Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_freelancer_verification_page_id',
									'title' => esc_html__('Identity Verification Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_freelancer_reviews_page_id',
									'title' => esc_html__('My Reviews Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_freelancer_company_page_id',
									'title' => esc_html__('My Following', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_freelancer_messages_page_id',
									'title' => esc_html__('Messages Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),
								array(
									'id' => 'felan_freelancer_settings_page_id',
									'title' => esc_html__('Settings Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),

								$freelancer_user_package_page,
								$freelancer_package_page,

								$freelancer_payment_page,
								$freelancer_payment_completed_page,

								array(
									'id' => 'felan_freelancer_wallet_page_id',
									'title' => esc_html__('Wallet Page', 'felan-framework'),
									'type' => 'selectize',
									'data' => 'page',
									'allow_clear' => true,
									'data_args' => array(
										'numberposts' => -1,
									)
								),

								$freelancer_disputes_page_id,
								$freelancer_meetings_page_id,
								$my_jobs_page_id,

								$freelancer_service_page_id,
								$submit_service_page_id,
								$my_project_page_id,
							),
						)),
					),
					apply_filters('felan_register_setup_page_freelancer_bottom', array())
				)
			));
		}
}
