<?php

/**
 * Felan Payment Options Trait
 * Extracted from class-felan-admin.php
 * Contains: payment_option, wallet_option
 *
 * @package Felan_Framework
 */

if (!defined('ABSPATH')) {
	exit;
}

trait Felan_Payment_Options_Trait
{
	private function payment_option()
	{
		$option_payment_service = $option_payment_project = array();
		$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
		$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
		$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
		$title_freelancers = esc_html__('Freelancer Settings', 'felan-framework');
		$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');
		if ($enable_post_type_jobs == '1' && $enable_post_type_service !== '1' && $enable_post_type_project !== '1') {
			$title_freelancers = esc_html__('Candidate Settings', 'felan-framework');
		}

		if ($enable_post_type_service == '1') {
			$option_payment_service = array(
				'id' => 'felan_main_group',
				'type' => 'group',
				'title' => esc_html__('Service Settings', 'felan-framework'),
				'fields' => array(
					array(
						'id' => 'felan_service_paypal',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Paypal Setting', 'felan-framework'),
					),
					array(
						'id' => 'service_enable_paypal',
						'title' => esc_html__('Enable Paypal', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'service_paypal_api',
						'type' => 'select',
						'required' => array(
							array('service_enable_paypal', '=', '1'),
						),
						'title' => esc_html__('Paypal Api', 'felan-framework'),
						'subtitle' => esc_html__('Sandbox = test API. LIVE = real payments API', 'felan-framework'),
						'desc' => esc_html__('Update PayPal settings according to API type selection', 'felan-framework'),
						'options' => array(
							'sandbox' => esc_html__('Sandbox', 'felan-framework'),
							'live' => esc_html__('Live', 'felan-framework')
						),
						'default' => 'sandbox',
					),
					array(
						'id' => 'service_paypal_client_id',
						'type' => 'text',
						'required' => array(
							array('service_enable_paypal', '=', '1'),
						),
						'title' => esc_html__('Paypal Client ID', 'felan-framework'),
						'subtitle' => '',
						'default' => '',
					),
					array(
						'id' => 'service_paypal_client_secret_key',
						'type' => 'text',
						'required' => array(
							array('service_enable_paypal', '=', '1'),
						),
						'title' => esc_html__('Paypal Client Secret Key', 'felan-framework'),
						'subtitle' => '',
						'default' => '',
					),
					array(
						'id' => 'felan_service_stripe',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Stripe Setting', 'felan-framework'),
					),
					array(
						'id' => 'service_enable_stripe',
						'title' => esc_html__('Enable Stripe', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'service_stripe_secret_key',
						'type' => 'text',
						'required' => array(
							array('service_enable_stripe', '=', '1'),
						),
						'title' => esc_html__('Stripe Secret Key', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'service_tripe_publishable_key',
						'type' => 'text',
						'required' => array(
							array('service_enable_stripe', '=', '1'),
						),
						'title' => esc_html__('Stripe Publishable Key', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'felan_service_razor',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Razor Setting', 'felan-framework'),
					),
					array(
						'id' => 'service_enable_razor',
						'title' => esc_html__('Enable Razor', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'service_razor_key_id',
						'type' => 'text',
						'required' => array(
							array('service_enable_razor', '=', '1'),
						),
						'title' => esc_html__('Razor Key ID', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'service_razor_key_secret',
						'type' => 'text',
						'required' => array(
							array('service_enable_razor', '=', '1'),
						),
						'title' => esc_html__('Razor Key Secret', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'felan_service_wire_transfer',
						'type' => 'info',
						'style' => 'warning',
						'title' => esc_html__('Wire Transfer Setting', 'felan-framework'),
						'desc' => esc_html__('important! When Wire Transfer is enabled, these fields are REQUIRED: Account Number, Account Holder, Bank Name, and at least one of (SWIFT/BIC, IBAN, or Routing Number). Payments will not be available if these are not configured.', 'felan-framework'),
					),
					array(
						'id' => 'service_enable_wire_transfer',
						'title' => esc_html__('Enable Wire Transfer', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'service_wire_transfer_account_number',
						'type' => 'text',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Account Number', 'felan-framework') . ' <span style="color:red;">*</span>',
						'subtitle' => esc_html__('Bank account number for wire transfer (REQUIRED)', 'felan-framework'),
						'desc' => esc_html__('Enter your bank account number exactly as it appears on your bank statement', 'felan-framework'),
						'placeholder' => '123456789',
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_account_holder',
						'type' => 'text',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Account Holder Name', 'felan-framework') . ' <span style="color:red;">*</span>',
						'subtitle' => esc_html__('Name of the account holder - beneficiary name (REQUIRED)', 'felan-framework'),
						'desc' => esc_html__('Enter the full name exactly as it appears on the bank account', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_bank_name',
						'type' => 'text',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Bank Name', 'felan-framework') . ' <span style="color:red;">*</span>',
						'subtitle' => esc_html__('Full name of the bank (REQUIRED)', 'felan-framework'),
						'desc' => esc_html__('Enter the complete official name of your bank', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_bank_address',
						'type' => 'textarea',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Bank Address', 'felan-framework'),
						'subtitle' => esc_html__('Full address of the bank (street, city, country)', 'felan-framework'),
						'desc' => esc_html__('Enter the complete address including street, city, state/province, postal code, and country', 'felan-framework'),
						'placeholder' => 'e.g., 123 Main Street, New York, NY 10001, USA',
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_swift_bic',
						'type' => 'text',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('SWIFT/BIC Code', 'felan-framework') . ' <span style="color:orange;">*</span>',
						'subtitle' => esc_html__('Required for international transfers - At least one identification field required (SWIFT, IBAN, or Routing)', 'felan-framework'),
						'desc' => esc_html__('Enter your bank\'s SWIFT or BIC code. Format: 4 letters (bank) + 2 letters (country) + 2 characters (location) + optional 3 characters (branch)', 'felan-framework'),
						'placeholder' => 'e.g., CHASUS33 or CHASUS33XXX',
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_iban',
						'type' => 'text',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('IBAN', 'felan-framework') . ' <span style="color:orange;">*</span>',
						'subtitle' => esc_html__('International Bank Account Number - At least one identification field required (SWIFT, IBAN, or Routing)', 'felan-framework'),
						'desc' => esc_html__('Enter your IBAN (required for European transfers). Format: 2 letters (country) + 2 digits (check) + up to 30 alphanumeric characters', 'felan-framework'),
						'placeholder' => 'e.g., GB82 WEST 1234 5698 7654 32',
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_routing_number',
						'type' => 'text',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Routing Number / ABA', 'felan-framework') . ' <span style="color:orange;">*</span>',
						'subtitle' => esc_html__('Required for US transfers - At least one identification field required (SWIFT, IBAN, or Routing)', 'felan-framework'),
						'desc' => esc_html__('Enter your 9-digit routing number (also known as ABA routing transit number) for US bank accounts', 'felan-framework'),
						'placeholder' => 'e.g., 021000021',
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_country',
						'type' => 'text',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Country', 'felan-framework'),
						'subtitle' => esc_html__('Country of the bank account', 'felan-framework'),
						'desc' => esc_html__('Enter the country where your bank account is located (e.g., United States, United Kingdom, Germany)', 'felan-framework'),
						'placeholder' => 'e.g., United States',
						'default' => '',
					),
					array(
						'id' => 'service_wire_transfer_instructions',
						'type' => 'editor',
						'required' => array(
							array('service_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Wire Transfer Instructions', 'felan-framework'),
						'subtitle' => esc_html__('Additional instructions for customers (HTML allowed)', 'felan-framework'),
						'default' => '',
						'args' => array(
							'teeny' => false,
							'textarea_rows' => 10,
							'wpautop' => true,
						),
					),
					array(
						'id' => 'felan_service_woocheckout',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Woocommerce Setting', 'felan-framework'),
					),
					array(
						'id' => 'service_enable_woocheckout',
						'title' => esc_html__('Enable Woocommerce Checkout', 'felan-framework'),
						'type' => 'button_set',
						'subtitle' => esc_html__('Works when you activate plugin woocomerce and checkout page', 'felan-framework'),
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '0',
					),
				),
			);
		}
		if ($enable_post_type_project == '1') {
			$option_payment_project = array(
				'id' => 'felan_main_group',
				'type' => 'group',
				'title' => esc_html__('Project Settings', 'felan-framework'),
				'fields' => array(
					array(
						'id' => 'felan_project_paypal',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Paypal Setting', 'felan-framework'),
					),
					array(
						'id' => 'project_enable_paypal',
						'title' => esc_html__('Enable Paypal', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'project_paypal_api',
						'type' => 'select',
						'required' => array(
							array('project_enable_paypal', '=', '1'),
						),
						'title' => esc_html__('Paypal Api', 'felan-framework'),
						'subtitle' => esc_html__('Sandbox = test API. LIVE = real payments API', 'felan-framework'),
						'desc' => esc_html__('Update PayPal settings according to API type selection', 'felan-framework'),
						'options' => array(
							'sandbox' => esc_html__('Sandbox', 'felan-framework'),
							'live' => esc_html__('Live', 'felan-framework')
						),
						'default' => 'sandbox',
					),
					array(
						'id' => 'project_paypal_client_id',
						'type' => 'text',
						'required' => array(
							array('project_enable_paypal', '=', '1'),
						),
						'title' => esc_html__('Paypal Client ID', 'felan-framework'),
						'subtitle' => '',
						'default' => '',
					),
					array(
						'id' => 'project_paypal_client_secret_key',
						'type' => 'text',
						'required' => array(
							array('project_enable_paypal', '=', '1'),
						),
						'title' => esc_html__('Paypal Client Secret Key', 'felan-framework'),
						'subtitle' => '',
						'default' => '',
					),
					array(
						'id' => 'felan_project_stripe',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Stripe Setting', 'felan-framework'),
					),
					array(
						'id' => 'project_enable_stripe',
						'title' => esc_html__('Enable Stripe', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'project_stripe_secret_key',
						'type' => 'text',
						'required' => array(
							array('project_enable_stripe', '=', '1'),
						),
						'title' => esc_html__('Stripe Secret Key', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'project_tripe_publishable_key',
						'type' => 'text',
						'required' => array(
							array('project_enable_stripe', '=', '1'),
						),
						'title' => esc_html__('Stripe Publishable Key', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'felan_project_razor',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Razor Setting', 'felan-framework'),
					),
					array(
						'id' => 'project_enable_razor',
						'title' => esc_html__('Enable Razor', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'project_razor_key_id',
						'type' => 'text',
						'required' => array(
							array('project_enable_razor', '=', '1'),
						),
						'title' => esc_html__('Razor Key ID', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'project_razor_key_secret',
						'type' => 'text',
						'required' => array(
							array('project_enable_razor', '=', '1'),
						),
						'title' => esc_html__('Razor Key Secret', 'felan-framework'),
						'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'felan_project_wire_transfer',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Wire Transfer Setting', 'felan-framework'),
					),
					array(
						'id' => 'project_enable_wire_transfer',
						'title' => esc_html__('Enable Wire Transfer', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'project_wire_transfer_account_number',
						'type' => 'text',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Account Number', 'felan-framework'),
						'subtitle' => esc_html__('Bank account number for wire transfer', 'felan-framework'),
						'desc' => esc_html__('Enter your bank account number exactly as it appears on your bank statement', 'felan-framework'),
						'placeholder' => '123456789',
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_account_holder',
						'type' => 'text',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Account Holder Name', 'felan-framework'),
						'subtitle' => esc_html__('Name of the account holder (beneficiary name)', 'felan-framework'),
						'desc' => esc_html__('Enter the full name exactly as it appears on the bank account', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_bank_name',
						'type' => 'text',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Bank Name', 'felan-framework'),
						'subtitle' => esc_html__('Full name of the bank', 'felan-framework'),
						'desc' => esc_html__('Enter the complete official name of your bank', 'felan-framework'),
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_bank_address',
						'type' => 'textarea',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Bank Address', 'felan-framework'),
						'subtitle' => esc_html__('Full address of the bank (street, city, country)', 'felan-framework'),
						'desc' => esc_html__('Enter the complete address including street, city, state/province, postal code, and country', 'felan-framework'),
						'placeholder' => 'e.g., 123 Main Street, New York, NY 10001, USA',
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_swift_bic',
						'type' => 'text',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('SWIFT/BIC Code', 'felan-framework'),
						'subtitle' => esc_html__('Required for international transfers (8-11 characters)', 'felan-framework'),
						'desc' => esc_html__('Enter your bank\'s SWIFT or BIC code. Format: 4 letters (bank) + 2 letters (country) + 2 characters (location) + optional 3 characters (branch)', 'felan-framework'),
						'placeholder' => 'e.g., CHASUS33 or CHASUS33XXX',
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_iban',
						'type' => 'text',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('IBAN', 'felan-framework'),
						'subtitle' => esc_html__('International Bank Account Number (required for EU transfers)', 'felan-framework'),
						'desc' => esc_html__('Enter your IBAN (required for European transfers). Format: 2 letters (country) + 2 digits (check) + up to 30 alphanumeric characters', 'felan-framework'),
						'placeholder' => 'e.g., GB82 WEST 1234 5698 7654 32',
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_routing_number',
						'type' => 'text',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Routing Number / ABA', 'felan-framework'),
						'subtitle' => esc_html__('Required for US transfers (9 digits)', 'felan-framework'),
						'desc' => esc_html__('Enter your 9-digit routing number (also known as ABA routing transit number) for US bank accounts', 'felan-framework'),
						'placeholder' => 'e.g., 021000021',
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_country',
						'type' => 'text',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Country', 'felan-framework'),
						'subtitle' => esc_html__('Country of the bank account', 'felan-framework'),
						'desc' => esc_html__('Enter the country where your bank account is located (e.g., United States, United Kingdom, Germany)', 'felan-framework'),
						'placeholder' => 'e.g., United States',
						'default' => '',
					),
					array(
						'id' => 'project_wire_transfer_instructions',
						'type' => 'editor',
						'required' => array(
							array('project_enable_wire_transfer', '=', '1'),
						),
						'title' => esc_html__('Wire Transfer Instructions', 'felan-framework'),
						'subtitle' => esc_html__('Additional instructions for customers (HTML allowed)', 'felan-framework'),
						'default' => '',
						'args' => array(
							'teeny' => false,
							'textarea_rows' => 10,
							'wpautop' => true,
						),
					),
					array(
						'id' => 'felan_project_woocheckout',
						'type' => 'info',
						'style' => 'info',
						'title' => esc_html__('Woocommerce Setting', 'felan-framework'),
					),
					array(
						'id' => 'project_enable_woocheckout',
						'title' => esc_html__('Enable Woocommerce Checkout', 'felan-framework'),
						'type' => 'button_set',
						'subtitle' => esc_html__('Works when you activate plugin woocomerce and checkout page', 'felan-framework'),
						'options' => array(
							'1' => esc_html__('Enabled', 'felan-framework'),
							'0' => esc_html__('Disabled', 'felan-framework'),
						),
						'default' => '0',
					),
				),
			);
		}

		return apply_filters('felan_register_option_payment', array(
			'id' => 'felan_payment_option',
			'title' => esc_html__('Payment Option', 'felan-framework'),
			'icon' => 'dashicons-cart',
			'fields' => array(
				//Employer
				apply_filters('felan_register_option_payment_top', array()),
				apply_filters('felan_register_option_payment_main', array(
					'id' => 'felan_main_group',
					'type' => 'group',
					'title' => esc_html__('Employer Settings', 'felan-framework'),
					'fields' => array(
						array(
							'id' => 'paid_submission_type',
							'type' => 'select',
							'title' => esc_html__('Paid Submission Type', 'felan-framework'),
							'subtitle' => '',
							'options' => array(
								'no' => esc_html__('Free Submit', 'felan-framework'),
								'per_package' => esc_html__('Pay Per Package', 'felan-framework')
							),
							'default' => 'no',
						),
						array(
							'id' => 'felan_paypal',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Paypal Setting', 'felan-framework'),
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'enable_paypal',
							'title' => esc_html__('Enable Paypal', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'paypal_api',
							'type' => 'select',
							'required' => array(
								array('enable_paypal', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Paypal Api', 'felan-framework'),
							'subtitle' => esc_html__('Sandbox = test API. LIVE = real payments API', 'felan-framework'),
							'desc' => esc_html__('Update PayPal settings according to API type selection', 'felan-framework'),
							'options' => array(
								'sandbox' => esc_html__('Sandbox', 'felan-framework'),
								'live' => esc_html__('Live', 'felan-framework')
							),
							'default' => 'sandbox',
						),
						array(
							'id' => 'paypal_client_id',
							'type' => 'text',
							'required' => array(
								array('enable_paypal', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Paypal Client ID', 'felan-framework'),
							'subtitle' => '',
							'default' => '',
						),
						array(
							'id' => 'paypal_client_secret_key',
							'type' => 'text',
							'required' => array(
								array('enable_paypal', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Paypal Client Secret Key', 'felan-framework'),
							'subtitle' => '',
							'default' => '',
						),
						array(
							'id' => 'felan_stripe',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Stripe Setting', 'felan-framework'),
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'enable_stripe',
							'title' => esc_html__('Enable Stripe', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'stripe_secret_key',
							'type' => 'text',
							'required' => array(
								array('enable_stripe', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Stripe Secret Key', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'stripe_publishable_key',
							'type' => 'text',
							'required' => array(
								array('enable_stripe', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Stripe Publishable Key', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'felan_razor',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Razor Setting', 'felan-framework'),
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'enable_razor',
							'title' => esc_html__('Enable Razor', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'razor_key_id',
							'type' => 'text',
							'required' => array(
								array('enable_razor', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Razor Key ID', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'razor_key_secret',
							'type' => 'text',
							'required' => array(
								array('enable_razor', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Razor Key Secret', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'felan_wire_transfer',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Wire Transfer Setting', 'felan-framework'),
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'enable_wire_transfer',
							'title' => esc_html__('Enable Wire Transfer', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'wire_transfer_account_number',
							'type' => 'text',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Account Number', 'felan-framework'),
							'subtitle' => esc_html__('Bank account number for wire transfer', 'felan-framework'),
							'desc' => esc_html__('Enter your bank account number exactly as it appears on your bank statement', 'felan-framework'),
							'placeholder' => '123456789',
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_account_holder',
							'type' => 'text',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Account Holder Name', 'felan-framework'),
							'subtitle' => esc_html__('Name of the account holder (beneficiary name)', 'felan-framework'),
							'desc' => esc_html__('Enter the full name exactly as it appears on the bank account', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_bank_name',
							'type' => 'text',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Bank Name', 'felan-framework'),
							'subtitle' => esc_html__('Full name of the bank', 'felan-framework'),
							'desc' => esc_html__('Enter the complete official name of your bank', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_bank_address',
							'type' => 'textarea',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Bank Address', 'felan-framework'),
							'subtitle' => esc_html__('Full address of the bank (street, city, country)', 'felan-framework'),
							'desc' => esc_html__('Enter the complete address including street, city, state/province, postal code, and country', 'felan-framework'),
							'placeholder' => 'e.g., 123 Main Street, New York, NY 10001, USA',
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_swift_bic',
							'type' => 'text',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('SWIFT/BIC Code', 'felan-framework'),
							'subtitle' => esc_html__('Required for international transfers (8-11 characters)', 'felan-framework'),
							'desc' => esc_html__('Enter your bank\'s SWIFT or BIC code. Format: 4 letters (bank) + 2 letters (country) + 2 characters (location) + optional 3 characters (branch)', 'felan-framework'),
							'placeholder' => 'e.g., CHASUS33 or CHASUS33XXX',
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_iban',
							'type' => 'text',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('IBAN', 'felan-framework'),
							'subtitle' => esc_html__('International Bank Account Number (required for EU transfers)', 'felan-framework'),
							'desc' => esc_html__('Enter your IBAN (required for European transfers). Format: 2 letters (country) + 2 digits (check) + up to 30 alphanumeric characters', 'felan-framework'),
							'placeholder' => 'e.g., GB82 WEST 1234 5698 7654 32',
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_routing_number',
							'type' => 'text',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Routing Number / ABA', 'felan-framework'),
							'subtitle' => esc_html__('Required for US transfers (9 digits)', 'felan-framework'),
							'desc' => esc_html__('Enter your 9-digit routing number (also known as ABA routing transit number) for US bank accounts', 'felan-framework'),
							'placeholder' => 'e.g., 021000021',
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_country',
							'type' => 'text',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Country', 'felan-framework'),
							'subtitle' => esc_html__('Country of the bank account', 'felan-framework'),
							'desc' => esc_html__('Enter the country where your bank account is located (e.g., United States, United Kingdom, Germany)', 'felan-framework'),
							'placeholder' => 'e.g., United States',
							'default' => '',
						),
						array(
							'id' => 'wire_transfer_instructions',
							'type' => 'editor',
							'required' => array(
								array('enable_wire_transfer', '=', '1'),
								array('paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Wire Transfer Instructions', 'felan-framework'),
							'subtitle' => esc_html__('Additional instructions for customers (HTML allowed)', 'felan-framework'),
							'default' => '',
							'args' => array(
								'teeny' => false,
								'textarea_rows' => 10,
								'wpautop' => true,
							),
						),
						array(
							'id' => 'felan_woocheckout',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Woocommerce Setting', 'felan-framework'),
							'required' => array('paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'enable_woocheckout',
							'title' => esc_html__('Enable Woocommerce Checkout', 'felan-framework'),
							'type' => 'button_set',
							'subtitle' => esc_html__('Works when you activate plugin woocomerce and checkout page', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('paid_submission_type', '!=', 'no'),
						),
					),
				)),
				apply_filters('felan_register_option_payment_bottom', array()),
				//Freelancer
				apply_filters('felan_register_option_payment_freelancer_top', array()),
				apply_filters('felan_register_option_payment_freelancer_main', array(
					'id' => 'felan_main_group',
					'type' => 'group',
					'title' => $title_freelancers,
					'fields' => array(
						array(
							'id' => 'freelancer_paid_submission_type',
							'type' => 'select',
							'title' => esc_html__('Paid Submission Type', 'felan-framework'),
							'subtitle' => '',
							'options' => array(
								'no' => esc_html__('Free Submit', 'felan-framework'),
								'freelancer_per_package' => esc_html__('Pay Per Package', 'felan-framework')
							),
							'default' => 'no',
						),
						array(
							'id' => 'felan_freelancer_paypal',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Paypal Setting', 'felan-framework'),
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_enable_paypal',
							'title' => esc_html__('Enable Paypal', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_paypal_api',
							'type' => 'select',
							'required' => array(
								array('freelancer_enable_paypal', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Paypal Api', 'felan-framework'),
							'subtitle' => esc_html__('Sandbox = test API. LIVE = real payments API', 'felan-framework'),
							'desc' => esc_html__('Update PayPal settings according to API type selection', 'felan-framework'),
							'options' => array(
								'sandbox' => esc_html__('Sandbox', 'felan-framework'),
								'live' => esc_html__('Live', 'felan-framework')
							),
							'default' => 'sandbox',
						),
						array(
							'id' => 'freelancer_paypal_client_id',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_paypal', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Paypal Client ID', 'felan-framework'),
							'subtitle' => '',
							'default' => '',
						),
						array(
							'id' => 'freelancer_paypal_client_secret_key',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_paypal', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Paypal Client Secret Key', 'felan-framework'),
							'subtitle' => '',
							'default' => '',
						),
						array(
							'id' => 'felan_freelancer_stripe',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Stripe Setting', 'felan-framework'),
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_enable_stripe',
							'title' => esc_html__('Enable Stripe', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_stripe_secret_key',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_stripe', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Stripe Secret Key', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'freelancer_tripe_publishable_key',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_stripe', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Stripe Publishable Key', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'felan_freelancer_razor',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Razor Setting', 'felan-framework'),
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_enable_razor',
							'title' => esc_html__('Enable Razor', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_razor_key_id',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_razor', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Razor Key ID', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'freelancer_razor_key_secret',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_razor', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Razor Key Secret', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'felan_freelancer_wire_transfer',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Wire Transfer Setting', 'felan-framework'),
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_enable_wire_transfer',
							'title' => esc_html__('Enable Wire Transfer', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_wire_transfer_account_number',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Account Number', 'felan-framework'),
							'subtitle' => esc_html__('Bank account number for wire transfer', 'felan-framework'),
							'desc' => esc_html__('Enter your bank account number exactly as it appears on your bank statement', 'felan-framework'),
							'placeholder' => '123456789',
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_account_holder',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Account Holder Name', 'felan-framework'),
							'subtitle' => esc_html__('Name of the account holder (beneficiary name)', 'felan-framework'),
							'desc' => esc_html__('Enter the full name exactly as it appears on the bank account', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_bank_name',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Bank Name', 'felan-framework'),
							'subtitle' => esc_html__('Full name of the bank', 'felan-framework'),
							'desc' => esc_html__('Enter the complete official name of your bank', 'felan-framework'),
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_bank_address',
							'type' => 'textarea',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Bank Address', 'felan-framework'),
							'subtitle' => esc_html__('Full address of the bank (street, city, country)', 'felan-framework'),
							'desc' => esc_html__('Enter the complete address including street, city, state/province, postal code, and country', 'felan-framework'),
							'placeholder' => 'e.g., 123 Main Street, New York, NY 10001, USA',
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_swift_bic',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('SWIFT/BIC Code', 'felan-framework'),
							'subtitle' => esc_html__('Required for international transfers (8-11 characters)', 'felan-framework'),
							'desc' => esc_html__('Enter your bank\'s SWIFT or BIC code. Format: 4 letters (bank) + 2 letters (country) + 2 characters (location) + optional 3 characters (branch)', 'felan-framework'),
							'placeholder' => 'e.g., CHASUS33 or CHASUS33XXX',
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_iban',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('IBAN', 'felan-framework'),
							'subtitle' => esc_html__('International Bank Account Number (required for EU transfers)', 'felan-framework'),
							'desc' => esc_html__('Enter your IBAN (required for European transfers). Format: 2 letters (country) + 2 digits (check) + up to 30 alphanumeric characters', 'felan-framework'),
							'placeholder' => 'e.g., GB82 WEST 1234 5698 7654 32',
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_routing_number',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Routing Number / ABA', 'felan-framework'),
							'subtitle' => esc_html__('Required for US transfers (9 digits)', 'felan-framework'),
							'desc' => esc_html__('Enter your 9-digit routing number (also known as ABA routing transit number) for US bank accounts', 'felan-framework'),
							'placeholder' => 'e.g., 021000021',
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_country',
							'type' => 'text',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Country', 'felan-framework'),
							'subtitle' => esc_html__('Country of the bank account', 'felan-framework'),
							'desc' => esc_html__('Enter the country where your bank account is located (e.g., United States, United Kingdom, Germany)', 'felan-framework'),
							'placeholder' => 'e.g., United States',
							'default' => '',
						),
						array(
							'id' => 'freelancer_wire_transfer_instructions',
							'type' => 'editor',
							'required' => array(
								array('freelancer_enable_wire_transfer', '=', '1'),
								array('freelancer_paid_submission_type', '!=', 'no')
							),
							'title' => esc_html__('Wire Transfer Instructions', 'felan-framework'),
							'subtitle' => esc_html__('Additional instructions for customers (HTML allowed)', 'felan-framework'),
							'default' => '',
							'args' => array(
								'teeny' => false,
								'textarea_rows' => 10,
								'wpautop' => true,
							),
						),
						array(
							'id' => 'felan_freelancer_woocheckout',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Woocommerce Setting', 'felan-framework'),
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
						array(
							'id' => 'freelancer_enable_woocheckout',
							'title' => esc_html__('Enable Woocommerce Checkout', 'felan-framework'),
							'type' => 'button_set',
							'subtitle' => esc_html__('Works when you activate plugin woocomerce and checkout page', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
							'required' => array('freelancer_paid_submission_type', '!=', 'no'),
						),
					),
				)),
				apply_filters('felan_register_option_payment_freelancer_bottom', array()),

				//Service
				apply_filters('felan_register_option_payment_service_top', array()),
				apply_filters(
					'felan_register_option_payment_service_main',
					$option_payment_service
				),
				apply_filters('felan_register_option_payment_service_bottom', array()),


				//Project
				apply_filters('felan_register_option_payment_project_top', array()),
				apply_filters(
					'felan_register_option_payment_project_main',
					$option_payment_project
				),
				apply_filters('felan_register_option_payment_project_bottom', array()),
			)
		));
	}

	/**
	 * @return mixed|void
	 */
	private function wallet_option()
	{
		$enable_wallet_posting_project = $wallet_posting_project_fee_amount = $enable_wallet_featured_project = $enable_wallet_featured_project =
			$enable_wallet_posting_service = $wallet_posting_service_fee_amount = $enable_wallet_featured_service = $wallet_featured_service_fee_amount =
			$enable_wallet_project_proposals = $wallet_project_proposals_fee_amount = $wallet_featured_service_fee_time = $wallet_featured_project_fee_time = $wallet_featured_project_fee_amount = array();

		$enable_wallet_posting_project =  array(
			'id' => 'enable_wallet_posting_project',
			'type' => 'button_set',
			'title' => esc_html__('Enable Fee For Posting Projects', 'felan-framework'),
			'subtitle' => esc_html__('Enable/Disable Employer Project Fee', 'felan-framework'),
			'desc' => '',
			'options' => array(
				'1' => esc_html__('On', 'felan-framework'),
				'0' => esc_html__('Off', 'felan-framework'),
			),
			'default' => '1',
		);

		$wallet_posting_project_fee_amount = array(
			'id' => "wallet_posting_project_fee_amount",
			'title' => esc_html__('Fee Amount', 'felan-framework'),
			'subtitle' => esc_html__('Enter the amount to charge for posting a project', 'felan-framework'),
			'type' => 'text',
			'default' => '10',
			'pattern' => '[0-9]*',
			'required' => array(
				array("enable_wallet_posting_project", '=', '1')
			),
		);

		$enable_wallet_featured_project = array(
			'id' => 'enable_wallet_featured_project',
			'type' => 'button_set',
			'title' => esc_html__('Enable Fee for Featured Project', 'felan-framework'),
			'subtitle' => esc_html__('Enable/Disable additional fee for featured project', 'felan-framework'),
			'desc' => '',
			'options' => array(
				'1' => esc_html__('On', 'felan-framework'),
				'0' => esc_html__('Off', 'felan-framework'),
			),
			'default' => '1',
		);

		$wallet_featured_project_fee_amount = array(
			'id' => "wallet_featured_project_fee_amount",
			'title' => esc_html__('Fee Amount', 'felan-framework'),
			'subtitle' => esc_html__('Enter the amount to charge for a featured project', 'felan-framework'),
			'type' => 'text',
			'default' => '10',
			'pattern' => '[0-9]*',
			'required' => array(array("enable_wallet_featured_project", '=', '1')),
		);

		$wallet_featured_project_fee_time = array(
			'id' => "wallet_featured_project_fee_time",
			'title' => esc_html__('Featured Project expiration days', 'felan-framework'),
			'subtitle' => esc_html__('Days until Featured Project expires', 'felan-framework'),
			'type' => 'text',
			'default' => '10',
			'pattern' => '[0-9]*',
			'required' => array(array("enable_wallet_featured_project", '=', '1')),
		);

		$enable_wallet_posting_service = array(
			'id' => 'enable_wallet_posting_service',
			'type' => 'button_set',
			'title' => esc_html__('Enable Fee For Posting Service', 'felan-framework'),
			'subtitle' => esc_html__('Enable/Disable Employer Service Fee', 'felan-framework'),
			'desc' => '',
			'options' => array(
				'1' => esc_html__('On', 'felan-framework'),
				'0' => esc_html__('Off', 'felan-framework'),
			),
			'default' => '1',
		);

		$wallet_posting_service_fee_amount = array(
			'id' => "wallet_posting_service_fee_amount",
			'title' => esc_html__('Fee Amount', 'felan-framework'),
			'subtitle' => esc_html__('Enter the amount to charge for posting a service', 'felan-framework'),
			'type' => 'text',
			'default' => '10',
			'pattern' => '[0-9]*',
			'required' => array(
				array("enable_wallet_posting_service", '=', '1')
			),
		);

		$enable_wallet_featured_service = array(
			'id' => 'enable_wallet_featured_service',
			'type' => 'button_set',
			'title' => esc_html__('Enable Fee for Featured Service', 'felan-framework'),
			'subtitle' => esc_html__('Enable/Disable additional fee for featured service', 'felan-framework'),
			'desc' => '',
			'options' => array(
				'1' => esc_html__('On', 'felan-framework'),
				'0' => esc_html__('Off', 'felan-framework'),
			),
			'default' => '1',
		);

		$wallet_featured_service_fee_amount =  array(
			'id' => "wallet_featured_service_fee_amount",
			'title' => esc_html__('Fee Amount', 'felan-framework'),
			'subtitle' => esc_html__('Enter the amount to charge for a featured service', 'felan-framework'),
			'type' => 'text',
			'default' => '10',
			'pattern' => '[0-9]*',
			'required' => array(array("enable_wallet_featured_service", '=', '1')),
		);

		$wallet_featured_service_fee_time = array(
			'id' => "wallet_featured_service_fee_time",
			'title' => esc_html__('Featured Project expiration days', 'felan-framework'),
			'subtitle' => esc_html__('Days until Featured Project expires', 'felan-framework'),
			'type' => 'text',
			'default' => '10',
			'pattern' => '[0-9]*',
			'required' => array(array("enable_wallet_featured_service", '=', '1')),
		);

		$enable_wallet_project_proposals = array(
			'id' => 'enable_wallet_project_proposals',
			'type' => 'button_set',
			'title' => esc_html__('Enable Fee for Project Proposals', 'felan-framework'),
			'subtitle' => esc_html__('Enable/Disable Fee for Employer Project Proposals', 'felan-framework'),
			'desc' => '',
			'options' => array(
				'1' => esc_html__('On', 'felan-framework'),
				'0' => esc_html__('Off', 'felan-framework'),
			),
			'default' => '1',
		);

		$wallet_project_proposals_fee_amount = array(
			'id' => "wallet_project_proposals_fee_amount",
			'title' => esc_html__('Fee Amount', 'felan-framework'),
			'subtitle' => esc_html__('Enter the amount to charge for posting a project proposal', 'felan-framework'),
			'type' => 'text',
			'default' => '10',
			'pattern' => '[0-9]*',
			'required' => array(
				array("enable_wallet_project_proposals", '=', '1')
			),
		);

		return apply_filters('felan_register_wallet_setting_page', array(
			'id'    => 'felan_wallet_page_option',
			'title' => esc_html__('Wallet Option', 'felan-framework'),
			'icon'  => 'dashicons-lock',
			'fields' => array(
				apply_filters('felan_register_option_wallet_employer_page_top', array()),
				apply_filters('felan_register_option_wallet_employer_page_main', array(
					'id'    => 'wallet_option_group',
					'title' => esc_html__('Employer Options', 'felan-framework'),
					'type'  => 'group',
					'fields' => array(
						$enable_wallet_posting_project,
						$wallet_posting_project_fee_amount,
						$enable_wallet_featured_project,
						$wallet_featured_project_fee_amount,
						$wallet_featured_project_fee_time,
					),
				)),
				apply_filters('felan_register_option_wallet_employer_page_bottom', array()),

				apply_filters('felan_register_option_wallet_freelancer_page_top', array()),
				apply_filters('felan_register_option_wallet_freelancer_page_main', array(
					'id'    => 'wallet_option_group',
					'title' => esc_html__('Freelancer Options', 'felan-framework'),
					'type'  => 'group',
					'fields' => array(
						$enable_wallet_posting_service,
						$wallet_posting_service_fee_amount,
						$enable_wallet_featured_service,
						$wallet_featured_service_fee_amount,
						$wallet_featured_service_fee_time,
						$enable_wallet_project_proposals,
						$wallet_project_proposals_fee_amount,
					),
				)),
				apply_filters('felan_register_option_wallet_freelancer_page_bottom', array()),

				apply_filters('felan_register_option_wallet_payment_page_top', array()),
				apply_filters('felan_register_option_wallet_payment_page_main', array(
					'id'    => 'wallet_option_group',
					'title' => esc_html__('Payment Options', 'felan-framework'),
					'type'  => 'group',
					'fields' => array(
						array(
							'id' => 'wallet_wire_transfer',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Wire Transfer Setting', 'felan-framework'),
						),
						array(
							'id' => 'enable_wallet_wire_transfer',
							'title' => esc_html__('Enable Wire Transfer', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'wallet_wire_transfer_account_number',
							'type' => 'text',
							'title' => esc_html__('Account Number', 'felan-framework'),
							'subtitle' => esc_html__('Bank account number for wire transfer', 'felan-framework'),
							'desc' => esc_html__('Enter your bank account number exactly as it appears on your bank statement', 'felan-framework'),
							'placeholder' => '123456789',
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_account_holder',
							'type' => 'text',
							'title' => esc_html__('Account Holder Name', 'felan-framework'),
							'subtitle' => esc_html__('Name of the account holder (beneficiary name)', 'felan-framework'),
							'desc' => esc_html__('Enter the full name exactly as it appears on the bank account', 'felan-framework'),
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_bank_name',
							'type' => 'text',
							'title' => esc_html__('Bank Name', 'felan-framework'),
							'subtitle' => esc_html__('Full name of the bank', 'felan-framework'),
							'desc' => esc_html__('Enter the complete official name of your bank', 'felan-framework'),
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_bank_address',
							'type' => 'textarea',
							'title' => esc_html__('Bank Address', 'felan-framework'),
							'subtitle' => esc_html__('Full address of the bank (street, city, country)', 'felan-framework'),
							'desc' => esc_html__('Enter the complete address including street, city, state/province, postal code, and country', 'felan-framework'),
							'placeholder' => 'e.g., 123 Main Street, New York, NY 10001, USA',
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_swift_bic',
							'type' => 'text',
							'title' => esc_html__('SWIFT/BIC Code', 'felan-framework'),
							'subtitle' => esc_html__('Required for international transfers (8-11 characters)', 'felan-framework'),
							'desc' => esc_html__('Enter your bank\'s SWIFT or BIC code. Format: 4 letters (bank) + 2 letters (country) + 2 characters (location) + optional 3 characters (branch)', 'felan-framework'),
							'placeholder' => 'e.g., CHASUS33 or CHASUS33XXX',
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_iban',
							'type' => 'text',
							'title' => esc_html__('IBAN', 'felan-framework'),
							'subtitle' => esc_html__('International Bank Account Number (required for EU transfers)', 'felan-framework'),
							'desc' => esc_html__('Enter your IBAN (required for European transfers). Format: 2 letters (country) + 2 digits (check) + up to 30 alphanumeric characters', 'felan-framework'),
							'placeholder' => 'e.g., GB82 WEST 1234 5698 7654 32',
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_routing_number',
							'type' => 'text',
							'title' => esc_html__('Routing Number / ABA', 'felan-framework'),
							'subtitle' => esc_html__('Required for US transfers (9 digits)', 'felan-framework'),
							'desc' => esc_html__('Enter your 9-digit routing number (also known as ABA routing transit number) for US bank accounts', 'felan-framework'),
							'placeholder' => 'e.g., 021000021',
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_country',
							'type' => 'text',
							'title' => esc_html__('Country', 'felan-framework'),
							'subtitle' => esc_html__('Country of the bank account', 'felan-framework'),
							'desc' => esc_html__('Enter the country where your bank account is located (e.g., United States, United Kingdom, Germany)', 'felan-framework'),
							'placeholder' => 'e.g., United States',
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_wire_transfer_instructions',
							'type' => 'editor',
							'title' => esc_html__('Wire Transfer Instructions', 'felan-framework'),
							'subtitle' => esc_html__('Additional instructions for customers (HTML allowed)', 'felan-framework'),
							'default' => '',
							'required' => array(
								array('enable_wallet_wire_transfer', '=', '1'),
							),
							'args' => array(
								'teeny' => false,
								'textarea_rows' => 10,
								'wpautop' => true,
							),
						),
						array(
							'id' => 'felan_wallet_paypal',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Paypal Setting', 'felan-framework'),
						),
						array(
							'id' => 'enable_wallet_paypal',
							'title' => esc_html__('Enable Paypal', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'wallet_paypal_api',
							'type' => 'select',
							'title' => esc_html__('Paypal Api', 'felan-framework'),
							'subtitle' => esc_html__('Sandbox = test API. LIVE = real payments API', 'felan-framework'),
							'desc' => esc_html__('Update PayPal settings according to API type selection', 'felan-framework'),
							'options' => array(
								'sandbox' => esc_html__('Sandbox', 'felan-framework'),
								'live' => esc_html__('Live', 'felan-framework')
							),
							'default' => 'sandbox',
							'required' => array(
								array('enable_wallet_paypal', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_paypal_client_id',
							'type' => 'text',
							'title' => esc_html__('Paypal Client ID', 'felan-framework'),
							'subtitle' => '',
							'default' => '',
							'required' => array(
								array('enable_wallet_paypal', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_paypal_client_secret_key',
							'type' => 'text',
							'title' => esc_html__('Paypal Client Secret Key', 'felan-framework'),
							'subtitle' => '',
							'default' => '',
							'required' => array(
								array('enable_wallet_paypal', '=', '1'),
							),
						),
						array(
							'id' => 'felan_wallet_stripe',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Stripe Setting', 'felan-framework'),
						),
						array(
							'id' => 'enable_wallet_stripe',
							'title' => esc_html__('Enable Stripe', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'wallet_stripe_secret_key',
							'type' => 'text',
							'title' => esc_html__('Stripe Secret Key', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
							'default' => '',
							'required' => array(
								array('enable_wallet_stripe', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_stripe_publishable_key',
							'type' => 'text',
							'title' => esc_html__('Stripe Publishable Key', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.stripe.com/login', 'felan-framework'),
							'default' => '',
							'required' => array(
								array('enable_wallet_stripe', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_razor',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Razor Setting', 'felan-framework'),
						),
						array(
							'id' => 'enable_wallet_razor',
							'title' => esc_html__('Enable Razor', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'wallet_razor_key_id',
							'type' => 'text',
							'title' => esc_html__('Razor Key ID', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
							'default' => '',
							'required' => array(
								array('enable_wallet_razor', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_razor_key_secret',
							'type' => 'text',
							'title' => esc_html__('Razor Key Secret', 'felan-framework'),
							'subtitle' => esc_html__('Info is taken from your account at https://dashboard.razorpay.com/', 'felan-framework'),
							'default' => '',
							'required' => array(
								array('enable_wallet_razor', '=', '1'),
							),
						),
						array(
							'id' => 'wallet_woocheckout',
							'type' => 'info',
							'style' => 'info',
							'title' => esc_html__('Woocommerce Setting', 'felan-framework'),
						),
						array(
							'id' => 'enable_wallet_woocheckout',
							'title' => esc_html__('Enable Woocommerce Checkout', 'felan-framework'),
							'type' => 'button_set',
							'subtitle' => esc_html__('Works when you activate plugin woocomerce and checkout page', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('Enabled', 'felan-framework'),
								'0' => esc_html__('Disabled', 'felan-framework'),
							),
							'default' => '0',
						),
					),
				)),
				apply_filters('felan_register_option_wallet_payment_page_bottom', array()),
			),
		));
	}

	/**
	 * Validate wire transfer settings before saving
	 * Ensures required fields are filled when wire transfer is enabled
	 *
	 * @param array $options The options being saved
	 * @return array Modified options with validation errors if any
	 */
	public function validate_wire_transfer_settings($options)
	{
		// Contexts to validate (service, freelancer, project, employer, wallet)
		$contexts = array(
			'service' => 'service_enable_wire_transfer',
			'freelancer' => 'freelancer_enable_wire_transfer',
			'project' => 'project_enable_wire_transfer',
			'employer' => 'enable_wire_transfer',
			'wallet' => 'enable_wallet_wire_transfer',
		);

		$has_errors = false;
		$error_messages = array();

		foreach ($contexts as $context => $enable_key) {
			// Check if wire transfer is enabled for this context
			if (isset($options[$enable_key]) && $options[$enable_key] === '1') {
				$prefix = ($context === 'employer') ? '' : $context . '_';
				if ($context === 'wallet') {
					$prefix = 'wallet_';
				}

				$prefix_key = $prefix . 'wire_transfer_';

				// Required fields
				$account_number = isset($options[$prefix_key . 'account_number']) ? trim($options[$prefix_key . 'account_number']) : '';
				$account_holder = isset($options[$prefix_key . 'account_holder']) ? trim($options[$prefix_key . 'account_holder']) : '';
				$bank_name = isset($options[$prefix_key . 'bank_name']) ? trim($options[$prefix_key . 'bank_name']) : '';

				// Identification fields (at least one required)
				$swift_bic = isset($options[$prefix_key . 'swift_bic']) ? trim($options[$prefix_key . 'swift_bic']) : '';
				$iban = isset($options[$prefix_key . 'iban']) ? trim($options[$prefix_key . 'iban']) : '';
				$routing_number = isset($options[$prefix_key . 'routing_number']) ? trim($options[$prefix_key . 'routing_number']) : '';

				$context_label = ucfirst($context);
				$missing_fields = array();

				// Check required fields
				if (empty($account_number)) {
					$missing_fields[] = 'Account Number';
				}
				if (empty($account_holder)) {
					$missing_fields[] = 'Account Holder Name';
				}
				if (empty($bank_name)) {
					$missing_fields[] = 'Bank Name';
				}

				// Check if at least one identification field exists
				$has_identification = !empty($swift_bic) || !empty($iban) || !empty($routing_number);

				if (!$has_identification) {
					$missing_fields[] = 'At least one of: SWIFT/BIC, IBAN, or Routing Number';
				}

				// If there are missing fields, add error and force disable
				if (!empty($missing_fields)) {
					$has_errors = true;
					$fields_list = implode(', ', $missing_fields);
					$error_messages[] = sprintf(
						'<strong>%s Wire Transfer</strong>: Cannot enable without required fields: %s',
						$context_label,
						$fields_list
					);

					// Force disable wire transfer for this context
					$options[$enable_key] = '0';
				}
			}
		}

		// If there are errors, show admin notice
		if ($has_errors) {
			add_settings_error(
				'felan-framework',
				'wire_transfer_validation',
				implode('<br>', $error_messages) . '<br><strong>Wire Transfer has been disabled.</strong> Please fill in all required fields and try again.',
				'error'
			);
		}

		return $options;
	}
}
