<?php
/**
 * Felan Post Type Options Trait
 * Extracted from class-felan-admin.php
 * Contains: jobs_option, company_option, freelancer_option, service_option, project_option
 *
 * @package Felan_Framework
 */

if (!defined('ABSPATH')) {
    exit;
}

trait Felan_Post_Type_Options_Trait
{
		private function jobs_option()
		{
			$sidebar_filter = [
				'jobs-type' => esc_html__('Type', 'felan-framework'),
				'jobs-salary' => esc_html__('Salary', 'felan-framework'),
				'jobs-career' => esc_html__('Career', 'felan-framework'),
				'jobs-experience' => esc_html__('Experience', 'felan-framework'),
			];
			$custom_field_filter = felan_render_custom_field('jobs');
			foreach ($custom_field_filter as $custom_field) {
				$sidebar_filter[$custom_field['id']] = $custom_field['title'];
			}
			return
				apply_filters('felan_register_option_listing_setting_page', array(
					'id' => 'felan_listing_setting_page_option',
					'title' => esc_html__('Jobs Option', 'felan-framework'),
					'icon' => 'dashicons-list-view',
					'fields' => array(
						//General Jobs
						apply_filters('felan_register_option_genera_jobs_page_top', array()),
						apply_filters('felan_register_option_genera_jobs_page_main', array(
							'id' => 'felan_main_group',
							'type' => 'group',
							'title' => esc_html__('General Jobs', 'felan-framework'),
							'fields' => array(
								array(
									'id' => 'enable_extend_expired_jobs',
									'type' => 'button_set',
									'title' => esc_html__('Extend Expired Jobs', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable extend expired jobs', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0'
								),
								array(
									'id' => 'enable_apply_login',
									'type' => 'button_set',
									'title' => esc_html__('Enable Apply Job Login', 'felan-framework'),
									'subtitle' => esc_html__('Only works in apply (gmail,phone,external)', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0'
								),
								array(
									'id' => "enable_job_alerts",
									'type' => 'button_set',
									'title' => esc_html__('Enable Job Alerts', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Job Alerts', 'felan-framework'),
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'felan_job_alerts_page_id',
									'title' => esc_html__('Job Alerts', 'felan-framework'),
									'type' => 'select',
									'data' => 'page',
									'data_args' => array(
										'numberposts' => -1,
									),
									'subtitle' => esc_html__('Select page for job alerts', 'felan-framework'),
									'required' => array("enable_job_alerts", '=', '1'),
								),
								array(
									'id' => "enable_status_urgent",
									'type' => 'button_set',
									'title' => esc_html__('Enable Status Urgent', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Status Urgent', 'felan-framework'),
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => "number_status_urgent",
									'title' => esc_html__('Number Status Urgent', 'felan-framework'),
									'subtitle' => esc_html__('Enter number of days status urgent', 'felan-framework'),
									'default' => '3',
									'type' => 'text',
									'required' => array("enable_status_urgent", '=', '1'),
								),
								array(
									'id' => "jobs_number_days",
									'title' => esc_html__('Number of days to apply', 'felan-framework'),
									'subtitle' => esc_html__('Enter number of days to apply', 'felan-framework'),
									'default' => '30',
									'type' => 'text',
								),
							),
						)),
						apply_filters('felan_register_option_genera_jobs_page_bottom', array()),

						//Archive Jobs
						apply_filters('felan_register_option_archive_jobs_page_top', array()),
						apply_filters('felan_register_option_archive_jobs_page_main', array(
							'id' => 'felan_main_group',
							'type' => 'group',
							'title' => esc_html__('Archive Jobs', 'felan-framework'),
							'fields' => array(
								array(
									'id' => 'archive_jobs_layout',
									'type' => 'select',
									'title' => esc_html__('Jobs Layout', 'felan-framework'),
									'default' => 'layout-list',
									'options' => array(
										'layout-list' => esc_html__('Layout List', 'felan-framework'),
										'layout-grid' => esc_html__('Layout Grid', 'felan-framework'),
										'layout-full' => esc_html__('Layout Full', 'felan-framework')
									)
								),
								array(
									'id' => 'archive_jobs_items_amount',
									'type' => 'text',
									'title' => esc_html__('Items Amount', 'felan-framework'),
									'default' => 12,
									'pattern' => '[0-9]*',
								),
								array(
									'id' => 'jobs_pagination_type',
									'type' => 'select',
									'title' => esc_html__('Type Pagination', 'felan-framework'),
									'default' => 'number',
									'options' => array(
										'number' => esc_html__('Number', 'felan-framework'),
										'loadmore' => esc_html__('Load More', 'felan-framework')
									)
								),
								array(
									'id' => "jobs_filter_sidebar_option",
									'title' => esc_html__('Postion Filter ', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'filter-left' => 'Filter Left',
										'filter-right' => 'Filter Right',
										'filter-canvas' => 'Filter Canvas',
									),
									'default' => 'left',
									'required' => array(
										array("enable_jobs_show_map", '=', '0'),
										array("archive_jobs_layout", '!=', 'layout-full'),
									),
								),

								array(
									'id' => 'enable_jobs_url_push',
									'type' => 'button_set',
									'title' => esc_html__('Show URL Push', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden URL Push', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),

								array(
									'id' => 'enable_jobs_single_popup',
									'type' => 'button_set',
									'title' => esc_html__('Show Single Popup', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Single Popup', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
									'required' => array(
										array("archive_jobs_layout", '!=', 'layout-full'),
									),
								),

								array(
									'id' => 'enable_jobs_filter_top',
									'type' => 'button_set',
									'title' => esc_html__('Show Top Filter', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Top Filter', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_jobs_show_map',
									'type' => 'button_set',
									'title' => esc_html__('Show Maps', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Maps', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
									'required' => array(
										array("archive_jobs_layout", '!=', 'layout-full'),
										array("enable_jobs_single_popup", '!=', '1'),
									),
								),
								array(
									'id' => "jobs_map_postion",
									'title' => esc_html__('Postion Maps ', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'map-right' => 'Map Right',
										'map-top' => 'Map Top',
									),
									'default' => 'right',
									'required' => array(
										array("enable_jobs_show_map", '=', '1'),
										array("archive_jobs_layout", '!=', 'layout-full'),
										array("enable_jobs_single_popup", '!=', '1'),
									),
								),
								array(
									'id' => 'enable_jobs_show_des',
									'type' => 'button_set',
									'title' => esc_html__('Show Description', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Description', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_jobs_show_expires',
									'type' => 'button_set',
									'title' => esc_html__('Show Jobs Expires', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Jobs Expires', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
							),
						)),
						apply_filters('felan_register_option_archive_jobs_page_bottom', array()),

						//Single Jobs
						apply_filters('felan_register_option_single_jobs_page_top', array()),
						apply_filters('felan_register_option_single_jobs_page_main', array(
							'id' => 'jobs_page_main_group',
							'type' => 'group',
							'title' => esc_html__('Single Jobs', 'felan-framework'),
							'fields' => array(
								array(
									'id' => 'single_job_layout',
									'type' => 'select',
									'title' => esc_html__('Layout', 'felan-framework'),
									'default' => '01',
									'options' => array(
										'01' => esc_html__('01', 'felan-framework'),
										'02' => esc_html__('02', 'felan-framework'),
										'03' => esc_html__('03', 'felan-framework'),
										'04' => esc_html__('04', 'felan-framework'),
									)
								),
								array(
									'id' => 'enable_single_jobs_info_left',
									'type' => 'button_set',
									'title' => esc_html__('Enable Company Sidebar Left', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Company Sidebar Left', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
									'required' => array(
										array("single_job_layout", '=', '01'),
									)
								),
								array(
									'id' => "enable_job_login_to_view",
									'type' => 'button_set',
									'title' => esc_html__('Enable Job Login To View', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Job Login To View', 'felan-framework'),
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_sticky_sidebar_type',
									'type' => 'button_set',
									'title' => esc_html__('Enable Sticky Sidebar', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable sticky sidebar when scroll', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_single_jobs_salary',
									'type' => 'button_set',
									'title' => esc_html__('Enable Jobs Salary', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Jobs Salary', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_single_jobs_related',
									'type' => 'button_set',
									'title' => esc_html__('Enable Jobs Related', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Jobs Related', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => "enable_date_posted",
									'type' => 'button_set',
									'title' => esc_html__('Enable Date Posted', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Date Posted', 'felan-framework'),
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => "enable_closing_date",
									'type' => 'button_set',
									'title' => esc_html__('Enable Closing Date', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Closing Date', 'felan-framework'),
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => 'enable_single_jobs_apply',
									'type' => 'button_set',
									'title' => esc_html__('Enable Jobs Apply', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Apply', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => 'show_field_jobs_apply',
									'type' => 'checkbox_list',
									'title' => esc_html__('Show Field Form Apply', 'felan-framework'),
									'subtitle' => esc_html__('Choose the field you want to display in the Email application form', 'felan-framework'),
									'options' => array(
										'position' => esc_html__('Current Position', 'felan-framework'),
										'categories' => esc_html__('Categories', 'felan-framework'),
										'date' => esc_html__('Date of Birth', 'felan-framework'),
										'age' => esc_html__('Age', 'felan-framework'),
										'gender' => esc_html__('Gender', 'felan-framework'),
										'languages' => esc_html__('Languages', 'felan-framework'),
										'qualification' => esc_html__('Qualification', 'felan-framework'),
										'experience' => esc_html__('Years of Experience', 'felan-framework'),
									),
									'value_inline' => false,
									'default' => array(),
									'required' => array("enable_single_jobs_apply", '=', '1'),
								),

								array(
									'id' => 'single_jobs_image_size',
									'type' => 'text',
									'title' => esc_html__('Image Size', 'felan-framework'),
									'subtitle' => esc_html__('Enter image size. Alternatively enter size in pixels (Example : 770x250 (Not Include Unit, Space))', 'felan-framework'),
									'default' => '770x250',
								),

								array(
									'id' => 'jobs_details_order',
									'type' => 'sortable',
									'title' => esc_html__('Jobs Content Order', 'felan-framework'),
									'desc' => esc_html__('Drag and drop layout manager, to quickly organize your jobs content details.', 'felan-framework'),
									'options' => array(
										'enable_sp_head' => esc_html__('Head', 'felan-framework'),
										'enable_sp_insights' => esc_html__('Insights', 'felan-framework'),
										'enable_sp_description' => esc_html__('Description', 'felan-framework'),
										'enable_sp_skills' => esc_html__('Skills', 'felan-framework'),
										'enable_sp_gallery' => esc_html__('Gallery', 'felan-framework'),
										'enable_sp_video' => esc_html__('Video', 'felan-framework'),
										'enable_sp_map' => esc_html__('Map', 'felan-framework'),
									),
									'default' => array('enable_sp_skills', 'enable_sp_head', 'enable_sp_description', 'enable_sp_video', 'enable_sp_map', 'enable_sp_insights')
								),
								array(
									'id' => 'jobs_details_sidebar_order',
									'type' => 'sortable',
									'title' => esc_html__('Jobs Sidebar Order', 'felan-framework'),
									'desc' => esc_html__('Drag and drop layout manager, to quickly organize your jobs sidebar order.', 'felan-framework'),
									'options' => array(
										'enable_sidebar_sp_insights' => esc_html__('Insights', 'felan-framework'),
										'enable_sidebar_sp_company' => esc_html__('Company', 'felan-framework'),
									),
									'default' => array('enable_sidebar_sp_apply', 'enable_sidebar_sp_insights', 'enable_sidebar_sp_company')
								),
							),
						)),
						apply_filters('felan_register_option_single_jobs_page_bottom', array()),
						//Jobs Submit
						apply_filters('felan_jobs_option_jobs_submit_top', array()),
						apply_filters('felan_jobs_option_jobs_submit_main', array(
							'id' => 'jobs_submit_group',
							'title' => esc_html__('Jobs Submit', 'felan-framework'),
							'type' => 'group',
							'fields' => array(
								array(
									'id' => 'auto_publish',
									'title' => esc_html__('Automatically publish the submitted jobs?', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => 'auto_publish_edited',
									'title' => esc_html__('Automatically publish the edited jobs?', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_add_new_job_location',
									'title' => esc_html__('Enable Add New Location', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_add_new_job_categories',
									'title' => esc_html__('Enable Add New Categories', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'section_jobs_hide_group_fields',
									'title' => esc_html__('Hide Submit Group Form Fields', 'felan-framework'),
									'type' => 'group',

									'fields' => array(
										array(
											'id' => 'hide_jobs_group_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Submit Form Groups', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide on group field jobs?', 'felan-framework'),
											'options' => array(
												'general' => esc_html__('General', 'felan-framework'),
												'salary' => esc_html__('Salary', 'felan-framework'),
												'apply' => esc_html__('Apply', 'felan-framework'),
												'social' => esc_html__('Social network', 'felan-framework'),
												'company' => esc_html__('Company', 'felan-framework'),
												'location' => esc_html__('Location', 'felan-framework'),
												'thumbnail' => esc_html__('Cover Image', 'felan-framework'),
												'gallery' => esc_html__('Gallery', 'felan-framework'),
												'video' => esc_html__('Video', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
										array(
											'id' => 'hide_jobs_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Submit Form Fields', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide on field jobs?', 'felan-framework'),
											'options' => array(
												'fields_jobs_name' => esc_html__('Name', 'felan-framework'),
												'fields_jobs_category' => esc_html__('Category', 'felan-framework'),
												'fields_jobs_type' => esc_html__('Type', 'felan-framework'),
												'fields_jobs_skills' => esc_html__('Skills', 'felan-framework'),
												'fields_jobs_des' => esc_html__('Description', 'felan-framework'),
												'fields_jobs_career' => esc_html__('Career', 'felan-framework'),
												'fields_jobs_experience' => esc_html__('Experience', 'felan-framework'),
												'fields_jobs_qualification' => esc_html__('Qualification', 'felan-framework'),
												'fields_jobs_quantity' => esc_html__('Quantity', 'felan-framework'),
												'fields_jobs_gender' => esc_html__('Gender', 'felan-framework'),
												'fields_closing_days' => esc_html__('Closing', 'felan-framework'),
												'fields_jobs_location' => esc_html__('Location', 'felan-framework'),
												'fields_map' => esc_html__('Maps', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
										array(
											'id' => 'hide_jobs_apply_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Job apply type', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide on field job apply type?', 'felan-framework'),
											'options' => array(
												'fields_jobs_apply_email' => esc_html__('By Email', 'felan-framework'),
												'fields_jobs_apply_external' => esc_html__('External Apply', 'felan-framework'),
												'fields_jobs_apply_internal' => esc_html__('Internal Apply', 'felan-framework'),
												'fields_jobs_call_to_apply' => esc_html__('Call To Apply', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
										array(
											'id' => 'hide_jobs_salary_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Job Salary', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide on field job salary?', 'felan-framework'),
											'options' => array(
												'fields_jobs_salary_range' => esc_html__('Range', 'felan-framework'),
												'fields_jobs_salary_starting' => esc_html__('Starting Amount', 'felan-framework'),
												'fields_jobs_salary_maximum' => esc_html__('Maximum Amount', 'felan-framework'),
												'fields_jobs_salary_negotiable' => esc_html__('Negotiable Price', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
									)
								),
							)
						)),
						apply_filters('felan_jobs_option_jobs_submit_bottom', array()),

						//Jobs Search
						apply_filters('felan_register_option_search_page_top', array()),
						apply_filters('felan_register_option_search_page_main', array(
							'id' => 'jobs_search_group',
							'title' => esc_html__('Search Jobs', 'felan-framework'),
							'type' => 'group',
							'fields' => array(
								array(
									'id' => 'enable_jobs_search_bg',
									'type' => 'button_set',
									'title' => esc_html__('Enable Background', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Background', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_jobs_search_location_top',
									'type' => 'button_set',
									'title' => esc_html__('Enable Search City/Town (Top)', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Search City/Town', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_jobs_search_location_radius',
									'type' => 'button_set',
									'title' => esc_html__('Enable Search location radius', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden search location radius', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => "jobs_search_color",
									'title' => esc_html__('Color', 'felan-framework'),
									'type' => 'color',
									'col' => '12',
									'default' => '',
									'required' => array(
										array("enable_jobs_search_bg", '=', '1'),
									),
								),
								array(
									'id' => "jobs_search_image",
									'title' => esc_html__('Image', 'felan-framework'),
									'type' => 'image',
									'default' => '',
									'col' => '12',
									'required' => array(
										array("enable_jobs_search_bg", '=', '1'),
									),
								),
								array(
									'id' => 'jobs_search_field',
									'title' => esc_html__('Search Fields', 'felan-framework'),
									'type' => 'sorter',
									'default' => array(
										'top' => array(
											'jobs-categories' => esc_html__('Categories', 'felan-framework'),
										),
										'sidebar' => $sidebar_filter,
										'disable' => array(
											'jobs-skills' => esc_html__('Skills', 'felan-framework'),
											'jobs-location' => esc_html__('Locations', 'felan-framework'),
											'jobs-gender' => esc_html__('Gender', 'felan-framework'),
											'jobs-qualification' => esc_html__('Qualification', 'felan-framework'),
										)
									),
								),
								array(
									'id' => 'jobs_search_fields_jobs-categories',
									'title' => esc_html__('Icon Categories', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'jobs_search_fields_jobs-type',
									'title' => esc_html__('Icon Type', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'jobs_search_fields_jobs-career',
									'title' => esc_html__('Icon Career', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'jobs_search_fields_jobs-experience',
									'title' => esc_html__('Icon Experience', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'jobs_search_fields_jobs-gender',
									'title' => esc_html__('Icon Gender', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'jobs_search_fields_location',
									'title' => esc_html__('Icon City', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'jobs_search_fields_state',
									'title' => esc_html__('Icon State', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'jobs_search_fields_country',
									'title' => esc_html__('Icon Country', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
							)
						)),
						apply_filters('felan_register_option_search_page_bottom', array()),
					),
				));
		}


		/**
		 * Company page option
		 * @return mixed
		 */
		private function company_option()
		{
			$enable_company_package_invite = $option_package_company = array();

			$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
			if ($enable_post_type_service == '1') {
				$enable_company_package_invite = array(
					'id' => "enable_company_package_invite",
					'title' => esc_html__('Enable/Disable Invite', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');
			if ($enable_wallet_mode == '0') {
				$option_package_company = array(
					'id' => 'company_package_group',
					'title' => esc_html__('Company Package', 'felan-framework'),
					'type' => 'group',
					'fields' => array(
						array(
							'id' => "enable_company_package_freelancer_follow",
							'title' => esc_html__('Enable/Disable Freelancer Follow', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),

						$enable_company_package_invite,

						array(
							'id' => "enable_company_package_send_message",
							'title' => esc_html__('Enable/Disable Send Message', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "enable_company_package_review_and_commnent",
							'title' => esc_html__('Enable/Disable Review And Comment', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "enable_company_package_info",
							'title' => esc_html__('Enable/Disable profile information', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'hide_company_freelancer_info_fields',
							'type' => 'checkbox_list',
							'title' => esc_html__('Hide Field freelancer information', 'felan-framework'),
							'subtitle' => esc_html__('Choose which fields you want to hide on freelancer information', 'felan-framework'),
							'options' => array(
								'salary' => esc_html__('Offered Salary', 'felan-framework'),
								'social' => esc_html__('Social', 'felan-framework'),
								'locations' => esc_html__('Locations', 'felan-framework'),
								'languages' => esc_html__('Languages', 'felan-framework'),
								'phone' => esc_html__('Phone', 'felan-framework'),
								'email' => esc_html__('Email', 'felan-framework'),
							),
							'value_inline' => false,
							'default' => array('phone', 'email', 'social'),
							'required' => array("enable_company_package_info", '=', '1'),
						),
					)
				);
			}

			$sidebar_filter = [
				'company-rating' => esc_html__('Rating', 'felan-framework'),
				'company-founded' => esc_html__('Founded', 'felan-framework'),
				'company-size' => esc_html__('Size', 'felan-framework'),
			];
			$custom_field_filter = felan_render_custom_field('company');
			foreach ($custom_field_filter as $custom_field) {
				$sidebar_filter[$custom_field['id']] = $custom_field['title'];
			}
			return
				apply_filters('felan_register_company_option_listing_setting_page', array(
					'id' => 'felan_listing_company_setting_page_option',
					'title' => esc_html__('Companies Option', 'felan-framework'),
					'icon' => 'dashicons-awards',
					'fields' => array(
						//Archive Company
						apply_filters('felan_register_option_archive_company_page_top', array()),
						apply_filters('felan_register_option_archive_company_page_main', array(
							'id' => 'felan_main_group',
							'type' => 'group',
							'title' => esc_html__('Archive Company', 'felan-framework'),
							'fields' => array(
								array(
									'id' => 'archive_company_layout',
									'type' => 'select',
									'title' => esc_html__('Company Layout', 'felan-framework'),
									'default' => 'layout-list',
									'options' => array(
										'layout-list' => esc_html__('Layout List', 'felan-framework'),
										'layout-grid' => esc_html__('Layout Grid', 'felan-framework'),
									)
								),
								array(
									'id' => 'archive_company_thumbnail_size',
									'type' => 'text',
									'title' => esc_html__('Thumbnail Size', 'felan-framework'),
									'subtitle' => esc_html__('Enter image size. Alternatively enter size in pixels (Example : 330x180 (Not Include Unit, Space))', 'felan-framework'),
									'default' => '576x327',
								),
								array(
									'id' => 'archive_company_items_amount',
									'type' => 'text',
									'title' => esc_html__('Items Amount', 'felan-framework'),
									'default' => 12,
									'pattern' => '[0-9]*',
								),
								array(
									'id' => 'company_pagination_type',
									'type' => 'select',
									'title' => esc_html__('Type Pagination', 'felan-framework'),
									'default' => 'number',
									'options' => array(
										'number' => esc_html__('Number', 'felan-framework'),
										'loadmore' => esc_html__('Load More', 'felan-framework')
									)
								),
								array(
									'id' => "company_filter_sidebar_option",
									'title' => esc_html__('Postion Filter', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'filter-left' => 'Filter Left',
										'filter-right' => 'Filter Right',
										'filter-canvas' => 'Filter Canvas',
									),
									'default' => 'left',
								),
								array(
									'id' => 'enable_company_single_popup',
									'type' => 'button_set',
									'title' => esc_html__('Show Single Popup', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Single Popup', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_company_filter_top',
									'type' => 'button_set',
									'title' => esc_html__('Show Top Filter', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Top Filter', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_company_show_map',
									'type' => 'button_set',
									'title' => esc_html__('Show Maps', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Maps', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
									'required' => array(
										array("enable_company_single_popup", '!=', '1'),
									),
								),
								array(
									'id' => "company_map_postion",
									'title' => esc_html__('Postion Maps ', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'map-right' => 'Map Right',
										'map-top' => 'Map Top',
									),
									'default' => 'right',
									'required' => array(
										array("enable_company_show_map", '=', '1'),
										array("enable_company_single_popup", '!=', '1')
									),
								),
								array(
									'id' => 'enable_company_show_des',
									'type' => 'button_set',
									'title' => esc_html__('Show Description', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Description', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_edit_review_company',
									'type' => 'button_set',
									'title' => esc_html__('Enable Edit Review Company', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Edit Review Company', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_company_url_push',
									'type' => 'button_set',
									'title' => esc_html__('Show URL Push', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden URL Push', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
							),
						)),
						apply_filters('felan_register_option_archive_company_page_bottom', array()),

						//Single Company
						apply_filters('felan_register_option_single_company_page_top', array()),
						apply_filters('felan_register_option_single_company_page_main', array(
							'id' => 'company_page_main_group',
							'type' => 'group',
							'title' => esc_html__('Single Company', 'felan-framework'),
							'fields' => array(
								array(
									'id' => "enable_company_login_to_view",
									'type' => 'button_set',
									'title' => esc_html__('Enable Company Login To View', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Company Login To View', 'felan-framework'),
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_sticky_company_sidebar_type',
									'type' => 'button_set',
									'title' => esc_html__('Enable Sticky Sidebar', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable sticky sidebar when scroll', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_single_company_related',
									'type' => 'button_set',
									'title' => esc_html__('Enable Company Related', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Company Related', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => "single_company_style",
									'title' => esc_html__('Style Thumbnail Images', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'cover-img' => 'Cover Image',
										'large-cover-img' => 'Large Cover Image',
									),
								),

								array(
									'id' => 'single_company_image_size',
									'type' => 'text',
									'title' => esc_html__('Image Size', 'felan-framework'),
									'subtitle' => esc_html__('Enter image size. Alternatively enter size in pixels (Example : 330x180 (Not Include Unit, Space))', 'felan-framework'),
									'default' => '',
								),

								array(
									'id' => 'hide_company_tabs_groups',
									'type' => 'checkbox_list',
									'title' => esc_html__('Hide Tabs Groups', 'felan-framework'),
									'subtitle' => esc_html__('Choose which tabs you want to hide on company detail', 'felan-framework'),
									'options' => array(
										'about_us' => esc_html__('About us', 'felan-framework'),
										'photos' => esc_html__('Photos', 'felan-framework'),
										'projects' => esc_html__('Projects', 'felan-framework'),
										'reviews' => esc_html__('Reviews', 'felan-framework'),
									),
									'value_inline' => false,
									'default' => array()
								),

								array(
									'id' => 'company_details_order',
									'type' => 'sortable',
									'title' => esc_html__('Company Content Order', 'felan-framework'),
									'desc' => esc_html__('Drag and drop layout manager, to quickly organize your company content details.', 'felan-framework'),
									'options' => array(
										'enable_sp_overview' => esc_html__('Overview', 'felan-framework'),
										'enable_sp_video' => esc_html__('Video', 'felan-framework'),
									),
									'default' => array('enable_sp_company_overview', 'enable_sp_video')
								),
								array(
									'id' => 'company_details_sidebar_order',
									'type' => 'sortable',
									'title' => esc_html__('Company Sidebar Order', 'felan-framework'),
									'desc' => esc_html__('Drag and drop layout manager, to quickly organize your company sidebar order.', 'felan-framework'),
									'options' => array(
										'enable_sidebar_sp_info' => esc_html__('Information', 'felan-framework'),
										'enable_sidebar_sp_location' => esc_html__('Location', 'felan-framework'),
									),
									'default' => array('enable_sidebar_sp_info', 'enable_sidebar_sp_location'),
								),
							),
						)),
						apply_filters('felan_register_option_single_company_page_bottom', array()),

						//Company Submit
						apply_filters('felan_option_company_submit_top', array()),
						apply_filters('felan_option_company_submit_main', array(
							'id' => 'company_submit_group',
							'title' => esc_html__('Company Submit', 'felan-framework'),
							'type' => 'group',
							'fields' => array(
								array(
									'id' => 'company_auto_publish',
									'title' => esc_html__('Automatically publish the submitted Company?', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => 'company_auto_publish_edited',
									'title' => esc_html__('Automatically publish the edited Company?', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => 'enable_add_new_company_location',
									'title' => esc_html__('Enable Add New Location', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '0',
								),

								array(
									'id' => 'enable_add_new_company_categories',
									'title' => esc_html__('Enable Add New Categories', 'felan-framework'),
									'type' => 'button_set',
									'options' => array(
										'1' => esc_html__('Yes', 'felan-framework'),
										'0' => esc_html__('No', 'felan-framework'),
									),
									'default' => '0',
								),

								array(
									'id' => 'value_founded_min',
									'type' => 'text',
									'title' => esc_html__('Founded Year Min', 'felan-framework'),
									'subtitle' => esc_html__('Enter values founded year min', 'felan-framework'),
									'default' => '2010',
								),
								array(
									'id' => 'section_company_hide_group_fields',
									'title' => esc_html__('Hide Submit Group Form Fields', 'felan-framework'),
									'type' => 'group',

									'fields' => array(
										array(
											'id' => 'hide_company_group_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Submit Form Groups', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide on group fields company?', 'felan-framework'),
											'options' => array(
												'general' => esc_html__('General', 'felan-framework'),
												'media' => esc_html__('Media', 'felan-framework'),
												'social' => esc_html__('Social network', 'felan-framework'),
												'location' => esc_html__('Location', 'felan-framework'),
												'gallery' => esc_html__('Gallery', 'felan-framework'),
												'video' => esc_html__('Video', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
										array(
											'id' => 'hide_company_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Submit Form Fields', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide on fields company?', 'felan-framework'),
											'options' => array(
												'fields_company_name' => esc_html__('Name', 'felan-framework'),
												'fields_company_category' => esc_html__('Category', 'felan-framework'),
												'fields_company_url' => esc_html__('Url', 'felan-framework'),
												'fields_company_about' => esc_html__('About', 'felan-framework'),
												'fields_company_website' => esc_html__('Website', 'felan-framework'),
												'fields_company_phone' => esc_html__('Phone', 'felan-framework'),
												'fields_company_email' => esc_html__('Email', 'felan-framework'),
												'fields_company_founded' => esc_html__('Founded', 'felan-framework'),
												'fields_company_size' => esc_html__('Size', 'felan-framework'),
												'fields_company_logo' => esc_html__('Logo', 'felan-framework'),
												'fields_company_thumbnail' => esc_html__('Thumbnail', 'felan-framework'),
												'fields_company_location' => esc_html__('Location', 'felan-framework'),
												'fields_company_map' => esc_html__('Maps', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
									)
								),
							)
						)),
						apply_filters('felan_option_company_submit_bottom', array()),

						//Company Search
						apply_filters('felan_register_option_search_company_page_top', array()),
						apply_filters('felan_register_option_search_company_page_main', array(
							'id' => 'company_search_group',
							'title' => esc_html__('Search Company', 'felan-framework'),
							'type' => 'group',
							'fields' => array(
								array(
									'id' => 'enable_company_search_bg',
									'type' => 'button_set',
									'title' => esc_html__('Enable Background', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Background', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_company_search_location_top',
									'type' => 'button_set',
									'title' => esc_html__('Enable Search City/Town (Top)', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Search City/Town', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_company_search_location_radius',
									'type' => 'button_set',
									'title' => esc_html__('Enable Search location radius', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden search location radius', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => "company_search_color",
									'title' => esc_html__('Color', 'felan-framework'),
									'type' => 'color',
									'col' => '12',
									'default' => '',
									'required' => array(
										array("enable_company_search_bg", '=', '1'),
									),
								),
								array(
									'id' => "company_search_image",
									'title' => esc_html__('Image', 'felan-framework'),
									'type' => 'image',
									'default' => '',
									'col' => '12',
									'required' => array(
										array("enable_company_search_bg", '=', '1'),
									),
								),
								array(
									'id' => 'company_search_fields',
									'title' => esc_html__('Search Fields', 'felan-framework'),
									'type' => 'sorter',
									'default' => array(
										'top' => array(
											'company-categories' => esc_html__('Categories', 'felan-framework'),
										),
										'sidebar' => $sidebar_filter,
										'disable' => array(
											'company-location' => esc_html__('Location', 'felan-framework'),
										)
									),
								),
								array(
									'id' => 'company_search_fields_company-categories',
									'title' => esc_html__('Icon Categories', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'company_search_fields_company-rating',
									'title' => esc_html__('Icon Rating', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'company_search_fields_company-founded',
									'title' => esc_html__('Icon Founded', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'company_search_fields_company-size',
									'title' => esc_html__('Icon Size', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'company_search_fields_location',
									'title' => esc_html__('Icon City', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'company_search_fields_state',
									'title' => esc_html__('Icon State', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'company_search_fields_country',
									'title' => esc_html__('Icon Country', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
							)
						)),
						apply_filters('felan_register_option_search_company_page_bottom', array()),

						//Company Package
						apply_filters('felan_register_option_company_package_page_top', array()),
						apply_filters('felan_register_option_company_package_page_main', $option_package_company),
						apply_filters('felan_register_option_company_package_page_bottom', array())
					),
				));
		}
		/**
		 * Freelancer page option
		 * @return mixed
		 */
		private function freelancer_option()
		{
			$enable_freelancer_package_jobs_apply = $enable_freelancer_package_jobs_wishlist = $enable_freelancer_package_project_apply
				= $enable_freelancer_package_contact_company = $hide_freelancer_contact_company_fields
				= $enable_freelancer_withdrawal_fee = $freelancer_number_withdrawal_fee = $option_freelancer_package = array();

			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			if ($enable_post_type_jobs == '1') {
				$enable_freelancer_package_jobs_apply = array(
					'id' => "enable_freelancer_package_jobs_apply",
					'title' => esc_html__('Enable/Disable Jobs Apply', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);

				$enable_freelancer_package_jobs_wishlist = 	array(
					'id' => "enable_freelancer_package_jobs_wishlist",
					'title' => esc_html__('Enable/Disable Jobs Wishlist', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);

				$enable_freelancer_package_contact_company = array(
					'id' => "enable_freelancer_package_contact_company",
					'title' => esc_html__('Enable/Disable Contact Company In Jobs', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);

				$hide_freelancer_contact_company_fields = array(
					'id' => 'hide_freelancer_contact_company_fields',
					'type' => 'checkbox_list',
					'title' => esc_html__('Hide Field Contact Company In Jobs', 'felan-framework'),
					'subtitle' => esc_html__('Choose which fields you want to hide on Contact Company In Jobs', 'felan-framework'),
					'options' => array(
						'categories' => esc_html__('Categories', 'felan-framework'),
						'location' => esc_html__('Location', 'felan-framework'),
						'phone' => esc_html__('Phone', 'felan-framework'),
						'email' => esc_html__('Email', 'felan-framework'),
					),
					'value_inline' => false,
					'default' => array('phone', 'email', 'social'),
					'required' => array("enable_freelancer_package_contact_company", '=', '1'),
				);
			}

			$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
			if ($enable_post_type_service == '1') {
				$enable_freelancer_withdrawal_fee =   array(
					'id' => 'enable_freelancer_withdrawal_fee',
					'type' => 'button_set',
					'title' => esc_html__('Enable Withdrawal Service Fee', 'felan-framework'),
					'subtitle' => esc_html__('Enable/Disable Freelancer Withdrawal Service Fee', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1',
				);

				$freelancer_number_withdrawal_fee = array(
					'id' => "freelancer_number_withdrawal_fee",
					'title' => esc_html__('Number Withdrawal Service Fee', 'felan-framework'),
					'subtitle' => esc_html__('Enter (%) Freelancer Withdrawal Service Fee', 'felan-framework'),
					'type' => 'text',
					'default' => '10',
					'pattern' => '[0-9]*',
					'required' => array(
						array("enable_freelancer_withdrawal_fee", '=', '1')
					),
				);
			}

			$enable_edit_review_freelancer = array(
				'id' => 'enable_edit_review_freelancer',
				'type' => 'button_set',
				'title' => esc_html__('Enable Edit Review Freelancer', 'felan-framework'),
				'subtitle' => esc_html__('Enable/Disable Edit Review Freelancer', 'felan-framework'),
				'desc' => '',
				'options' => array(
					'1' => esc_html__('On', 'felan-framework'),
					'0' => esc_html__('Off', 'felan-framework'),
				),
				'default' => '1',
			);

			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			if ($enable_post_type_project == '1') {
				$enable_freelancer_package_project_apply = array(
					'id' => "enable_freelancer_package_project_apply",
					'title' => esc_html__('Enable/Disable Project Apply', 'felan-framework'),
					'type' => 'button_set',
					'options' => array(
						'1' => esc_html__('Yes', 'felan-framework'),
						'0' => esc_html__('No', 'felan-framework'),
					),
					'default' => '0',
				);
			}

			$title_freelancers = esc_html__('Freelancers Option', 'felan-framework');
			if ($enable_post_type_jobs == '1' && $enable_post_type_service !== '1' && $enable_post_type_project !== '1') {
				$title_freelancers = esc_html__('Candidate Option', 'felan-framework');
			}

			$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');
			if ($enable_wallet_mode == '0') {
				$option_freelancer_package = array(
					'id' => 'freelancer_package_group',
					'title' => esc_html__('Package Options', 'felan-framework'),
					'type' => 'group',
					'fields' => array(

						$enable_freelancer_package_jobs_apply,
						$enable_freelancer_package_jobs_wishlist,

						$enable_freelancer_package_project_apply,

						array(
							'id' => "enable_freelancer_package_company_follow",
							'title' => esc_html__('Enable/Disable Company follow', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "enable_freelancer_package_send_message",
							'title' => esc_html__('Enable/Disable Send Message', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "enable_freelancer_package_review_and_commnent",
							'title' => esc_html__('Enable/Disable Review And Comment', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),

						$enable_freelancer_package_contact_company,
						$hide_freelancer_contact_company_fields,

						array(
							'id' => "enable_freelancer_package_info_company",
							'title' => esc_html__('Enable/Disable Information Company', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'hide_freelancer_info_company_fields',
							'type' => 'checkbox_list',
							'title' => esc_html__('Hide Field Info Company', 'felan-framework'),
							'subtitle' => esc_html__('Choose which fields you want to hide on Information Company', 'felan-framework'),
							'options' => array(
								'categories' => esc_html__('Categories', 'felan-framework'),
								'size' => esc_html__('Size', 'felan-framework'),
								'founded' => esc_html__('Founded in', 'felan-framework'),
								'location' => esc_html__('Location', 'felan-framework'),
								'phone' => esc_html__('Phone', 'felan-framework'),
								'email' => esc_html__('Email', 'felan-framework'),
								'social' => esc_html__('Social', 'felan-framework'),
							),
							'value_inline' => false,
							'default' => array('phone', 'email', 'social'),
							'required' => array("enable_freelancer_package_info_company", '=', '1'),
						),
					)
				);
			}

			$sidebar_filter = [
				'freelancer_rating' => esc_html__('Rating', 'felan-framework'),
				'freelancer_yoe' => esc_html__('Experience', 'felan-framework'),
				'freelancer_qualification' => esc_html__('Qualification', 'felan-framework'),
				'freelancer_gender' => esc_html__('Gender', 'felan-framework'),
			];
			$custom_field_filter = felan_render_custom_field('freelancer');
			foreach ($custom_field_filter as $custom_field) {
				$sidebar_filter[$custom_field['id']] = $custom_field['title'];
			}
			return
				apply_filters('felan_register_freelancer_option_listing_setting_page', array(
					'id' => 'felan_listing_freelancer_setting_page_option',
					'title' => $title_freelancers,
					'icon' => 'dashicons-businessperson',
					'fields' => array(
						$enable_freelancer_withdrawal_fee,
						$freelancer_number_withdrawal_fee,
						$enable_edit_review_freelancer,

						//Archive Freelancer
						apply_filters('felan_register_option_archive_freelancer_page_top', array()),
						apply_filters('felan_register_option_archive_freelancer_page_main', array(
							'id' => 'felan_main_group',
							'type' => 'group',
							'title' => esc_html__('Archive Options', 'felan-framework'),
							'fields' => array(
								array(
									'id' => 'archive_freelancer_layout',
									'type' => 'select',
									'title' => esc_html__('Archive Layout', 'felan-framework'),
									'default' => 'layout-list',
									'options' => array(
										'layout-list' => esc_html__('Layout List', 'felan-framework'),
										'layout-grid' => esc_html__('Layout Grid', 'felan-framework'),
									)
								),
								array(
									'id' => 'archive_freelancer_items_amount',
									'type' => 'text',
									'title' => esc_html__('Items Amount', 'felan-framework'),
									'default' => 12,
									'pattern' => '[0-9]*',
								),
								array(
									'id' => 'freelancer_pagination_type',
									'type' => 'select',
									'title' => esc_html__('Type Pagination', 'felan-framework'),
									'default' => 'number',
									'options' => array(
										'number' => esc_html__('Number', 'felan-framework'),
										'loadmore' => esc_html__('Load More', 'felan-framework')
									)
								),
								array(
									'id' => "freelancer_filter_sidebar_option",
									'title' => esc_html__('Postion Filter ', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'filter-left' => 'Filter Left',
										'filter-right' => 'Filter Right',
										'filter-canvas' => 'Filter Canvas',
									),
									'default' => 'left',
									'required' => array(
										array("enable_freelancer_show_map", '=', '0'),
									),
								),
								array(
									'id' => 'enable_freelancer_single_popup',
									'type' => 'button_set',
									'title' => esc_html__('Show Single Popup', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Single Popup', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_freelancer_filter_top',
									'type' => 'button_set',
									'title' => esc_html__('Show Top Filter', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Top Filter', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'enable_freelancer_show_map',
									'type' => 'button_set',
									'title' => esc_html__('Show Maps', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Maps', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
									'required' => array(
										array("enable_freelancer_single_popup", '!=', '1'),
									),
								),
								array(
									'id' => "freelancer_map_postion",
									'title' => esc_html__('Postion Maps ', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'map-right' => 'Map Right',
										'map-top' => 'Map Top',
									),
									'default' => 'right',
									'required' => array(
										array("enable_freelancer_show_map", '=', '1'),
										array("enable_freelancer_single_popup", '!=', '1'),
									),
								),
								array(
									'id' => 'enable_freelancer_show_des',
									'type' => 'button_set',
									'title' => esc_html__('Show Description', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Description', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => 'archive_freelancer_stautus',
									'type' => 'select',
									'title' => esc_html__('Status', 'felan-framework'),
									'subtitle' => esc_html__('Select freelancer status after registration', 'felan-framework'),
									'default' => 'pending',
									'options' => array(
										'pending' => esc_html__('Pending', 'felan-framework'),
										'publish' => esc_html__('Published', 'felan-framework'),
									)
								),
							),
						)),
						apply_filters('felan_register_option_archive_freelancer_page_bottom', array()),

						//Single Freelancer
						apply_filters('felan_register_option_single_freelancer_page_top', array()),
						apply_filters('felan_register_option_single_freelancer_page_main', array(
							'id' => 'freelancer_page_main_group',
							'type' => 'group',
							'title' => esc_html__('Single Options', 'felan-framework'),
							'fields' => array(
								array(
									'id' => "enable_freelancer_login_to_view",
									'type' => 'button_set',
									'title' => esc_html__('Enable Login To View', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable Freelancer Login To View', 'felan-framework'),
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_sticky_freelancer_sidebar_type',
									'type' => 'button_set',
									'title' => esc_html__('Enable Sticky Sidebar', 'felan-framework'),
									'subtitle' => esc_html__('Enable/Disable sticky sidebar when scroll', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),

								array(
									'id' => "single_freelancer_style",
									'title' => esc_html__('Style Thumbnail Images', 'felan-framework'),
									'type' => 'select',
									'options' => array(
										'cover-img' => 'Cover Image',
										'large-cover-img' => 'Large Cover Image',
									),
								),

								array(
									'id' => 'single_freelancer_image_size',
									'type' => 'text',
									'title' => esc_html__('Image Size', 'felan-framework'),
									'subtitle' => esc_html__('Enter image size. Alternatively enter size in pixels (Example : 330x180 (Not Include Unit, Space))', 'felan-framework'),
									'default' => '',
								),
								array(
									'id' => 'hide_freelancer_tabs_groups',
									'type' => 'checkbox_list',
									'title' => esc_html__('Hide Tabs Groups', 'felan-framework'),
									'subtitle' => esc_html__('Choose which tabs you want to hide on Freelancer Profile', 'felan-framework'),
									'options' => array(
										'about_me' => esc_html__('About Me', 'felan-framework'),
										'projects' => esc_html__('Projects', 'felan-framework'),
										'services' => esc_html__('Services', 'felan-framework'),
										'reviews' => esc_html__('Reviews', 'felan-framework'),
									),
									'value_inline' => false,
									'default' => array()
								),
								array(
									'id' => 'freelancers_details_order',
									'type' => 'sortable',
									'title' => esc_html__('Content Order', 'felan-framework'),
									'desc' => esc_html__('Drag and drop layout manager, to quickly organize your freelancer content order.', 'felan-framework'),
									'options' => array(
										'enable_sp_thumbnail' => esc_html__('Thumbnail', 'felan-framework'),
										'enable_sp_head' => esc_html__('Head', 'felan-framework'),
										'enable_sp_descriptions' => esc_html__('Descriptions', 'felan-framework'),
										'enable_sp_video' => esc_html__('Video', 'felan-framework'),
										'enable_sp_experience' => esc_html__('Experience', 'felan-framework'),
										'enable_sp_education' => esc_html__('Education', 'felan-framework'),
										'enable_sp_photos' => esc_html__('Photos', 'felan-framework'),
										'enable_sp_portfolio' => esc_html__('Portfolio', 'felan-framework'),
										'enable_sp_awards' => esc_html__('Awards', 'felan-framework'),
									),
									'default' => array(
										'enable_sp_thumbnail',
										'enable_sp_head',
										'enable_sp_descriptions',
										'enable_sp_video',
										'enable_sp_experience',
										'enable_sp_education',
										'enable_sp_portfolio',
										'enable_sp_awards'
									),
								),

								array(
									'id' => 'freelancer_details_sidebar_order',
									'type' => 'sortable',
									'title' => esc_html__('Sidebar Order', 'felan-framework'),
									'desc' => esc_html__('Drag and drop layout manager, to quickly organize your freelancer sidebar order.', 'felan-framework'),
									'options' => array(
										'enable_sidebar_sp_info' => esc_html__('Information', 'felan-framework'),
										'enable_sidebar_sp_location' => esc_html__('Location', 'felan-framework'),
									),
									'default' => array('enable_sidebar_sp_info', 'enable_sidebar_sp_location'),
								),
							),
						)),
						apply_filters('felan_register_option_single_freelancer_page_bottom', array()),
						//Freelancer Profile
						apply_filters('felan_option_freelancer_profile_top', array()),
						apply_filters('felan_option_freelancer_profile_main', array(
							'id' => 'freelancer_profile_group',
							'title' => esc_html__('Profile Options', 'felan-framework'),
							'type' => 'group',
							'fields' => array(
								array(
									'id' => 'section_freelancer_hide_group_fields',
									'title' => esc_html__('Hide Submit Group Form Fields', 'felan-framework'),
									'type' => 'group',
									'fields' => array(
										array(
											'id' => 'enable_freelancer_language_multiple',
											'type' => 'button_set',
											'title' => esc_html__('Enable Language Multiple', 'felan-framework'),
											'subtitle' => esc_html__('Show/Hidden Multiple', 'felan-framework'),
											'desc' => '',
											'options' => array(
												'1' => esc_html__('On', 'felan-framework'),
												'0' => esc_html__('Off', 'felan-framework'),
											),
											'default' => '0',
										),
										array(
											'id' => 'type_name_freelancer',
											'type' => 'select',
											'title' => esc_html__('Display Name', 'felan-framework'),
											'subtitle' => esc_html__('Display type name after registration', 'felan-framework'),
											'options' => array(
												'user-name' => esc_html__('User Name', 'felan-framework'),
												'fl-name' => esc_html__('First Name + Last Name', 'felan-framework'),
											),
											'default' => 'user-name',
										),
										array(
											'id' => 'hide_freelancer_group_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Submit Form Groups', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide on profile', 'felan-framework'),
											'options' => array(
												'info' => esc_html__('Basic Info', 'felan-framework'),
												'education' => esc_html__('Education', 'felan-framework'),
												'experience' => esc_html__('Experience', 'felan-framework'),
												'skills' => esc_html__('Skills', 'felan-framework'),
												'projects' => esc_html__('Projects', 'felan-framework'),
												'awards' => esc_html__('Awards', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
										array(
											'id' => 'hide_freelancer_fields',
											'type' => 'checkbox_list',
											'title' => esc_html__('Hide Submit Form Fields', 'felan-framework'),
											'subtitle' => esc_html__('Choose which fields you want to hide profile', 'felan-framework'),
											'options' => array(
												'fields_freelancer_avatar' => esc_html__('Avatar', 'felan-framework'),
												'fields_freelancer_thumbnail' => esc_html__('Thumbnail', 'felan-framework'),
												'fields_freelancer_first_name' => esc_html__('First name', 'felan-framework'),
												'fields_freelancer_last_name' => esc_html__('Last name', 'felan-framework'),
												'fields_freelancer_email_address' => esc_html__('Email address', 'felan-framework'),
												'fields_freelancer_phone_number' => esc_html__('Phone number', 'felan-framework'),
												'fields_freelancer_current_position' => esc_html__('Current Position', 'felan-framework'),
												'fields_freelancer_categories' => esc_html__('Categories', 'felan-framework'),
												'fields_freelancer_description' => esc_html__('Description', 'felan-framework'),
												'fields_freelancer_date_of_birth' => esc_html__('Date of Birth', 'felan-framework'),
												'fields_freelancer_age' => esc_html__('Age', 'felan-framework'),
												'fields_freelancer_gender' => esc_html__('Gender', 'felan-framework'),
												'fields_closing_languages' => esc_html__('Languages', 'felan-framework'),
												'fields_freelancer_qualification' => esc_html__('Qualification', 'felan-framework'),
												'fields_freelancer_experience' => esc_html__('Years of Experience', 'felan-framework'),
												'fields_freelancer_salary' => esc_html__('Salary', 'felan-framework'),
												'fields_freelancer_resume' => esc_html__('Resume', 'felan-framework'),
												'fields_freelancer_social' => esc_html__('Social Network', 'felan-framework'),
												'fields_freelancer_my_profile' => esc_html__('My Profile', 'felan-framework'),
												'fields_freelancer_location' => esc_html__('Location', 'felan-framework'),
												'fields_freelancer_map' => esc_html__('Map', 'felan-framework'),
												'fields_freelancer_gallery' => esc_html__('Gallery', 'felan-framework'),
												'fields_freelancer_video' => esc_html__('Video', 'felan-framework'),
											),
											'value_inline' => false,
											'default' => array()
										),
									)
								),
							)
						)),
						apply_filters('felan_option_freelancer_submit_bottom', array()),

						//Freelancer Search
						apply_filters('felan_register_option_search_freelancer_page_top', array()),
						apply_filters('felan_register_option_search_freelancer_page_main', array(
							'id' => 'freelancer_search_group',
							'title' => esc_html__('Search Options', 'felan-framework'),
							'type' => 'group',
							'fields' => array(
								array(
									'id' => 'enable_freelancer_search_bg',
									'type' => 'button_set',
									'title' => esc_html__('Enable Background', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Background', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_freelancer_search_location_top',
									'type' => 'button_set',
									'title' => esc_html__('Enable Search City/Town (Top)', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden Search City/Town', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '0',
								),
								array(
									'id' => 'enable_freelancer_search_location_radius',
									'type' => 'button_set',
									'title' => esc_html__('Enable Search location radius', 'felan-framework'),
									'subtitle' => esc_html__('Show/Hidden search location radius', 'felan-framework'),
									'desc' => '',
									'options' => array(
										'1' => esc_html__('On', 'felan-framework'),
										'0' => esc_html__('Off', 'felan-framework'),
									),
									'default' => '1',
								),
								array(
									'id' => "freelancer_search_color",
									'title' => esc_html__('Color', 'felan-framework'),
									'type' => 'color',
									'col' => '12',
									'default' => '',
									'required' => array(
										array("enable_freelancer_search_bg", '=', '1'),
									),
								),
								array(
									'id' => "freelancer_search_image",
									'title' => esc_html__('Image', 'felan-framework'),
									'type' => 'image',
									'default' => '',
									'col' => '12',
									'required' => array(
										array("enable_freelancer_search_bg", '=', '1'),
									),
								),
								array(
									'id' => 'freelancer_search_fields',
									'title' => esc_html__('Search Fields', 'felan-framework'),
									'type' => 'sorter',
									'default' => array(
										'top' => array(
											'freelancer_categories' => esc_html__('Categories', 'felan-framework'),
										),
										'sidebar' => $sidebar_filter,
										'disable' => array(
											'freelancer_locations' => esc_html__('Location', 'felan-framework'),
											'freelancer_ages' => esc_html__('Ages', 'felan-framework'),
											'freelancer_skills' => esc_html__('Skills', 'felan-framework'),
											'freelancer_languages' => esc_html__('Languages', 'felan-framework'),
										)
									),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_categories',
									'title' => esc_html__('Icon Categories', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_rating',
									'title' => esc_html__('Icon Rating', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_yoe',
									'title' => esc_html__('Icon Experience', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_qualification',
									'title' => esc_html__('Icon Qualification', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_ages',
									'title' => esc_html__('Icon Ages', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_gender',
									'title' => esc_html__('Icon Gender', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_skills',
									'title' => esc_html__('Icon Skills', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_freelancer_languages',
									'title' => esc_html__('Icon Languages', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_location',
									'title' => esc_html__('Icon City', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_state',
									'title' => esc_html__('Icon State', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
								array(
									'id' => 'freelancer_search_fields_country',
									'title' => esc_html__('Icon Country', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
							)
						)),
						apply_filters('felan_register_option_search_freelancer_page_bottom', array()),


						//Freelancer Package
						apply_filters('felan_register_option_freelancer_package_page_top', array()),
						apply_filters('felan_register_option_freelancer_package_page_main', $option_freelancer_package),
						apply_filters('felan_register_option_freelancer_package_page_bottom', array())
					),
				));
		}


		/**
		 * Service page option
		 * @return mixed
		 */

		private function service_option()
		{
			//Archive Service
			$option_archive_service = $option_single_service = $option_submit_service = $option_search_service = array();

			//Archive Service
			$option_archive_service = array(
				'id' => 'felan_archive_service_group',
				'type' => 'group',
				'title' => esc_html__('Archive Service', 'felan-framework'),
				'fields' => array(
					array(
						'id' => 'archive_service_layout',
						'type' => 'select',
						'title' => esc_html__('Service Layout', 'felan-framework'),
						'default' => 'layout-list',
						'options' => array(
							'layout-list' => esc_html__('Layout List', 'felan-framework'),
							'layout-grid' => esc_html__('Layout Grid', 'felan-framework'),
						)
					),
					array(
						'id' => 'archive_service_items_amount',
						'type' => 'text',
						'title' => esc_html__('Items Amount', 'felan-framework'),
						'default' => 12,
						'pattern' => '[0-9]*',
					),
					array(
						'id' => 'service_pagination_type',
						'type' => 'select',
						'title' => esc_html__('Type Pagination', 'felan-framework'),
						'default' => 'number',
						'options' => array(
							'number' => esc_html__('Number', 'felan-framework'),
							'loadmore' => esc_html__('Load More', 'felan-framework')
						)
					),
					array(
						'id' => "service_filter_sidebar_option",
						'title' => esc_html__('Postion Filter ', 'felan-framework'),
						'type' => 'select',
						'options' => array(
							'filter-left' => 'Filter Left',
							'filter-right' => 'Filter Right',
							'filter-canvas' => 'Filter Canvas',
						),
						'default' => 'left',
					),
					array(
						'id' => 'enable_service_single_popup',
						'type' => 'button_set',
						'title' => esc_html__('Show Single Popup', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Single Popup', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
						'required' => array(
							array("archive_jobs_layout", '!=', 'layout-full'),
						),
					),
					array(
						'id' => 'enable_service_filter_top',
						'type' => 'button_set',
						'title' => esc_html__('Show Top Filter', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Top Filter', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'enable_service_show_map',
						'type' => 'button_set',
						'title' => esc_html__('Show Maps', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Maps', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
						'required' => array(
							array("enable_service_single_popup", '!=', '1'),
						),
					),
					array(
						'id' => "service_map_postion",
						'title' => esc_html__('Postion Maps ', 'felan-framework'),
						'type' => 'select',
						'options' => array(
							'map-right' => 'Map Right',
							'map-top' => 'Map Top',
						),
						'default' => 'right',
						'required' => array(
							array("enable_service_show_map", '=', '1'),
							array("enable_service_single_popup", '!=', '1'),
						),
					),
					array(
						'id' => 'enable_service_show_des',
						'type' => 'button_set',
						'title' => esc_html__('Show Description', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Description', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
				),
			);

			//Single Service
			$option_single_service = array(
				'id' => 'service_single_service_group',
				'type' => 'group',
				'title' => esc_html__('Single Service', 'felan-framework'),
				'fields' => array(
					array(
						'id' => 'enable_single_service_info_left',
						'type' => 'button_set',
						'title' => esc_html__('Enable Profile Sidebar Left', 'felan-framework'),
						'subtitle' => esc_html__('Enable/Disable Profile Sidebar Left', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'enable_sticky_service_sidebar_type',
						'type' => 'button_set',
						'title' => esc_html__('Enable Sticky Sidebar', 'felan-framework'),
						'subtitle' => esc_html__('Enable/Disable sticky sidebar when scroll', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'enable_single_service_related',
						'type' => 'button_set',
						'title' => esc_html__('Enable Service Related', 'felan-framework'),
						'subtitle' => esc_html__('Enable/Disable Service Related', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'services_details_order',
						'type' => 'sortable',
						'title' => esc_html__('Service Content Order', 'felan-framework'),
						'desc' => esc_html__('Drag and drop layout manager, to quickly organize your service content details.', 'felan-framework'),
						'options' => array(
							'enable_sp_gallery' => esc_html__('Gallery', 'felan-framework'),
							'enable_sp_descriptions' => esc_html__('Descriptions', 'felan-framework'),
							'enable_sp_skills' => esc_html__('Skills', 'felan-framework'),
							'enable_sp_package' => esc_html__('Packages', 'felan-framework'),
							'enable_sp_location' => esc_html__('Location', 'felan-framework'),
							'enable_sp_video' => esc_html__('Video', 'felan-framework'),
							'enable_sp_faq' => esc_html__('Faq', 'felan-framework'),
							'enable_sp_review' => esc_html__('Review', 'felan-framework'),
						),
						'default' => array('enable_sp_gallery', 'enable_sp_descriptions', 'enable_sp_skills', 'enable_sp_package', 'enable_sp_location', 'enable_sp_video', 'enable_sp_faq', 'enable_sp_review')
					),
					array(
						'id' => 'service_details_sidebar_order',
						'type' => 'sortable',
						'title' => esc_html__('Service Sidebar Order', 'felan-framework'),
						'desc' => esc_html__('Drag and drop layout manager, to quickly organize your service sidebar order.', 'felan-framework'),
						'options' => array(
							'enable_sidebar_sp_package' => esc_html__('Package', 'felan-framework'),
							'enable_sidebar_sp_info' => esc_html__('Information', 'felan-framework'),
						),
						'default' => array('enable_sidebar_sp_package', 'enable_sidebar_sp_info'),
					),
				),
			);
			//Submit Service
			$option_submit_service = array(
				'id' => 'service_submit_group',
				'title' => esc_html__('Service Submit', 'felan-framework'),
				'type' => 'group',
				'fields' => array(
					array(
						'id' => 'service_auto_publish',
						'title' => esc_html__('Automatically publish the submitted Service?', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Yes', 'felan-framework'),
							'0' => esc_html__('No', 'felan-framework'),
						),
						'default' => '1',
					),

					array(
						'id' => 'service_auto_publish_edited',
						'title' => esc_html__('Automatically publish the edited Service?', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Yes', 'felan-framework'),
							'0' => esc_html__('No', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'section_service_hide_fields',
						'title' => esc_html__('Hide Submit Form Fields', 'felan-framework'),
						'type' => 'group',
						'fields' => array(
							array(
								'id' => 'hide_service_fields',
								'type' => 'checkbox_list',
								'title' => esc_html__('Hide Submit Form Fields', 'felan-framework'),
								'subtitle' => esc_html__('Choose which fields you want to hide on New Property page?', 'felan-framework'),
								'options' => array(
									'fields_service_title' => esc_html__('Title', 'felan-framework'),
									'fields_service_category' => esc_html__('Category', 'felan-framework'),
									'fields_service_language' => esc_html__('Languages', 'felan-framework'),
									'fields_service_description' => esc_html__('Description', 'felan-framework'),
									'fields_service_skills' => esc_html__('Skills', 'felan-framework'),
									'fields_service_location' => esc_html__('Location', 'felan-framework'),
									'fields_service_map' => esc_html__('Maps', 'felan-framework'),
									'fields_service_cover_image' => esc_html__('Cover image', 'felan-framework'),
									'fields_service_gallery' => esc_html__('Gallery', 'felan-framework'),
									'fields_service_video' => esc_html__('Video', 'felan-framework'),
									'fields_service_pricing' => esc_html__('Pricing', 'felan-framework'),
									'fields_service_package' => esc_html__('Package', 'felan-framework'),
									'fields_service_addons' => esc_html__('Addons', 'felan-framework'),
									'fields_service_faq' => esc_html__('Faqs', 'felan-framework'),
								),
								'value_inline' => false,
								'default' => array()
							),
						)
					),
				)
			);

			//Search Service
			$sidebar_filter = [
				'service-rating' => esc_html__('Rating', 'felan-framework'),
				'service-price' => esc_html__('Price', 'felan-framework'),
			];
			$custom_field_filter = felan_render_custom_field('service');
			foreach ($custom_field_filter as $custom_field) {
				$sidebar_filter[$custom_field['id']] = $custom_field['title'];
			}

			$option_search_service = array(
				'id' => 'service_search_group',
				'title' => esc_html__('Search Service', 'felan-framework'),
				'type' => 'group',
				'fields' => array(
					array(
						'id' => 'enable_service_search_bg',
						'type' => 'button_set',
						'title' => esc_html__('Enable Background', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Background', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'enable_service_search_location_top',
						'type' => 'button_set',
						'title' => esc_html__('Enable Search City/Town (Top)', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Search City/Town', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'enable_service_search_location_radius',
						'type' => 'button_set',
						'title' => esc_html__('Enable Search location radius', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden search location radius', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => "service_search_color",
						'title' => esc_html__('Color', 'felan-framework'),
						'type' => 'color',
						'col' => '12',
						'default' => '',
						'required' => array(
							array("enable_service_search_bg", '=', '1'),
						),
					),
					array(
						'id' => "service_search_image",
						'title' => esc_html__('Image', 'felan-framework'),
						'type' => 'image',
						'default' => '',
						'col' => '12',
						'required' => array(
							array("enable_service_search_bg", '=', '1'),
						),
					),
					array(
						'id' => 'service_search_fields',
						'title' => esc_html__('Search Fields', 'felan-framework'),
						'type' => 'sorter',
						'default' => array(
							'top' => array(
								'service-categories' => esc_html__('Categories', 'felan-framework'),
							),
							'sidebar' => $sidebar_filter,
							'disable' => array(
								'service-location' => esc_html__('Location', 'felan-framework'),
								'service-skills' => esc_html__('Skills', 'felan-framework'),
								'service-language' => esc_html__('Language', 'felan-framework'),
							)
						),
					),
					array(
						'id' => 'service_search_fields_service-categories',
						'title' => esc_html__('Icon Categories', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'service_search_fields_service-rating',
						'title' => esc_html__('Icon Rating', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'service_search_fields_service-skills',
						'title' => esc_html__('Icon Skills', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'service_search_fields_service-language',
						'title' => esc_html__('Icon Language', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'service_search_fields_location',
						'title' => esc_html__('Icon City', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'service_search_fields_state',
						'title' => esc_html__('Icon State', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'service_search_fields_country',
						'title' => esc_html__('Icon Country', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
				)
			);


			//Package Options
			$option_package_service = array(
				'id' => 'service_package_group',
				'title' => esc_html__('Package Service', 'felan-framework'),
				'type' => 'group',
				'fields' => array(
					array(
						'id' => "package_service",
						'type' => 'panel',
						'title' => esc_html__('Options', 'felan-framework'),
						'sort' => true,
						'panel_title' => 'label',
						'fields' => array(
							array(
								'id' => 'package_service_title',
								'title' => esc_html__('Service Title', 'felan-framework'),
								'type' => 'text',
								'default' => esc_html__('3D Mockup', 'felan-framework'),
							),
							array(
								'id' => "package_checkbox_list",
								'type' => 'checkbox_list',
								'title' => esc_html__('Package', 'felan-framework'),
								'options' =>  array(
									'basic' => esc_html__('Basic', 'felan-framework'),
									'standard' => esc_html__('Standard', 'felan-framework'),
									'premium' => esc_html__('Premium', 'felan-framework'),
								),
								'value_inline' => true,
								'default' => array(),
								'col' => '12',
							),
						)
					)
				)
			);

			return
				apply_filters('felan_register_service_option_listing_setting_page', array(
					'id' => 'felan_listing_service_setting_page_option',
					'title' => esc_html__('Services Option', 'felan-framework'),
					'icon' => 'dashicons-nametag',
					'fields' => array(

						array(
							'id' => 'enable_freelancer_service_fee',
							'type' => 'button_set',
							'title' => esc_html__('Enable Freelancer Service Fee', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Freelancer Service Fee', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),

						array(
							'id' => "freelancer_number_service_fee",
							'title' => esc_html__('Number Freelancer Service Fee', 'felan-framework'),
							'subtitle' => esc_html__('Enter (%) Freelancer Service Fee', 'felan-framework'),
							'type' => 'text',
							'default' => '10',
							'pattern' => '[0-9]*',
							'required' => array(
								array("enable_freelancer_service_fee", '=', '1')
							),
						),

						array(
							'id' => 'enable_edit_review_service',
							'type' => 'button_set',
							'title' => esc_html__('Enable Edit Review Service', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable  Edit Review Service', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),

						array(
							'id' => 'enable_auto_approve_pending_service',
							'type' => 'button_set',
							'title' => esc_html__('Enable Auto Approve For Service', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Auto Approve For Service', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),

						//Archive Service
						apply_filters('felan_register_option_archive_service_page_top', array()),
						apply_filters(
							'felan_register_option_archive_service_page_main',
							$option_archive_service
						),
						apply_filters('felan_register_option_archive_service_page_bottom', array()),

						//Single Service
						apply_filters('felan_register_option_single_service_page_top', array()),
						apply_filters(
							'felan_register_option_single_service_page_main',
							$option_single_service
						),
						apply_filters('felan_register_option_single_service_page_bottom', array()),

						//Service Submit
						apply_filters('felan_option_service_submit_top', array()),
						apply_filters(
							'felan_option_service_submit_main',
							$option_submit_service
						),
						apply_filters('felan_option_service_submit_bottom', array()),

						//Service Search
						apply_filters('felan_register_option_search_service_page_top', array()),
						apply_filters(
							'felan_register_option_search_service_page_main',
							$option_search_service
						),
						apply_filters('felan_register_option_search_service_page_bottom', array()),

						//Package Options
						apply_filters('felan_register_option_package_service_top', array()),
						apply_filters(
							'felan_register_option_package_service_main',
							$option_package_service
						),
						apply_filters('felan_register_option_package_service_bottom', array())
					),
				));
		}

		/**
		 * Project page option
		 * @return mixed
		 */
		private function project_option()
		{
			//Archive Project
			$option_archive_project = $option_single_project = $option_submit_project = $option_search_project = array();

			//Archive Project
			$option_archive_project = array(
				'id' => 'felan_archive_project_group',
				'type' => 'group',
				'title' => esc_html__('Archive Project', 'felan-framework'),
				'fields' => array(
					array(
						'id' => 'archive_project_layout',
						'type' => 'select',
						'title' => esc_html__('Project Layout', 'felan-framework'),
						'default' => 'layout-list',
						'options' => array(
							'layout-list' => esc_html__('Layout List', 'felan-framework'),
							'layout-grid' => esc_html__('Layout Grid', 'felan-framework'),
						)
					),
					array(
						'id' => 'archive_project_items_amount',
						'type' => 'text',
						'title' => esc_html__('Items Amount', 'felan-framework'),
						'default' => 12,
						'pattern' => '[0-9]*',
					),
					array(
						'id' => 'project_pagination_type',
						'type' => 'select',
						'title' => esc_html__('Type Pagination', 'felan-framework'),
						'default' => 'number',
						'options' => array(
							'number' => esc_html__('Number', 'felan-framework'),
							'loadmore' => esc_html__('Load More', 'felan-framework')
						)
					),
					array(
						'id' => "project_filter_sidebar_option",
						'title' => esc_html__('Postion Filter ', 'felan-framework'),
						'type' => 'select',
						'options' => array(
							'filter-left' => 'Filter Left',
							'filter-right' => 'Filter Right',
							'filter-canvas' => 'Filter Canvas',
						),
						'default' => 'left',
					),
					array(
						'id' => 'enable_project_single_popup',
						'type' => 'button_set',
						'title' => esc_html__('Show Single Popup', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Single Popup', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
						'required' => array(
							array("archive_jobs_layout", '!=', 'layout-full'),
						),
					),
					array(
						'id' => 'enable_project_filter_top',
						'type' => 'button_set',
						'title' => esc_html__('Show Top Filter', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Top Filter', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'enable_project_show_map',
						'type' => 'button_set',
						'title' => esc_html__('Show Maps', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Maps', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
						'required' => array(
							array("enable_project_single_popup", '!=', '1'),
						),
					),
					array(
						'id' => "project_map_postion",
						'title' => esc_html__('Postion Maps ', 'felan-framework'),
						'type' => 'select',
						'options' => array(
							'map-right' => 'Map Right',
							'map-top' => 'Map Top',
						),
						'default' => 'right',
						'required' => array(
							array("enable_project_show_map", '=', '1'),
							array("enable_project_single_popup", '!=', '1'),
						),
					),
					array(
						'id' => 'enable_project_show_des',
						'type' => 'button_set',
						'title' => esc_html__('Show Description', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Description', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
				),
			);

			//Single Project
			$option_single_project = array(
				'id' => 'project_single_project_group',
				'type' => 'group',
				'title' => esc_html__('Single Project', 'felan-framework'),
				'fields' => array(
					array(
						'id' => 'enable_single_project_info_left',
						'type' => 'button_set',
						'title' => esc_html__('Enable Profile Sidebar Left', 'felan-framework'),
						'subtitle' => esc_html__('Enable/Disable Profile Sidebar Left', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'enable_sticky_project_sidebar_type',
						'type' => 'button_set',
						'title' => esc_html__('Enable Sticky Sidebar', 'felan-framework'),
						'subtitle' => esc_html__('Enable/Disable sticky sidebar when scroll', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'enable_single_project_related',
						'type' => 'button_set',
						'title' => esc_html__('Enable Project Related', 'felan-framework'),
						'subtitle' => esc_html__('Enable/Disable Project Related', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'projects_details_order',
						'type' => 'sortable',
						'title' => esc_html__('Project Content Order', 'felan-framework'),
						'desc' => esc_html__('Drag and drop layout manager, to quickly organize your project content details.', 'felan-framework'),
						'options' => array(
							'enable_sp_gallery' => esc_html__('Gallery', 'felan-framework'),
							'enable_sp_descriptions' => esc_html__('Descriptions', 'felan-framework'),
							'enable_sp_skills' => esc_html__('Skills', 'felan-framework'),
							'enable_sp_location' => esc_html__('Location', 'felan-framework'),
							'enable_sp_video' => esc_html__('Video', 'felan-framework'),
							'enable_sp_faq' => esc_html__('Faq', 'felan-framework'),
						),
						'default' => array('enable_sp_gallery', 'enable_sp_descriptions', 'enable_sp_skills', 'enable_sp_package', 'enable_sp_location', 'enable_sp_video', 'enable_sp_faq', 'enable_sp_review')
					),
					array(
						'id' => 'project_details_sidebar_order',
						'type' => 'sortable',
						'title' => esc_html__('Project Sidebar Order', 'felan-framework'),
						'desc' => esc_html__('Drag and drop layout manager, to quickly organize your project sidebar order.', 'felan-framework'),
						'options' => array(
							'enable_sidebar_sp_apply' => esc_html__('Apply', 'felan-framework'),
							'enable_sidebar_sp_info' => esc_html__('Information', 'felan-framework'),
						),
						'default' => array('enable_sidebar_sp_package', 'enable_sidebar_sp_info'),
					),
				),
			);

			//Submit Project
			$option_submit_project = array(
				'id' => 'project_submit_group',
				'title' => esc_html__('Project Submit', 'felan-framework'),
				'type' => 'group',
				'fields' => array(
					array(
						'id' => 'project_auto_publish',
						'title' => esc_html__('Automatically publish the submitted Project?', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Yes', 'felan-framework'),
							'0' => esc_html__('No', 'felan-framework'),
						),
						'default' => '1',
					),

					array(
						'id' => 'project_auto_publish_edited',
						'title' => esc_html__('Automatically publish the edited Project?', 'felan-framework'),
						'type' => 'button_set',
						'options' => array(
							'1' => esc_html__('Yes', 'felan-framework'),
							'0' => esc_html__('No', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => 'section_project_hide_fields',
						'title' => esc_html__('Hide Submit Form Fields', 'felan-framework'),
						'type' => 'group',
						'fields' => array(
							array(
								'id' => 'hide_project_fields',
								'type' => 'checkbox_list',
								'title' => esc_html__('Hide Submit Form Fields', 'felan-framework'),
								'subtitle' => esc_html__('Choose which fields you want to hide on New Property page?', 'felan-framework'),
								'options' => array(
									'fields_project_title' => esc_html__('Title', 'felan-framework'),
									'fields_project_category' => esc_html__('Category', 'felan-framework'),
									'fields_project_language' => esc_html__('Languages', 'felan-framework'),
									'fields_project_career' => esc_html__('Career', 'felan-framework'),
									'fields_project_description' => esc_html__('Description', 'felan-framework'),
									'fields_project_skills' => esc_html__('Skills', 'felan-framework'),
									'fields_project_location' => esc_html__('Location', 'felan-framework'),
									'fields_project_map' => esc_html__('Maps', 'felan-framework'),
									'fields_project_cover_image' => esc_html__('Cover image', 'felan-framework'),
									'fields_project_gallery' => esc_html__('Gallery', 'felan-framework'),
									'fields_project_video' => esc_html__('Video', 'felan-framework'),
									'fields_project_budget' => esc_html__('Budget', 'felan-framework'),
									'fields_project_company' => esc_html__('Company', 'felan-framework'),
									'fields_project_faq' => esc_html__('Faqs', 'felan-framework'),
								),
								'value_inline' => false,
								'default' => array()
							),
						)
					),
				)
			);

			//Project Package Group (only when wallet mode is off and enable_post_type_project is on)
			$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');
			$option_package_project = array();

			if ($enable_wallet_mode == '0') {
				$option_package_project = array(
					'id' => 'project_package_group',
					'title' => esc_html__('Project Alert', 'felan-framework'),
					'type' => 'group',
					'fields' => array(
						array(
							'id' => 'enable_project_package_specific_settings',
							'title' => esc_html__('Enable Package-Specific Project Alert Settings', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '1',
							'required' => array('enable_project_package_alerts', '=', '1'),
							'desc' => esc_html__('If enabled, each package can have its own project alert settings. If disabled, all packages will use the global settings below.', 'felan-framework'),
						),
						array(
							'id' => 'project_package_alerts_default_limit',
							'title' => esc_html__('Default Alerts Limit', 'felan-framework'),
							'type' => 'text',
							'default' => '3',
							'pattern' => '[0-9]*',
							'required' => array(
								array('enable_project_package_alerts', '=', '1'),
								array('enable_project_package_specific_settings', '!=', '1'),
							),
							'desc' => esc_html__('Default number of alerts allowed. Used when package-specific settings are disabled.', 'felan-framework'),
						),
						array(
							'id' => 'project_package_allowed_taxonomies',
							'title' => esc_html__('Allowed Taxonomies', 'felan-framework'),
							'type' => 'checkbox_list',
							'options' => array(
								'categories' => esc_html__('Categories', 'felan-framework'),
								'skills' => esc_html__('Skills', 'felan-framework'),
								'language' => esc_html__('Languages', 'felan-framework'),
								'career' => esc_html__('Careers', 'felan-framework'),
								'location' => esc_html__('Location', 'felan-framework'),
								'state' => esc_html__('State/Province', 'felan-framework'),
							),
							'value_inline' => false,
							'default' => array('categories', 'skills', 'language', 'career', 'location'),
							'required' => array(
								array('enable_project_package_alerts', '=', '1'),
								array('enable_project_package_specific_settings', '!=', '1'),
							),
							'desc' => esc_html__('Select which taxonomies can be used in project alerts. Only applies when package-specific settings are disabled.', 'felan-framework'),
						),
						array(
							'id' => 'project_package_max_terms_per_taxonomy',
							'title' => esc_html__('Max Terms Per Taxonomy', 'felan-framework'),
							'type' => 'text',
							'default' => '10',
							'pattern' => '[0-9]*',
							'required' => array(
								array('enable_project_package_alerts', '=', '1'),
								array('enable_project_package_specific_settings', '!=', '1'),
							),
							'desc' => esc_html__('Maximum number of terms that can be selected per taxonomy in an alert. Only applies when package-specific settings are disabled.', 'felan-framework'),
						),
						array(
							'id' => 'project_alerts_email_time',
							'title' => esc_html__('Preferred Email Time', 'felan-framework'),
							'type' => 'text',
							'input_type' => 'time',
							'default' => '09:00',
							'pattern' => '^([01]?[0-9]|2[0-3]):[0-5][0-9]$',
							'required' => array('enable_project_package_alerts', '=', '1'),
							'desc' => esc_html__('Default time to send project alert emails (24-hour format, e.g., 09:00 for 9 AM). This applies to all users unless overridden by package-specific settings.', 'felan-framework'),
						),
					),
				);
			}

			//Search Project
			$sidebar_filter = [
				'project-price' => esc_html__('Price', 'felan-framework'),
				'project-language' => esc_html__('Language', 'felan-framework'),
				'project-skills' => esc_html__('Skills', 'felan-framework'),
				'felan_location' => esc_html__('Location', 'felan-framework'),
			];
			$custom_field_filter = felan_render_custom_field('project');
			foreach ($custom_field_filter as $custom_field) {
				$sidebar_filter[$custom_field['id']] = $custom_field['title'];
			}
			$option_search_project = array(
				'id' => 'project_search_group',
				'title' => esc_html__('Search Project', 'felan-framework'),
				'type' => 'group',
				'fields' => array(
					array(
						'id' => 'enable_project_search_bg',
						'type' => 'button_set',
						'title' => esc_html__('Enable Background', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Background', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'enable_project_search_location_top',
						'type' => 'button_set',
						'title' => esc_html__('Enable Search City/Town (Top)', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden Search City/Town', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '0',
					),
					array(
						'id' => 'enable_project_search_location_radius',
						'type' => 'button_set',
						'title' => esc_html__('Enable Search location radius', 'felan-framework'),
						'subtitle' => esc_html__('Show/Hidden search location radius', 'felan-framework'),
						'desc' => '',
						'options' => array(
							'1' => esc_html__('On', 'felan-framework'),
							'0' => esc_html__('Off', 'felan-framework'),
						),
						'default' => '1',
					),
					array(
						'id' => "project_search_color",
						'title' => esc_html__('Color', 'felan-framework'),
						'type' => 'color',
						'col' => '12',
						'default' => '',
						'required' => array(
							array("enable_project_search_bg", '=', '1'),
						),
					),
					array(
						'id' => "project_search_image",
						'title' => esc_html__('Image', 'felan-framework'),
						'type' => 'image',
						'default' => '',
						'col' => '12',
						'required' => array(
							array("enable_project_search_bg", '=', '1'),
						),
					),
					array(
						'id' => 'project_search_fields',
						'title' => esc_html__('Search Fields', 'felan-framework'),
						'type' => 'sorter',
						'default' => array(
							'top' => array(
								'project-categories' => esc_html__('Categories', 'felan-framework'),
							),
							'sidebar' => $sidebar_filter,
							'disable' => array()
						),
					),
					array(
						'id' => 'project_search_fields_project-categories',
						'title' => esc_html__('Icon Categories', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'project_search_fields_project-rating',
						'title' => esc_html__('Icon Rating', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'project_search_fields_project-skills',
						'title' => esc_html__('Icon Skills', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'project_search_fields_project-language',
						'title' => esc_html__('Icon Language', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'project_search_fields_location',
						'title' => esc_html__('Icon City', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'project_search_fields_state',
						'title' => esc_html__('Icon State', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
					array(
						'id' => 'project_search_fields_country',
						'title' => esc_html__('Icon Country', 'felan-framework'),
						'type' => 'text',
						'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
					),
				)
			);

			return
				apply_filters('felan_register_project_option_listing_setting_page', array(
					'id' => 'felan_listing_project_setting_page_option',
					'title' => esc_html__('Projects Option', 'felan-framework'),
					'icon' => 'dashicons-image-filter',
					'fields' => array(
						array(
							'id' => 'enable_project_package_alerts',
							'type' => 'button_set',
							'title' => esc_html__('Enable/Disable Project Alerts', 'felan-framework'),
							'subtitle' => esc_html__('Allow freelancers to create project alerts based on their package', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => 'enable_employer_project_fee',
							'type' => 'button_set',
							'title' => esc_html__('Enable Employer Project Fee', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Employer Project Fee', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),

						array(
							'id' => "employer_number_project_fee",
							'title' => esc_html__('Number Employer Project Fee', 'felan-framework'),
							'subtitle' => esc_html__('Enter (%) Employer Project Fee', 'felan-framework'),
							'type' => 'text',
							'default' => '10',
							'pattern' => '[0-9]*',
							'required' => array(
								array("enable_employer_project_fee", '=', '1')
							),
						),

						//Archive Project
						apply_filters('felan_register_option_archive_project_page_top', array()),
						apply_filters(
							'felan_register_option_archive_project_page_main',
							$option_archive_project
						),
						apply_filters('felan_register_option_archive_project_page_bottom', array()),

						//Single Project
						apply_filters('felan_register_option_single_project_page_top', array()),
						apply_filters(
							'felan_register_option_single_project_page_main',
							$option_single_project
						),
						apply_filters('felan_register_option_single_project_page_bottom', array()),

						//Project Submit
						apply_filters('felan_option_project_submit_top', array()),
						apply_filters(
							'felan_option_project_submit_main',
							$option_submit_project
						),
						apply_filters('felan_option_project_submit_bottom', array()),

						//Project Search
						apply_filters('felan_register_option_search_project_page_top', array()),
						apply_filters(
							'felan_register_option_search_project_page_main',
							$option_search_project
						),
						apply_filters('felan_register_option_search_project_page_bottom', array()),

						//Project Package
						apply_filters('felan_register_option_package_project_top', array()),
						apply_filters(
							'felan_register_option_package_project_main',
							$option_package_project
						),
						apply_filters('felan_register_option_package_project_bottom', array()),
					),
				));
		}
}
