<?php
/**
 * Felan Settings Options Trait
 * Extracted from class-felan-admin.php
 * Contains: url_slugs_option, custom_field_*_option, price_format_option, ai_helper, locations_option, google_map_option
 *
 * @package Felan_Framework
 */

if (!defined('ABSPATH')) {
    exit;
}

trait Felan_Settings_Options_Trait
{
		private function url_slugs_option()
		{
			$option_url_service_slugs = $option_url_jobs_slugs = array();
			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			$title_freelancers = esc_html__('Freelancer', 'felan-framework');
			if ($enable_post_type_jobs == '1' && $enable_post_type_service !== '1' && $enable_post_type_project !== '1') {
				$title_freelancers = esc_html__('Candidate', 'felan-framework');
			}

			if ($enable_post_type_jobs == '1') {
				$option_url_jobs_slugs = array(
					'id' => 'felan_main_group',
					'type' => 'group',
					'title' => esc_html__('Jobs', 'felan-framework'),
					'fields' => array(
						array(
							'id' => 'jobs_url_slug',
							'title' => esc_html__('Jobs Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs',
						),
						array(
							'id' => 'jobs_type_url_slug',
							'title' => esc_html__('Type Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs-type',
						),
						array(
							'id' => 'jobs_categories_url_slug',
							'title' => esc_html__('Categories Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs-categories',
						),
						array(
							'id' => 'jobs_skills_url_slug',
							'title' => esc_html__('Skills Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs-skills',
						),
						array(
							'id' => 'jobs_career_url_slug',
							'title' => esc_html__('Career Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs-career',
						),
						array(
							'id' => 'jobs_experience_url_slug',
							'title' => esc_html__('Experience Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs-experience',
						),
						array(
							'id' => 'jobs_qualification_url_slug',
							'title' => esc_html__('Qualification Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs-qualification',
						),
						array(
							'id' => 'jobs_gender_url_slug',
							'title' => esc_html__('Gender Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'jobs-gender',
						),
					),
				);
			}

			if ($enable_post_type_service == '1') {
				$option_url_service_slugs = array(
					'id' => 'felan_main_group',
					'type' => 'group',
					'title' => esc_html__('Service', 'felan-framework'),
					'fields' => array(
						array(
							'id' => 'service_url_slug',
							'title' => esc_html__('Service Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'services',
						),
						array(
							'id' => 'service_categories_url_slug',
							'title' => esc_html__('Service Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'service-categories',
						),
						array(
							'id' => 'service_skills_url_slug',
							'title' => esc_html__('Skills Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'service-skills',
						),
						array(
							'id' => 'service_language_url_slug',
							'title' => esc_html__('Language Slug', 'felan-framework'),
							'type' => 'text',
							'default' => 'service-language',
						),
					),
				);
			}
			return
				apply_filters(
					'felan_register_option_url_slugs',
					array(
						'id' => 'felan_url_slugs_option',
						'title' => esc_html__('Url Slug', 'felan-framework'),
						'icon' => 'dashicons-admin-links',
						'fields' => array(
							array(
								'id' => 'enable_slug_categories',
								'type' => 'button_set',
								'title' => esc_html__('Slug Categories', 'felan-framework'),
								'subtitle' => esc_html__('Show/Hidden Slug Categories', 'felan-framework'),
								'desc' => '',
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '1',
							),

							//Jobs
							apply_filters('felan_register_option_url_jobs_slugs_top', array()),
							apply_filters(
								'felan_register_option_url_jobs_slugs_center',
								$option_url_jobs_slugs
							),
							apply_filters('felan_register_option_url_jobs_slugs_bottom', array()),

							//Company
							apply_filters('felan_register_option_url_company_slugs_top', array()),
							apply_filters('felan_register_option_url_company_slugs_center', array(
								'id' => 'felan_main_group',
								'type' => 'group',
								'title' => esc_html__('Company', 'felan-framework'),
								'fields' => array(
									array(
										'id' => 'company_url_slug',
										'title' => esc_html__('Company Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'companies',
									),
									array(
										'id' => 'company_categories_url_slug',
										'title' => esc_html__('Categories Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'company-categories',
									),
									array(
										'id' => 'company_size_url_slug',
										'title' => esc_html__('Size Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'company-size',
									),
								),
							)),
							apply_filters('felan_register_option_url_company_slugs_bottom', array()),

							//Freelancer
							apply_filters('felan_register_option_url_freelancer_slugs_top', array()),
							apply_filters('felan_register_option_url_freelancer_slugs_center', array(
								'id' => 'felan_main_group',
								'type' => 'group',
								'title' => $title_freelancers,
								'fields' => array(
									array(
										'id' => 'freelancer_url_slug',
										'title' => $title_freelancers,
										'type' => 'text',
										'default' => 'freelancers',
									),
									array(
										'id' => 'freelancer_categories_url_slug',
										'title' => esc_html__('Categories Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer_categories',
									),
									array(
										'id' => 'freelancer_ages_url_slug',
										'title' => esc_html__('Ages Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer-ages',
									),
									array(
										'id' => 'freelancer_languages_url_slug',
										'title' => esc_html__('Languages Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer-languages',
									),
									array(
										'id' => 'freelancer_qualification_url_slug',
										'title' => esc_html__('Qualification Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer-qualification',
									),
									array(
										'id' => 'freelancer_yoe_url_slug',
										'title' => esc_html__('Yoe Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer-yoe',
									),
									array(
										'id' => 'freelancer_education_levels_url_slug',
										'title' => esc_html__('Education Levels Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer-education-levels',
									),
									array(
										'id' => 'freelancer_skills_url_slug',
										'title' => esc_html__('Skills Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer-skills',
									),
									array(
										'id' => 'freelancer_gender_url_slug',
										'title' => esc_html__('Gender Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'freelancer-gender',
									),
								),
							)),
							apply_filters('felan_register_option_url_freelancer_slugs_bottom', array()),

							//Service
							apply_filters('felan_register_option_url_service_slugs_top', array()),
							apply_filters(
								'felan_register_option_url_service_slugs_center',
								$option_url_service_slugs
							),
							apply_filters('felan_register_option_url_service_slugs_bottom', array()),

							//Other
							apply_filters('felan_register_option_url_other_slugs_top', array()),
							apply_filters('felan_register_option_url_other_slugs_center', array(
								'id' => 'felan_main_group',
								'type' => 'group',
								'title' => esc_html__('Other', 'felan-framework'),
								'fields' => array(
									array(
										'id' => 'package_url_slug',
										'title' => esc_html__('Package Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'package',
									),
									array(
										'id' => 'invoice_url_slug',
										'title' => esc_html__('Invoice Slug', 'felan-framework'),
										'type' => 'text',
										'default' => 'invoice',
									)
								),
							)),
							apply_filters('felan_register_option_url_other_slugs_bottom', array()),
						),
					)
				);
		}

		/**
		 * @return mixed|void
		 */
		private function custom_field_jobs_option()
		{
			return apply_filters('felan_register_option_custom_field_jobs', array(
				'id' => 'felan_custom_field_jobs_option',
				'title' => esc_html__('Custom Field (Jobs)', 'felan-framework'),
				'icon' => 'dashicons dashicons-admin-customizer',
				'fields' => array_merge(
					apply_filters('felan_register_option_custom_field_jobs_top', array()),
					apply_filters('felan_register_option_custom_field_jobs_main', array(
						array(
							'id' => "custom_field_jobs",
							'type' => 'panel',
							'title' => esc_html__('Additional Field', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'title' => esc_html__('Label', 'felan-framework'),
									'id' => "label",
									'type' => 'text',
									'default' => '',
								),
								array(
									'title' => esc_html__('ID', 'felan-framework'),
									'id' => "id",
									'type' => 'text',
									'placeholder' => esc_html__('Enter field ID', 'felan-framework'),
									'desc' => esc_html__('ID values cannot be changed after being set!', 'felan-framework'),
									'default' => '',
								),
								array(
									'title' => esc_html__('Field Type', 'felan-framework'),
									'id' => "field_type",
									'type' => 'select',
									'default' => 'text',
									'options' => array(
										'text' => esc_html__('Text', 'felan-framework'),
										'url' => esc_html__('Video', 'felan-framework'),
										'textarea' => esc_html__('Textarea', 'felan-framework'),
										'image' => esc_html__('Image', 'felan-framework'),
										'file' => esc_html__('Upload File', 'felan-framework'),
										'select' => esc_html__('Select', 'felan-framework'),
										'checkbox_list' => esc_html__('Checkbox', 'felan-framework'),
									)
								),
								array(
									'title' => esc_html__('Options Value', 'felan-framework'),
									'subtitle' => esc_html__('Input each per line', 'felan-framework'),
									'id' => "select_choices",
									'type' => 'textarea',
									'default' => '',
									'required' => array(
										"field_type",
										'in',
										array('checkbox_list', 'select')
									),
								),
							)
						)
					)),
					apply_filters('felan_register_option_custom_field_jobs_bottom', array())
				)
			));
		}

		private function custom_field_company_option()
		{
			return apply_filters('felan_register_option_custom_field_company', array(
				'id' => 'felan_custom_field_company_option',
				'title' => esc_html__('Custom Field (Company)', 'felan-framework'),
				'icon' => 'dashicons dashicons-admin-customizer',
				'fields' => array_merge(
					apply_filters('felan_register_option_custom_field_company_top', array()),
					apply_filters('felan_register_option_custom_field_company_main', array(
						array(
							'id' => "custom_field_company",
							'type' => 'panel',
							'title' => esc_html__('Additional Field', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'title' => esc_html__('Label', 'felan-framework'),
									'id' => "label",
									'type' => 'text',
									'default' => '',
								),
								array(
									'title' => esc_html__('ID', 'felan-framework'),
									'id' => "id",
									'type' => 'text',
									'placeholder' => esc_html__('Enter field ID', 'felan-framework'),
									'desc' => esc_html__('ID values cannot be changed after being set!', 'felan-framework'),
									'default' => '',
								),
								array(
									'title' => esc_html__('Field Type', 'felan-framework'),
									'id' => "field_type",
									'type' => 'select',
									'default' => 'text',
									'options' => array(
										'text' => esc_html__('Text', 'felan-framework'),
										'url' => esc_html__('Video', 'felan-framework'),
										'textarea' => esc_html__('Textarea', 'felan-framework'),
										'image' => esc_html__('Image', 'felan-framework'),
										'file' => esc_html__('Upload File', 'felan-framework'),
										'select' => esc_html__('Select', 'felan-framework'),
										'checkbox_list' => esc_html__('Checkbox', 'felan-framework'),
									)
								),
								array(
									'title' => esc_html__('Options Value', 'felan-framework'),
									'subtitle' => esc_html__('Input each per line', 'felan-framework'),
									'id' => "select_choices",
									'type' => 'textarea',
									'default' => '',
									'required' => array(
										"field_type",
										'in',
										array('checkbox_list', 'select')
									),
								),
							)
						)
					)),
					apply_filters('felan_register_option_custom_field_company_bottom', array())
				)
			));
		}

		private function custom_field_freelancer_option()
		{
			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			$title_freelancers = esc_html__('Custom Field (Freelancer)', 'felan-framework');
			if ($enable_post_type_jobs == '1' && $enable_post_type_service !== '1' && $enable_post_type_project !== '1') {
				$title_freelancers = esc_html__('Custom Field (Candidate)', 'felan-framework');
			}

			return apply_filters('felan_register_option_custom_field_freelancer', array(
				'id' => 'felan_custom_field_freelancer_option',
				'title' => $title_freelancers,
				'icon' => 'dashicons dashicons-admin-customizer',
				'fields' => array_merge(
					apply_filters('felan_register_option_custom_field_freelancer_top', array()),
					apply_filters('felan_register_option_custom_field_freelancer_main', array(
						array(
							'id' => "custom_field_freelancer",
							'type' => 'panel',
							'title' => esc_html__('Additional Field', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'title' => esc_html__('Tabs', 'felan-framework'),
									'id' => "tabs",
									'type' => 'select',
									'default' => 'text',
									'options' => array(
										'info' => esc_html__('Info', 'felan-framework'),
										'education' => esc_html__('Education', 'felan-framework'),
										'experience' => esc_html__('Experience', 'felan-framework'),
										'skills' => esc_html__('Skills', 'felan-framework'),
										'projects' => esc_html__('Projects', 'felan-framework'),
										'awards' => esc_html__('Awards', 'felan-framework'),
										'new' => esc_html__('New Tabs', 'felan-framework'),
									),
									'default' => 'new',
								),
								array(
									'title' => esc_html__('Name Tabs', 'felan-framework'),
									'id' => "section",
									'type' => 'text',
									'default' => '',
									'required' => array(
										array("tabs", '=', 'new')
									),
								),
								array(
									'title' => esc_html__('Label', 'felan-framework'),
									'id' => "label",
									'type' => 'text',
									'default' => '',
								),
								array(
									'title' => esc_html__('ID', 'felan-framework'),
									'id' => "id",
									'type' => 'text',
									'placeholder' => esc_html__('Enter field ID', 'felan-framework'),
									'desc' => esc_html__('ID values cannot be changed after being set!', 'felan-framework'),
									'default' => '',
								),
								array(
									'title' => esc_html__('Field Type', 'felan-framework'),
									'id' => "field_type",
									'type' => 'select',
									'default' => 'text',
									'options' => array(
										'text' => esc_html__('Text', 'felan-framework'),
										'url' => esc_html__('Video', 'felan-framework'),
										'textarea' => esc_html__('Textarea', 'felan-framework'),
										'image' => esc_html__('Image', 'felan-framework'),
										'file' => esc_html__('Upload File', 'felan-framework'),
										'select' => esc_html__('Select', 'felan-framework'),
										'checkbox_list' => esc_html__('Checkbox', 'felan-framework'),
									)
								),
								array(
									'title' => esc_html__('Options Value', 'felan-framework'),
									'subtitle' => esc_html__('Input each per line', 'felan-framework'),
									'id' => "select_choices",
									'type' => 'textarea',
									'default' => '',
									'required' => array(
										"field_type",
										'in',
										array('checkbox_list', 'select')
									),
								),
							)
						)
					)),
					apply_filters('felan_register_option_custom_field_freelancer_bottom', array())
				)
			));
		}

		private function custom_field_project_option()
		{
			return apply_filters('felan_register_option_custom_field_project', array(
				'id' => 'felan_custom_field_project_option',
				'title' => esc_html__('Custom Field (Project)', 'felan-framework'),
				'icon' => 'dashicons dashicons-admin-customizer',
				'fields' => array_merge(
					apply_filters('felan_register_option_custom_field_project_top', array()),
					apply_filters('felan_register_option_custom_field_project_main', array(
						array(
							'id' => "custom_field_project",
							'type' => 'panel',
							'title' => esc_html__('Additional Field', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'title' => esc_html__('Label', 'felan-framework'),
									'id' => "label",
									'type' => 'text',
									'default' => '',
								),
								array(
									'title' => esc_html__('ID', 'felan-framework'),
									'id' => "id",
									'type' => 'text',
									'placeholder' => esc_html__('Enter field ID', 'felan-framework'),
									'desc' => esc_html__('ID values cannot be changed after being set!', 'felan-framework'),
									'default' => '',
								),
								array(
									'title' => esc_html__('Field Type', 'felan-framework'),
									'id' => "field_type",
									'type' => 'select',
									'default' => 'text',
									'options' => array(
										'text' => esc_html__('Text', 'felan-framework'),
										'url' => esc_html__('Video', 'felan-framework'),
										'textarea' => esc_html__('Textarea', 'felan-framework'),
										'image' => esc_html__('Image', 'felan-framework'),
										'file' => esc_html__('Upload File', 'felan-framework'),
										'select' => esc_html__('Select', 'felan-framework'),
										'checkbox_list' => esc_html__('Checkbox', 'felan-framework'),
									)
								),
								array(
									'title' => esc_html__('Options Value', 'felan-framework'),
									'subtitle' => esc_html__('Input each per line', 'felan-framework'),
									'id' => "select_choices",
									'type' => 'textarea',
									'default' => '',
									'required' => array(
										"field_type",
										'in',
										array('checkbox_list', 'select')
									),
								),
							)
						)
					)),
					apply_filters('felan_register_option_custom_field_project_bottom', array())
				)
			));
		}
		private function custom_field_service_option()
		{
			return apply_filters('felan_register_option_custom_field_service', array(
				'id' => 'felan_custom_field_service_option',
				'title' => esc_html__('Custom Field (Service)', 'felan-framework'),
				'icon' => 'dashicons dashicons-admin-customizer',
				'fields' => array_merge(
					apply_filters('felan_register_option_custom_field_service_top', array()),
					apply_filters('felan_register_option_custom_field_service_main', array(
						array(
							'id' => "custom_field_service",
							'type' => 'panel',
							'title' => esc_html__('Additional Field', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'title' => esc_html__('Label', 'felan-framework'),
									'id' => "label",
									'type' => 'text',
									'default' => '',
								),
								array(
									'title' => esc_html__('ID', 'felan-framework'),
									'id' => "id",
									'type' => 'text',
									'placeholder' => esc_html__('Enter field ID', 'felan-framework'),
									'desc' => esc_html__('ID values cannot be changed after being set!', 'felan-framework'),
									'default' => '',
								),
								array(
									'title' => esc_html__('Field Type', 'felan-framework'),
									'id' => "field_type",
									'type' => 'select',
									'default' => 'text',
									'options' => array(
										'text' => esc_html__('Text', 'felan-framework'),
										'url' => esc_html__('Video', 'felan-framework'),
										'textarea' => esc_html__('Textarea', 'felan-framework'),
										'image' => esc_html__('Image', 'felan-framework'),
										'file' => esc_html__('Upload File', 'felan-framework'),
										'select' => esc_html__('Select', 'felan-framework'),
										'checkbox_list' => esc_html__('Checkbox', 'felan-framework'),
									)
								),
								array(
									'title' => esc_html__('Options Value', 'felan-framework'),
									'subtitle' => esc_html__('Input each per line', 'felan-framework'),
									'id' => "select_choices",
									'type' => 'textarea',
									'default' => '',
									'required' => array(
										"field_type",
										'in',
										array('checkbox_list', 'select')
									),
								),
							)
						)
					)),
					apply_filters('felan_register_option_custom_field_service_bottom', array())
				)
			));
		}

		function additional_details_field($meta_prefix)
		{
			if (!class_exists('Felan_Framework')) {
				return array(
					'id' => "{$meta_prefix}additional_features",
					'title' => esc_html__('Additional details:', 'felan-framework'),
					'type' => 'custom',
					'default' => array(),
					'template' => FELAN_PLUGIN_DIR . '/includes/admin/templates/additional-details-field.php',
				);
			}
			return array(
				'id' => "{$meta_prefix}additional_features",
				'type' => 'repeater',
				'title' => esc_html__('Additional details:', 'felan-framework'),
				'col' => '6',
				'sort' => true,
				'fields' => array(
					array(
						'id' => "{$meta_prefix}additional_feature_title",
						'title' => esc_html__('Title:', 'felan-framework'),
						'desc' => esc_html__('Enter additional title', 'felan-framework'),
						'type' => 'text',
						'default' => '',
						'col' => '5',
					),
					array(
						'id' => "{$meta_prefix}additional_feature_value",
						'title' => esc_html__('Value', 'felan-framework'),
						'desc' => esc_html__('Enter additional value', 'felan-framework'),
						'type' => 'text',
						'default' => '',
						'col' => '7',
					),
				)
			);
		}

		/**
		 * @return mixed|void
		 */
		private function price_format_option()
		{
			return apply_filters('felan_register_option_price_format', array(
				'id' => 'felan_price_format_option',
				'title' => esc_html__('Currency Option', 'felan-framework'),
				'icon' => 'dashicons-money',
				'fields' => array_merge(
					apply_filters('felan_register_option_price_format_top', array()),
					apply_filters('felan_register_option_price_format_main', array(
						array(
							'id' => 'currency_position',
							'title' => esc_html__('Currency Sign Position', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'before' => esc_html__('Before ($59)', 'felan-framework'),
								'after' => esc_html__('After (59$)', 'felan-framework'),
							),
							'default' => 'before',
						),
						array(
							'id' => 'thousand_separator',
							'title' => esc_html__('Thousand Separator', 'felan-framework'),
							'type' => 'text',
							'default' => ',',
						),
						array(
							'id' => 'decimal_separator',
							'title' => esc_html__('Decimal Separator', 'felan-framework'),
							'type' => 'text',
							'default' => '.',
						),
						array(
							'id' => 'currency_type_default',
							'title' => esc_html__('Currency Type (Default)', 'felan-framework'),
							'type' => 'text',
							'default' => 'USD',
						),
						array(
							'id' => 'currency_sign_default',
							'title' => esc_html__('Currency Sign (Default)', 'felan-framework'),
							'type' => 'text',
							'default' => '$',
						),
						array(
							'id' => "currency_fields",
							'type' => 'panel',
							'title' => esc_html__('Currency Field', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'id' => 'currency_type',
									'title' => esc_html__('Currency Type', 'felan-framework'),
									'type' => 'text',
									'default' => 'VND',
								),
								array(
									'id' => 'currency_sign',
									'title' => esc_html__('Currency Sign', 'felan-framework'),
									'type' => 'text',
									'default' => 'đ',
								),
								array(
									'id' => 'currency_conversion',
									'title' => esc_html__('Currency Conversion', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Convert currency values ​​based on default currency', 'felan-framework'),
									'default' => '',
								),
							)
						)
					)),
					apply_filters('felan_register_option_price_format_bottom', array())
				)
			));
		}

		/**
		 * @return mixed|void
		 */
		private function ai_helper()
		{
			return apply_filters('felan_register_option_ai_helper', array(
				'id' => 'felan_ai_helper',
				'title' => esc_html__('AI Helper', 'felan-framework'),
				'icon' => 'dashicons-smiley',
				'fields' => array_merge(
					apply_filters('felan_register_option_ai_helper_top', array()),
					apply_filters('felan_register_option_ai_helper_main', array(
						array(
							'id' => 'enable_ai_helper',
							'type' => 'button_set',
							'title' => esc_html__('Show AI Helper', 'felan-framework'),
							'subtitle' => esc_html__('Show/Hidden AI Helper in Post Job. Automatically generate your job descriptions with ChatGPT.', 'felan-framework'),
							'desc' => '',
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'ai_type',
							'title' => esc_html__('AI Type', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'open_ai' => esc_html__('OpenAI', 'felan-framework'),
								'deep_seek' => esc_html__('DeepSeek', 'felan-framework'),
								'grok' => esc_html__('Grok', 'felan-framework'),
							),
							'default' => 'open_ai',
						),
						array(
							'id' => 'ai_key',
							'title' => esc_html__('OpenAI API Key', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'required' => array("ai_type", '=', 'open_ai'),
						),
						array(
							'id' => 'ai_model',
							'title' => esc_html__('Model', 'felan-framework'),
							'type' => 'select',
							'options' => model_ai_helper(),
							'default' => 'gpt-3.5-turbo',
							'required' => array("ai_type", '=', 'open_ai'),
						),
						array(
							'id' => 'ai_deepseek_key',
							'title' => esc_html__('DeepSeek API Key', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'required' => array("ai_type", '=', 'deep_seek'),
						),
						array(
							'id' => 'ai_deepseek_model',
							'title' => esc_html__('Model', 'felan-framework'),
							'type' => 'select',
							'options' => [
								'deepseek-chat' => 'deepseek-chat',
								'deepseek-reasoner' => 'deepseek-reasoner'
							],
							'default' => 'deepseek-chat',
							'required' => array("ai_type", '=', 'deep_seek'),
						),
						array(
							'id' => 'ai_grok_key',
							'title' => esc_html__('Grok API Key', 'felan-framework'),
							'type' => 'text',
							'default' => '',
							'required' => array("ai_type", '=', 'grok'),
						),
						array(
							'id' => 'ai_grok_model',
							'title' => esc_html__('Model', 'felan-framework'),
							'type' => 'select',
							'options' => [
								'grok-2-latest' => 'grok-2-latest',
							],
							'default' => 'grok-2-latest',
							'required' => array("ai_type", '=', 'grok'),
						),
						array(
							'id' => 'ai_temperature',
							'title' => esc_html__('Temperature', 'felan-framework'),
							'type' => 'text',
							'desc' => esc_html__('The "temperature" parameter is used to control the randomness of the generated text. A higher temperature value, such as 1.0, increases the randomness and diversity of the output, while a lower value, such as 0.2, makes the output more focused and deterministic.', 'felan-framework'),
							'default' => '0.7',
						),
						array(
							'id' => 'ai_tone',
							'title' => esc_html__('Tone', 'felan-framework'),
							'type' => 'select',
							'options' => tone_ai_helper(),
						),
						array(
							'id' => 'ai_language',
							'title' => esc_html__('Language', 'felan-framework'),
							'type' => 'select',
							'options' => language_ai_helper(),
						),
					)),
					apply_filters('felan_register_option_ai_helper_bottom', array())
				)
			));
		}

		/**
		 * @return mixed|void
		 */
		private function locations_option()
		{
			return apply_filters('felan_register_option_locations', array(
				'id' => 'felan_locations_option',
				'title' => esc_html__('Locations Option', 'felan-framework'),
				'icon' => 'dashicons-location-alt',
				'fields' => array_merge(
					apply_filters('felan_register_option_locations_top', array()),
					apply_filters('felan_register_option_locations_main', array(
						array(
							'id' => "enable_option_state",
							'type' => 'button_set',
							'title' => esc_html__('Enable State', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable State', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => "enable_option_country",
							'type' => 'button_set',
							'title' => esc_html__('Enable Country', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Country', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '0',
							'required' => array("enable_option_state", '=', '1'),
						),
						array(
							'id' => "select_option_country",
							'title' => esc_html__('Country', 'felan-framework'),
							'subtitle' => esc_html__('Select countries to enable. Leave empty to enable all countries.', 'felan-framework'),
							'type' => 'selectize',
							'options' => felan_get_countries(),
							'multiple' => true,
							'placeholder' => esc_html__('Type to search countries...', 'felan-framework'),
							'default' => array(),
							'required' => array(
								array('enable_option_state', '=', '1'),
								array('enable_option_country', '=', '1')
							),
						),
					)),
					apply_filters('felan_register_option_locations_bottom', array())
				)
			));
		}

		/**
		 * @return mixed|void
		 */
		private function google_map_option()
		{
			return apply_filters('felan_register_option_google_map', array(
				'id' => 'felan_google_map_option',
				'title' => esc_html__('Maps Option', 'felan-framework'),
				'icon' => 'dashicons-admin-site',
				'fields' => array_merge(
					apply_filters('felan_register_option_google_map_top', array()),
					apply_filters('felan_register_option_google_map_main', array(
						array(
							'id' => 'map_effects',
							'title' => esc_html__('Maps Effects', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'' => esc_html__('None', 'felan-framework'),
								'shine' => esc_html__('Shine', 'felan-framework'),
								'popup' => esc_html__('Popup', 'felan-framework'),
							),
							'default' => 'shine',
						),
						array(
							'id' => 'map_type',
							'title' => esc_html__('Maps Type', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'google_map' => esc_html__('Google Map', 'felan-framework'),
								'mapbox' => esc_html__('Mapbox', 'felan-framework'),
								'openstreetmap' => esc_html__('OpenStreetMap', 'felan-framework'),
							),
							'default' => 'mapbox',
						),
						array(
							'id' => 'map_ssl',
							'title' => esc_html__('Maps SSL', 'felan-framework'),
							'subtitle' => esc_html__('Use maps with ssl', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
						),
						array(
							'id' => 'googlemap_type',
							'title' => esc_html__('Google Maps Type', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'roadmap' => esc_html__('Roadmap', 'felan-framework'),
								'satellite' => esc_html__('Satellite', 'felan-framework'),
								'hybrid' => esc_html__('Hybrid', 'felan-framework'),
								'terrain' => esc_html__('Terrain', 'felan-framework'),
							),
							'default' => 'roadmap',
							'required' => array("map_type", '=', 'google_map'),
						),
						array(
							'id' => 'googlemap_api_key',
							'type' => 'text',
							'title' => esc_html__('Google Maps API KEY', 'felan-framework'),
							'subtitle' => esc_html__('Enter your google maps api key', 'felan-framework'),
							'default' => '',
							'required' => array("map_type", '=', 'google_map'),
						),
						array(
							'id' => 'mapbox_api_key',
							'type' => 'text',
							'title' => esc_html__('Mapbox API KEY', 'felan-framework'),
							'subtitle' => esc_html__('Enter your mapbox api key', 'felan-framework'),
							'default' => 'pk.eyJ1Ijoic2F5aTc3NDciLCJhIjoiY2tpcXRmYW1tMWpjMjJzbGllbThieTFlaCJ9.eDj6zNLBZpG-veFqXiyVPw',
							'required' => array("map_type", '=', 'mapbox'),
						),
						array(
							'id' => 'openstreetmap_api_key',
							'type' => 'text',
							'title' => esc_html__('OpenStreetMap API KEY', 'felan-framework'),
							'subtitle' => esc_html__('Enter your OpenStreetMap api key', 'felan-framework'),
							'default' => 'pk.eyJ1Ijoic2F5aTc3NDciLCJhIjoiY2tpcXRmYW1tMWpjMjJzbGllbThieTFlaCJ9.eDj6zNLBZpG-veFqXiyVPw',
							'required' => array("map_type", '=', 'openstreetmap'),
						),
						array(
							'id' => 'map_pin_cluster',
							'title' => esc_html__('Pin Cluster', 'felan-framework'),
							'subtitle' => esc_html__('Use pin cluster on map', 'felan-framework'),
							'type' => 'button_set',
							'options' => array(
								'1' => esc_html__('Yes', 'felan-framework'),
								'0' => esc_html__('No', 'felan-framework'),
							),
							'default' => '0',
							'required' => array("map_type", '=', 'google_map'),
						),
						array(
							'id' => 'googlemap_style',
							'type' => 'ace_editor',
							'title' => esc_html__('Style for Google Map', 'felan-framework'),
							'subtitle' => sprintf(
								__('Use %s https://snazzymaps.com/ %s to create styles', 'felan-framework'),
								'<a href="https://snazzymaps.com/" target="_blank">',
								'</a>'
							),
							'default' => '',
							'required' => array("map_type", '=', 'google_map'),
						),
						array(
							'id' => 'mapbox_style',
							'title' => esc_html__('Style for Mapbox', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'streets-v11' => esc_html__('Streets', 'felan-framework'),
								'light-v10' => esc_html__('Light', 'felan-framework'),
								'dark-v10' => esc_html__('Dark', 'felan-framework'),
								'outdoors-v11' => esc_html__('Outdoors', 'felan-framework'),
								'satellite-v9' => esc_html__('Satellite', 'felan-framework'),
							),
							'required' => array("map_type", '=', 'mapbox'),
						),
						array(
							'id' => 'openstreetmap_style',
							'title' => esc_html__('Style for OpenStreetMap', 'felan-framework'),
							'type' => 'select',
							'options' => array(
								'streets-v11' => esc_html__('Streets', 'felan-framework'),
								'light-v10' => esc_html__('Light', 'felan-framework'),
								'dark-v10' => esc_html__('Dark', 'felan-framework'),
								'outdoors-v11' => esc_html__('Outdoors', 'felan-framework'),
								'satellite-v9' => esc_html__('Satellite', 'felan-framework'),
							),
							'required' => array("map_type", '=', 'openstreetmap'),
						),
						array(
							'id' => 'map_zoom_level',
							'type' => 'text',
							'title' => esc_html__('Default Map Zoom', 'felan-framework'),
							'default' => '3'
						),
						array(
							'id' => 'map_lat_default',
							'type' => 'text',
							'title' => esc_html__('Default Map Latitude', 'felan-framework'),
							'default' => '59.325'
						),
						array(
							'id' => 'map_lng_default',
							'type' => 'text',
							'title' => esc_html__('Default Map Longitude ', 'felan-framework'),
							'default' => '18.070'
						),
					)),
					apply_filters('felan_register_option_google_map_bottom', array())
				)
			));
		}
}
