<?php
/**
 * Felan User Options Trait
 * Extracted from class-felan-admin.php
 * Contains: login_option, social_network, user_option
 *
 * @package Felan_Framework
 */

if (!defined('ABSPATH')) {
    exit;
}

trait Felan_User_Options_Trait
{
		private function login_option()
		{
			return apply_filters('felan_register_option_login', array(
				'id' => 'felan_login_option',
				'title' => esc_html__('Login/Register', 'felan-framework'),
				'icon' => 'dashicons-admin-users',
				'fields' => array(

					//General Login
					apply_filters('felan_register_option_genera_login_page_top', array()),
					apply_filters('felan_register_option_genera_login_page_main', array(
						'id' => 'felan_login_general_group',
						'type' => 'group',
						'title' => esc_html__('General Option', 'felan-framework'),
						'fields' => array(
							array(
								'id' => 'enable_user_name_after_login',
								'type' => 'button_set',
								'title' => esc_html__('Enable User Name After Login', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable User Name After Login', 'felan-framework'),
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '1'
							),
							array(
								'id' => 'enable_redirect_after_login',
								'type' => 'button_set',
								'title' => esc_html__('Enable Redirect After Login', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable Redirect After Login', 'felan-framework'),
								'desc' => '',
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '0'
							),
							array(
								'id' => 'redirect_for_admin',
								'title' => esc_html__('Redirect For Admin', 'felan-framework'),
								'subtitle' => esc_html__('Select redirect page after admin login.', 'felan-framework'),
								'type' => 'selectize',
								'data' => 'page',
								'allow_clear' => true,
								'data_args' => array(
									'numberposts' => -1,
								),
								'required' => array('enable_redirect_after_login', '!=', '0'),
							),
							array(
								'id' => 'redirect_for_freelancer',
								'title' => esc_html__('Redirect For Freelancer', 'felan-framework'),
								'subtitle' => esc_html__('Select redirect page after freelancer login.', 'felan-framework'),
								'type' => 'selectize',
								'data' => 'page',
								'allow_clear' => true,
								'data_args' => array(
									'numberposts' => -1,
								),
								'required' => array('enable_redirect_after_login', '!=', '0'),
							),
							array(
								'id' => 'redirect_for_employer',
								'title' => esc_html__('Redirect For Employer', 'felan-framework'),
								'subtitle' => esc_html__('Select redirect page after employer login.', 'felan-framework'),
								'type' => 'selectize',
								'data' => 'page',
								'allow_clear' => true,
								'data_args' => array(
									'numberposts' => -1,
								),
								'required' => array('enable_redirect_after_login', '!=', '0'),
							),
							array(
								'id' => 'enable_user_role',
								'type' => 'button_set',
								'title' => esc_html__('Enable User Role', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable User Role In Form Register', 'felan-framework'),
								'desc' => '',
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '1'
							),
							array(
								'id' => 'enable_default_user_role',
								'type' => 'button_set',
								'title' => esc_html__('Enable Default User Role', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable Default User Role', 'felan-framework'),
								'desc' => '',
								'options' => array(
									'freelancer' => esc_html__('Freelancer', 'felan-framework'),
									'employer' => esc_html__('Employer', 'felan-framework'),
								),
								'default' => 'freelancer',
							),
						),
					)),
					apply_filters('felan_register_option_genera_login_page_bottom', array()),

					//Verify Login
					apply_filters('felan_register_option_verify_login_page_top', array()),
					apply_filters('felan_register_option_verify_login_page_main', array(
						'id' => 'felan_login_verify_group',
						'type' => 'group',
						'title' => esc_html__('Verify Option', 'felan-framework'),
						'fields' => array(
							array(
								'id' => 'enable_status_user',
								'type' => 'button_set',
								'title' => esc_html__('Enable Verify Your Account Information', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable Verify Your Account Information (Status) After Register', 'felan-framework'),
								'desc' => '',
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '0'
							),
							array(
								'id' => 'enable_recaptcha',
								'type' => 'button_set',
								'title' => esc_html__('Enable Google reCAPTCHA v3', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable Google reCAPTCHA v3 Protection', 'felan-framework'),
								'desc' => esc_html__('Protects login and registration forms from spam and bots. Make sure to configure Site Key and Secret Key below.', 'felan-framework'),
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '0'
							),
							array(
								'id' => 'recaptcha_site_key',
								'title' => esc_html__('Google reCAPTCHA Site Key', 'felan-framework'),
								'subtitle' => esc_html__('Enter your Google reCAPTCHA v3 Site Key', 'felan-framework'),
								'desc' => esc_html__('Get your keys from https://www.google.com/recaptcha/admin/create', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'required' => array("enable_recaptcha", '=', '1'),
							),
							array(
								'id' => 'recaptcha_secret_key',
								'title' => esc_html__('Google reCAPTCHA Secret Key', 'felan-framework'),
								'subtitle' => esc_html__('Enter your Google reCAPTCHA v3 Secret Key', 'felan-framework'),
								'desc' => esc_html__('Get your keys from https://www.google.com/recaptcha/admin/create', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'required' => array("enable_recaptcha", '=', '1'),
							),
							array(
								'id' => 'recaptcha_threshold',
								'title' => esc_html__('reCAPTCHA Score Threshold', 'felan-framework'),
								'subtitle' => esc_html__('Minimum score to pass reCAPTCHA', 'felan-framework'),
								'desc' => esc_html__('Lower values = more restrictive, Higher values = less restrictive', 'felan-framework'),
								'default' => '0.5',
								'type' => 'select',
								'options' => array(
									'0.1' => esc_html__('0.1 - Very Restrictive (likely bot)', 'felan-framework'),
									'0.2' => esc_html__('0.2 - Highly Restrictive', 'felan-framework'),
									'0.3' => esc_html__('0.3 - More Restrictive', 'felan-framework'),
									'0.4' => esc_html__('0.4 - Moderately Restrictive', 'felan-framework'),
									'0.5' => esc_html__('0.5 - Balanced (Recommended)', 'felan-framework'),
									'0.6' => esc_html__('0.6 - Moderately Permissive', 'felan-framework'),
									'0.7' => esc_html__('0.7 - Less Restrictive', 'felan-framework'),
									'0.8' => esc_html__('0.8 - Highly Permissive', 'felan-framework'),
									'0.9' => esc_html__('0.9 - Very Permissive (likely human)', 'felan-framework'),
								),
								'required' => array("enable_recaptcha", '=', '1'),
							),
							array(
								'id' => 'recaptcha_hide_badge',
								'title' => esc_html__('Hide reCAPTCHA v3 Badge', 'felan-framework'),
								'subtitle' => esc_html__('Hide the reCAPTCHA badge from the page', 'felan-framework'),
								'desc' => esc_html__('If hidden, you must add a privacy notice to your site', 'felan-framework'),
								'type' => 'button_set',
								'options' => array(
									'0' => esc_html__('Show', 'felan-framework'),
									'1' => esc_html__('Hide', 'felan-framework'),
								),
								'default' => '0',
								'required' => array("enable_recaptcha", '=', '1'),
							),
							array(
								'id' => 'enable_verify_user',
								'type' => 'button_set',
								'title' => esc_html__('Enable Email Verification', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable Email Verification After Register', 'felan-framework'),
								'desc' => '',
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '0'
							),
							array(
								'id' => "verify_user_time",
								'title' => esc_html__('Verification Expiration Time', 'felan-framework'),
								'subtitle' => esc_html__('Enter the expiration time of the verification code (second)', 'felan-framework'),
								'default' => '900',
								'type' => 'text',
								'required' => array("enable_verify_user", '!=', '0'),
							),
						),
					)),
					apply_filters('felan_register_option_verify_login_page_bottom', array()),

					//Social Login
					apply_filters('felan_register_option_social_login_page_top', array()),
					apply_filters('felan_register_option_social_login_page_main', array(
						'id' => 'felan_login_social_group',
						'type' => 'group',
						'title' => esc_html__('Social Option', 'felan-framework'),
						'fields' => array(
							array(
								'id' => 'enable_social_login',
								'type' => 'button_set',
								'title' => esc_html__('Enable Social Login', 'felan-framework'),
								'subtitle' => esc_html__('Enable/Disable Social Login', 'felan-framework'),
								'desc' => '',
								'options' => array(
									'1' => esc_html__('On', 'felan-framework'),
									'0' => esc_html__('Off', 'felan-framework'),
								),
								'default' => '1'
							),
							array(
								'id' => "shortcode_social_login",
								'title' => esc_html__('Shortcode Social Login', 'felan-framework'),
								'subtitle' => esc_html__('Enter shortcode for social login', 'felan-framework'),
								'desc' => esc_html__('Example: [social_login] or your custom shortcode', 'felan-framework'),
								'default' => '',
								'type' => 'text',
								'required' => array("enable_social_login", '!=', '0'),
							),
						),
					)),
					apply_filters('felan_register_option_social_login_page_bottom', array()),
				)
			));
		}

		/**
		 * Social network
		 * @return mixed
		 */
		private function social_network()
		{
			return apply_filters('felan_register_social_option', array(
				'id' => 'felan_social_option',
				'title' => esc_html__('Social Network', 'felan-framework'),
				'icon' => 'dashicons dashicons-networking',
				'fields' => array_merge(
					apply_filters('felan_register_social_option_top', array()),
					array(
						array(
							'id' => "enable_social_twitter",
							'type' => 'button_set',
							'title' => esc_html__('Enable Twitter', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Twitter', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "enable_social_linkedin",
							'type' => 'button_set',
							'title' => esc_html__('Enable Linkedin', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Linkedin', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "enable_social_facebook",
							'type' => 'button_set',
							'title' => esc_html__('Enable Facebook', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Facebook', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "enable_social_instagram",
							'type' => 'button_set',
							'title' => esc_html__('Enable Instagram', 'felan-framework'),
							'subtitle' => esc_html__('Enable/Disable Instagram', 'felan-framework'),
							'options' => array(
								'1' => esc_html__('On', 'felan-framework'),
								'0' => esc_html__('Off', 'felan-framework'),
							),
							'default' => '1',
						),
						array(
							'id' => "felan_social_fields",
							'type' => 'panel',
							'title' => esc_html__('Social Field', 'felan-framework'),
							'sort' => true,
							'panel_title' => 'label',
							'fields' => array(
								array(
									'id' => 'social_name',
									'title' => esc_html__('Social Name', 'felan-framework'),
									'type' => 'text',
								),
								array(
									'id' => 'social_icon',
									'title' => esc_html__('Social Icon', 'felan-framework'),
									'type' => 'text',
									'desc' => esc_html__('Please enter the html code of the "fontawesome" icon to display it', 'felan-framework'),
								),
							)
						)
					),
					apply_filters('felan_register_social_option_bottom', array())
				),
			));
		}

		/**
		 * @return mixed|void
		 */
		private function user_option()
		{
			$user_navigation_employer_show_servive = $user_navigation_employer_image_service = $user_navigation_freelancer_image_service = $user_navigation_freelancer_show_servive
				= $user_navigation_employer_show_meetings = $user_navigation_employer_image_meetings = $user_navigation_freelancer_show_meetings = $user_navigation_freelancer_image_meetings
				= $user_navigation_employer_show_jobs = $user_navigation_employer_image_jobs = $user_navigation_freelancer_show_jobs = $user_navigation_freelancer_image_jobs
				= $user_navigation_employer_show_project = $user_navigation_employer_image_project = $user_navigation_freelancer_show_project = $user_navigation_freelancer_image_project
				= $user_navigation_employer_show_disputes = $user_navigation_employer_image_disputes = $user_navigation_freelancer_show_disputes = $user_navigation_freelancer_image_disputes
				= $user_navigation_employer_show_user_package = $user_navigation_employer_image_user_package = $user_navigation_freelancer_show_user_package = $user_navigation_freelancer_image_user_package
				= $user_navigation_freelancer_show_user_package = $user_navigation_freelancer_show_user_package = $user_navigation_employer_show_wallet = $user_navigation_employer_image_wallet = array();

			//Jobs
			$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
			if ($enable_post_type_jobs == '1') {
				$user_navigation_employer_show_jobs = array(
					'id' => 'show_employer_jobs_dashboard',
					'type' => 'button_set',
					'title' => esc_html__('Show "Jobs"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Jobs" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_employer_image_jobs =  array(
					'id' => 'image_employer_jobs_dashboard',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Jobs', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for jobs', 'felan-framework'),
					'required' => array('show_employer_jobs_dashboard', '!=', '0'),
				);

				$user_navigation_freelancer_show_jobs = array(
					'id' => 'show_my_jobs',
					'type' => 'button_set',
					'title' => esc_html__('Show "My Jobs"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "My Jobs" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_freelancer_image_jobs = array(
					'id' => 'image_my_jobs',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon My Jobs', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for My Jobs', 'felan-framework'),
					'required' => array('show_my_jobs', '!=', '0'),
				);

				$user_navigation_employer_show_meetings = array(
					'id' => 'show_employer_meetings',
					'type' => 'button_set',
					'title' => esc_html__('Show "Meetings"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Meetings" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_employer_image_meetings = array(
					'id' => 'image_employer_meetings',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Meetings', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for meetings', 'felan-framework'),
					'required' => array('show_employer_meetings', '!=', '0'),
				);

				$user_navigation_freelancer_show_meetings = array(
					'id' => 'show_freelancer_meetings',
					'type' => 'button_set',
					'title' => esc_html__('Show "Meetings"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Meetings" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_freelancer_image_meetings = array(
					'id' => 'image_freelancer_meetings',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Meetings', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for meetings', 'felan-framework'),
					'required' => array('show_freelancer_meetings', '!=', '0'),
				);
			}

			//Service
			$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
			if ($enable_post_type_service == '1') {
				$user_navigation_employer_show_servive = array(
					'id' => 'show_employer_employer_service',
					'type' => 'button_set',
					'title' => esc_html__('Show "Services"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Services" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_employer_image_service = array(
					'id' => 'image_employer_employer_service',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Services', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for services', 'felan-framework'),
					'required' => array('show_employer_employer_service', '!=', '0'),
				);

				$user_navigation_freelancer_show_servive = array(
					'id' => 'show_freelancer_service',
					'type' => 'button_set',
					'title' => esc_html__('Show "My Service"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "My Service" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_freelancer_image_service = array(
					'id' => 'image_freelancer_service',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon My Service', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for My Service', 'felan-framework'),
					'required' => array('show_freelancer_service', '!=', '0'),
				);
			}

			//Project
			$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
			if ($enable_post_type_project == '1') {
				$user_navigation_employer_show_project = array(
					'id' => 'show_employer_projects',
					'type' => 'button_set',
					'title' => esc_html__('Show "Projects"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide projects"', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_employer_image_project = array(
					'id' => 'image_employer_projects',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Projects', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for jobs', 'felan-framework'),
					'required' => array('show_employer_projects', '!=', '0'),
				);

				$user_navigation_employer_show_proposal = array(
					'id' => 'show_employer_proposal',
					'type' => 'button_set',
					'title' => esc_html__('Show Proposal', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide Proposal on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_employer_image_proposal = array(
					'id' => 'image_employer_proposal',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Proposal', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for proposal', 'felan-framework'),
					'required' => array('show_employer_proposal', '!=', '0'),
				);
				$user_navigation_freelancer_show_project = array(
					'id' => 'show_my_project',
					'type' => 'button_set',
					'title' => esc_html__('Show "My Project"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "My Project" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_freelancer_image_project = array(
					'id' => 'image_my_project',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon My Project', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for My Project', 'felan-framework'),
					'required' => array('show_my_project', '!=', '0'),
				);
			} else {
				// Initialize variables as empty arrays when project post type is disabled
				$user_navigation_employer_show_project = array();
				$user_navigation_employer_image_project = array();
				$user_navigation_employer_show_proposal = array();
				$user_navigation_employer_image_proposal = array();
				$user_navigation_freelancer_show_project = array();
				$user_navigation_freelancer_image_project = array();
			}

			//Disputes
			if ($enable_post_type_project == '1' || $enable_post_type_service == '1') {
				$user_navigation_employer_show_disputes = array(
					'id' => 'show_employer_disputes',
					'type' => 'button_set',
					'title' => esc_html__('Show "Disputes"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Disputes" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_employer_image_disputes = array(
					'id' => 'image_employer_disputes',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Disputes', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for Disputes', 'felan-framework'),
					'required' => array('show_employer_disputes', '!=', '0'),
				);

				$user_navigation_freelancer_show_disputes =  array(
					'id' => 'show_freelancer_disputes',
					'type' => 'button_set',
					'title' => esc_html__('Show "Disputes"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Disputes" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_freelancer_image_disputes =   array(
					'id' => 'image_freelancer_disputes',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Disputes', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for disputes', 'felan-framework'),
					'required' => array('show_freelancer_disputes', '!=', '0'),
				);
			}

			$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');
			if ($enable_wallet_mode == '0') {
				$user_navigation_employer_show_user_package = array(
					'id' => 'show_employer_user_package',
					'type' => 'button_set',
					'title' => esc_html__('Show "User Package"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "User Package" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_employer_image_user_package = array(
					'id' => 'image_employer_user_package',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon User Package', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for User Package', 'felan-framework'),
					'required' => array('show_employer_user_package', '!=', '0'),
				);

				$user_navigation_freelancer_show_user_package =  array(
					'id' => 'show_freelancer_user_package',
					'type' => 'button_set',
					'title' => esc_html__('Show "Package"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Package" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);

				$user_navigation_freelancer_image_user_package = array(
					'id' => 'image_freelancer_user_package',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon User Package', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for User Package', 'felan-framework'),
					'required' => array('show_freelancer_user_package', '!=', '0'),
				);
			}

			if ($enable_wallet_mode == '1') {
				$user_navigation_employer_show_wallet = array(
					'id' => 'show_employer_wallet',
					'type' => 'button_set',
					'title' => esc_html__('Show "Wallet"', 'felan-framework'),
					'subtitle' => esc_html__('Show/Hide "Wallet" on navigation', 'felan-framework'),
					'desc' => '',
					'options' => array(
						'1' => esc_html__('On', 'felan-framework'),
						'0' => esc_html__('Off', 'felan-framework'),
					),
					'default' => '1'
				);
				$user_navigation_employer_image_wallet = array(
					'id' => 'image_employer_wallet',
					'type' => 'image',
					'url' => true,
					'title' => esc_html__('Icon Wallet', 'felan-framework'),
					'subtitle' => esc_html__('Choose icon for Wallet', 'felan-framework'),
					'required' => array('show_employer_wallet', '!=', '0'),
				);
			}

			$title_freelancers = esc_html__('Freelancer Settings', 'felan-framework');
			if ($enable_post_type_jobs == '1' && $enable_post_type_service !== '1' && $enable_post_type_project !== '1') {
				$title_freelancers = esc_html__('Candidate Settings', 'felan-framework');
			}
			return apply_filters('felan_register_user_option', array(
				'id' => 'felan_user_option',
				'title' => esc_html__('User Navigation', 'felan-framework'),
				'icon' => 'dashicons-groups',
				'fields' => array_merge(
					apply_filters('felan_register_user_employer_option_top', array()),
					array(
						apply_filters(
							'felan_register_user_employer_option_main',
							array(
								'id' => 'felan_user_option_employer',
								'type' => 'group',
								'title' => esc_html__('Employer Setting', 'felan-framework'),
								'fields' => array(
									array(
										'id' => 'show_employer_payout',
										'type' => 'button_set',
										'title' => esc_html__('Show "Payout"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Payout"', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'type_icon_employer',
										'type' => 'select',
										'title' => esc_html__('Icon Type', 'felan-framework'),
										'default' => 'svg',
										'options' => array(
											'image' => esc_html__('Image', 'felan-framework'),
											'svg' => esc_html__('Svg', 'felan-framework')
										),
									),
									array(
										'id' => 'show_employer_dashboard',
										'type' => 'button_set',
										'title' => esc_html__('Show "Dashboard"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Dashboard" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_employer_dashboard',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Dashboard', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for dashboard', 'felan-framework'),
										'required' => array('show_employer_dashboard', '!=', '0'),
									),

									$user_navigation_employer_show_project,
									$user_navigation_employer_image_project,

									$user_navigation_employer_show_proposal,
									$user_navigation_employer_image_proposal,

									$user_navigation_employer_show_jobs,
									$user_navigation_employer_image_jobs,

									array(
										'id' => 'show_employer_freelancers',
										'type' => 'button_set',
										'title' => esc_html__('Show "Follow"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Follow" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_employer_freelancers',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Follow', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for follow', 'felan-framework'),
										'required' => array('show_employer_freelancers', '!=', '0'),
									),

									$user_navigation_employer_show_disputes,
									$user_navigation_employer_image_disputes,

									$user_navigation_employer_show_user_package,
									$user_navigation_employer_image_user_package,

									$user_navigation_employer_show_wallet,
									$user_navigation_employer_image_wallet,

									array(
										'id' => 'show_employer_messages',
										'type' => 'button_set',
										'title' => esc_html__('Show "Messages"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Messages" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_employer_messages',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Messages', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for messages', 'felan-framework'),
										'required' => array('show_employer_messages', '!=', '0'),
									),

									$user_navigation_employer_show_meetings,
									$user_navigation_employer_image_meetings,

									array(
										'id' => 'show_employer_company',
										'type' => 'button_set',
										'title' => esc_html__('Show "Company"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Company" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_employer_company',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Company', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for company', 'felan-framework'),
										'required' => array('show_employer_company', '!=', '0'),
									),
									array(
										'id' => 'show_employer_settings',
										'type' => 'button_set',
										'title' => esc_html__('Show "Settings"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Settings" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_employer_settings',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Settings', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for settings', 'felan-framework'),
										'required' => array('show_employer_settings', '!=', '0'),
									),
									array(
										'id' => 'show_employer_verification',
										'type' => 'button_set',
										'title' => esc_html__('Show Identity Verification', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide Identity Verification on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_employer_verification',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Identity Verification', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for Identity Verification', 'felan-framework'),
										'required' => array('show_employer_verification', '!=', '0'),
									),
									array(
										'id' => 'show_employer_logout',
										'type' => 'button_set',
										'title' => esc_html__('Show "Logout"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Logout" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_employer_logout',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Logout', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for logout', 'felan-framework'),
										'required' => array('show_employer_logout', '!=', '0'),
									),
									$user_navigation_employer_show_servive,
									$user_navigation_employer_image_service,
								),
							),
						),
					),
					apply_filters('felan_register_user_freelancer_option_top', array()),
					array(
						apply_filters(
							'felan_register_user_freelancer_option_main',
							array(
								'id' => 'felan_user_option_freelancer',
								'type' => 'group',
								'title' => $title_freelancers,
								'fields' => array(
									array(
										'id' => 'show_freelancer_payout',
										'type' => 'button_set',
										'title' => esc_html__('Show "Payout"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Payout"', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'type_icon_freelancer',
										'type' => 'select',
										'title' => esc_html__('Icon Type', 'felan-framework'),
										'default' => 'svg',
										'options' => array(
											'image' => esc_html__('Image', 'felan-framework'),
											'svg' => esc_html__('Svg', 'felan-framework')
										),
									),
									array(
										'id' => 'show_freelancer_dashboard',
										'type' => 'button_set',
										'title' => esc_html__('Show "Dashboard"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Dashboard" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_dashboard',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Dashboard', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for dashboard', 'felan-framework'),
										'required' => array('show_freelancer_dashboard', '!=', '0'),
									),
									array(
										'id' => 'show_freelancer_profile',
										'type' => 'button_set',
										'title' => esc_html__('Show "Profile"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Profile" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_profile',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Profile', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for profile', 'felan-framework'),
										'required' => array('show_freelancer_profile', '!=', '0'),
									),

									$user_navigation_freelancer_show_project,
									$user_navigation_freelancer_image_project,

									$user_navigation_freelancer_show_jobs,
									$user_navigation_freelancer_image_jobs,

									$user_navigation_freelancer_show_user_package,
									$user_navigation_freelancer_image_user_package,

									array(
										'id' => 'show_freelancer_reviews',
										'type' => 'button_set',
										'title' => esc_html__('Show "My Reviews"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "My Reviews" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_reviews',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon My Reviews', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for My Reviews', 'felan-framework'),
										'required' => array('show_freelancer_reviews', '!=', '0'),
									),
									array(
										'id' => 'show_freelancer_company',
										'type' => 'button_set',
										'title' => esc_html__('Show "My Following"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "My Following" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_company',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon My Following', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for My Following', 'felan-framework'),
										'required' => array('show_freelancer_company', '!=', '0'),
									),
									array(
										'id' => 'show_freelancer_messages',
										'type' => 'button_set',
										'title' => esc_html__('Show "Messages"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Messages" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_messages',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Messages', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for messages', 'felan-framework'),
										'required' => array('show_freelancer_messages', '!=', '0'),
									),

									$user_navigation_freelancer_show_meetings,
									$user_navigation_freelancer_image_meetings,

									$user_navigation_freelancer_show_disputes,
									$user_navigation_freelancer_image_disputes,

									array(
										'id' => 'show_freelancer_wallet',
										'type' => 'button_set',
										'title' => esc_html__('Show "Wallet"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Wallet" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_wallet',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Wallet', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for wallet', 'felan-framework'),
										'required' => array('show_freelancer_settings', '!=', '0'),
									),
									array(
										'id' => 'show_freelancer_settings',
										'type' => 'button_set',
										'title' => esc_html__('Show "Settings"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Settings" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_settings',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Settings', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for settings', 'felan-framework'),
										'required' => array('show_freelancer_settings', '!=', '0'),
									),
									array(
										'id' => 'show_freelancer_verification',
										'type' => 'button_set',
										'title' => esc_html__('Show Identity Verification', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide Identity Verification on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_verification',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Identity Verification', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for Identity Verification', 'felan-framework'),
										'required' => array('show_freelancer_verification', '!=', '0'),
									),
									array(
										'id' => 'show_freelancer_logout',
										'type' => 'button_set',
										'title' => esc_html__('Show "Logout"', 'felan-framework'),
										'subtitle' => esc_html__('Show/Hide "Logout" on navigation', 'felan-framework'),
										'desc' => '',
										'options' => array(
											'1' => esc_html__('On', 'felan-framework'),
											'0' => esc_html__('Off', 'felan-framework'),
										),
										'default' => '1'
									),
									array(
										'id' => 'image_freelancer_logout',
										'type' => 'image',
										'url' => true,
										'title' => esc_html__('Icon Logout', 'felan-framework'),
										'subtitle' => esc_html__('Choose icon for logout', 'felan-framework'),
										'required' => array('show_freelancer_logout', '!=', '0'),
									),
									$user_navigation_freelancer_show_servive,
									$user_navigation_freelancer_image_service,
								),
							),
						),
					),
					apply_filters('felan_register_user_option_bottom', array())
				)
			));
		}
}
