<?php
/**
 * Felan Capabilities Trait
 *
 * Contains all capability-related methods extracted from class-felan-admin.php
 *
 * @package Felan_Framework
 * @since 1.0.0
 *
 * REFACTOR NOTE:
 * - Extracted from class-felan-admin.php lines 945-1103
 * - Original file: 16,156 lines
 * - This trait: ~160 lines
 * - Use trait in Felan_Admin class: use Felan_Capabilities_Trait;
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!trait_exists('Felan_Capabilities_Trait')) {

    trait Felan_Capabilities_Trait {

        /**
         * Get invoice capabilities
         * @return array
         */
        private function get_invoice_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_invoices',
                'delete_posts' => 'delete_invoices'
            );
            return apply_filters('get_invoice_capabilities', $caps);
        }

        /**
         * Get order capabilities
         * @return array
         */
        private function get_order_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_order',
                'delete_posts' => true,
            );
            return apply_filters('get_order_capabilities', $caps);
        }

        /**
         * Get freelancer withdraw capabilities
         * @return array
         */
        private function get_freelancer_withdraw_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_order',
                'delete_posts' => true,
            );
            return apply_filters('get_order_capabilities', $caps);
        }

        /**
         * Get applicants capabilities
         * @return array
         */
        private function get_applicants_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_applicants',
                'delete_posts' => true,
            );
            return apply_filters('get_applicants_capabilities', $caps);
        }

        /**
         * Get proposal capabilities
         * @return array
         */
        private function get_proposal_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_proposal',
                'delete_posts' => true,
            );
            return apply_filters('get_proposal_capabilities', $caps);
        }

        /**
         * Get meetings capabilities
         * @return array
         */
        private function get_meetings_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_meetings',
                'delete_posts' => true,
            );
            return apply_filters('get_meetings_capabilities', $caps);
        }

        /**
         * Get project alerts capabilities
         * @return array
         */
        private function get_project_alerts_capabilities()
        {
            $caps = array(
                'edit_post' => 'edit_project_alerts',
                'read_post' => 'read_project_alert',
                'delete_post' => 'delete_project_alert',
                'edit_posts' => 'edit_project_alerts',
                'edit_others_posts' => 'edit_others_project_alerts',
                'publish_posts' => 'publish_project_alerts',
                'read_private_posts' => 'read_private_project_alerts',
                'delete_posts' => 'delete_project_alerts',
                'delete_private_posts' => 'delete_private_project_alerts',
                'delete_published_posts' => 'delete_published_project_alerts',
                'delete_others_posts' => 'delete_others_project_alerts',
                'edit_private_posts' => 'edit_private_project_alerts',
                'edit_published_posts' => 'edit_published_project_alerts',
                'create_posts' => 'edit_project_alerts',
            );
            return apply_filters('get_project_alerts_capabilities', $caps);
        }

        /**
         * Get user_package capabilities
         * @return array
         */
        private function get_user_package_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_user_packages',
                'delete_posts' => 'do_not_allow'
            );
            return apply_filters('get_user_package_capabilities', $caps);
        }

        /**
         * Get freelancer capabilities
         * @return array
         */
        private function get_freelancer_capabilities()
        {
            $caps = array(
                'create_posts' => 'do_not_allow',
                'edit_post' => 'edit_freelancer',
                'delete_post' => 'delete_freelancer',
            );
            return apply_filters('get_freelancer_capabilities', $caps);
        }

        /**
         * Get freelancer users options for select field
         * @return array
         */
        private function get_freelancer_users_options()
        {
            $users = get_users(array(
                'role' => 'felan_user_freelancer',
                'number' => -1,
                'orderby' => 'display_name',
                'order' => 'ASC',
            ));

            $options = array('' => esc_html__('Select a user', 'felan-framework'));
            foreach ($users as $user) {
                $options[$user->ID] = $user->display_name . ' (' . $user->user_email . ')';
            }

            return $options;
        }
    }
}
