<?php
/**
 * Post Types Registration Trait
 *
 * Contains all post type registration methods for Felan Admin.
 * Extracted from class-felan-admin.php for better code organization.
 *
 * @package Felan_Framework
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
	exit;
}

trait Felan_Post_Types_Trait
{
	/**
	 * Register post_type
	 * @param $post_types
	 * @return mixed
	 */
	public function register_post_type($post_types)
	{
		$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
		$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
		$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
		$enable_wallet_mode = felan_get_option('enable_wallet_mode', '0');

		if ($enable_wallet_mode == '1') {
			$post_types['wallet_order'] = array(
				'labels' => array(
					'name' => esc_html__('Wallet Order', 'felan-framework'),
					'singular_name' => esc_html__('Wallet Order', 'felan-framework'),
					'all_items' => esc_html__('Wallet Order', 'felan-framework'),
				),
				'supports' => array('title'),
				'menu_icon' => 'dashicons-printer',
				'capabilities' => $this->get_order_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_wallet_order_slug', 'order'),
				),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 10,
			);
			$post_types['employer_withdraw'] = array(
				'labels' => array(
					'name' => esc_html__('Withdraw', 'felan-framework'),
					'singular_name' => esc_html__('Withdraw', 'felan-framework'),
					'all_items' => esc_html__('Withdraw', 'felan-framework'),
				),
				'supports' => array('title'),
				'menu_icon' => 'dashicons-money-alt',
				'capabilities' => $this->get_freelancer_withdraw_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_employer_withdraw_slug', 'employer_withdraw'),
				),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 11,
			);
		}

		$post_types['company'] = array(
			'labels' => array(
				'name' => esc_html__('Companies', 'felan-framework'),
				'singular_name' => esc_html__('Companies', 'felan-framework'),
				'all_items' => esc_html__('Companies', 'felan-framework'),
				'add_new' => esc_html__('Add New Companies', 'felan-framework'),
				'add_new_item' => esc_html__('Add New Companies', 'felan-framework'),
				'edit_item' => esc_html__('Edit Companies', 'felan-framework'),
				'new_item' => esc_html__('Add New Companies', 'felan-framework'),
				'view_item' => esc_html__('View Companies', 'felan-framework'),
			),
			'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments'),
			'menu_icon' => 'dashicons-admin-multisite',
			'can_export' => true,
			'show_in_rest' => true,
			'capability_type' => 'company',
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_company_slug', 'company'),
				'with_front' => false,
			),
			'has_archive' => apply_filters('felan_company_has_archive', 'company'),
			'show_in_admin_bar' => true,
			'menu_position' => 6,
		);

		$post_types['package'] = array(
			'labels' => array(
				'name' => esc_html__('Package', 'felan-framework'),
				'singular_name' => esc_html__('Package', 'felan-framework'),
				'all_items' => esc_html__('Package', 'felan-framework'),
			),
			'supports' => array('title', 'thumbnail'),
			'menu_icon' => 'dashicons-archive',
			'can_export' => true,
			'show_in_rest' => true,
			'capability_type' => 'package',
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_package_slug', 'package'),
			),
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 7,
		);

		$post_types['user_package'] = array(
			'labels' => array(
				'name' => esc_html__('User Packages', 'felan-framework'),
				'singular_name' => esc_html__('User Packages', 'felan-framework'),
				'all_items' => esc_html__('User Packages', 'felan-framework'),
			),
			'supports' => array('title', 'excerpt'),
			'menu_icon' => 'dashicons-money',
			'can_export' => true,
			'capabilities' => $this->get_user_package_capabilities(),
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_user_package_slug', 'user_package'),
			),
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 8,
		);

		$post_types['invoice'] = array(
			'labels' => array(
				'name' => esc_html__('Invoices', 'felan-framework'),
				'singular_name' => esc_html__('Invoices', 'felan-framework'),
				'all_items' => esc_html__('Invoices', 'felan-framework'),
			),
			'supports' => array('title', 'excerpt'),
			'menu_icon' => 'dashicons-list-view',
			'capabilities' => $this->get_invoice_capabilities(),
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_invoice_slug', 'invoice'),
			),
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 9,
		);

		$post_types['freelancer_withdraw'] = array(
			'labels' => array(
				'name' => esc_html__('Withdraw', 'felan-framework'),
				'singular_name' => esc_html__('Withdraw', 'felan-framework'),
				'all_items' => esc_html__('Withdraw', 'felan-framework'),
			),
			'supports' => array('title'),
			'menu_icon' => 'dashicons-money-alt',
			'capabilities' => $this->get_freelancer_withdraw_capabilities(),
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_withdraw_slug', 'freelancer_withdraw'),
			),
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 11,
		);

		if ($enable_post_type_jobs == '1' && $enable_post_type_service !== '1' && $enable_post_type_project !== '1') {
			$post_types['freelancer'] = array(
				'labels' => array(
					'name' => esc_html__('Candidate', 'felan-framework'),
					'singular_name' => esc_html__('Candidate', 'felan-framework'),
					'all_items' => esc_html__('Candidate', 'felan-framework'),
					'add_new' => esc_html__('Add New Candidate', 'felan-framework'),
					'add_new_item' => esc_html__('Add New Candidate', 'felan-framework'),
					'edit_item' => esc_html__('Edit Candidate', 'felan-framework'),
					'new_item' => esc_html__('Add New Candidate', 'felan-framework'),
					'view_item' => esc_html__('View Candidate', 'felan-framework'),
				),
				'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'page-attributes', 'comments'),
				'menu_icon' => 'dashicons-buddicons-buddypress-logo',
				'can_export' => true,
				'show_in_rest' => true,
				'capabilities' => $this->get_freelancer_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_freelancer_slug', 'candidate'),
					'with_front' => false,
				),
				'has_archive' => apply_filters('felan_freelancer_has_archive', 'candidate'),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 13,
			);
		} else {
			$post_types['freelancer'] = array(
				'labels' => array(
					'name' => esc_html__('Freelancers', 'felan-framework'),
					'singular_name' => esc_html__('Freelancers', 'felan-framework'),
					'all_items' => esc_html__('Freelancers', 'felan-framework'),
					'add_new' => esc_html__('Add New Freelancers', 'felan-framework'),
					'add_new_item' => esc_html__('Add New Freelancers', 'felan-framework'),
					'edit_item' => esc_html__('Edit Freelancers', 'felan-framework'),
					'new_item' => esc_html__('Add New Freelancers', 'felan-framework'),
					'view_item' => esc_html__('View Freelancers', 'felan-framework'),
				),
				'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'page-attributes', 'comments'),
				'menu_icon' => 'dashicons-buddicons-buddypress-logo',
				'can_export' => true,
				'show_in_rest' => true,
				'capabilities' => $this->get_freelancer_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_freelancer_slug', 'freelancer'),
					'with_front' => false,
				),
				'has_archive' => apply_filters('felan_freelancer_has_archive', 'freelancer'),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 13,
			);
		}

		$post_types['freelancer_package'] = array(
			'labels' => array(
				'name' => esc_html__('Package', 'felan-framework'),
				'singular_name' => esc_html__('Package', 'felan-framework'),
				'all_items' => esc_html__('Package', 'felan-framework'),
			),
			'supports' => array('title', 'thumbnail'),
			'menu_icon' => 'dashicons-archive',
			'can_export' => true,
			'show_in_rest' => true,
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_package_slug', 'freelancer_package'),
			),
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 15,
		);
		$post_types['freelancer_order'] = array(
			'labels' => array(
				'name' => esc_html__('Order', 'felan-framework'),
				'singular_name' => esc_html__('Order', 'felan-framework'),
				'all_items' => esc_html__('Service Order', 'felan-framework'),
			),
			'supports' => array('title'),
			'menu_icon' => 'dashicons-list-view',
			'capabilities' => $this->get_order_capabilities(),
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_order_slug', 'freelancer_order'),
			),
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 16,
		);

		$post_types['messages'] = array(
			'labels' => array(
				'name' => esc_html__('Messages', 'felan-framework'),
				'singular_name' => esc_html__('Messages', 'felan-framework'),
				'all_items' => esc_html__('Messages', 'felan-framework'),
			),
			'supports' => array('title', 'excerpt'),
			'menu_icon'         => 'dashicons-format-chat',
			'has_archive'       => false,
			'publicly_queryable' => false,
			'show_in_rest'		=> false,
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 17,
		);

		$post_types['notification'] = array(
			'labels' => array(
				'name' => esc_html__('Notification', 'felan-framework'),
				'singular_name' => esc_html__('Notification', 'felan-framework'),
				'all_items' => esc_html__('Notification', 'felan-framework'),
			),
			'supports' => array('title', 'excerpt'),
			'menu_icon'         => 'dashicons-bell',
			'has_archive'       => false,
			'publicly_queryable' => false,
			'show_in_rest'		=> false,
			'show_ui'	=> true,
			'show_in_menu' => true,
			'menu_position' => 18,
		);

		$post_types['locations'] = array(
			'labels' => array(
				'name' => esc_html__('Locations', 'felan-framework'),
				'singular_name' => esc_html__('Locations', 'felan-framework'),
				'all_items' => esc_html__('Locations', 'felan-framework'),
			),
			'supports' => array(),
			'menu_icon' => 'dashicons-calendar-alt',
			'capabilities' => array( // Chỉ cho phép xem danh sách
				'read' => 'read',
				'edit_posts' => 'do_not_allow',
				'delete_posts' => 'do_not_allow',
				'publish_posts' => 'do_not_allow',
			),
			'map_meta_cap' => true,
			'rewrite' => array(
				'slug' => apply_filters('felan_locations_slug', 'locations'),
			),
			'show_ui' => true,
			'show_in_menu' => true,
			'menu_position' => 22,
		);

		$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
		if ($enable_post_type_jobs == '1') {
			$post_types['jobs'] = array(
				'labels' => array(
					'name' => esc_html__('Jobs', 'felan-framework'),
					'singular_name' => esc_html__('Jobs', 'felan-framework'),
					'all_items' => esc_html__('Jobs', 'felan-framework'),
					'add_new' => esc_html__('Add New Jobs', 'felan-framework'),
					'add_new_item' => esc_html__('Add New Jobs', 'felan-framework'),
					'edit_item' => esc_html__('Edit Jobs', 'felan-framework'),
					'new_item' => esc_html__('Add New Jobs', 'felan-framework'),
					'view_item' => esc_html__('View Jobs', 'felan-framework'),
				),
				'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'revisions', 'page-attributes', 'comments'),
				'menu_icon' => 'dashicons-hammer',
				'can_export' => true,
				'show_in_rest' => true,
				'capability_type' => 'jobs',
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_slug', 'jobs'),
					'with_front' => false,
				),
				'show_ui'	=> true,
				'menu_position' => 3,
				'has_archive' => apply_filters('felan_jobs_has_archive', 'jobs'),
				'show_in_menu' => true,
			);

			$post_types['applicants'] = array(
				'labels' => array(
					'name' => esc_html__('Applicants', 'felan-framework'),
					'singular_name' => esc_html__('Applicants', 'felan-framework'),
					'all_items' => esc_html__('Applicants', 'felan-framework'),
				),
				'menu_icon' => 'dashicons-universal-access-alt',
				'capabilities' => $this->get_applicants_capabilities(),
				'map_meta_cap' => true,
				'supports' => array('title'),
				'rewrite' => array(
					'slug' => apply_filters('felan_applicants_slug', 'applicants'),
				),
				'show_in_admin_bar' => true,
				'menu_position' => 4,
			);
			if (felan_get_option('enable_job_alerts') === '1') {
				$post_types['job_alerts'] = array(
					'labels' => array(
						'name' => esc_html__('Job Alerts', 'felan-framework'),
						'singular_name' => esc_html__('Job Alerts', 'felan-framework'),
						'all_items' => esc_html__('Job Alerts', 'felan-framework'),
					),
					'menu_icon'         => 'dashicons-email-alt',
					'map_meta_cap' => true,
					'supports' => array('title'),
					'show_in_admin_bar' => true,
					'menu_position' => 5,
				);
			}
			$post_types['meetings'] = array(
				'labels' => array(
					'name' => esc_html__('Meetings', 'felan-framework'),
					'singular_name' => esc_html__('Meetings', 'felan-framework'),
					'all_items' => esc_html__('Meetings', 'felan-framework'),
				),
				'supports' => array('title'),
				'menu_icon' => 'dashicons-calendar-alt',
				'capabilities' => $this->get_meetings_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_meetings_slug', 'meetings'),
				),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 19,
			);
		}

		$enable_post_type_service = felan_get_option('enable_post_type_service', '1');
		if ($enable_post_type_service == '1') {
			$post_types['service_order'] = array(
				'labels' => array(
					'name' => esc_html__('Service Order', 'felan-framework'),
					'singular_name' => esc_html__('Service Order', 'felan-framework'),
					'all_items' => esc_html__('Service Order', 'felan-framework'),
				),
				'supports' => array('title'),
				'menu_icon' => 'dashicons-printer',
				'capabilities' => $this->get_order_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_service_order_slug', 'service_order'),
				),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 10,
			);

			$post_types['service'] = array(
				'labels' => array(
					'name' => esc_html__('Services', 'felan-framework'),
					'singular_name' => esc_html__('Services', 'felan-framework'),
					'all_items' => esc_html__('Services', 'felan-framework'),
					'add_new' => esc_html__('Add New Services', 'felan-framework'),
					'add_new_item' => esc_html__('Add New Services', 'felan-framework'),
					'edit_item' => esc_html__('Edit Services', 'felan-framework'),
					'new_item' => esc_html__('Add New Services', 'felan-framework'),
					'view_item' => esc_html__('View Services', 'felan-framework'),
				),
				'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'revisions', 'page-attributes', 'comments'),
				'menu_icon' => 'dashicons-hammer',
				'can_export' => true,
				'show_in_rest' => true,
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_service_slug', 'services'),
					'with_front' => false,
				),
				'show_ui'	=> true,
				'has_archive' => apply_filters('felan_service_has_archive', 'services'),
				'show_in_menu' => true,
				'menu_position' => 14,
			);

			$post_types['disputes'] = array(
				'labels' => array(
					'name' => esc_html__('Service Disputes', 'felan-framework'),
					'singular_name' => esc_html__('Service Disputes', 'felan-framework'),
					'all_items' => esc_html__('Service Disputes', 'felan-framework'),
				),
				'supports' => array('title', 'excerpt'),
				'menu_icon' => 'dashicons-calendar-alt',
				'capabilities' => $this->get_meetings_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_disputes_slug', 'disputes'),
				),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 20,
			);
		}

		$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
		if ($enable_post_type_project == '1') {
			$post_types['project'] = array(
				'labels' => array(
					'name' => esc_html__('Projects', 'felan-framework'),
					'singular_name' => esc_html__('Projects', 'felan-framework'),
					'all_items' => esc_html__('Projects', 'felan-framework'),
					'add_new' => esc_html__('Add New Projects', 'felan-framework'),
					'add_new_item' => esc_html__('Add New Projects', 'felan-framework'),
					'edit_item' => esc_html__('Edit Projects', 'felan-framework'),
					'new_item' => esc_html__('Add New Projects', 'felan-framework'),
					'view_item' => esc_html__('View Projects', 'felan-framework'),
				),
				'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments'),
				'menu_icon' => 'dashicons-sos',
				'can_export' => true,
				'show_in_rest' => true,
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_project_slug', 'projects'),
					'with_front' => false,
				),
				'has_archive' => apply_filters('felan_project_has_archive', 'projects'),
				'show_in_admin_bar' => true,
				'menu_position' => 12,
			);

			$post_types['project-proposal'] = array(
				'labels' => array(
					'name' => esc_html__('Projects Proposal', 'felan-framework'),
					'singular_name' => esc_html__('Projects Proposal', 'felan-framework'),
					'all_items' => esc_html__('Projects Proposal', 'felan-framework'),
				),
				'menu_icon' => 'dashicons-universal-access-alt',
				'capabilities' => $this->get_proposal_capabilities(),
				'map_meta_cap' => true,
				'supports' => array('title'),
				'rewrite' => array(
					'slug' => apply_filters('felan_proposal_slug', 'project-proposal'),
				),
				'show_in_admin_bar' => true,
				'menu_position' => 13,
			);

			$post_types['project_order'] = array(
				'labels' => array(
					'name' => esc_html__('Project Order', 'felan-framework'),
					'singular_name' => esc_html__('Project Order', 'felan-framework'),
					'all_items' => esc_html__('Project Order', 'felan-framework'),
				),
				'supports' => array('title'),
				'menu_icon' => 'dashicons-printer',
				'capabilities' => $this->get_order_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_project_order_slug', 'project_order'),
				),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 10,
			);

			$post_types['project_disputes'] = array(
				'labels' => array(
					'name' => esc_html__('Project Disputes', 'felan-framework'),
					'singular_name' => esc_html__('Project Disputes', 'felan-framework'),
					'all_items' => esc_html__('Project Disputes', 'felan-framework'),
				),
				'supports' => array('title', 'excerpt'),
				'menu_icon' => 'dashicons-calendar-alt',
				'capabilities' => $this->get_meetings_capabilities(),
				'map_meta_cap' => true,
				'rewrite' => array(
					'slug' => apply_filters('felan_project_disputes_slug', 'project_disputes'),
				),
				'show_ui'	=> true,
				'show_in_menu' => true,
				'menu_position' => 21,
			);

			// Register Project Alerts post type
			if (felan_get_option('enable_project_alerts', '1') === '1') {
				$post_types['project_alerts'] = array(
					'labels' => array(
						'name' => esc_html__('Project Alerts', 'felan-framework'),
						'singular_name' => esc_html__('Project Alert', 'felan-framework'),
						'all_items' => esc_html__('Project Alerts', 'felan-framework'),
						'not_found_in_trash' => esc_html__('No Project Alerts found in Trash.', 'felan-framework'),
					),
					'menu_icon'         => 'dashicons-email-alt',
					'capabilities' => $this->get_project_alerts_capabilities(),
					'map_meta_cap' => true,
					'supports' => array('title'),
					'public' => false,
					'publicly_queryable' => false,
					'exclude_from_search' => true,
					'show_ui' => true,
					'show_in_menu' => 'felan_extensions',
					'show_in_admin_bar' => true,
					'can_export' => true,
					'delete_with_user' => false,
				);
			}
		}

		return $post_types;
	}

	/**
	 * Register post status
	 */
	public function register_post_status()
	{
		register_post_status('expired', array(
			'label' => _x('Expired', 'post status', 'felan-framework'),
			'public' => true,
			'protected' => true,
			'exclude_from_search' => true,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop('Expired <span class="count">(%s)</span>', 'Expired <span class="count">(%s)</span>', 'felan-framework'),
		));

		register_post_status('pause', array(
			'label' => _x('Paused', 'post status', 'felan-framework'),
			'public' => true,
			'protected' => true,
			'exclude_from_search' => true,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop('Paused <span class="count">(%s)</span>', 'Paused <span class="count">(%s)</span>', 'felan-framework'),
		));

		register_post_status('canceled', array(
			'label' => _x('Canceled', 'post status', 'felan-framework'),
			'public' => true,
			'protected' => true,
			'exclude_from_search' => true,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop('Canceled <span class="count">(%s)</span>', 'Canceled <span class="count">(%s)</span>', 'felan-framework'),
		));

		register_post_status('hidden', array(
			'label' => _x('Hidden', 'post status', 'felan-framework'),
			'public' => true,
			'protected' => true,
			'exclude_from_search' => true,
			'show_in_admin_all_list' => true,
			'show_in_admin_status_list' => true,
			'label_count' => _n_noop('Hidden <span class="count">(%s)</span>', 'Hidden <span class="count">(%s)</span>', 'felan-framework'),
		));
	}
}
