<?php
/**
 * Taxonomies Registration Trait
 *
 * Contains all taxonomy registration methods for Felan Admin.
 * Extracted from class-felan-admin.php for better code organization.
 *
 * @package Felan_Framework
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
	exit;
}

trait Felan_Taxonomies_Trait
{
	/**
	 * Register taxonomy
	 * @param $taxonomies
	 * @return mixed
	 */
	public function register_taxonomy($taxonomies)
	{
		// Location
		$post_types = ['jobs', 'company', 'service', 'project', 'freelancer'];

		register_taxonomy('felan_location', $post_types, [
			'label'        => __('City / Town', 'felan-framework'),
			'rewrite'      => false,
			'hierarchical' => true,
			'public'       => true,
			'show_ui'      => true,
			'show_admin_column' => true,
			'show_in_rest'      => true,
		]);

		if (felan_get_option('enable_option_state') === '1') {
			register_taxonomy('felan_state', $post_types, [
				'label'        => __('Province / State', 'felan-framework'),
				'rewrite'      => false,
				'hierarchical' => true,
				'public'       => true,
				'show_ui'      => true,
				'show_admin_column' => true,
				'show_in_rest'      => true,
			]);
		}

		// Freelancer taxonomy
		$taxonomies['freelancer_categories'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Categories', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Category', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_categories_slug', 'freelancer_categories'),
			),
		);
		$taxonomies['freelancer_ages'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Ages', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Age', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_ages_slug', 'freelancer_ages'),
			),
		);

		$taxonomies['freelancer_languages'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Languages', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Language', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_languages_slug', 'freelancer_languages'),
			),
		);
		$taxonomies['freelancer_qualification'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Qualification', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Qualification', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_qualification_slug', 'freelancer_qualification'),
			),
		);

		$taxonomies['freelancer_yoe'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Years of Experience', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Years of Experience', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_yoe_slug', 'freelancer_yoe'),
			),
		);

		$taxonomies['freelancer_education_levels'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Levels of Education', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Level of Education', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_education_levels_slug', 'freelancer_education_levels'),
			),
		);

		$taxonomies['freelancer_skills'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Skills', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Skill', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_skills_slug', 'freelancer_skills'),
			),
		);

		$taxonomies['freelancer_gender'] = array(
			'post_type' => 'freelancer',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Gender', 'felan-framework'),
			'singular_name' => esc_html__('Freelancer Gender', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_freelancer_gender_slug', 'freelancer_gender'),
			),
		);

		//Jobs
		$enable_post_type_jobs = felan_get_option('enable_post_type_jobs', '1');
		if ($enable_post_type_jobs == '1') {
			$taxonomies['jobs-categories'] = array(
				'post_type' => 'jobs',
				'hierarchical' => true,
				'show_in_rest' => true,
				'label' => esc_html__('Categories', 'felan-framework'),
				'singular_name' => esc_html__('Jobs Categories', 'felan-framework'),
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_categories_slug', 'jobs-categories'),
				),
			);
			$taxonomies['jobs-skills'] = array(
				'post_type' => 'jobs',
				'hierarchical' => true,
				'show_in_rest' => true,
				'label' => esc_html__('Skills', 'felan-framework'),
				'singular_name' => esc_html__('Jobs Skills', 'felan-framework'),
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_skills_slug', 'jobs-skills'),
				),
			);
			$taxonomies['jobs-type'] = array(
				'post_type' => 'jobs',
				'hierarchical' => true,
				'show_in_rest' => true,
				'label' => esc_html__('Type', 'felan-framework'),
				'singular_name' => esc_html__('Jobs Type', 'felan-framework'),
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_type_slug', 'jobs-type'),
				),
			);
			$taxonomies['jobs-career'] = array(
				'post_type' => 'jobs',
				'hierarchical' => true,
				'show_in_rest' => true,
				'label' => esc_html__('Career', 'felan-framework'),
				'singular_name' => esc_html__('Jobs Career', 'felan-framework'),
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_career_slug', 'jobs-career'),
				),
			);
			$taxonomies['jobs-experience'] = array(
				'post_type' => 'jobs',
				'hierarchical' => true,
				'show_in_rest' => true,
				'label' => esc_html__('Experience', 'jobs-framework'),
				'singular_name' => esc_html__('Jobs Experience', 'felan-framework'),
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_experience_slug', 'jobs-experience'),
				),
			);
			$taxonomies['jobs-qualification'] = array(
				'post_type' => 'jobs',
				'hierarchical' => true,
				'show_in_rest' => true,
				'label' => esc_html__('Qualification', 'felan-framework'),
				'singular_name' => esc_html__('Jobs Qualification', 'felan-framework'),
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_qualification_slug', 'jobs-qualification'),
				),
			);
			$taxonomies['jobs-gender'] = array(
				'post_type' => 'jobs',
				'hierarchical' => true,
				'show_in_rest' => true,
				'label' => esc_html__('Gender', 'felan-framework'),
				'singular_name' => esc_html__('Jobs Gender', 'felan-framework'),
				'rewrite' => array(
					'slug' => apply_filters('felan_jobs_gender_slug', 'jobs-gender'),
				),
			);
		}

		//Company
		$taxonomies['company-categories'] = array(
			'post_type' => 'company',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Categories', 'felan-framework'),
			'singular_name' => esc_html__('Company Categories', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_company_categories_slug', 'company-categories'),
			),
		);
		$taxonomies['company-size'] = array(
			'post_type' => 'company',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Size', 'felan-framework'),
			'singular_name' => esc_html__('Company Size', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_company_size_slug', 'company-size'),
			),
		);

		//Service
		$taxonomies['service-categories'] = array(
			'post_type' => 'service',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Categories', 'felan-framework'),
			'singular_name' => esc_html__('Service Categories', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_service_categories_slug', 'service-categories'),
			),
		);

		$taxonomies['service-skills'] = array(
			'post_type' => 'service',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Skills', 'felan-framework'),
			'singular_name' => esc_html__('Service Skills', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_service_skills_slug', 'service-skills'),
			),
		);
		$taxonomies['service-language'] = array(
			'post_type' => 'service',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Language', 'felan-framework'),
			'singular_name' => esc_html__('Service Language', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_service_language_slug', 'service-language'),
			),
		);


		//Project
		$taxonomies['project-categories'] = array(
			'post_type' => 'project',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Categories', 'felan-framework'),
			'singular_name' => esc_html__('Project Categories', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_project_categories_slug', 'project-categories'),
			),
		);

		$taxonomies['project-skills'] = array(
			'post_type' => 'project',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Skills', 'felan-framework'),
			'singular_name' => esc_html__('Project Skills', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_project_skills_slug', 'project-skills'),
			),
		);
		$taxonomies['project-language'] = array(
			'post_type' => 'project',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Language', 'felan-framework'),
			'singular_name' => esc_html__('Project Language', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_project_language_slug', 'project-language'),
			),
		);
		$taxonomies['project-career'] = array(
			'post_type' => 'project',
			'hierarchical' => true,
			'show_in_rest' => true,
			'label' => esc_html__('Career', 'felan-framework'),
			'singular_name' => esc_html__('Project Career', 'felan-framework'),
			'rewrite' => array(
				'slug' => apply_filters('felan_project_career_slug', 'project-career'),
			),
		);

		return $taxonomies;
	}
}
