<?php
/**
 * Term Meta Registration Trait
 *
 * Contains all term meta registration methods for Felan Admin.
 * Extracted from class-felan-admin.php for better code organization.
 *
 * @package Felan_Framework
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
	exit;
}

trait Felan_Term_Meta_Trait
{
	/**
	 * Register meta term
	 * @param $configs
	 * @return mixed
	 */
	public function register_term_meta($configs)
	{
		$configs['jobs-experience-settings'] = apply_filters('felan_register_term_meta_jobs_experience', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('jobs-experience'),
			'fields' => array(
				array(
					'id' => 'jobs_experience_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['company-size-settings'] = apply_filters('felan_register_term_meta_company_size', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('company-size'),
			'fields' => array(
				array(
					'id' => 'company_size_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['canidate-experience-settings'] = apply_filters('felan_register_term_meta_freelancer_experience', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('freelancer_yoe'),
			'fields' => array(
				array(
					'id' => 'freelancer_experience_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['freelancer-ages-settings'] = apply_filters('felan_register_term_meta_freelancer_ages', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('freelancer_ages'),
			'fields' => array(
				array(
					'id' => 'freelancer_ages_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['freelancer-qualification-settings'] = apply_filters('felan_register_term_meta_freelancer_qualification', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('freelancer_qualification'),
			'fields' => array(
				array(
					'id' => 'freelancer_qualification_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['freelancer-education-settings'] = apply_filters('felan_register_term_meta_freelancer_education', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('freelancer_education_levels'),
			'fields' => array(
				array(
					'id' => 'freelancer_education_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['jobs-qualification-settings'] = apply_filters('felan_register_term_meta_jobs_qualification', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('jobs-qualification'),
			'fields' => array(
				array(
					'id' => 'jobs_qualification_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['jobs-type-settings'] = apply_filters('felan_register_term_meta_jobs_type', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('jobs-type'),
			'fields' => array(
				array(
					'id' => 'jobs_type_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['jobs-career-settings'] = apply_filters('felan_register_term_meta_jobs_career', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('jobs-career'),
			'fields' => array(
				array(
					'id' => 'jobs_career_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['freelancer-gender-settings'] = apply_filters('felan_register_term_meta_freelancer_gender', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('freelancer_gender'),
			'fields' => array(
				array(
					'id' => 'freelancer_gender_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['freelancer-categories-settings'] = apply_filters('felan_register_term_meta_freelancer_categories', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('freelancer_categories'),
			'fields' => array(
				array(
					'id' => 'freelancer_categories_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['jobs-gender-settings'] = apply_filters('felan_register_term_meta_jobs_gender', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('jobs-gender'),
			'fields' => array(
				array(
					'id' => 'jobs_gender_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));
		$configs['jobs-categories-settings'] = apply_filters('felan_register_term_meta_jobs_categories', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('jobs-categories'),
			'fields' => array(
				array(
					'id' => 'jobs_categories_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['company-categories-settings'] = apply_filters('felan_register_term_meta_company_categories', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('company-categories'),
			'fields' => array(
				array(
					'id' => 'company_categories_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['service-categories-settings'] = apply_filters('felan_register_term_meta_service_categories', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('service-categories'),
			'fields' => array(
				array(
					'id' => 'service_categories_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		$configs['project-categories-settings'] = apply_filters('felan_register_term_meta_project_categories', array(
			'name' => esc_html__('', 'felan-framework'),
			'layout' => 'horizontal',
			'taxonomy' => array('project-categories'),
			'fields' => array(
				array(
					'id' => 'project_categories_order',
					'title' => esc_html__('Number Order by', 'felan-framework'),
					'type' => 'text',
					'col' => '5',
					'pattern' => '[0-9]*',
					'default' => '',
				),
			)
		));

		if (felan_get_option('enable_option_country') === '1' && felan_get_option('enable_option_state') === '1') {
			$select_option_country = felan_get_option('select_option_country');
			$countries = felan_get_countries();
			$keys = $values = array();
			// Ensure select_option_country is an array
			if (!is_array($select_option_country)) {
				$select_option_country = !empty($select_option_country) ? array($select_option_country) : array();
			}
			if (!empty($select_option_country)) {
				foreach ($select_option_country as $key_country => $option_country) {
					if (array_key_exists($option_country, $countries)) {
						$keys[] = $option_country;
						$values[] = $countries[$option_country];
					}
				}
				$list_country = array_combine($keys, $values);
			} else {
				$list_country = $countries;
			}

			$configs['felan-state-settings'] = apply_filters('felan_register_country_meta', array(
				'name'     => '',
				'layout' => 'horizontal',
				'taxonomy' => array('felan_state'),
				'fields' => array(
					array(
						'id'      => 'felan-state-country',
						'title'   => esc_html__('Country', 'felan-framework'),
						'type'    => 'select',
						'options' => $list_country,
					),
				)
			));
		}

		if (felan_get_option('enable_option_state') === '1') {
			$list_state = felan_get_option_taxonomy('felan_state');
			$configs['state-location'] = apply_filters('felan_register_state_meta', array(
				'name'     => '',
				'layout' => 'horizontal',
				'taxonomy' => array('felan_location'),
				'fields' => array(
					array(
						'id'      => 'felan-location-state',
						'title'   => esc_html__('Province / State', 'felan-framework'),
						'default' => '',
						'type'    => 'select',
						'options' => $list_state,
					),
				)
			));
		}

		return apply_filters('felan_register_term_meta', $configs);
	}
}
