<?php

namespace MyStripe\ApiOperations;

/**
 * Trait for listable resources. Adds a `all()` static method to the class.
 *
 * This trait should only be applied to classes that derive from StripeObject.
 */
trait All
{
    /**
     * @param null|array $params
     * @param null|array|string $opts
     *
     * @throws \MyStripe\Exception\ApiErrorException if the request fails
     *
     * @return \MyStripe\Collection of ApiResources
     */
    public static function all($params = null, $opts = null)
    {
        self::_validateParams($params);
        $url = static::classUrl();

        list($response, $opts) = static::_staticRequest('get', $url, $params, $opts);
        $obj = \MyStripe\Util\Util::convertToStripeObject($response->json, $opts);
        if (!($obj instanceof \MyStripe\Collection)) {
            throw new \MyStripe\Exception\UnexpectedValueException(
                'Expected type ' . \MyStripe\Collection::class . ', got "' . \get_class($obj) . '" instead.'
            );
        }
        $obj->setLastResponse($response);
        $obj->setFilters($params);

        return $obj;
    }
}
