<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Felan_Notification')) {
    /**
     * Class Felan_Notification
     */
    class Felan_Notification
    {
        /**
         * Notification refresh
         */
        public function felan_refresh_notification()
        {
            // Security: Check if user is logged in
            if (!is_user_logged_in()) {
                echo json_encode(array(
                    'success' => false,
                    'message' => esc_html__('You must be logged in.', 'felan-framework'),
                ));
                wp_die();
            }

            global $current_user;
            $noti_id = isset($_REQUEST['noti_id']) ? absint($_REQUEST['noti_id']) : 0;
            $action_click = isset($_REQUEST['action_click']) ? sanitize_key($_REQUEST['action_click']) : '';

            // Handle mark as read action
            if (!empty($noti_id) && $action_click == 'read') {
                // Validate ownership before marking as read
                $user_receive = get_post_meta($noti_id, FELAN_METABOX_PREFIX . 'user_receive_noti', true);
                if ($user_receive == $current_user->ID) {
                    update_post_meta($noti_id, FELAN_METABOX_PREFIX . 'notification_read', 'yes');
                }
            }

            // Handle mark as unread action
            if (!empty($noti_id) && $action_click == 'unread') {
                // Validate ownership before marking as unread
                $user_receive = get_post_meta($noti_id, FELAN_METABOX_PREFIX . 'user_receive_noti', true);
                if ($user_receive == $current_user->ID) {
                    delete_post_meta($noti_id, FELAN_METABOX_PREFIX . 'notification_read');
                }
            }

            if (!empty($noti_id) && $action_click == 'delete') {
                // Validate ownership before deleting
                $user_receive = get_post_meta($noti_id, FELAN_METABOX_PREFIX . 'user_receive_noti', true);
                if ($user_receive == $current_user->ID) {
                    wp_delete_post($noti_id, true);
                }
            }

            if ($action_click == 'clear') {
                $posts = felan_get_data_notification();
                foreach ($posts as $post) :
                    $id = $post->ID;
                    wp_delete_post($id, true);
                    wp_reset_postdata();
                endforeach;
            }

            $data_notification = felan_get_data_notification();
            // Only count unread notifications
            $count = felan_get_unread_notification_count();
            if ($count > 99) {
                $count = '99';
            }

            ob_start();
            felan_get_template('dashboard/notification/content.php', array(
                'data_notification' => $data_notification,
            ));

            $noti_content = ob_get_clean();

            echo json_encode(array('success' => true, 'count' => $count, 'noti_content' => $noti_content));

            wp_die();
        }
    }
}
