<?php
/**
 * Project Alert Package Integration
 * Update user project alert limits when freelancer package is assigned
 *
 * Note: Package fields are added in class-felan-admin.php to avoid duplication
 * This file only handles the hook to update user meta when package is assigned
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Update user project alert limits when package is assigned
 */
add_action('felan_after_assign_freelancer_package', 'felan_update_user_project_alert_limits', 10, 2);

function felan_update_user_project_alert_limits($user_id, $package_id)
{
    // Validate inputs
    if (empty($user_id) || empty($package_id)) {
        return;
    }

    // Validate package exists and is correct post type
    $package_post = get_post($package_id);
    if (!$package_post || $package_post->post_type !== 'freelancer_package') {
        return;
    }

    // Check if feature is enabled
    $enable_post_type_project = felan_get_option('enable_post_type_project', '1');
    $enable_project_package_alerts = felan_get_option('enable_project_package_alerts', '1');

    if ($enable_post_type_project !== '1' || $enable_project_package_alerts !== '1') {
        // Feature not enabled, reset user meta
        update_user_meta($user_id, FELAN_METABOX_PREFIX . 'package_number_project_alerts', 0);
        update_user_meta($user_id, FELAN_METABOX_PREFIX . 'enable_package_project_alerts_unlimited', 0);
        return;
    }

    // Check if package-specific settings are enabled
    $enable_package_specific = felan_get_option('enable_project_package_specific_settings', '1');

    if ($enable_package_specific === '1') {
        // Package-specific settings enabled - get from package
        $limit = get_post_meta($package_id, FELAN_METABOX_PREFIX . 'package_number_project_alerts', true);

        // Use package limit if set, otherwise use default from theme options
        if ($limit !== '' && $limit !== false && $limit !== null) {
            $limit = intval($limit);
            // Ensure limit is not negative
            if ($limit < 0) {
                $limit = 0;
            }
        } else {
            $limit = intval(felan_get_option('project_package_alerts_default_limit', '3'));
        }
    } else {
        // Package-specific settings disabled - always use default from theme options
        $limit = intval(felan_get_option('project_package_alerts_default_limit', '3'));
    }

    update_user_meta($user_id, FELAN_METABOX_PREFIX . 'package_number_project_alerts', $limit);
    // Always set unlimited to 0 (unlimited option removed)
    update_user_meta($user_id, FELAN_METABOX_PREFIX . 'enable_package_project_alerts_unlimited', 0);
}
