<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Felan_Tool')) {
    /**
     * Abstract Class Felan_Tool
     * Base class for all Felan Extension tools
     */
    abstract class Felan_Tool
    {
        /**
         * Tool ID
         * @var string
         */
        protected $id;

        /**
         * Tool Name
         * @var string
         */
        protected $name;

        /**
         * Tool Description
         * @var string
         */
        protected $description;

        /**
         * Tool Group (e.g., 'maintenance', 'importers')
         * @var string
         */
        protected $group = 'maintenance';

        /**
         * Tool Icon (Dashicon class or FontAwesome class)
         * @var string
         */
        protected $icon = 'dashicons-admin-tools';

        public function __construct()
        {
            // Initialize tool...
        }

        /**
         * Get Tool ID
         */
        public function get_id()
        {
            return $this->id;
        }

        /**
         * Get Tool Name
         */
        public function get_name()
        {
            return $this->name;
        }

        /**
         * Get Tool Description
         */
        public function get_description()
        {
            return $this->description;
        }

        /**
         * Get Tool Group
         */
        public function get_group()
        {
            return $this->group;
        }

         /**
         * Get Tool Icon
         */
        public function get_icon()
        {
            return $this->icon;
        }

        /**
         * Run the tool logic
         * @return array ['success' => bool, 'message' => string]
         */
        abstract public function run();

        /**
         * Render the tool UI
         */
        public function render()
        {
            // Default render if needed, or abstract if forced
        }
    }
}
