
/**
 * Script to update all jobs expiration correctly
 * Handles both enable_jobs_expires and enable_jobs_package_expires
 */

function civi_fix_all_jobs_expiration() {
	$min_days = 55;
	$max_days = 90;

	$args = array(
		'post_type' => 'jobs',
		'post_status' => 'any',
		'posts_per_page' => -1
	);

	$jobs_query = new WP_Query($args);
	$current_date = date('Y-m-d');
	$updated_count = 0;

	while ($jobs_query->have_posts()) {
		$jobs_query->the_post();
		$job_id = get_the_ID();
		$publish_date = get_the_date('Y-m-d');
		$current_status = get_post_status();

		// Calculate expiration days
		$days_since_publish = (strtotime($current_date) - strtotime($publish_date)) / 86400;
		$random_additional_days = $min_days + ($job_id % ($max_days - $min_days + 1));
		$new_jobs_days_closing = ceil($days_since_publish) + $random_additional_days;

		// Update meta fields
		update_post_meta($job_id, CIVI_METABOX_PREFIX . 'enable_jobs_expires', '0');
		update_post_meta($job_id, CIVI_METABOX_PREFIX . 'enable_jobs_package_expires', '0');
		update_post_meta($job_id, CIVI_METABOX_PREFIX . 'jobs_days_closing', $new_jobs_days_closing);

		// Change expired and draft jobs to publish
		if ($current_status == 'expired' || $current_status == 'draft') {
			wp_update_post(array(
				'ID' => $job_id,
				'post_status' => 'publish'
			));
		}

		$updated_count++;
	}

	wp_reset_postdata();

	// Show completion notice
	if (is_admin()) {
		add_action('admin_notices', function() use ($updated_count) {
			echo '<div class="notice notice-success is-dismissible">';
			echo '<p><strong>Civi Jobs Fix:</strong> Đã cập nhật thành công ' . $updated_count . ' jobs!</p>';
			echo '</div>';
		});
	}
}

// Run once - uncomment to execute, then comment again
//civi_fix_all_jobs_expiration();



/**
* Fix all jobs expiration dates
* Reset expiration flags and update jobs_days_closing with random days
*/
function felan_fix_jobs_expiration() {
$min_days = 55;
$max_days = 90;

$args = array(
	'post_type' => 'jobs',
	'post_status' => 'any',
	'posts_per_page' => -1
);

$jobs_query = new WP_Query($args);
$current_date = date('Y-m-d');
$updated_count = 0;

while ($jobs_query->have_posts()) {
	$jobs_query->the_post();
	$job_id = get_the_ID();
	$publish_date = get_the_date('Y-m-d');
	$current_status = get_post_status();

	// Calculate expiration days
	$days_since_publish = (strtotime($current_date) - strtotime($publish_date)) / 86400;
	$random_additional_days = $min_days + ($job_id % ($max_days - $min_days + 1));
	$new_jobs_days_closing = ceil($days_since_publish) + $random_additional_days;

	// Update meta fields
	update_post_meta($job_id, FELAN_METABOX_PREFIX . 'enable_jobs_expires', '0');
	update_post_meta($job_id, FELAN_METABOX_PREFIX . 'enable_jobs_package_expires', '0');
	update_post_meta($job_id, FELAN_METABOX_PREFIX . 'jobs_days_closing', $new_jobs_days_closing);

	// Change expired jobs to publish
	if ($current_status == 'expired') {
		wp_update_post(array(
			'ID' => $job_id,
			'post_status' => 'publish'
		));
	}

	$updated_count++;
}

wp_reset_postdata();

// Show completion notice
if (is_admin()) {
	add_action('admin_notices', function() use ($updated_count) {
		echo '<div class="notice notice-success is-dismissible">';
		echo '<p><strong>Felan Jobs Fix:</strong> Đã cập nhật thành công ' . $updated_count . ' jobs!</p>';
		echo '</div>';
	});
}
}

// Run once - uncomment to execute, then comment again
// felan_fix_jobs_expiration();

