<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
wp_enqueue_style('lity');
wp_enqueue_script('lity');
$company_id = get_the_ID();
if (!empty($company_single_id)) {
    $company_id = $company_single_id;
}
$company_meta_data = get_post_custom($company_id);
$company_data = get_post($company_id);
$custom_field_company = felan_render_custom_field('company');
$image_src = FELAN_PLUGIN_URL . 'assets/images/bg-video.webp';
if (count($custom_field_company) <= 0) {
    return;
}
?>
<?php foreach ($custom_field_company as $key => $field) { ?>
    <?php switch ($field['type']) {
        case 'text':
            if (!empty($company_meta_data[$field['id']])) {
                $field_value = trim($company_meta_data[$field['id']][0]);
                if (!empty($field_value)) { ?>
                    <div class="block-archive-inner company-additional-text">
                        <div class="additional-warpper">
                            <h4 class="title-company"><?php echo $field['title']; ?></h4>
                            <div class="content">
                                <?php echo esc_html($field_value); ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }
            break;
        case 'url':
            if (!empty($company_meta_data[$field['id']])) {
                $url_value = trim($company_meta_data[$field['id']][0]);
                $oembed_content = wp_oembed_get($url_value, array('wmode' => 'transparent'));
                if (!empty($url_value) && !empty($oembed_content)) { ?>
                    <div class="block-archive-inner company-additional-url">
                        <div class="additional-warpper">
                            <h4 class="title-company"><?php echo $field['title']; ?></h4>
                            <div class="embed-responsive embed-responsive-16by9 embed-responsive-full">
                                <?php echo $oembed_content; ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }
            break;
        case 'textarea':
            if (!empty($company_meta_data[$field['id']])) {
                $field_value = trim($company_meta_data[$field['id']][0]);
                if (!empty($field_value)) { ?>
                    <div class="block-archive-inner company-additional-textarea">
                        <div class="additional-warpper">
                            <h4 class="title-company"><?php echo $field['title']; ?></h4>
                            <div class="content">
                                <?php echo nl2br(esc_html($field_value)); ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }
            break;
        case 'select':
            if (!empty($company_meta_data[$field['id']])) {
                $field_value = trim($company_meta_data[$field['id']][0]);
                if (!empty($field_value)) { ?>
                    <div class="block-archive-inner company-additional-select">
                        <div class="additional-warpper">
                            <h4 class="title-company"><?php echo $field['title']; ?></h4>
                            <div class="content">
                                <?php echo esc_html($field_value); ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }
            break;
        case 'checkbox_list':
            if (!empty($company_meta_data[$field['id']])) {
                $company_field = get_post_meta($company_data->ID, $field['id'], true);
                if (empty($company_field)) {
                    $company_field = array();
                }
                $has_selected = false;
                foreach ($field['options'] as $opt_value) {
                    if (in_array($opt_value, $company_field)) {
                        $has_selected = true;
                        break;
                    }
                }
                if ($has_selected) { ?>
                    <div class="block-archive-inner company-additional-checkbox_list">
                        <div class="additional-warpper">
                            <h4 class="title-company"><?php echo $field['title']; ?></h4>
                            <div class="content">
                                <?php foreach ($field['options'] as $opt_value) :
                                    if (in_array($opt_value, $company_field)) : ?>
                                        <div class="label label-skills"><?php echo esc_html($opt_value); ?></div>
                                <?php endif;
                                endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }
            break;
        case 'image':
            $company_field = get_post_meta($company_data->ID, $field['id'], true);
            if (!empty($company_field['url'])) { ?>
                <div class="block-archive-inner company-additional-image">

                    <div class="additional-warpper">
                        <h4 class="title-company"><?php echo $field['title']; ?></h4>
                        <img src="<?php echo esc_html($company_field['url']); ?>" alt="<?php echo esc_attr($field['title']); ?>" />
                    </div>
                </div>
<?php }
            break;
        case 'file':
            $company_field = get_post_meta($company_data->ID, $field['id'], true);
            $file_title = $file_url = '';
            if(!empty($company_field)){
                $file_title = get_the_title(intval($company_field));
                $file_url = wp_get_attachment_url(intval($company_field));
            }
            if (!empty($file_url)) { ?>
                <div class="block-archive-inner jobs-additional-upload">
                    <div class="additional-warpper">
                        <h4 class="title-jobs"><?php echo $field['title']; ?></h4>
                        <a class="felan-button" href="<?php echo esc_attr($file_url); ?>">
                            <i class="far fa-download"></i>
                            <?php echo esc_html($file_title); ?>
                        </a>
                    </div>
                </div>
            <?php }
            break;
    }
} ?>
