<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
$felan_project_payment = new Felan_project_payment();
$project_payment_method = isset($_GET['payment_method']) ? absint(wp_unslash($_GET['payment_method'])) : -1;
if ($project_payment_method == 1) {
    $felan_project_payment->paypal_payment_completed();
} elseif ($project_payment_method == 2) {
    $felan_project_payment->stripe_payment_completed();
} elseif ($project_payment_method == 4) {
    $felan_project_payment->razor_payment_completed();
}
?>
<div class="felan-payment-completed-wrap">
    <div class="inner-payment-completed">
        <?php
        do_action('felan_before_project_payment_completed');
        if (isset($_GET['order_id']) && $_GET['order_id'] != '') :
            $order_id = absint(wp_unslash($_GET['order_id']));
            $felan_project_order = new Felan_project_order();
            $order_meta = $felan_project_order->get_project_order_meta($order_id);
            $project_order_item_id = $order_meta['project_order_item_id'];
            // Wire Transfer Information
            $project_enable_wire_transfer = felan_get_option('project_enable_wire_transfer', '0');
            $project_wire_transfer_account_number = trim(felan_get_option('project_wire_transfer_account_number', ''));
            $project_wire_transfer_account_holder = trim(felan_get_option('project_wire_transfer_account_holder', ''));
            $project_wire_transfer_bank_name = trim(felan_get_option('project_wire_transfer_bank_name', ''));
            $project_wire_transfer_bank_address = trim(felan_get_option('project_wire_transfer_bank_address', ''));
            $project_wire_transfer_swift_bic = trim(felan_get_option('project_wire_transfer_swift_bic', ''));
            $project_wire_transfer_iban = trim(felan_get_option('project_wire_transfer_iban', ''));
            $project_wire_transfer_routing_number = trim(felan_get_option('project_wire_transfer_routing_number', ''));
            $project_wire_transfer_country = trim(felan_get_option('project_wire_transfer_country', ''));
            $project_wire_transfer_instructions = felan_get_option('project_wire_transfer_instructions', '');

            // Check if this is wire transfer payment
            $is_wire_transfer = isset($order_meta['project_order_payment_method']) && $order_meta['project_order_payment_method'] == 3;
        ?>

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h2><?php esc_html_e('Payment Successful', 'felan-framework'); ?></h2>
                </div>

                <?php if ($is_wire_transfer && $project_enable_wire_transfer === '1') : ?>
                    <p><?php esc_html_e('Please transfer to our account number with the "Order Number" and wait for us to confirm.', 'felan-framework'); ?></p>
                <?php endif; ?>

                <?php if ($is_wire_transfer && $project_enable_wire_transfer === '1' && (!empty($project_wire_transfer_account_number) || !empty($project_wire_transfer_account_holder) || !empty($project_wire_transfer_bank_name))) : ?>
                    <div class="card-info wire-transfer-info">
                        <h3><?php esc_html_e('Wire Transfer Details', 'felan-framework'); ?></h3>
                        <table>
                            <?php if (!empty($project_wire_transfer_country)) : ?>
                            <tr>
                                <th><?php esc_html_e('Country', 'felan-framework'); ?></th>
                                <td><?php echo esc_html($project_wire_transfer_country); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($project_wire_transfer_account_number)) : ?>
                            <tr>
                                <th><?php esc_html_e('Account Number', 'felan-framework'); ?></th>
                                <td><?php echo esc_html($project_wire_transfer_account_number); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($project_wire_transfer_account_holder)) : ?>
                            <tr>
                                <th><?php esc_html_e('Account Holder Name', 'felan-framework'); ?></th>
                                <td><?php echo esc_html($project_wire_transfer_account_holder); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($project_wire_transfer_bank_name)) : ?>
                            <tr>
                                <th><?php esc_html_e('Bank Name', 'felan-framework'); ?></th>
                                <td><?php echo esc_html($project_wire_transfer_bank_name); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($project_wire_transfer_bank_address)) : ?>
                            <tr>
                                <th><?php esc_html_e('Bank Address', 'felan-framework'); ?></th>
                                <td><?php echo nl2br(esc_html($project_wire_transfer_bank_address)); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($project_wire_transfer_swift_bic)) : ?>
                            <tr>
                                <th><?php esc_html_e('SWIFT/BIC Code', 'felan-framework'); ?></th>
                                <td><?php echo esc_html($project_wire_transfer_swift_bic); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($project_wire_transfer_iban)) : ?>
                            <tr>
                                <th><?php esc_html_e('IBAN', 'felan-framework'); ?></th>
                                <td><?php echo esc_html($project_wire_transfer_iban); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($project_wire_transfer_routing_number)) : ?>
                            <tr>
                                <th><?php esc_html_e('Routing Number / ABA', 'felan-framework'); ?></th>
                                <td><?php echo esc_html($project_wire_transfer_routing_number); ?></td>
                            </tr>
                            <?php endif; ?>
                        </table>
                        <?php if (!empty($project_wire_transfer_instructions)) : ?>
                            <div class="wire-transfer-instructions">
                                <h4><?php esc_html_e('Additional Instructions', 'felan-framework'); ?></h4>
                                <?php echo wp_kses_post($project_wire_transfer_instructions); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="entry-title">
                    <h3><?php esc_html_e('Order Detail', 'felan-framework'); ?></h3>
                </div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <span><?php esc_html_e('Order Number', 'felan-framework'); ?></span>
                        <strong class="pull-right"><?php echo esc_html($order_id); ?></strong>
                    </li>
                    <li class="list-group-item">
                        <span><?php esc_html_e('Date', 'felan-framework'); ?></span>
                        <strong class="pull-right"><?php echo get_the_date('', $order_id); ?></strong>
                    </li>
                    <li class="list-group-item">
                        <span><?php esc_html_e('Payment Method', 'felan-framework'); ?></span>
                        <strong class="pull-right">
                            <?php echo Felan_project_order::get_project_order_payment_method($order_meta['project_order_payment_method']);  ?>
                        </strong>
                    </li>
                    <li class="list-group-item">
                        <span><?php esc_html_e('Total', 'felan-framework'); ?></span>
                        <strong class="pull-right"><?php echo $order_meta['project_order_item_price']; ?></strong>
                    </li>
                </ul>
            </div>
            <a href="<?php echo esc_url(get_permalink($project_order_item_id)); ?>" class="felan-button"><?php esc_html_e('Go to Proposal detail', 'felan-framework'); ?></a>
        <?php else : ?>
            <div class="felan-heading">
                <h2><?php esc_html_e('Payment Successful', 'felan-framework'); ?></h2>
            </div>
            <div class="felan-thankyou-content">
                <?php esc_html_e('Payment Successful! Your package has been successfully updated.', 'felan-framework'); ?>
            </div>
            <a href="<?php echo esc_url(get_permalink($project_order_item_id)); ?>" class="felan-button"> <?php esc_html_e('Go to Dashboard', 'felan-framework'); ?> </a>
        <?php endif;
        do_action('felan_after_project_payment_completed');
        ?>
    </div>
</div>
