<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
wp_enqueue_script(FELAN_PLUGIN_PREFIX . 'employer-review-freelancer');
wp_localize_script(
    FELAN_PLUGIN_PREFIX . 'employer-review-freelancer',
    'felan_freelancer_review_vars',
    array(
        'ajax_url' => FELAN_AJAX_URL,
        'errors' => array(
            'freelancer_id_missing' => esc_html__('Freelancer ID is missing.', 'felan-framework'),
            'message_required' => esc_html__('Please enter your review message.', 'felan-framework'),
            'ratings_required' => esc_html__('Please select all rating fields.', 'felan-framework'),
            'submit_error' => esc_html__('Error submitting review.', 'felan-framework'),
            'submission_failed' => esc_html__('Submission failed', 'felan-framework'),
        ),
    )
);
global $current_user;
$user_id = $current_user->ID;
$project_id = isset($_GET['project_id']) ? felan_clean(wp_unslash($_GET['project_id'])) : '';
$applicants_id = isset($_GET['applicants_id']) ? felan_clean(wp_unslash($_GET['applicants_id'])) : '';
$pages = isset($_GET['pages']) ? felan_clean(wp_unslash($_GET['pages'])) : '';
$projects_submit = felan_get_permalink('projects_submit');
?>

<div class="felan-employer-service entry-my-page">
	<?php felan_withdraw_noti_print('featured_project','You will be charged %s for a featured project.'); ?>
	<div class="entry-title">
		<h4><?php esc_html_e('Proposals', 'felan-framework'); ?></h4>
	</div>
	<?php felan_get_template('dashboard/employer/project/proposals.php'); ?>
</div>
