<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

global $freelancer_data, $freelancer_meta_data;

switch ($field['type']) {
    case 'text': ?>
        <div class="form-group col-lg-6">
            <label><?php echo esc_html($field['title']); ?></label>
            <input type="text" id="<?php echo esc_attr($field['id']); ?>" class="form-control" name="<?php echo esc_attr($field['id']); ?>" value="<?php if (isset($freelancer_meta_data[$field['id']])) {
                                                                                                                                                        echo sanitize_text_field($freelancer_meta_data[$field['id']][0]);
                                                                                                                                                    } ?>" placeholder="<?php esc_attr_e('Your Value', 'felan-framework'); ?>">
        </div>
    <?php
        break;
    case 'url':
    ?>
        <div class="form-group col-lg-6">
            <label><?php echo esc_html($field['title']); ?></label>
            <input type="url" id="<?php echo esc_attr($field['id']); ?>" class="form-control" name="<?php echo esc_attr($field['id']); ?>" value="<?php if (isset($freelancer_meta_data[$field['id']])) {
                                                                                                                                                        echo sanitize_text_field($freelancer_meta_data[$field['id']][0]);
                                                                                                                                                    } ?>" placeholder="<?php esc_attr_e('Your Url', 'felan-framework'); ?>">
        </div>
    <?php
        break;
    case 'textarea':
    ?>
        <div class="form-group col-12">
            <label><?php echo esc_html($field['title']); ?></label>
            <textarea name="<?php echo esc_attr($field['id']); ?>" rows="6" id="<?php echo esc_attr($field['id']); ?>" class="form-control"><?php if (isset($freelancer_meta_data[$field['id']])) {
                                                                                                                                                echo esc_textarea($freelancer_meta_data[$field['id']][0]);
                                                                                                                                            } ?></textarea>
        </div>
    <?php
        break;
    case 'select':
    ?>
        <div class="form-group col-lg-6">
            <label class="d-block"><?php echo esc_html($field['title']); ?></label>
            <div class="select2-field">
                <select name="<?php echo esc_attr($field['id']); ?>" id="<?php echo esc_attr($field['id']); ?>" class="form-control felan-select2">
                    <?php
                    foreach ($field['options'] as $opt_value) : ?>
                        <option value="<?php echo esc_attr($opt_value); ?>" <?php if (isset($freelancer_meta_data[$field['id']]) && $freelancer_meta_data[$field['id']][0] == $opt_value) {
                                                                                echo 'selected';
                                                                            } ?>><?php echo esc_html($opt_value); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    <?php
        break;
    case 'checkbox_list':
    ?>
        <div class="form-group col-lg-6">
            <label><?php echo esc_html($field['title']); ?></label>
            <div class="felan-field-<?php echo esc_attr($field['id']); ?>">
                <?php
                $freelancer_field = isset($freelancer_data->ID) ? get_post_meta($freelancer_data->ID, $field['id'], true) : array();
                if (empty($freelancer_field)) {
                    $freelancer_field = array();
                }
                foreach ($field['options'] as $opt_value) :
                    if (in_array($opt_value, $freelancer_field)) : ?>
                        <div class="checkbox-inline inline"><input class="custom-checkbox" type="checkbox" name="<?php echo esc_attr($field['id']); ?>[]" value="<?php echo esc_attr($opt_value); ?>" checked><?php echo esc_html($opt_value); ?>
                        </div>
                    <?php else : ?>
                        <div class="checkbox-inline inline"><input class="custom-checkbox" type="checkbox" name="<?php echo esc_attr($field['id']); ?>[]" value="<?php echo esc_attr($opt_value); ?>"><?php echo esc_html($opt_value); ?>
                        </div>
                <?php endif;
                endforeach; ?>
            </div>
        </div>
    <?php
        break;
    case 'image':
        felan_get_custom_image_enqueue();
        $freelancer_field = isset($freelancer_data->ID) ? get_post_meta($freelancer_data->ID, $field['id'], true) : array();
        $custom_image_id = !empty($freelancer_field['id']) ? $freelancer_field['id'] : '';
        $custom_image_url = !empty($freelancer_field['url']) ? $freelancer_field['url'] : '';
    ?>
        <div class="form-group col-12 felan-fields-custom_image">
            <label><?php echo esc_html($field['title']); ?></label>
            <div class="felan-field-<?php echo esc_attr($field['id']); ?>">
                <div id="felan_custom_image_errors_<?php echo esc_attr($field['id']); ?>" class="errors-log"></div>
                <div id="felan_custom_image_container_<?php echo esc_attr($field['id']); ?>" class="file-upload-block preview">
                    <div id="felan_custom_image_view_<?php echo esc_attr($field['id']); ?>" class="custom-image-view"></div>
                    <div id="felan_add_custom_image_<?php echo esc_attr($field['id']); ?>" class="custom-image-add">
                        <i class="far fa-arrow-from-bottom large"></i>
                        <p id="felan_drop_custom_image_<?php echo esc_attr($field['id']); ?>">
                            <button type="button" id="felan_select_custom_image_<?php echo esc_attr($field['id']); ?>" class="select-custom-image"><?php esc_html_e('Click here', 'felan-framework') ?></button>
                            <?php esc_html_e(' or drop files to upload', 'felan-framework') ?>
                        </p>
                    </div>
                    <input type="hidden" class="custom_image_url" value="<?php echo esc_url($custom_image_url); ?>" id="custom_image_url_<?php echo esc_attr($field['id']); ?>">
                    <input type="hidden" class="custom_image_id" value="<?php echo esc_attr($custom_image_id); ?>" id="custom_image_id_<?php echo esc_attr($field['id']); ?>" />
                </div>
            </div>
            <p class="felan-custom_image-size"><?php esc_html_e('The cover image size should be max 1920 x 400px', 'felan-framework') ?></p>
            <input type="hidden" class="image-id" value="<?php echo esc_attr($field['id']); ?>">
        </div>
    <?php
        break;
    case 'file':
        felan_get_custom_cv_enqueue();
        $cv_file = felan_get_option('felan-cv-type');
        $freelancer_field = isset($freelancer_data->ID) ? get_post_meta($freelancer_data->ID, $field['id'], true) : '';
        $file_title = '';
        if (!empty($freelancer_field)) {
            $file_title = get_the_title(intval($freelancer_field));
        }
    ?>
        <div class="form-group col-12 felan-fields-custom_upload">
            <label><?php echo esc_html($field['title']); ?></label>
            <div class="felan-field-<?php echo esc_attr($field['id']); ?>">
                <div id="cv_errors_log_<?php echo esc_attr($field['id']); ?>" class="errors-log"></div>
                <div id="felan_cv_container_<?php echo esc_attr($field['id']); ?>" class="file-upload-block">
                    <?php if ($freelancer_field && $file_title) : ?>
                        <div class="file-uploaded-item">
                            <div class="file-info">
                                <i class="far fa-file-alt"></i>
                                <span class="file-name"><?php echo esc_html($file_title); ?></span>
                            </div>
                            <div class="media-item-actions">
                                <a href="#" class="icon-file-delete" data-field-id="<?php echo esc_attr($field['id']); ?>" data-attachment-id="<?php echo esc_attr($freelancer_field); ?>">
                                    <i class="far fa-trash-alt"></i>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="file-upload-button" id="felan_cv_upload_<?php echo esc_attr($field['id']); ?>" <?php echo $freelancer_field ? 'style="display:none;"' : ''; ?>>
                        <button class="felan-button" type="button" id="felan_select_cv_<?php echo esc_attr($field['id']); ?>">
                            <i class="far fa-arrow-from-bottom"></i>
                            <span><?php esc_html_e('Browse', 'felan-framework'); ?></span>
                        </button>
                    </div>
                    <input type="hidden" class="cv_attachment_id" name="<?php echo esc_attr($field['id']); ?>" value="<?php echo esc_attr($freelancer_field); ?>" id="cv_attachment_id_<?php echo esc_attr($field['id']); ?>" data-initial-value="<?php echo esc_attr($freelancer_field); ?>">
                </div>
            </div>
            <div class="file-type"><?php echo esc_html(sprintf(__('Upload file: %s', 'felan-framework'), $cv_file)); ?></div>
        </div>
<?php
        break;
} ?>
