<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Check if project post type is enabled
$enable_post_type_project = felan_get_option('enable_post_type_project', '1');
if ($enable_post_type_project !== '1') {
    felan_get_template('global/access-denied.php', array('type' => 'not_available'));
    return;
}

if (!is_user_logged_in()) {
    felan_get_template('global/access-denied.php', array('type' => 'not_login'));
    return;
}

global $current_user;
$user_id = $current_user->ID;
$user_email = $current_user->user_email;

// Enqueue scripts and styles (following codebase pattern)
// Note: select2 is already enqueued globally in template-loader, but we ensure it's loaded
wp_enqueue_script('select2');
wp_enqueue_style('select2');

// Get package limits
if (!class_exists('Felan_Project_Alert_Package')) {
    include_once FELAN_PLUGIN_DIR . 'includes/partials/project-alert/class-felan-project-alert-package.php';
}
$package_handler = new Felan_Project_Alert_Package();
$package_info = $package_handler->get_package_info($user_id);
$package_limits = $package_handler->get_package_limits($user_id);

// Check if alerts are enabled for user's package
$alerts_enabled = $package_limits['alerts']['enabled'];

// Get allowed taxonomies for current user
$freelancer_package_id = get_user_meta($user_id, FELAN_METABOX_PREFIX . 'freelancer_package_id', true);
$allowed_taxonomies = $package_handler->get_allowed_taxonomies($user_id, $freelancer_package_id);

// Enqueue project alerts script (already registered in template-loader)
// Dependencies: jquery, select2 (handled automatically by WordPress)
wp_enqueue_script(FELAN_PLUGIN_PREFIX . 'project-alerts');

// Localize script (following codebase pattern - called right after enqueue)
wp_localize_script(
    FELAN_PLUGIN_PREFIX . 'project-alerts',
    'felan_project_alerts_vars',
    array(
        'ajax_url' => FELAN_AJAX_URL,
        'nonce' => wp_create_nonce('felan_project_alerts_nonce'),
        'success_message' => esc_html__('Project alert created successfully! You will receive notifications when matching projects are published.', 'felan-framework'),
        'error_message' => esc_html__('An error occurred. Please try again.', 'felan-framework'),
        'validation_email' => esc_html__('Please enter a valid email address', 'felan-framework'),
        'validation_taxonomy' => esc_html__('Please select at least one taxonomy (category, skill, language, career, or location)', 'felan-framework'),
        'validation_match_type' => esc_html__('Please select a match type', 'felan-framework'),
        'validation_frequency' => esc_html__('Please select a notification frequency', 'felan-framework'),
        'no_taxonomies_selected' => esc_html__('No taxonomies selected yet', 'felan-framework'),
        'text_limit_exceeded' => esc_html__('You can only select up to %d %s. Please reduce your selection.', 'felan-framework'),
        'label_categories' => esc_html__('Categories', 'felan-framework'),
        'label_skills' => esc_html__('Skills', 'felan-framework'),
        'label_language' => esc_html__('Languages', 'felan-framework'),
        'label_career' => esc_html__('Careers', 'felan-framework'),
        'label_location' => esc_html__('Location', 'felan-framework'),
        'label_state' => esc_html__('State/Province', 'felan-framework'),
        'label_match_type' => esc_html__('Match Type', 'felan-framework'),
        'label_frequency' => esc_html__('Notification Frequency', 'felan-framework'),
        'delete_confirm' => esc_html__('Are you sure you want to delete this alert?', 'felan-framework'),
        'delete_success' => esc_html__('Alert deleted successfully', 'felan-framework'),
        'update_success' => esc_html__('Alert updated successfully', 'felan-framework'),
        'edit_alert' => esc_html__('Edit Alert', 'felan-framework'),
        'delete_alert' => esc_html__('Delete', 'felan-framework'),
        'cancel' => esc_html__('Cancel', 'felan-framework'),
        'save_changes' => esc_html__('Save Changes', 'felan-framework'),
        'loading' => esc_html__('Loading...', 'felan-framework'),
        'editing_alert' => esc_html__('Editing', 'felan-framework'),
        'create_alert' => esc_html__('Create Project Alert', 'felan-framework'),
        'title' => esc_html__('Project Alerts', 'felan-framework'),
        'back_to_list' => esc_html__('Back to List', 'felan-framework'),
        'upgrade_url' => felan_get_permalink('freelancer_package'),
        'package_limits' => $package_info,
        // Additional error messages
        'network_error' => esc_html__('Network error. Please check your connection and try again.', 'felan-framework'),
        'server_error' => esc_html__('Server error. Please try again later.', 'felan-framework'),
        'generic_error' => esc_html__('An error occurred. Please refresh the page and try again.', 'felan-framework'),
        // Form text
        'select_option' => esc_html__('Select an option', 'felan-framework'),
        'search' => esc_html__('Search', 'felan-framework'),
        'just_now' => esc_html__('Just now', 'felan-framework'),
        'minute' => esc_html__('minute', 'felan-framework'),
        'minutes' => esc_html__('minutes', 'felan-framework'),
        'hour' => esc_html__('hour', 'felan-framework'),
        'hours' => esc_html__('hours', 'felan-framework'),
        'day' => esc_html__('day', 'felan-framework'),
        'days' => esc_html__('days', 'felan-framework'),
        'ago' => esc_html__('ago', 'felan-framework'),
        // Package text
        'alert_limit_reached' => esc_html__('Alert Limit Reached', 'felan-framework'),
        'upgrade_package' => esc_html__('Upgrade Package', 'felan-framework'),
        'text_limit_reached' => esc_html__('You have reached your alert limit.', 'felan-framework'),
    )
);
?>

<div class="felan-project-alerts-wrapper">
    <div class="felan-project-alerts-title">
        <h2><?php esc_html_e('Project Alerts', 'felan-framework'); ?></h2>
        <p class="title-description"><?php esc_html_e('Create alerts to get notified when new projects match your criteria', 'felan-framework'); ?></p>
    </div>

    <?php
    // Include alerts list
    felan_get_template('dashboard/freelancer/project-alerts/alerts-list.php', array(
        'user_id' => $user_id,
        'user_email' => $user_email,
        'alerts_enabled' => $alerts_enabled,
    ));
    ?>

    <?php if ($alerts_enabled) : ?>
        <?php
        // Include edit mode banner
        felan_get_template('dashboard/freelancer/project-alerts/alerts-edit-banner.php');
        ?>

        <?php
        // Include form wrapper
        felan_get_template('dashboard/freelancer/project-alerts/alerts-form.php', array(
            'user_email' => $user_email,
            'allowed_taxonomies' => $allowed_taxonomies,
        ));
        ?>
    <?php else : ?>
        <div class="felan-message alert alert-warning" role="alert">
            <strong><?php esc_html_e('Project alerts are not enabled for your package.', 'felan-framework'); ?></strong>
            <p><?php esc_html_e('Please upgrade your package to create project alerts.', 'felan-framework'); ?></p>
            <a href="<?php echo esc_url(felan_get_permalink('freelancer_package')); ?>" class="btn btn-primary">
                <?php esc_html_e('Upgrade Package', 'felan-framework'); ?>
            </a>
        </div>
    <?php endif; ?>
</div>

<?php
// Include confirm modal for delete action
felan_get_template('global/confirm-modal.php', array(
    'title' => esc_html__('Delete Alert', 'felan-framework'),
    'message' => esc_html__('Are you sure you want to delete this alert? This action cannot be undone.', 'felan-framework'),
    'confirm_text' => esc_html__('Delete', 'felan-framework'),
    'cancel_text' => esc_html__('Cancel', 'felan-framework'),
    'modal_id' => 'felan-confirm-delete-alert',
    'confirm_class' => 'btn-confirm-delete-alert',
    'cancel_class' => 'btn-cancel-delete-alert'
));
?>
