<?php
/**
 * Project Alerts Form Fields Template
 *
 * @var string $user_email Current user email
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Extract variables
$user_email = isset($user_email) ? $user_email : '';
$allowed_taxonomies = isset($allowed_taxonomies) ? $allowed_taxonomies : array();

// If no allowed taxonomies specified, default to all (for backward compatibility)
if (empty($allowed_taxonomies)) {
    $allowed_taxonomies = array('categories', 'skills', 'language', 'career', 'location');
    $enable_option_state = felan_get_option('enable_option_state', '0');
    if ($enable_option_state === '1') {
        $allowed_taxonomies[] = 'state';
    }
}
?>

<!-- Hidden field for alert ID (used when editing) -->
<input type="hidden" id="alert-id" name="alert_id" value="" />

<div class="form-grid">
    <!-- Alert Name -->
    <div class="form-field field-text">
        <label for="alert-name" id="alert-name-label">
            <i class="far fa-tag" aria-hidden="true"></i>
            <?php esc_html_e('Alert Name', 'felan-framework'); ?>
            <span class="optional"><?php esc_html_e('(Optional)', 'felan-framework'); ?></span>
        </label>
        <input
            type="text"
            id="alert-name"
            name="name"
            class="form-input"
            placeholder="<?php esc_attr_e('e.g., My Project Alert', 'felan-framework'); ?>"
            autocomplete="name"
            aria-label="<?php esc_attr_e('Alert Name', 'felan-framework'); ?>"
        />
    </div>

    <!-- Email -->
    <div class="form-field field-email">
        <label for="alert-email" id="alert-email-label">
            <i class="far fa-envelope" aria-hidden="true"></i>
            <?php esc_html_e('Email', 'felan-framework'); ?>
            <span class="required">*</span>
        </label>
        <input
            type="email"
            id="alert-email"
            name="email"
            class="form-input"
            value="<?php echo esc_attr($user_email); ?>"
            placeholder="<?php esc_attr_e('your@email.com', 'felan-framework'); ?>"
            autocomplete="email"
            readonly
            required
            aria-label="<?php esc_attr_e('Email', 'felan-framework'); ?>"
            aria-required="true"
        />
    </div>

    <!-- Project Categories -->
    <?php if (in_array('categories', $allowed_taxonomies)) : ?>
    <div class="form-field field-select">
        <label for="alert-categories" id="alert-categories-label">
            <i class="far fa-folder" aria-hidden="true"></i>
            <?php esc_html_e('Project Categories', 'felan-framework'); ?>
            <span class="package-limit-info ms-2" style="font-size: 0.9em; margin-left: 5px; color: #666;"></span>
        </label>
        <div class="form-select">
            <select
                id="alert-categories"
                name="categories[]"
                data-taxonomy="categories"
                class="felan-select2"
                multiple="multiple"
                data-placeholder="<?php esc_attr_e('Select categories', 'felan-framework'); ?>"
                autocomplete="off"
                aria-label="<?php esc_attr_e('Project categories', 'felan-framework'); ?>"
            >
                <?php felan_get_taxonomy('project-categories', false, false); ?>
            </select>
        </div>
    </div>
    <?php endif; ?>

    <!-- Project Skills -->
    <?php if (in_array('skills', $allowed_taxonomies)) : ?>
    <div class="form-field field-select">
        <label for="alert-skills" id="alert-skills-label">
            <i class="far fa-tags" aria-hidden="true"></i>
            <?php esc_html_e('Project Skills', 'felan-framework'); ?>
            <span class="package-limit-info ms-2" style="font-size: 0.9em; margin-left: 5px; color: #666;"></span>
        </label>
        <div class="form-select">
            <select
                id="alert-skills"
                name="skills[]"
                data-taxonomy="skills"
                class="felan-select2"
                multiple="multiple"
                data-placeholder="<?php esc_attr_e('Select skills', 'felan-framework'); ?>"
                autocomplete="off"
                aria-label="<?php esc_attr_e('Project skills', 'felan-framework'); ?>"
            >
                <?php felan_get_taxonomy('freelancer_skills', false, false); ?>
            </select>
        </div>
    </div>
    <?php endif; ?>

    <!-- Project Language -->
    <?php if (in_array('language', $allowed_taxonomies)) : ?>
    <div class="form-field field-select">
        <label for="alert-language" id="alert-language-label">
            <i class="far fa-globe" aria-hidden="true"></i>
            <?php esc_html_e('Project Language', 'felan-framework'); ?>
            <span class="package-limit-info ms-2" style="font-size: 0.9em; margin-left: 5px; color: #666;"></span>
        </label>
        <div class="form-select">
            <select
                id="alert-language"
                name="language[]"
                data-taxonomy="language"
                class="felan-select2"
                multiple="multiple"
                data-placeholder="<?php esc_attr_e('Select languages', 'felan-framework'); ?>"
                autocomplete="off"
                aria-label="<?php esc_attr_e('Project languages', 'felan-framework'); ?>"
            >
                <?php felan_get_taxonomy('project-language', false, false); ?>
            </select>
        </div>
    </div>
    <?php endif; ?>

    <!-- Project Career -->
    <?php if (in_array('career', $allowed_taxonomies)) : ?>
    <div class="form-field field-select">
        <label for="alert-career" id="alert-career-label">
            <i class="far fa-briefcase" aria-hidden="true"></i>
            <?php esc_html_e('Project Career', 'felan-framework'); ?>
            <span class="package-limit-info ms-2" style="font-size: 0.9em; margin-left: 5px; color: #666;"></span>
        </label>
        <div class="form-select">
            <select
                id="alert-career"
                name="career[]"
                data-taxonomy="career"
                class="felan-select2"
                multiple="multiple"
                data-placeholder="<?php esc_attr_e('Select careers', 'felan-framework'); ?>"
                autocomplete="off"
                aria-label="<?php esc_attr_e('Project careers', 'felan-framework'); ?>"
            >
                <?php felan_get_taxonomy('project-career', false, false); ?>
            </select>
        </div>
    </div>
    <?php endif; ?>

    <!-- Location -->
    <?php if (in_array('location', $allowed_taxonomies)) : ?>
    <div class="form-field field-select">
        <label for="alert-location" id="alert-location-label">
            <i class="far fa-map-marker-alt" aria-hidden="true"></i>
            <?php esc_html_e('Location', 'felan-framework'); ?>
            <span class="package-limit-info ms-2" style="font-size: 0.9em; margin-left: 5px; color: #666;"></span>
        </label>
        <div class="form-select">
            <select
                id="alert-location"
                name="location[]"
                data-taxonomy="location"
                class="felan-select2"
                multiple="multiple"
                data-placeholder="<?php esc_attr_e('Select locations', 'felan-framework'); ?>"
                autocomplete="address-level2"
                aria-label="<?php esc_attr_e('Location', 'felan-framework'); ?>"
            >
                <?php felan_get_taxonomy('felan_location', false, false); ?>
            </select>
        </div>
    </div>
    <?php endif; ?>

    <!-- State (Optional) -->
    <?php if (felan_get_option('enable_option_state') === '1' && in_array('state', $allowed_taxonomies)) : ?>
        <div class="form-field field-select">
            <label for="alert-state" id="alert-state-label">
                <i class="far fa-map" aria-hidden="true"></i>
                <?php esc_html_e('State/Province', 'felan-framework'); ?>
                <span class="package-limit-info ms-2" style="font-size: 0.9em; margin-left: 5px; color: #666;"></span>
                <span class="optional"><?php esc_html_e('(Optional)', 'felan-framework'); ?></span>
            </label>
            <div class="form-select">
                <select
                    id="alert-state"
                    name="state[]"
                    data-taxonomy="state"
                    class="felan-select2"
                    multiple="multiple"
                    data-placeholder="<?php esc_attr_e('Select states', 'felan-framework'); ?>"
                    autocomplete="address-level1"
                    aria-label="<?php esc_attr_e('State/Province', 'felan-framework'); ?>"
                >
                    <?php felan_get_taxonomy('felan_state', false, false); ?>
                </select>
            </div>
        </div>
    <?php endif; ?>

    <!-- Match Type -->
    <div class="form-field field-select">
        <label for="alert-match-type" id="alert-match-type-label">
            <i class="far fa-filter" aria-hidden="true"></i>
            <?php esc_html_e('Match Type', 'felan-framework'); ?>
            <span class="required">*</span>
        </label>
        <div class="form-select">
            <select
                id="alert-match-type"
                name="match_type"
                class="felan-select2"
                required
                data-placeholder="<?php esc_attr_e('Select match type', 'felan-framework'); ?>"
                autocomplete="off"
                aria-label="<?php esc_attr_e('Match Type', 'felan-framework'); ?>"
                aria-required="true"
            >
                <option value=""><?php esc_html_e('Select match type', 'felan-framework'); ?></option>
                <option value="OR"><?php esc_html_e('OR - Match any selected taxonomy', 'felan-framework'); ?></option>
                <option value="AND"><?php esc_html_e('AND - Match all selected taxonomies', 'felan-framework'); ?></option>
            </select>
        </div>
        <div class="field-error" role="alert" style="display: none;"></div>
        <small class="help-text">
            <?php esc_html_e('OR: Notify when project matches ANY selected criteria. AND: Notify only when project matches ALL selected criteria.', 'felan-framework'); ?>
        </small>
    </div>

    <!-- Notification Frequency -->
    <div class="form-field field-select">
        <label for="alert-frequency" id="alert-frequency-label">
            <i class="far fa-clock" aria-hidden="true"></i>
            <?php esc_html_e('Notification Frequency', 'felan-framework'); ?>
            <span class="required">*</span>
        </label>
        <div class="form-select">
            <select
                id="alert-frequency"
                name="frequency"
                class="felan-select2"
                required
                data-placeholder="<?php esc_attr_e('Select frequency', 'felan-framework'); ?>"
                autocomplete="off"
                aria-label="<?php esc_attr_e('Notification Frequency', 'felan-framework'); ?>"
                aria-required="true"
            >
                <option value=""><?php esc_html_e('Select frequency', 'felan-framework'); ?></option>
                <option value="daily"><?php esc_html_e('Daily', 'felan-framework'); ?></option>
                <option value="weekly"><?php esc_html_e('Weekly', 'felan-framework'); ?></option>
                <option value="monthly"><?php esc_html_e('Monthly', 'felan-framework'); ?></option>
            </select>
        </div>
    </div>
</div>

<!-- Progress Indicator -->
<div class="form-progress" id="form-progress" role="status" aria-live="polite" style="display: none;">
    <div class="progress-header">
        <span class="progress-title">
            <i class="far fa-check-circle" aria-hidden="true"></i>
            <?php esc_html_e('Selected Taxonomies', 'felan-framework'); ?>
        </span>
        <span class="progress-count">
            <span id="selected-count">0</span> <?php esc_html_e('items', 'felan-framework'); ?>
        </span>
    </div>
    <div class="progress-details" id="progress-details">
        <div class="progress-empty">
            <?php esc_html_e('No taxonomies selected yet', 'felan-framework'); ?>
        </div>
    </div>
</div>

<!-- Notice/Error Messages -->
<div class="form-notice" id="form-notice" role="alert" aria-live="assertive"></div>

<!-- Submit Button -->
<div class="form-submit">
    <button type="submit" id="submit-alert" class="btn btn-primary">
        <span class="btn-text"><?php esc_html_e('Create Project Alert', 'felan-framework'); ?></span>
        <span class="btn-loading" style="display: none;">
            <i class="far fa-spinner fa-spin" aria-hidden="true"></i>
            <?php esc_html_e('Creating...', 'felan-framework'); ?>
        </span>
    </button>
</div>

