<?php
/**
 * Project Alerts Form Wrapper Template
 *
 * @var string $user_email Current user email
 * @var array $allowed_taxonomies Array of allowed taxonomy slugs
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Extract variables
$user_email = isset($user_email) ? $user_email : '';
$allowed_taxonomies = isset($allowed_taxonomies) ? $allowed_taxonomies : array();
?>

<?php
// Check if we're in edit mode from URL parameter
$edit_id = isset($_GET['edit']) ? absint($_GET['edit']) : 0;
$is_edit_mode = $edit_id > 0;
?>
<!-- Create/Edit Form (hidden by default, unless in edit mode) -->
<div class="project-alerts-form-wrapper" id="project-alerts-form-wrapper" style="<?php echo $is_edit_mode ? 'display: block;' : 'display: none;'; ?>">
    <div class="form-header">
        <h3 class="form-title">
            <i id="form-title-icon" class="far <?php echo $is_edit_mode ? 'fa-edit' : 'fa-plus-circle'; ?>" aria-hidden="true"></i>
            <span id="form-title-text"><?php echo $is_edit_mode ? esc_html__('Edit Project Alert', 'felan-framework') : esc_html__('Create Project Alert', 'felan-framework'); ?></span>
        </h3>
        <button type="button" class="btn-back-to-list" id="btn-back-to-list" aria-label="<?php esc_attr_e('Back to alerts list', 'felan-framework'); ?>">
            <i class="far fa-arrow-left" aria-hidden="true"></i>
            <span class="btn-text"><?php esc_html_e('Back to List', 'felan-framework'); ?></span>
        </button>
    </div>

    <form id="project-alerts-form" class="project-alerts-form" method="POST" action="#" novalidate>
        <?php
        // Include form fields
        felan_get_template('dashboard/freelancer/project-alerts/alerts-form-fields.php', array(
            'user_email' => $user_email,
            'allowed_taxonomies' => $allowed_taxonomies,
        ));
        ?>
    </form>

    <!-- Sticky Submit Button (shows when original button is out of view) -->
    <div class="form-submit-sticky" id="form-submit-sticky" style="display: none;">
        <div class="sticky-submit-wrapper">
            <button type="button" id="submit-alert-sticky" class="btn btn-primary">
                <span class="btn-text"><?php esc_html_e('Create Project Alert', 'felan-framework'); ?></span>
                <span class="btn-loading" style="display: none;">
                    <i class="far fa-spinner fa-spin" aria-hidden="true"></i>
                    <?php esc_html_e('Creating...', 'felan-framework'); ?>
                </span>
            </button>
        </div>
    </div>
</div>

