<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
global $current_user;
?>
<?php if (!empty($data_notification)) { ?>
	<div class="head-noti">
		<div class="head-left">
			<span class="noti-refresh">
				<i class="far fa-sync"></i>
				<?php esc_html_e('Refresh', 'felan-framework'); ?>
			</span>
			<span class="noti-clear">
				<i class="far fa-trash-alt"></i>
				<?php esc_html_e('Clear All', 'felan-framework'); ?>
			</span>
		</div>
		<a href="#" class="close-noti">
			<i class="far fa-times"></i>
		</a>
	</div>
	<ul>
		<?php foreach ($data_notification as $data) {
			$post_id = $data->ID;
			$user_send_id = get_post_meta($post_id, FELAN_METABOX_PREFIX . 'user_send_noti', true);
			$user_avatar = get_the_author_meta('author_avatar_image_url', $user_send_id);
			$user_send = felan_get_user_display_name($user_send_id);
			$time = human_time_diff(get_the_time('U', $post_id), current_time('timestamp'));
			$mess_noti = get_post_meta($post_id, FELAN_METABOX_PREFIX . 'mess_noti', true);

			// Check if notification is read
			$is_read = get_post_meta($post_id, FELAN_METABOX_PREFIX . 'notification_read', true);
			$unread_class = ($is_read !== 'yes') ? ' unread' : '';

			$link = get_post_meta($post_id, FELAN_METABOX_PREFIX . 'link_post_noti', true);
			// Get title for display (no HTML wrapping to avoid escape issues)
			$link_title = !empty($link) ? get_the_title($post_id) : '';

			$page_link = get_post_meta($post_id, FELAN_METABOX_PREFIX . 'link_page_noti', true);
			if (!empty($page_link)) {
				$link_page = $page_link;
			} else {
				$link_page = '#';
			}

		?>
			<li class="<?php echo esc_attr($unread_class); ?>">
				<?php if (!empty($user_avatar)) : ?>
					<img class="avatar" src="<?php echo esc_url($user_avatar); ?>" alt="" />
				<?php else : ?>
					<span class="avatar"><i class="far fa-camera"></i></span>
				<?php endif; ?>
				<span class="content-wrapper">
					<span class="content">
						<?php
						$noti_action = get_post_meta($post_id, FELAN_METABOX_PREFIX . 'action_noti', true);
						if ($noti_action == 'Proposal') {
							$link_noti = get_the_title($post_id);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has submitted a proposal for your project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Service Order') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has placed a new order for your service <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Dispute') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has approved dispute for your project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Dispute denied') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has denied dispute for your project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Dispute service') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has approved dispute for your service <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Dispute denied service') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has denied dispute for your service <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Message Dispute Project') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has sent a new message in the dispute for project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Message Dispute service') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has sent a new message in the dispute for service <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Employer Approve Proposal') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has approved your proposal for project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Employer Reject Proposal') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has rejected your proposal for project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Employer Create Dispute Proposal') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has create dispute your proposal for project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Message Service') {
							$link_noti = get_the_title($link);

							$message_template = __('<b>%1$s</b> has sent a new message in service <b>%2$s</b>', 'felan-framework');
							$message_html = sprintf($message_template, esc_html($user_send), esc_html($link_noti));

							echo '<div class="message" style="font-size: 12px;">' . $message_html . '</div>';
						} elseif ($noti_action == 'Service Completed') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has marked the service <b>' . esc_html($link_noti) . '</b> as completed.</div>',
							);
						} elseif ($noti_action == 'Service Canceled') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has marked the service <b>' . esc_html($link_noti) . '</b> as canceled.</div>',
							);
						} elseif ($noti_action == 'Employer Create Dispute Service') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has create dispute for service <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} elseif ($noti_action == 'Project Order') {
							$link_noti = get_the_title($link);
							echo sprintf(
								esc_html__('%1s %2s', 'felan-framework'),
								$mess_noti,
								'<div class="message" style="font-size: 12px;"><b>' . esc_html($user_send) . '</b> has placed a new order for your project <b>' . esc_html($link_noti) . '.</b></div>',
							);
						} else {
							// Default display format - use $link_title (escaped title only, no HTML)
							if (!empty($link_title)) {
								echo sprintf(
									/* translators: %1$s: notification message, %2$s: post title link, %3$s: user name */
									esc_html__('%1$s %2$s by %3$s', 'felan-framework'),
									esc_html($mess_noti),
									'<b><a href="' . esc_url($link) . '">' . esc_html($link_title) . '</a></b>',
									'<b>' . esc_html($user_send) . '</b>'
								);
							} else {
								echo sprintf(
									/* translators: %1$s: notification message, %2$s: user name */
									esc_html__('%1$s by %2$s', 'felan-framework'),
									esc_html($mess_noti),
									'<b>' . esc_html($user_send) . '</b>'
								);
							}
						}
						?>
					</span>
					<span class="date">
						<?php echo sprintf(esc_html__('%s ago', 'felan-framework'), $time); ?>
					</span>
				</span>
				<?php if ($is_read !== 'yes') : ?>
					<a href="#" class="btn-quick-read" data-noti-id="<?php echo esc_attr(wp_json_encode($post_id)); ?>" title="<?php esc_attr_e('Mark as Read', 'felan-framework'); ?>">
						<span class="unread-dot"></span>
					</a>
				<?php endif; ?>
				<span class="action action-setting">
					<a href="#" class="icon-setting"><i class="far fa-ellipsis-v"></i></a>
					<span class="action-dropdown">
						<?php if ($is_read !== 'yes') : ?>
							<a class="btn-mark-read" data-noti-id="<?php echo esc_attr(wp_json_encode($post_id)); ?>" href="#"><?php esc_html_e('Mark as Read', 'felan-framework') ?></a>
						<?php else : ?>
							<a class="btn-mark-unread" data-noti-id="<?php echo esc_attr(wp_json_encode($post_id)); ?>" href="#"><?php esc_html_e('Mark as Unread', 'felan-framework') ?></a>
						<?php endif; ?>
						<a class="btn-delete" data-noti-id="<?php echo esc_attr(wp_json_encode($post_id)); ?>" href="#"><?php esc_html_e('Delete', 'felan-framework') ?></a>
					</span>
				</span>
				<a href="<?php echo esc_url($link_page); ?>" class="link-page" data-noti-id="<?php echo esc_attr(wp_json_encode($post_id)); ?>"></a>
			</li>
		<?php } ?>
	</ul>
<?php } else { ?>
	<span class="empty"><?php esc_html_e('You do not have any notifications.', 'felan-framework'); ?></span>
<?php } ?>
