<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
global $current_user;
// Only count unread notifications
$count = felan_get_unread_notification_count();
if ($count > 99) {
    $count = '99';
}
?>

<?php if (
    in_array('felan_user_freelancer', (array)$current_user->roles)
    || in_array('felan_user_employer', (array)$current_user->roles)
) { ?>
    <a href="#" class="icon-noti">
        <i class="far fa-bell"></i>
        <span><?php echo $count; ?></span>
    </a>
<?php } else { ?>
    <div class="logged-out">
        <a href="#popup-form" class="btn-login icon-noti notice-employer" data-notice="<?php echo esc_attr__('Please login Employer or Freelancer', 'felan-framework'); ?>">
            <i class="far fa-bell"></i>
            <span>0</span>
        </a>
    </div>
<?php } ?>
