<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!is_user_logged_in()) {
    wp_redirect(home_url('/'));
    exit;
}

global $current_user;
$user_id = $current_user->ID;
$custom_payout = felan_get_option('custom_payout_setting');
$enable_paypal = felan_get_option('enable_payout_paypal');
$enable_stripe = felan_get_option('enable_payout_stripe');
$enable_bank = felan_get_option('enable_payout_bank_transfer');
wp_enqueue_script(FELAN_PLUGIN_PREFIX . 'payout');

// Localize script with validation messages
wp_localize_script(FELAN_PLUGIN_PREFIX . 'payout', 'felan_payout_vars', array(
    // Security nonce
    'nonce' => wp_create_nonce('felan_update_payout_nonce'),

    // Validation messages
    'country_required' => esc_html__('Please select a country.', 'felan-framework'),
    'account_name_required' => esc_html__('Please enter account holder name.', 'felan-framework'),
    'account_name_min_length' => esc_html__('Account holder name must be at least 2 characters.', 'felan-framework'),
    'bank_name_min_length' => esc_html__('Bank name must be at least 2 characters.', 'felan-framework'),
    'account_number_min_length' => esc_html__('Account number must be at least 4 characters.', 'felan-framework'),
    'account_number_invalid' => esc_html__('Account number must contain only numbers.', 'felan-framework'),
    'iban_required' => esc_html__('IBAN is required for EU countries.', 'felan-framework'),
    'iban_invalid' => esc_html__('Please enter a valid IBAN.', 'felan-framework'),
    'swift_required' => esc_html__('BIC/SWIFT code is required for this country.', 'felan-framework'),
    'swift_invalid' => esc_html__('Please enter a valid BIC/SWIFT code.', 'felan-framework'),
    'routing_required' => esc_html__('Routing number is required for US.', 'felan-framework'),
    'routing_invalid' => esc_html__('Please enter a valid 9-digit routing number.', 'felan-framework'),
    'bank_transfer_required' => esc_html__('Please fill in Bank Transfer information to use this payment method.', 'felan-framework'),
    'stripe_required' => esc_html__('Please enter your Stripe account ID.', 'felan-framework'),
    'paypal_required' => esc_html__('Please enter your PayPal email address.', 'felan-framework'),
    'paypal_invalid_email' => esc_html__('Please enter a valid email address.', 'felan-framework'),
    'no_payment_method' => esc_html__('Please select at least one payment method.', 'felan-framework'),
    'ajax_error' => esc_html__('An error occurred. Please try again.', 'felan-framework'),

    // Help texts
    'iban_required_eu' => esc_html__('Required for EU countries', 'felan-framework'),
    'iban_optional' => esc_html__('Optional - for international transfers', 'felan-framework'),
    'swift_optional' => esc_html__('For international transfers only', 'felan-framework'),

    // Custom field messages
    'custom_field_required' => esc_html__('Please fill in', 'felan-framework'),

    // Error handling messages
    'vars_not_loaded' => esc_html__('Required variables are not loaded. Please refresh the page and try again.', 'felan-framework'),
    'enable_payment_method' => esc_html__('Please enable at least one payment method.', 'felan-framework'),
    'unexpected_error' => esc_html__('An unexpected error occurred while processing your request.', 'felan-framework'),
    'contact_support' => esc_html__('Please try again or contact support if the problem persists.', 'felan-framework'),
    'stripe_default_required' => esc_html__('Please enter your Stripe account ID.', 'felan-framework'),
    'country_default_required' => esc_html__('Please select a country.', 'felan-framework'),
    'account_name_default_required' => esc_html__('Please enter account holder name.', 'felan-framework'),
    'iban_default_invalid' => esc_html__('Please enter a valid IBAN.', 'felan-framework'),
    'swift_default_invalid' => esc_html__('Please enter a valid BIC/SWIFT code.', 'felan-framework'),
    'routing_default_invalid' => esc_html__('Please enter a valid 9-digit routing number.', 'felan-framework'),
    'ajax_url_undefined' => esc_html__('AJAX URL is not defined. Please refresh the page and try again.', 'felan-framework'),
    'submit_failed' => esc_html__('Failed to submit payout data.', 'felan-framework'),
    'try_again' => esc_html__('Please try again.', 'felan-framework'),
));

// Load bank countries data
$bank_countries_file = plugin_dir_path(__FILE__) . '../../../assets/data/bank-countries.json';
$bank_countries = array();


if (file_exists($bank_countries_file)) {
    $bank_countries_data = json_decode(file_get_contents($bank_countries_file), true);
    if ($bank_countries_data) {
        $bank_countries = $bank_countries_data;
    }
} else {
    // Fallback: hardcoded countries if file doesn't exist
    $bank_countries = array(
        array('code' => 'US', 'name' => 'United States'),
        array('code' => 'CA', 'name' => 'Canada'),
        array('code' => 'GB', 'name' => 'United Kingdom'),
        array('code' => 'AU', 'name' => 'Australia'),
        array('code' => 'DE', 'name' => 'Germany'),
        array('code' => 'FR', 'name' => 'France'),
        array('code' => 'IT', 'name' => 'Italy'),
        array('code' => 'ES', 'name' => 'Spain'),
        array('code' => 'NL', 'name' => 'Netherlands'),
        array('code' => 'JP', 'name' => 'Japan'),
        array('code' => 'CN', 'name' => 'China'),
        array('code' => 'IN', 'name' => 'India'),
        array('code' => 'BR', 'name' => 'Brazil'),
        array('code' => 'MX', 'name' => 'Mexico'),
        array('code' => 'RU', 'name' => 'Russia'),
        array('code' => 'KR', 'name' => 'South Korea'),
        array('code' => 'SG', 'name' => 'Singapore'),
        array('code' => 'HK', 'name' => 'Hong Kong'),
        array('code' => 'TH', 'name' => 'Thailand'),
        array('code' => 'VN', 'name' => 'Vietnam'),
    );
}

// Ensure we always have some countries
if (empty($bank_countries)) {
    $bank_countries = array(
        array('code' => 'US', 'name' => 'United States'),
        array('code' => 'CA', 'name' => 'Canada'),
        array('code' => 'GB', 'name' => 'United Kingdom'),
    );
}

wp_localize_script(
    FELAN_PLUGIN_PREFIX . 'payout',
    'felan_payout_vars',
    array(
        'custom_field_payout' => $custom_payout,
        'bank_countries' => $bank_countries,
        'plugin_url' => plugin_dir_url(__FILE__),
        'enable_payout_paypal' => $enable_paypal,
        'enable_payout_stripe' => $enable_stripe,
        'enable_payout_bank_transfer' => $enable_bank,
    )
);
?>

<?php
// PayPal
$payout_paypal = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_paypal', $user_id);
$payout_paypal = !empty($payout_paypal) ? $payout_paypal : '';
$enable_paypal_user = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_enable_paypal', $user_id);
// Default to enabled for better UX after theme updates (prevents hidden payment forms)
// If user hasn't set preference yet, default to enabled
$enable_paypal_user = ($enable_paypal_user !== '') ? $enable_paypal_user : '1';

// Stripe
$payout_stripe = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_stripe', $user_id);
$payout_stripe_account_holder = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_stripe_account_holder', $user_id);
$payout_stripe_bank_country = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_stripe_bank_country', $user_id);
$payout_stripe_routing_number = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_stripe_routing_number', $user_id);
$payout_stripe_swift_bic = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_stripe_swift_bic', $user_id);
$payout_stripe = !empty($payout_stripe) ? $payout_stripe : '';
$payout_stripe_account_holder = !empty($payout_stripe_account_holder) ? $payout_stripe_account_holder : '';
$payout_stripe_bank_country = !empty($payout_stripe_bank_country) ? $payout_stripe_bank_country : '';
$payout_stripe_routing_number = !empty($payout_stripe_routing_number) ? $payout_stripe_routing_number : '';
$payout_stripe_swift_bic = !empty($payout_stripe_swift_bic) ? $payout_stripe_swift_bic : '';
$enable_stripe_user = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_enable_stripe', $user_id);
// Default to enabled for better UX after theme updates (prevents hidden payment forms)
// If user hasn't set preference yet, default to enabled
$enable_stripe_user = ($enable_stripe_user !== '') ? $enable_stripe_user : '1';

// Bank Transfer
$payout_bank_account_holder = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_account_holder', $user_id);
$payout_bank_account_number = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_account_number', $user_id);
$payout_bank_name = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_name', $user_id);
$payout_bank_country = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_country', $user_id);
$payout_bank_routing_number = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_routing_number', $user_id);
$payout_bank_swift_bic = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_swift_bic', $user_id);
$payout_bank_iban = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_iban', $user_id);
$payout_bank_branch_address = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_branch_address', $user_id);
$payout_bank_address = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_bank_address', $user_id);

$payout_bank_account_holder = !empty($payout_bank_account_holder) ? $payout_bank_account_holder : '';
$payout_bank_account_number = !empty($payout_bank_account_number) ? $payout_bank_account_number : '';
$payout_bank_name = !empty($payout_bank_name) ? $payout_bank_name : '';
$payout_bank_country = !empty($payout_bank_country) ? $payout_bank_country : '';
$payout_bank_routing_number = !empty($payout_bank_routing_number) ? $payout_bank_routing_number : '';
$payout_bank_swift_bic = !empty($payout_bank_swift_bic) ? $payout_bank_swift_bic : '';
$payout_bank_iban = !empty($payout_bank_iban) ? $payout_bank_iban : '';
$payout_bank_branch_address = !empty($payout_bank_branch_address) ? $payout_bank_branch_address : '';
$payout_bank_address = !empty($payout_bank_address) ? $payout_bank_address : '';
$enable_bank_user = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_enable_bank', $user_id);
// Default to enabled for better UX after theme updates (prevents hidden payment forms)
// If user hasn't set preference yet, default to enabled
$enable_bank_user = ($enable_bank_user !== '') ? $enable_bank_user : '1';
$name_same = $name_nsame = array();
?>

<form action="#" method="post" class="felan-payout-dashboard" enctype="multipart/form-data">
    <ul>
        <?php if ($enable_paypal === '1') : ?>
            <li class="payout-item">
                <div class="title-section">
                    <label class="toggle-label">
                        <input type="checkbox" name="enable_paypal" value="1" <?php checked($enable_paypal_user === '1', true); ?> class="payment-enable">
                        <span class="toggle-slider"></span>
                        <?php esc_html_e('Enable PayPal', 'felan-framework') ?>
                    </label>
                </div>
                <div class="content">
                    <div class="form-group">
                        <label><?php esc_html_e('Paypal email', 'felan-framework'); ?> <span class="required">*</span></label>
                        <input type="email" id="payout-paypal" name="payout_paypal" placeholder="<?php esc_attr_e('Enter your email', 'felan-framework') ?>" value="<?php echo esc_attr($payout_paypal) ?>">
                        <div class="error-message" id="error-paypal"></div>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if ($enable_stripe === '1') : ?>
            <li class="payout-item">
                <div class="title-section">
                    <label class="toggle-label">
                        <input type="checkbox" name="enable_stripe" value="1" <?php checked($enable_stripe_user === '1', true); ?> class="payment-enable">
                        <span class="toggle-slider"></span>
                        <?php esc_html_e('Enable Stripe', 'felan-framework') ?>
                    </label>
                </div>
                <div class="content">
                    <div class="form-group payout-content">
                        <label><?php esc_html_e('Stripe Account ID', 'felan-framework'); ?> <span class="required">*</span></label>
                        <input type="text" id="payout-stripe" name="payout_stripe" placeholder="<?php esc_attr_e('Enter your Stripe account ID', 'felan-framework') ?>" value="<?php echo esc_attr($payout_stripe) ?>">
                        <div class="error-message" id="error-stripe"></div>
                    </div>

                </div>
            </li>
        <?php endif; ?>
        <?php if ($enable_bank === '1') : ?>
            <li class="payout-item">
                <div class="title-section">
                    <label class="toggle-label">
                        <input type="checkbox" name="enable_bank" value="1" <?php checked($enable_bank_user === '1', true); ?> class="payment-enable">
                        <span class="toggle-slider"></span>
                        <?php esc_html_e('Enable Wire Transfer', 'felan-framework') ?>
                    </label>
                </div>
                <div class="content">
                    <div class="form-row">
                        <div class="form-group payout-content">
                            <label><?php esc_html_e('Country', 'felan-framework'); ?> <span class="required">*</span></label>
                            <select id="payout-bank-country" name="payout_bank_country" class="felan-select2" required>
                                <option value=""><?php esc_html_e('Select Country', 'felan-framework'); ?></option>
                                <?php foreach ($bank_countries as $country): ?>
                                    <option value="<?php echo esc_attr($country['code']); ?>" <?php selected($payout_bank_country, $country['code']); ?>>
                                        <?php echo esc_html($country['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="error-message" id="error-bank-country"></div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group payout-content form-col-2">
                            <label><?php esc_html_e('Account Number', 'felan-framework'); ?> <span class="required">*</span></label>
                            <input type="text" id="payout-bank-account-number" name="payout_bank_account_number" placeholder="<?php esc_attr_e('e.g., 123456789', 'felan-framework') ?>" value="<?php echo esc_attr($payout_bank_account_number) ?>" required>
                            <small class="help-text"><?php esc_html_e('Enter your bank account number exactly as it appears on your bank statement', 'felan-framework'); ?></small>
                            <div class="error-message" id="error-bank-account-number"></div>
                        </div>
                        <div class="form-group payout-content form-col-2">
                            <label><?php esc_html_e('Account Holder Name', 'felan-framework'); ?> <span class="required">*</span></label>
                            <input type="text" id="payout-bank-account-holder" name="payout_bank_account_holder" placeholder="<?php esc_attr_e('Enter account holder name', 'felan-framework') ?>" value="<?php echo esc_attr($payout_bank_account_holder) ?>" required>
                            <small class="help-text"><?php esc_html_e('Enter the full name exactly as it appears on the bank account', 'felan-framework'); ?></small>
                            <div class="error-message" id="error-bank-account-holder"></div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group payout-content form-col-2">
                            <label><?php esc_html_e('Bank Name', 'felan-framework'); ?> <span class="required">*</span></label>
                            <input type="text" id="payout-bank-name" name="payout_bank_name" placeholder="<?php esc_attr_e('Enter bank name', 'felan-framework') ?>" value="<?php echo esc_attr($payout_bank_name) ?>" required>
                            <small class="help-text"><?php esc_html_e('Enter the complete official name of your bank', 'felan-framework'); ?></small>
                            <div class="error-message" id="error-bank-name"></div>
                        </div>
                        <div class="form-group payout-content form-col-2">
                            <label><?php esc_html_e('SWIFT/BIC Code', 'felan-framework'); ?> <span class="required">*</span></label>
                            <input type="text" id="payout-bank-swift-bic" name="payout_bank_swift_bic" placeholder="<?php esc_attr_e('e.g., CHASUS33', 'felan-framework') ?>" value="<?php echo esc_attr($payout_bank_swift_bic) ?>" required>
                            <small class="help-text"><?php esc_html_e('8-11 characters. Format: AAAABBCCXXX', 'felan-framework'); ?></small>
                            <div class="error-message" id="error-bank-swift-bic"></div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group payout-content">
                            <label><?php esc_html_e('Bank Address', 'felan-framework'); ?> <span class="required">*</span></label>
                            <textarea id="payout-bank-address" name="payout_bank_address" rows="3" placeholder="<?php esc_attr_e('e.g., 123 Main Street, New York, NY 10001, USA', 'felan-framework') ?>" required><?php echo esc_textarea($payout_bank_address); ?></textarea>
                            <small class="help-text"><?php esc_html_e('Enter the complete address including street, city, state/province, postal code, and country', 'felan-framework'); ?></small>
                            <div class="error-message" id="error-bank-address"></div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group payout-content form-col-2">
                            <label><?php esc_html_e('IBAN', 'felan-framework'); ?> <span class="optional">(<?php esc_html_e('Required for EU', 'felan-framework'); ?>)</span></label>
                            <input type="text" id="payout-bank-iban" name="payout_bank_iban" placeholder="<?php esc_attr_e('e.g., GB82 WEST 1234 5698 7654 32', 'felan-framework') ?>" value="<?php echo esc_attr($payout_bank_iban) ?>">
                            <small class="help-text"><?php esc_html_e('Required for European transfers', 'felan-framework'); ?></small>
                            <div class="error-message" id="error-bank-iban"></div>
                        </div>
                        <div class="form-group payout-content form-col-2">
                            <label><?php esc_html_e('Routing Number / ABA', 'felan-framework'); ?> <span class="optional">(<?php esc_html_e('Required for US', 'felan-framework'); ?>)</span></label>
                            <input type="text" id="payout-bank-routing-number" name="payout_bank_routing_number" placeholder="<?php esc_attr_e('e.g., 021000021', 'felan-framework') ?>" value="<?php echo esc_attr($payout_bank_routing_number) ?>">
                            <small class="help-text"><?php esc_html_e('9-digit routing number for US banks', 'felan-framework'); ?></small>
                            <div class="error-message" id="error-bank-routing-number"></div>
                        </div>
                    </div>
                </div>
            </li>
            <?php endif;

        if (!empty($custom_payout)) :
            foreach ($custom_payout as $field) :
                if (!empty($field['name'])) :
                    $field_id = str_replace(' ', '-', $field['name']);
                    $author_payout_custom = get_the_author_meta(FELAN_METABOX_PREFIX . 'author_payout_custom_' . $field['id'], $user_id);
                    $author_payout_custom = !empty($author_payout_custom) ? $author_payout_custom : '';
                    if (in_array($field['name'], $name_nsame)) {
                        if (!in_array($field['name'], $name_same)) { ?>
                            <div class="form-group payout-content <?php echo esc_attr($field_id); ?>">
                                <label><?php echo esc_html($field['label']); ?></label>
                                <input type="<?php echo esc_attr($field['type']); ?>" id="<?php echo esc_attr($field['id']); ?>" name="<?php echo esc_attr($field['id']); ?>" placeholder="<?php echo sprintf(__('Enter %s', 'felan-framework'), $field['label']); ?>" value="<?php echo esc_attr($author_payout_custom); ?>">
                            </div>
                        <?php }
                    } else { ?>
                        <li class="payout-item" id="<?php echo esc_attr($field_id); ?>">
                            <h5 class="title"><?php echo esc_html($field['name']); ?></h5>
                            <div class="content">
                                <div class="form-group payout-content">
                                    <label><?php echo esc_html($field['label']); ?></label>
                                    <input type="<?php echo esc_attr($field['type']); ?>" id="<?php echo esc_attr($field['id']); ?>" name="<?php echo esc_attr($field['id']); ?>" placeholder="<?php echo sprintf(__('Enter %s', 'felan-framework'), $field['label']); ?>" value="<?php echo esc_attr($author_payout_custom); ?>">
                                </div>
                            </div>
                        </li>
        <?php $name_nsame[] = $field['name'];
                    }
                endif;
            endforeach;
        endif; ?>
    </ul>
    <a href="#" class="felan-button" id="btn-submit-payout">
        <?php esc_html_e('Save', 'felan-framework') ?>
        <span class="btn-loading"><i class="far fa-spinner fa-spin large"></i></span>
    </a>
</form>
