<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

global $current_user;
$user_id = $current_user->ID;
$freelancer_package_id = get_the_author_meta(FELAN_METABOX_PREFIX . 'freelancer_package_id', $user_id);
$enable_package_service_unlimited_time = get_post_meta($freelancer_package_id, FELAN_METABOX_PREFIX . 'enable_package_service_unlimited_time', true);
$enable_package_service_unlimited = get_post_meta($freelancer_package_id, FELAN_METABOX_PREFIX . 'enable_package_service_unlimited', true);
$enable_package_service_featured_unlimited = get_post_meta($freelancer_package_id, FELAN_METABOX_PREFIX . 'enable_package_service_featured_unlimited', true);
$freelancer_package_number_service = get_user_meta($user_id, FELAN_METABOX_PREFIX . 'freelancer_package_number_service', true);
$freelancer_package_number_service_featured = get_user_meta($user_id, FELAN_METABOX_PREFIX . 'freelancer_package_number_service_featured', true);
$freelancer_package_additional = get_post_meta($freelancer_package_id, FELAN_METABOX_PREFIX . 'freelancer_package_additional_details', true);
if ($freelancer_package_additional > 0) {
    $freelancer_package_additional_text = get_post_meta($freelancer_package_id, FELAN_METABOX_PREFIX . 'freelancer_package_details_text', true);
}
// Get sorted package fields using helper function
// This ensures number fields appear first, checkbox fields appear last
$sorted_fields = felan_get_sorted_freelancer_package_fields($freelancer_package_id, $user_id, 'overview');
?>
<ul class="felan-overview-package">
    <li>
        <span class="name"><?php esc_html_e('Number of services', 'felan-framework') ?></span>
        <span class="content">
            <?php if ($enable_package_service_unlimited == 1) {
                esc_html_e('Unlimited', 'felan-framework');
            } else {
                echo $freelancer_package_number_service;
            } ?>
        </span>
    </li>
    <li>
        <span class="name"><?php esc_html_e('Featured services', 'felan-framework') ?></span>
        <span class="content">
            <?php if ($enable_package_service_featured_unlimited == 1) {
                esc_html_e('Unlimited', 'felan-framework');
            } else {
                echo $freelancer_package_number_service_featured;
            } ?>
        </span>
    </li>
    <?php
    // Display sorted fields (number fields first, checkbox fields last)
    // Project Alerts are already included in sorted_fields
    foreach ($sorted_fields as $field_data) :
    ?>
        <li>
            <span class="name"><?php echo $field_data['name']; ?></span>
            <span class="content">
                <?php if ($field_data['is_check'] == true) { ?>
                    <i class="far fa-check"></i>
                <?php } else { ?>
                    <?php if ($field_data['unlimited'] == 1 || $field_data['value'] === 'unlimited') { ?>
                        <?php esc_html_e('Unlimited', 'felan-framework'); ?>
                    <?php } else { ?>
                        <?php echo $field_data['value']; ?>
                    <?php } ?>
                <?php } ?>
            </span>
        </li>
    <?php endforeach; ?>


    <?php if ($freelancer_package_additional > 0) :
        foreach ($freelancer_package_additional_text as $additional) : ?>
            <?php if (!empty($additional)) : ?>
                <li class="list-group-item">
                    <span class="name"><?php echo $additional; ?></span>
                    <span class="content">
                        <i class="far fa-check"></i>
                    </span>
                </li>
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>

</ul>
