<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
$felan_freelancer_payment = new Felan_freelancer_payment();
$freelancer_payment_method = isset($_GET['payment_method']) ? absint(wp_unslash($_GET['payment_method'])) : -1;
if ($freelancer_payment_method == 1) {
    $felan_freelancer_payment->paypal_payment_completed();
} elseif ($freelancer_payment_method == 2) {
    $felan_freelancer_payment->stripe_payment_completed();
} elseif ($freelancer_payment_method == 4) {
    $felan_freelancer_payment->razor_payment_completed();
}
?>
<div class="felan-payment-completed-wrap">
    <div class="inner-payment-completed">
        <?php
        do_action('felan_before_freelancer_payment_completed');

        // Check for payment errors or cancellations
        $payment_status = isset($_GET['status']) ? sanitize_text_field(wp_unslash($_GET['status'])) : '';
        $error_message = isset($_GET['message']) ? sanitize_text_field(wp_unslash($_GET['message'])) : '';

        // Display error alert if payment failed
        if ($payment_status === 'error' && !empty($error_message)) : ?>
            <div class="payment-status-header">
                <h2><?php esc_html_e('Payment Failed', 'felan-framework'); ?></h2>
            </div>

            <div class="alert alert-danger">
                <strong><i class="fas fa-exclamation-triangle"></i> <?php esc_html_e('Payment Error', 'felan-framework'); ?></strong>
                <p><?php echo esc_html($error_message); ?></p>
                <p><?php esc_html_e('Please try again or contact support if the problem persists.', 'felan-framework'); ?></p>
            </div>

            <a href="<?php echo esc_url(felan_get_permalink('freelancer_package')); ?>" class="felan-button">
                <?php esc_html_e('Return to Packages', 'felan-framework'); ?>
            </a>
        <?php
        // Display cancel alert if payment was cancelled
        elseif ($payment_status === 'cancelled') : ?>
            <div class="payment-status-header">
                <h2><?php esc_html_e('Payment Cancelled', 'felan-framework'); ?></h2>
            </div>

            <div class="alert alert-warning">
                <strong><i class="fas fa-info-circle"></i> <?php esc_html_e('Payment Cancelled', 'felan-framework'); ?></strong>
                <p><?php esc_html_e('You have cancelled the payment. No charges have been made.', 'felan-framework'); ?></p>
            </div>

            <a href="<?php echo esc_url(felan_get_permalink('freelancer_package')); ?>" class="felan-button">
                <?php esc_html_e('Return to Packages', 'felan-framework'); ?>
            </a>
        <?php
        // Display order details for successful payments
        elseif (isset($_GET['order_id']) && $_GET['order_id'] != '') :
            $order_id = absint(wp_unslash($_GET['order_id']));
            $felan_freelancer_order = new Felan_freelancer_order();
            $order_meta = $felan_freelancer_order->get_freelancer_order_meta($order_id);
            // Wire Transfer Information
            $freelancer_enable_wire_transfer = felan_get_option('freelancer_enable_wire_transfer', '0');
            $freelancer_wire_transfer_account_number = trim(felan_get_option('freelancer_wire_transfer_account_number', ''));
            $freelancer_wire_transfer_account_holder = trim(felan_get_option('freelancer_wire_transfer_account_holder', ''));
            $freelancer_wire_transfer_bank_name = trim(felan_get_option('freelancer_wire_transfer_bank_name', ''));
            $freelancer_wire_transfer_bank_address = trim(felan_get_option('freelancer_wire_transfer_bank_address', ''));
            $freelancer_wire_transfer_swift_bic = trim(felan_get_option('freelancer_wire_transfer_swift_bic', ''));
            $freelancer_wire_transfer_iban = trim(felan_get_option('freelancer_wire_transfer_iban', ''));
            $freelancer_wire_transfer_routing_number = trim(felan_get_option('freelancer_wire_transfer_routing_number', ''));
            $freelancer_wire_transfer_country = trim(felan_get_option('freelancer_wire_transfer_country', ''));
            $freelancer_wire_transfer_instructions = felan_get_option('freelancer_wire_transfer_instructions', '');

            // Check if this is wire transfer payment
            // Check both GET param (3) and stored meta
            $is_wire_transfer = ($freelancer_payment_method == 3) ||
                (isset($order_meta['freelancer_order_payment_method']) &&
                    ($order_meta['freelancer_order_payment_method'] == 3 ||
                        $order_meta['freelancer_order_payment_method'] === 'wire_transfer' ||
                        $order_meta['freelancer_order_payment_method'] === 'Wire_Transfer'));
        ?>

            <?php
            $payment_status_meta = get_post_meta($order_id, FELAN_METABOX_PREFIX . 'freelancer_order_payment_status', true);
            $is_pending = ($payment_status_meta == '0' || $payment_status_meta === 0);
            ?>

            <div class="payment-status-header">
                <h2>
                    <?php
                    if ($is_pending) {
                        esc_html_e('Order Received - Awaiting Confirmation', 'felan-framework');
                    } else {
                        esc_html_e('Thank you for your purchase!', 'felan-framework');
                    }
                    ?>
                </h2>
            </div>

            <?php if ($is_pending) : ?>
                <div class="alert alert-warning">
                    <strong><i class="fas fa-clock"></i> <?php esc_html_e('Payment Pending', 'felan-framework'); ?></strong>
                    <p><?php esc_html_e('Your order has been received and is pending admin confirmation. You will be notified once your package is activated.', 'felan-framework'); ?></p>
                </div>
            <?php endif; ?>

            <div class="panel panel-default">

                <?php if ($is_wire_transfer && $freelancer_enable_wire_transfer === '1') : ?>
                    <div class="wire-transfer-notice" style="padding: 0 20px 20px;">
                        <p><?php esc_html_e('Please transfer to our account number with the "Order Number" and wait for us to confirm.', 'felan-framework'); ?></p>
                    </div>
                <?php endif; ?>

                <?php
                if ($is_wire_transfer && $freelancer_enable_wire_transfer === '1' && (
                    !empty($freelancer_wire_transfer_account_number) ||
                    !empty($freelancer_wire_transfer_account_holder) ||
                    !empty($freelancer_wire_transfer_bank_name) ||
                    !empty($freelancer_wire_transfer_bank_address) ||
                    !empty($freelancer_wire_transfer_swift_bic) ||
                    !empty($freelancer_wire_transfer_iban) ||
                    !empty($freelancer_wire_transfer_routing_number) ||
                    !empty($freelancer_wire_transfer_country) ||
                    !empty($freelancer_wire_transfer_instructions)
                )) : ?>
                    <div class="card-info wire-transfer-info">
                        <h3><?php esc_html_e('Wire Transfer Details', 'felan-framework'); ?></h3>
                        <table>
                            <?php if (!empty($freelancer_wire_transfer_country)) : ?>
                                <tr>
                                    <th><?php esc_html_e('Country', 'felan-framework'); ?></th>
                                    <td><?php echo esc_html($freelancer_wire_transfer_country); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (!empty($freelancer_wire_transfer_account_number)) : ?>
                                <tr>
                                    <th><?php esc_html_e('Account Number', 'felan-framework'); ?></th>
                                    <td><?php echo esc_html($freelancer_wire_transfer_account_number); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (!empty($freelancer_wire_transfer_account_holder)) : ?>
                                <tr>
                                    <th><?php esc_html_e('Account Holder Name', 'felan-framework'); ?></th>
                                    <td><?php echo esc_html($freelancer_wire_transfer_account_holder); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (!empty($freelancer_wire_transfer_bank_name)) : ?>
                                <tr>
                                    <th><?php esc_html_e('Bank Name', 'felan-framework'); ?></th>
                                    <td><?php echo esc_html($freelancer_wire_transfer_bank_name); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (!empty($freelancer_wire_transfer_bank_address)) : ?>
                                <tr>
                                    <th><?php esc_html_e('Bank Address', 'felan-framework'); ?></th>
                                    <td><?php echo nl2br(esc_html($freelancer_wire_transfer_bank_address)); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (!empty($freelancer_wire_transfer_swift_bic)) : ?>
                                <tr>
                                    <th><?php esc_html_e('SWIFT/BIC Code', 'felan-framework'); ?></th>
                                    <td><?php echo esc_html($freelancer_wire_transfer_swift_bic); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (!empty($freelancer_wire_transfer_iban)) : ?>
                                <tr>
                                    <th><?php esc_html_e('IBAN', 'felan-framework'); ?></th>
                                    <td><?php echo esc_html($freelancer_wire_transfer_iban); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (!empty($freelancer_wire_transfer_routing_number)) : ?>
                                <tr>
                                    <th><?php esc_html_e('Routing Number / ABA', 'felan-framework'); ?></th>
                                    <td><?php echo esc_html($freelancer_wire_transfer_routing_number); ?></td>
                                </tr>
                            <?php endif; ?>
                        </table>
                        <?php if (!empty($freelancer_wire_transfer_instructions)) : ?>
                            <div class="wire-transfer-instructions">
                                <h4><?php esc_html_e('Additional Instructions', 'felan-framework'); ?></h4>
                                <?php echo wp_kses_post($freelancer_wire_transfer_instructions); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="entry-title" style="display:none;">
                    <h3><?php esc_html_e('Order Detail', 'felan-framework'); ?></h3>
                </div>
                <ul class="list-group">
                    <?php
                    // Get WooCommerce Order ID if exists
                    $woo_order_id = get_post_meta($order_id, FELAN_METABOX_PREFIX . 'woocommerce_order_id', true);

                    if (!empty($woo_order_id)):
                    ?>
                        <li class="list-group-item">
                            <span><?php esc_html_e('Payment Order', 'felan-framework'); ?></span>
                            <strong class="pull-right">#<?php echo esc_html($woo_order_id); ?></strong>
                        </li>
                        <li class="list-group-item">
                            <span><?php esc_html_e('Package Order', 'felan-framework'); ?></span>
                            <strong class="pull-right">#PO-<?php echo esc_html($order_id); ?></strong>
                        </li>
                    <?php else: ?>
                        <li class="list-group-item">
                            <span><?php esc_html_e('Package Order', 'felan-framework'); ?></span>
                            <strong class="pull-right">#PO-<?php echo esc_html($order_id); ?></strong>
                        </li>
                    <?php endif; ?>
                    <li class="list-group-item">
                        <span><?php esc_html_e('Date', 'felan-framework'); ?></span>
                        <strong class="pull-right"><?php echo get_the_date('', $order_id); ?></strong>
                    </li>
                    <li class="list-group-item">
                        <span><?php esc_html_e('Payment Method', 'felan-framework'); ?></span>
                        <strong class="pull-right">
                            <?php echo Felan_freelancer_order::get_freelancer_order_payment_method($order_meta['freelancer_order_payment_method']);  ?>
                        </strong>
                    </li>
                    <li class="list-group-item">
                        <span><?php esc_html_e('Total', 'felan-framework'); ?></span>
                        <strong class="pull-right"><?php echo felan_get_format_money($order_meta['freelancer_order_item_price']); ?></strong>
                </ul>

            </div>

            <?php if ($is_pending) : ?>
                <div class="alert alert-info">
                    <strong><i class="fas fa-info-circle"></i> <?php esc_html_e('Next Steps', 'felan-framework'); ?></strong>
                    <p><?php esc_html_e('Your package will be activated once the admin confirms your payment. You will receive an email notification when your package is ready to use.', 'felan-framework'); ?></p>
                </div>
            <?php else : ?>
                <div class="alert alert-success">
                    <strong><i class="fas fa-check-circle"></i> <?php esc_html_e('Payment Successful!', 'felan-framework'); ?></strong>
                    <p><?php esc_html_e('Your package has been successfully activated. You can now enjoy all the benefits of your package.', 'felan-framework'); ?></p>
                </div>
            <?php endif; ?>

            <a href="<?php echo felan_get_permalink('freelancer_dashboard'); ?>" class="felan-button"><?php esc_html_e('Go to Dashboard', 'felan-framework'); ?></a>
        <?php else : ?>
            <div class="felan-heading">
                <h2><?php esc_html_e('Thank you for your purchase', 'felan-framework'); ?></h2>
            </div>
            <div class="felan-thankyou-content">
                <?php esc_html_e('Payment Successful! Your package has been successfully updated.', 'felan-framework'); ?>
            </div>
            <a href="<?php echo felan_get_permalink('freelancer_dashboard'); ?>" class="felan-button"> <?php esc_html_e('Go to Dashboard', 'felan-framework'); ?> </a>
        <?php endif;
        do_action('felan_after_freelancer_payment_completed');
        ?>
    </div>
</div>
