<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
wp_enqueue_style('lity');
wp_enqueue_script('lity');
$custom_field_freelancer = felan_render_custom_field('freelancer');
$image_src = FELAN_PLUGIN_URL . 'assets/images/bg-video.webp';
if (count($custom_field_freelancer) <= 0) {
    return;
}
?>
<?php switch ($field['type']) {
    case 'text':
        if (!empty($freelancer_meta_data[$field['id']])) {
            $field_value = trim($freelancer_meta_data[$field['id']][0]);
            if (!empty($field_value)) { ?>
                <div class="additional-warpper">
                    <h4 class="title-freelancer"><?php echo $field['title']; ?></h4>
                    <div class="content">
                        <?php echo esc_html($field_value); ?>
                    </div>
                </div>
            <?php }
        }
        break;
    case 'url':
        if (!empty($freelancer_meta_data[$field['id']])) {
            $url_value = trim($freelancer_meta_data[$field['id']][0]);
            $oembed_content = wp_oembed_get($url_value, array('wmode' => 'transparent'));
            if (!empty($url_value) && !empty($oembed_content)) { ?>
                <div class="additional-warpper">
                    <h4 class="title-freelancer"><?php echo $field['title']; ?></h4>
                    <div class="embed-responsive embed-responsive-16by9 embed-responsive-full">
                        <?php echo $oembed_content; ?>
                    </div>
                </div>
            <?php }
        }
        break;
    case 'textarea':
        if (!empty($freelancer_meta_data[$field['id']])) {
            $field_value = trim($freelancer_meta_data[$field['id']][0]);
            if (!empty($field_value)) { ?>
                <div class="additional-warpper">
                    <h4 class="title-freelancer"><?php echo $field['title']; ?></h4>
                    <div class="content">
                        <?php echo nl2br(esc_html($field_value)); ?>
                    </div>
                </div>
            <?php }
        }
        break;
    case 'select':
        if (!empty($freelancer_meta_data[$field['id']])) {
            $field_value = trim($freelancer_meta_data[$field['id']][0]);
            if (!empty($field_value)) { ?>
                <div class="additional-warpper">
                    <h4 class="title-freelancer"><?php echo $field['title']; ?></h4>
                    <div class="content">
                        <?php echo esc_html($field_value); ?>
                    </div>
                </div>
            <?php }
        }
        break;
    case 'checkbox_list':
        if (!empty($freelancer_meta_data[$field['id']])) {
            $freelancer_field = get_post_meta($freelancer_data->ID, $field['id'], true);
            if (empty($freelancer_field)) {
                $freelancer_field = array();
            }
            $has_selected = false;
            foreach ($field['options'] as $opt_value) {
                if (in_array($opt_value, $freelancer_field)) {
                    $has_selected = true;
                    break;
                }
            }
            if ($has_selected) { ?>
                <div class="additional-warpper">
                    <h4 class="title-freelancer"><?php echo $field['title']; ?></h4>
                    <div class="content">
                        <?php foreach ($field['options'] as $opt_value) :
                            if (in_array($opt_value, $freelancer_field)) : ?>
                                <div class="label label-skills"><?php echo esc_html($opt_value); ?></div>
                        <?php endif;
                        endforeach; ?>
                    </div>
                </div>
            <?php }
        }
        break;
    case 'image':
        $freelancer_field = get_post_meta($freelancer_data->ID, $field['id'], true);
        if (!empty($freelancer_field['url'])) { ?>
            <div class="additional-warpper">
                <h4 class="title-freelancer"><?php echo $field['title']; ?></h4>
                <img src="<?php echo esc_html($freelancer_field['url']); ?>" alt="<?php echo esc_attr($field['title']); ?>" />
            </div>
<?php }
        break;
    case 'file':
        $freelancer_field = get_post_meta($freelancer_data->ID, $field['id'], true);
        $file_title = $file_url = '';
        if(!empty($freelancer_field)){
            $file_title = get_the_title(intval($freelancer_field));
            $file_url = wp_get_attachment_url(intval($freelancer_field));
        }
        if (!empty($file_url)) { ?>
            <div class="block-archive-inner jobs-additional-upload">
                <div class="additional-warpper">
                    <h4 class="title-jobs"><?php echo $field['title']; ?></h4>
                    <a class="felan-button" href="<?php echo esc_attr($file_url); ?>">
                        <i class="far fa-download"></i>
                        <?php echo esc_html($file_title); ?>
                    </a>
                </div>
            </div>
        <?php }
        break;
}
