<?php
if (!defined('ABSPATH')) {
    exit;
}

$title = isset($title) ? $title : esc_html__('Confirm', 'felan-framework');
$message = isset($message) ? $message : esc_html__('Are you sure you want to perform this action?', 'felan-framework');
$confirm_text = isset($confirm_text) ? $confirm_text : esc_html__('Confirm', 'felan-framework');
$cancel_text = isset($cancel_text) ? $cancel_text : esc_html__('Cancel', 'felan-framework');
$modal_id = isset($modal_id) ? $modal_id : 'felan-confirm-modal';
$confirm_class = isset($confirm_class) ? $confirm_class : 'btn-confirm-action';
$cancel_class = isset($cancel_class) ? $cancel_class : 'btn-cancel-action';
?>
<div class="form-popup felan-form-popup felan-confirm-modal" id="<?php echo esc_attr($modal_id); ?>" style="display: none;">
    <div class="bg-overlay"></div>
    <div class="project-popup inner-popup custom-scrollbar">
        <a href="#" class="btn-close <?php echo esc_attr($cancel_class); ?>"><i class="far fa-times"></i></a>
        <h5><?php echo esc_html($title); ?></h5>
        <p class="confirm-message"><?php echo esc_html($message); ?></p>
        <div class="button-warpper">
            <a href="#" class="felan-button button-outline <?php echo esc_attr($cancel_class); ?>"><?php echo esc_html($cancel_text); ?></a>
            <a href="#" class="felan-button <?php echo esc_attr($confirm_class); ?>"><?php echo esc_html($confirm_text); ?></a>
        </div>
    </div>
</div>

