<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
global $current_user;
$user_id = $current_user->ID;
$freelancer_id = get_the_ID();
$author_id = get_post_field('post_author', $freelancer_id);
$args = array(
    'posts_per_page' => -1,
    'post_type' => 'project',
    'post_status' => 'publish',
    'ignore_sticky_posts' => 1,
    'author' => $user_id,
);
$the_query = new WP_Query($args);
$my_project_invite = get_user_meta($author_id, FELAN_METABOX_PREFIX . 'my_project_invite', true);
?>

<div class="form-popup felan-form-invite" id="form-invite-project-popup">
    <div class="bg-overlay"></div>
    <form class="invite-popup custom-scrollbar">
        <a href="#" class="btn-close"><i class="far fa-times"></i></a>
        <h5><?php esc_html_e('Invite to apply project', 'felan-framework'); ?></h5>
        <p><?php esc_html_e('Select project to invite this user', 'felan-framework'); ?></p>

        <!-- Error/Success Message Container -->
        <div class="invite-message" style="display: none;"></div>

        <?php
        $list_projects = array();
        if ($the_query->have_posts()) {
            // Count total projects
            $total_projects = $the_query->post_count;
            $show_search = $total_projects > 5; // Show search if more than 5 projects
            ?>
            <?php if ($show_search) { ?>
                <!-- Search Box - Only show if more than 5 projects -->
                <div class="project-search-wrapper">
                    <input type="text" class="project-search-input" placeholder="<?php esc_attr_e('Search projects...', 'felan-framework'); ?>" autocomplete="off">
                    <i class="far fa-search project-search-icon"></i>
                </div>
            <?php } ?>

            <!-- Project Selection Field with Error Container -->
            <div class="project-selection-field">
                <ul class="type filter-control custom-scrollbar project-list">
                <?php while ($the_query->have_posts()) :
                    $the_query->the_post();
                    $css_class = '';
                    $key = false;
                    $project_id = get_the_ID();
                    $list_projects[] = get_the_ID();
                    $project_title = get_the_title($project_id);
                    if (!empty($my_project_invite)) {
                        $key = array_search($project_id, $my_project_invite);
                    }
                    if ($key !== false) {
                        $css_class = 'checked';
                    }
                ?>
                    <li data-project-title="<?php echo esc_attr(strtolower($project_title)); ?>" class="<?php echo ($key !== false) ? 'has-invite' : ''; ?>">
                        <input type="checkbox" id="felan_project_<?php echo esc_attr($project_id); ?>" class="custom-checkbox input-control" name="projects_invite[]" <?php echo esc_attr($css_class); ?> value="<?php echo esc_attr($project_id); ?>">
                        <label for="felan_project_<?php echo esc_attr($project_id); ?>">
                            <span class="project-title-text"><?php echo esc_html($project_title); ?></span>
                            <?php if ($key !== false) { ?>
                                <span class="project-invite-badge" title="<?php esc_attr_e('Already invited', 'felan-framework'); ?>">
                                    <i class="far fa-check-circle"></i>
                                    <span><?php esc_html_e('Invited', 'felan-framework'); ?></span>
                                </span>
                            <?php } ?>
                        </label>
                    </li>
                <?php endwhile; ?>
                </ul>
                <!-- Error message for project selection -->
                <div class="field-error project-selection-error" style="display: none;" role="alert"></div>
            </div>
            <div class="button-warpper">
                <a href="#" class="felan-button button-outline button-block felan-clear-project-invite"><?php esc_html_e('Clear', 'felan-framework'); ?></a>
                <a href="#" class="felan-button button-block" id="btn-saved-project-invite">
                    <?php esc_html_e('Invite', 'felan-framework'); ?>
                    <span class="btn-loading"><i class="far fa-spinner fa-spin large"></i></span>
                </a>
            </div>
            <input type="hidden" name="freelancer_id" value="<?php echo esc_attr($freelancer_id) ?>" />
            <input type="hidden" name="author_id" value="<?php echo esc_attr($author_id) ?>" />
            <input type="hidden" name="list_projects" value="<?php echo esc_attr(json_encode($list_projects)) ?>" />
            <input type="hidden" name="nonce" value="<?php echo esc_attr(wp_create_nonce('felan_project_invite_nonce')); ?>" />
        <?php } else { ?>
            <div class="no-projects-message">
                <i class="far fa-folder-open"></i>
                <h6><?php esc_html_e('No Projects Available', 'felan-framework'); ?></h6>
                <p><?php esc_html_e('You haven\'t created any projects yet. Please create a project first to invite this freelancer.', 'felan-framework'); ?></p>
            </div>
        <?php } ?>
    </form>
</div>

