<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
global $current_user, $service_data, $service_meta_data;
$user_id = $current_user->ID;
?>
<div class="service-fields-wrap">
    <div class="service-fields service-additional row block-from" id="service-submit-additional">
        <?php
        $custom_field_service = felan_render_custom_field('service');
        if (count($custom_field_service) > 0) {
            foreach ($custom_field_service as $key => $field) {
                // If editing, get value from post meta, otherwise from user meta
                if (!empty($service_data) && !empty($service_meta_data)) {
                    $field_value = isset($service_meta_data[$field['id']]) ? $service_meta_data[$field['id']][0] : '';
                    // For checkbox_list, need to get unserialized data
                    if ($field['type'] == 'checkbox_list' || $field['type'] == 'image') {
                        $field_value = get_post_meta($service_data->ID, $field['id'], true);
                    }
                } else {
                    $field_value_arr = get_user_meta($user_id, $field['id']);
                    $field_value = isset($field_value_arr[0]) ? $field_value_arr[0] : '';
                }
                switch ($field['type']) {
                    case 'text':
        ?>
                        <div class="form-group col-12">
                            <label><?php echo esc_html($field['title']); ?></label>
                            <input type="text" id="<?php echo esc_attr($field['id']); ?>" class="form-control" name="<?php echo esc_attr($field['id']); ?>" value="<?php echo esc_attr($field_value); ?>" placeholder="<?php esc_attr_e('Your Value', 'felan-framework'); ?>">
                        </div>
                    <?php
                        break;
                    case 'url':
                    ?>
                        <div class="form-group col-12">
                            <label><?php echo esc_html($field['title']); ?></label>
                            <input type="url" id="<?php echo esc_attr($field['id']); ?>" class="form-control" name="<?php echo esc_attr($field['id']); ?>" value="<?php echo esc_attr($field_value); ?>" placeholder="<?php esc_attr_e('Your Url', 'felan-framework'); ?>">
                        </div>
                    <?php
                        break;
                    case 'textarea':
                    ?>
                        <div class="form-group col-12">
                            <label><?php echo esc_html($field['title']); ?></label>
                            <textarea name="<?php echo esc_attr($field['id']); ?>" rows="6" id="<?php echo esc_attr($field['id']); ?>" class="form-control"><?php echo esc_textarea($field_value); ?></textarea>
                        </div>
                    <?php
                        break;
                    case 'select':
                    ?>
                        <div class="form-group col-12">
                            <label class="d-block"><?php echo esc_html($field['title']); ?></label>
                            <div class="select2-field">
                                <select name="<?php echo esc_attr($field['id']); ?>" id="<?php echo esc_attr($field['id']); ?>" class="form-control felan-select2">
                                    <?php
                                    foreach ($field['options'] as $opt_value) : ?>
                                        <option value="<?php echo esc_attr($opt_value); ?>" <?php selected($field_value, $opt_value); ?>><?php echo esc_html($opt_value); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    <?php
                        break;
                    case 'checkbox_list':
                    ?>
                        <div class="form-group col-12">
                            <label><?php echo esc_html($field['title']); ?></label>
                            <div class="felan-field-<?php echo esc_attr($field['id']); ?>">
                                <?php
                                $service_field = is_array($field_value) ? $field_value : array();
                                foreach ($field['options'] as $opt_value) :
                                    $is_checked = in_array($opt_value, $service_field);
                                ?>
                                    <div class="checkbox-inline inline">
                                        <input class="custom-checkbox" type="checkbox" name="<?php echo esc_attr($field['id']); ?>[]" value="<?php echo esc_attr($opt_value); ?>" <?php checked($is_checked); ?>><?php echo esc_html($opt_value); ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php
                        break;
                    case 'image':
                        felan_get_custom_image_enqueue();
                        $image_url = '';
                        $image_id = '';
                        if (is_array($field_value) && !empty($field_value['url'])) {
                            $image_url = $field_value['url'];
                            $image_id = $field_value['id'];
                        }
                        ?>
                        <div class="form-group col-12 felan-fields-custom_image">
                            <label><?php echo esc_html($field['title']); ?></label>
                            <div class="felan-field-<?php echo esc_attr($field['id']); ?>">
                                <div id="felan_custom_image_errors_<?php echo esc_attr($field['id']); ?>" class="errors-log"></div>
                                <div id="felan_custom_image_container_<?php echo esc_attr($field['id']); ?>" class="file-upload-block preview">
                                    <div id="felan_custom_image_view_<?php echo esc_attr($field['id']); ?>" class="custom-image-view">
                                        <?php if (!empty($image_url)) : ?>
                                            <div class="custom-image-item">
                                                <img src="<?php echo esc_url($image_url); ?>" alt="">
                                                <span class="custom-image-remove"><i class="far fa-times"></i></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div id="felan_add_custom_image_<?php echo esc_attr($field['id']); ?>" class="custom-image-add" <?php echo !empty($image_url) ? 'style="display:none;"' : ''; ?>>
                                        <i class="far fa-arrow-from-bottom large"></i>
                                        <p id="felan_drop_custom_image_<?php echo esc_attr($field['id']); ?>">
                                            <button type="button" id="felan_select_custom_image_<?php echo esc_attr($field['id']); ?>" class="select-custom-image"><?php esc_html_e('Click here', 'felan-framework') ?></button>
                                            <?php esc_html_e(' or drop files to upload', 'felan-framework') ?>
                                        </p>
                                    </div>
                                    <input type="hidden" class="custom_image_url" value="<?php echo esc_attr($image_url); ?>" id="custom_image_url_<?php echo esc_attr($field['id']); ?>">
                                    <input type="hidden" class="custom_image_id" value="<?php echo esc_attr($image_id); ?>" id="custom_image_id_<?php echo esc_attr($field['id']); ?>" />
                                </div>
                            </div>
                            <p class="felan-custom_image-size"><?php esc_html_e('The cover image size should be max 1920 x 400px', 'felan-framework') ?></p>
                            <input type="hidden" class="image-id" value="<?php echo esc_attr($field['id']); ?>">
                        </div>
        <?php
                        break;
                    case 'file':
                        felan_get_custom_upload_enqueue();
                        $cv_file = felan_get_option('felan-cv-type');
                        $file_id = !empty($field_value) ? intval($field_value) : '';
                        $file_title = $file_id ? get_the_title($file_id) : '';
                        $file_url = $file_id ? wp_get_attachment_url($file_id) : '';
                        ?>
                        <div class="form-group col-12 felan-fields-custom_upload">
                            <label><?php echo esc_html($field['title']); ?></label>
                            <div class="felan-field-<?php echo esc_attr($field['id']); ?>">
                                <div id="cv_errors_log_<?php echo esc_attr($field['id']); ?>" class="errors-log"></div>
                                <div id="felan_cv_container_<?php echo esc_attr($field['id']); ?>" class="file-upload-block">
                                    <?php if ($file_id && $file_title) : ?>
                                        <div class="file-uploaded-item">
                                            <div class="file-info">
                                                <i class="far fa-file-alt"></i>
                                                <span class="file-name"><?php echo esc_html($file_title); ?></span>
                                            </div>
                                            <div class="media-item-actions">
                                                <a href="#" class="icon-file-delete" data-field-id="<?php echo esc_attr($field['id']); ?>" data-attachment-id="<?php echo esc_attr($file_id); ?>">
                                                    <i class="far fa-trash-alt"></i>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="file-upload-button" id="felan_cv_upload_<?php echo esc_attr($field['id']); ?>" <?php echo $file_id ? 'style="display:none;"' : ''; ?>>
                                        <button class="felan-button" type="button" id="felan_select_cv_<?php echo esc_attr($field['id']); ?>">
                                            <i class="far fa-arrow-from-bottom"></i>
                                            <span><?php esc_html_e('Browse', 'felan-framework'); ?></span>
                                        </button>
                                    </div>
                                    <input type="hidden" class="cv_attachment_id" name="<?php echo esc_attr($field['id']); ?>" value="<?php echo esc_attr($file_id); ?>" id="cv_attachment_id_<?php echo esc_attr($field['id']); ?>">
                                </div>
                            </div>
                            <div class="file-type"><?php echo esc_html(sprintf(__('Upload file: %s', 'felan-framework'), $cv_file)); ?></div>
                        </div>
                        <?php
                        break;
                }
            }
        }
        ?>
    </div>
</div>

