/***************************************************
==================== JS INDEX ======================
****************************************************
01. PreLoader Js
02. Mobile Menu Js
03. Sticky Js
04. Backtotop Js
05. Common Js
06. Offcanvas Js
07. Search Js
08. Cartmini Js
09. Filter Js
10. Body overlay Js
11. Range slider Js
12. Nice Select Js
13. Year change slider Js
14. MagnificPopup Js
15. Wow Js
16. Ecommerce js
17. Line Animation Js
18. Counter Js
19. Header height Js
20. Click btn Js
21. Password Toggle Js
22. Select 2 Js
23. Date and time Js
24. Calernder Js
25. Chart Js
****************************************************/

(function ($) {
	"use strict";

	var windowOn = $(window);

	////////////////////////////////////////////////////
	// 01. PreLoader Js
	windowOn.on('load', function () {
		$("#loading").fadeOut(500);
	});


	////////////////////////////////////////////////////
	// 02. Mobile menu js
	if ($('.tp-main-menu-content').length && $('.tp-main-menu-mobile').length) {
		let navContent = document.querySelector(".tp-main-menu-content").outerHTML;
		let mobileNavContainer = document.querySelector(".tp-main-menu-mobile");
		mobileNavContainer.innerHTML = navContent;

		let arrow = $(".tp-main-menu-mobile .has-dropdown > a");

		arrow.each(function () {
			let self = $(this);
			let arrowBtn = document.createElement("BUTTON");
			arrowBtn.classList.add("dropdown-toggle-btn");

			// Append the arrow button after the link
			self[0].appendChild(arrowBtn);

			function toggleDropdown(e) {
				e.preventDefault();
				let self = $(this);
				let parent = self.parent();
				let submenu = parent.children(".tp-submenu, .tp-megamenu-main");

				self.toggleClass("dropdown-opened");
				parent.toggleClass("expanded");
				parent.parent().addClass("dropdown-opened").siblings().removeClass("dropdown-opened").find(".tp-submenu, .tp-megamenu-main").slideUp();

				submenu.slideToggle();
			}

			// Add event listeners to both the link and the button
			self.on("click", toggleDropdown);
			$(arrowBtn).on("click", toggleDropdown);
		});
	}

	// Mega menu hover width
	var homeDemoMenu = $('.main-menu .tp-megamenu-main');

	homeDemoMenu.each(function () {
		if ($(this).children('.megamenu-demo-conteiner').length > 0) {
			$(this).addClass('tp-megamenu-container')
		}

		if ($(this).children('.megamenu-demo-academics').length > 0) {
			$(this).addClass('tp-megamenu-academics')
		}

		if ($(this).children('.megamenu-demo-courses').length > 0) {
			$(this).addClass('tp-megamenu-courses')
		}

		if ($(this).children('.megamenu-demo-fullwidth').length > 0) {
			$(this).addClass('tp-megamenu-fullwidth')
		}

		if ($(this).children('.megamenu-demo-small').length > 0) {
			$(this).addClass('tp-megamenu-small')
		}
	})

	// last child menu
	$('.tp-acadia-defaults-headers nav > ul > li').slice(-4).addClass('menu-last');


	////////////////////////////////////////////////////
	// 03. Sticky Header Js
	windowOn.on('scroll', function () {
		var scroll = $(window).scrollTop();
		if (scroll < 200) {
			$("#header-sticky").removeClass("tp-header-sticky");
		} else {
			$("#header-sticky").addClass("tp-header-sticky");
		}

	});


	/////////////////////////////////////////////////
	// 04. back_to_top//////////////////
	function back_to_top() {
		var btn = $('#back_to_top');
		var btn_wrapper = $('.back-to-top-wrapper');

		windowOn.scroll(function () {
			if (windowOn.scrollTop() > 300) {
				btn_wrapper.addClass('back-to-top-btn-show');
			} else {
				btn_wrapper.removeClass('back-to-top-btn-show');
			}
		});

		btn.on('click', function (e) {
			e.preventDefault();
			$('html, body').animate({ scrollTop: 0 }, '300');
		});
	}
	back_to_top();


	////////////////////////////////////////////////////
	// 05. Common Js
	$("[data-background").each(function () {
		$(this).css("background-image", "url( " + $(this).attr("data-background") + "  )");
	});

	$("[data-width]").each(function () {
		$(this).css("width", $(this).attr("data-width"));
	});

	$("[data-bg-color]").each(function () {
		$(this).css("background-color", $(this).attr("data-bg-color"));
	});

	$("[data-text-color]").each(function () {
		$(this).css("color", $(this).attr("data-text-color"));
	});

	$("[data-cat-color]").each(function () {
		var color = $(this).attr("data-cat-color")
		$(this).css({
			'color': color,
		});
		// $(this)[0].style.setProperty('color', color);
		// $(this)[0].style.setProperty('background-color', `rgba(${color}, 0.08)`);
	});



	////////////////////////////////////////////////////
	// 06. Offcanvas Js
	$(".offcanvas-open-btn").on("click", function () {
		$(".offcanvas__area").addClass("offcanvas-opened");
		$(".body-overlay").addClass("opened");
	});
	$(".offcanvas-close-btn").on("click", function () {
		$(".offcanvas__area").removeClass("offcanvas-opened");
		$(".body-overlay").removeClass("opened");
	});
	$(".body-overlay").on("click", function () {
		$(".offcanvas__area").removeClass("offcanvas-opened");
		$(".body-overlay").removeClass("opened");
	});


	////////////////////////////////////////////////////
	// 07. Search Js
	$(".tp-search-open-btn").on("click", function () {
		$(".tp-search-area").addClass("opened");
		$(".body-overlay").addClass("opened");
	});
	$(".tp-search-close-btn").on("click", function () {
		$(".tp-search-area").removeClass("opened");
		$(".body-overlay").removeClass("opened");
	});


	////////////////////////////////////////////////////
	// 08. cartmini Js
	$(".cartmini-open-btn").on("click", function () {
		$(".cartmini__area").addClass("cartmini-opened");
		$(".body-overlay").addClass("opened");
	});
	$(".cartmini-close-btn").on("click", function () {
		$(".cartmini__area").removeClass("cartmini-opened");
		$(".body-overlay").removeClass("opened");
	});

	////////////////////////////////////////////////////
	// 09. filter
	$(".filter-open-btn").on("click", function () {
		$(".tp-filter-offcanvas-area").addClass("offcanvas-opened");
		$(".body-overlay").addClass("opened");
	});

	$(".filter-close-btn").on("click", function () {
		$(".tp-filter-offcanvas-area").removeClass("offcanvas-opened");
		$(".body-overlay").removeClass("opened");
	});

	$(".filter-open-dropdown-btn").on("click", function (e) {
		e.preventDefault();
		$(".tp-filter-dropdown-area").toggleClass('filter-dropdown-opened');
	});

	$(".filter-open-dropdown-btn-2").on("click", function (e) {
		e.preventDefault();
		$(".tp-filter-dropdown-area").slideToggle(300);
	});

	$(".archive-filter-btn").on("click", function () {
		$(".filter__area").addClass("filter-opened");
		$(".filter-overlay").addClass("opened");
	});

	$(".filter-close-btn").on("click", function () {
		$(".filter__area").removeClass("filter-opened");
		$(".filter-overlay").removeClass("opened");
	});
	$(".filter-overlay").on("click", function () {
		$(".filter__area").removeClass("filter-opened");
		$(".filter-overlay").removeClass("opened");
	});

	$(".filter-offcanvas-open-btn").on("click", function () {
		$(".tp-filter-dropdown-wrapper-3").addClass("filter-offcanvas-opened");
		$(".filter-offcanvas-overlay").addClass("opened");
	});

	$('.tp-filter-offcanvas-close-btn').on('click', function () {
		$(".tp-filter-dropdown-wrapper-3").removeClass("filter-offcanvas-opened");
		$(".filter-offcanvas-overlay").removeClass("opened");
	});

	$(".filter-offcanvas-overlay").on("click", function () {
		$(".tp-filter-dropdown-wrapper-3").removeClass("filter-offcanvas-opened");
		$(".filter-offcanvas-overlay").removeClass("opened");
	});


	////////////////////////////////////////////////////
	// 10. Body overlay Js
	$(".body-overlay").on("click", function () {
		$(".offcanvas__area").removeClass("offcanvas-opened");
		$(".tp-search-area").removeClass("opened");
		$(".cartmini__area").removeClass("cartmini-opened");
		$(".tp-filter-offcanvas-area").removeClass("offcanvas-opened");
		$(".body-overlay").removeClass("opened");
	});


	///////////////////////////////////////////
	// 11. Range slider
	if ($('#slider-range').length > 0) {
		$("#slider-range").slider({
			range: true,
			min: 0,
			max: 500,
			values: [75, 300],
			slide: function (event, ui) {
				$("#amount").val("$" + ui.values[0] + " - $" + ui.values[1]);
			}
		});
		$("#amount").val("$" + $("#slider-range").slider("values", 0) +
			" - $" + $("#slider-range").slider("values", 1));

		$("#slider-range-offcanvas").slider({
			range: true,
			min: 0,
			max: 500,
			values: [75, 300],
			slide: function (event, ui) {
				$("#amount-offcanvas").val("$" + ui.values[0] + " - $" + ui.values[1]);
			}
		});
		$("#amount-offcanvas").val("$" + $("#slider-range-offcanvas").slider("values", 0) +
			" - $" + $("#slider-range-offcanvas").slider("values", 1));
	}


	////////////////////////////////////////////////////
	// 12. Nice Select Js
	if ($('select').length > 0) {
		$('.tp-sidebar-wrapper select, .tp-sidebar-widget select, .tpd-select select, .tp-footer-widget select, .tp-postbox-details-main-wrapper select, .tp-course-grid-select select, .tp-course-filter-select select, .stm_lms_courses_grid__sort select').niceSelect();
	}


	////////////////////////////////////////////////////
	// Active Class 
	$('.tp-plan-4-item').on('mouseenter', function () {
		$(this).addClass('active').parent().siblings().find('.tp-plan-4-item').removeClass('active');
	})

	if ($('.tp-header-user-hover').length > 0) {
		window.addEventListener('click', function (e) {
			let clickedElement = e.target;

			$('.tp-header-user-hover').each(function () {
				if (this.contains(clickedElement)) {
					$(this).toggleClass('active');
				} else {
					$(this).removeClass('active');
				}
			});
		});
	}

	// class add js
	$('.tp-course-details2-nav nav ul li').on('click', function () {
		$(this).addClass('current').siblings().removeClass('current');
	});


	////////////////////////////////////////////////////
	// . language
	if ($("#header-bottom__lang-toggle").length > 0) {
		window.addEventListener('click', function (e) {

			if (document.getElementById('header-bottom__lang-toggle').contains(e.target)) {
				$(".header-bottom__lang-submenu, .header-bottom__lang-submenu-2").toggleClass("open");
			}
			else {
				$(".header-bottom__lang-submenu, .header-bottom__lang-submenu-2").removeClass("open");
			}
		});
	}

	if ($("#menu-language-menu").length > 0) {

		$(document).on('click', '.nav-links', function (e) {
			e.preventDefault();
			$(".tp-submenu").toggleClass("open");
		})
	}



	// Function to hide the parent section
	$('.hide-button').on('click', function () {
		$('.tp-announcement-area').slideUp(200);
	});

	$(document).ready(function () {
		$('.close').on('click', function () {
			$(this).toggleClass('active');
			$('.tpd-continue-learning-sidebar').toggleClass('d-none d-block');
		});
	});


	// home one
	function tp_main_slider() {

		var slider_animation = 3500;
		if (typeof slider_anim !== 'undefined' && slider_anim.animation) {
			slider_animation = slider_anim.animation;
		}

		var slider = new Swiper('.tp-slider-active', {
			slidesPerView: 1,
			effect: 'fade',
			loop: true,
			autoplay: {
				delay: slider_animation,
			},
			// Navigation arrows
			pagination: {
				el: ".tp-program-dot",
				clickable: true,
			},
		});

		var slider_animation_2 = 3400;
		if (typeof slider_anim_2 !== 'undefined' && slider_anim_2.animation_2) {
			slider_animation_2 = slider_anim_2.animation_2;
		}

		// home Five
		let is_rtl = $('html').attr('dir') == 'rtl' ? true : false;
		$('.tp-slider-5-active').slick({
			slidesToShow: 1,
			slidesToScroll: 1,
			arrows: false,
			fade: true,
			rtl: is_rtl,
			asNavFor: '.tp-slider-5-arrow',
			autoplay: true,
			autoplaySpeed: slider_animation_2
		});
		$('.tp-slider-5-arrow').slick({
			slidesToShow: 3,
			slidesToScroll: 1,
			asNavFor: '.tp-slider-5-active',
			dots: false,
			centerMode: false,
			focusOnSelect: true,
			rtl: is_rtl,
			centerPadding: "5px",
			arrows: false,
			responsive: [
				{
					breakpoint: 500,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 1,
						centerPadding: '15px',
					},
				},
			],
		});

	}

	function tp_slider_shop() {
		// Initialize Swiper
		var slider = new Swiper('.tp-shop-banner-active', {
			slidesPerView: 1,
			spaceBetween: 30,
			loop: true,

			pagination: {
				el: ".tp-shop-banner-dot",
				clickable: true,
			},
		});
	}

	// tp_academic_programs
	function tp_academic_programs() {
		// home one
		var slider = new Swiper('.tp-program-active', {
			slidesPerView: 3,
			spaceBetween: 30,
			loop: true,
			// Navigation arrows
			pagination: {
				el: ".tp-program-dot",
				clickable: true,
			},
			breakpoints: {
				'1200': {
					slidesPerView: 3,
				},
				'992': {
					slidesPerView: 3,
				},
				'768': {
					slidesPerView: 2,
				},
				'576': {
					slidesPerView: 1,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});

		// home Four
		var slider = new Swiper('.tp-program-4-active', {
			slidesPerView: 4,
			spaceBetween: 10,
			loop: true,
			autoplay: {
				delay: 5000,
			},
			// Navigation arrows
			navigation: {
				nextEl: ".tp-program-4-next",
				prevEl: ".tp-program-4-prev",
			},
			breakpoints: {
				'1200': {
					slidesPerView: 4,
				},
				'992': {
					slidesPerView: 3,
				},
				'768': {
					slidesPerView: 2,
				},
				'576': {
					slidesPerView: 2,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});

	}

	//testimonial
	function tp_testimonial_slider() {
		// home 1
		var swiper = new Swiper('.tp-testimonial-active', {
			slidesPerView: 1,
			spaceBetween: 10,
			loop: true,
			// Navigation arrows
			navigation: {
				nextEl: ".tp-testimonial-next",
				prevEl: ".tp-testimonial-prev",
			},
			autoplay: {
				delay: 2000,
			},
			breakpoints: {
				'1200': {
					slidesPerView: 1,
				},
				'992': {
					slidesPerView: 1,
				},
				'768': {
					slidesPerView: 1,
				},
				'576': {
					slidesPerView: 1,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});

		// home Two
		$('.tp-testimonial-2-avatar-active').slick({
			slidesToShow: 5,
			slidesToScroll: 1,
			asNavFor: '.tp-testimonial-2-active',
			dots: false,
			centerMode: true,
			centerPadding: '0px',
			prevArrow: '<button type="button" class="slick-prev"><i class="fa-solid fa-angle-left"></i></button>',
			nextArrow: '<button type="button" class="slick-next"><i class="fa-solid fa-angle-right"></i></button>',
			focusOnSelect: true,
			responsive: [
				{
					breakpoint: 500,
					settings: {
						slidesToShow: 3,
						slidesToScroll: 1,
					},
				},
			],
		});
		$('.tp-testimonial-2-active').slick({
			slidesToShow: 1,
			slidesToScroll: 1,
			arrows: false,
			fade: false,
			asNavFor: '.tp-testimonial-2-avatar-active'
		});

		// home Six
		var slider = new Swiper('.tp-testimonial-6-active', {
			loop: true,
			freemode: true,
			slidesPerView: 'auto',
			spaceBetween: 15,
			centeredSlides: true,
			allowTouchMove: false,
			slidesPerView: 5,
			speed: 6000,
			autoplay: {
				delay: 1,
				disableOnInteraction: true,
			},
			breakpoints: {
				'1400': {
					slidesPerView: 5,
				},
				'1200': {
					slidesPerView: 4,
				},
				'992': {
					slidesPerView: 3,
				},
				'768': {
					slidesPerView: 2,
				},
				'576': {
					slidesPerView: 2,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});
	}

	// home one
	function tp_instagram_slider() {
		var swiper = new Swiper(".tp-instagram-active", {
			slidesPerView: 5,
			spaceBetween: 10,
			freeMode: false,
			loop: true,
			autoplay: {
				delay: 3500,
			},
			breakpoints: {
				'1200': {
					slidesPerView: 5,
				},
				'992': {
					slidesPerView: 4,
				},
				'768': {
					slidesPerView: 3,
				},
				'576': {
					slidesPerView: 2,
				},
				'0': {
					slidesPerView: 2,
				},
			},
		});
	}
	tp_instagram_slider();

	// campus life 
	var swiper = new Swiper(".tp-campus-life-active", {
		slidesPerView: 'auto',
		spaceBetween: 130,
		loop: true,
		navigation: {
			nextEl: ".tp-campus-next",
			prevEl: ".tp-campus-prev",
		},
		breakpoints: {
			'1200': {
				spaceBetween: 130,
			},
			'768': {
				spaceBetween: 80,
			},
			'400': {
				spaceBetween: 50,
			},
		},
	});

	function tp_team_slider() {
		// home Two
		var slider = new Swiper('.tp-team-2-active', {
			slidesPerView: 4,
			spaceBetween: 30,
			loop: true,
			autoplay: {
				delay: 5000,
			},
			// Navigation arrows
			navigation: {
				nextEl: ".tp-team-2-next",
				prevEl: ".tp-team-2-prev",
			},
			breakpoints: {
				'1200': {
					slidesPerView: 4,
				},
				'992': {
					slidesPerView: 3,
				},
				'768': {
					slidesPerView: 2,
				},
				'576': {
					slidesPerView: 2,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});

		// home Five
		var slider = new Swiper('.tp-trainer-5-active', {
			slidesPerView: 2,
			spaceBetween: 30,
			loop: true,
			autoplay: {
				delay: 3000,
			},
			breakpoints: {
				'1200': {
					slidesPerView: 2,
				},
				'992': {
					slidesPerView: 2,
				},
				'768': {
					slidesPerView: 2,
				},
				'576': {
					slidesPerView: 2,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});

		// home Six
		var slider = new Swiper('.tp-team-6-active', {
			slidesPerView: 4,
			spaceBetween: 30,
			loop: true,
			autoplay: {
				delay: 5000,
			},
			// Navigation arrows
			navigation: {
				nextEl: ".tp-team-2-next",
				prevEl: ".tp-team-2-prev",
			},
			breakpoints: {
				'1400': {
					slidesPerView: 3,
				},
				'1200': {
					slidesPerView: 2.5,
				},
				'992': {
					slidesPerView: 2.2,
				},
				'768': {
					slidesPerView: 1,
				},
				'576': {
					slidesPerView: 2,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});
	}
	tp_team_slider();

	function tp_brand_slider() {

		var slider = new Swiper('.tp-brand-5-active', {
			slidesPerView: 6,
			loop: true,
			autoplay: {
				delay: 5000,
			},
			breakpoints: {
				'1200': {
					slidesPerView: 6,
				},
				'992': {
					slidesPerView: 4,
				},
				'768': {
					slidesPerView: 3,
				},
				'576': {
					slidesPerView: 2,
				},
				'0': {
					slidesPerView: 1,
				},
			},
		});
	}

	//////////////////////////////////////////////////////
	// 13. year change slider js
	function tp_about_year_slider() {
		$(function () {
			$('.slider-for').slick({
				slidesToShow: 1,
				slidesToScroll: 1,
				arrows: false,
				fade: true,
				asNavFor: '.slider-nav'
			});
			$('.slider-nav').slick({
				slidesToShow: 3,
				slidesToScroll: 1,
				asNavFor: '.slider-for',
				arrows: false,
				centerMode: true,
				focusOnSelect: true,
				responsive: [
					{
						breakpoint: 576,
						settings: {
							slidesToShow: 3,
						}
					}
				]
			});
		});
	}

	//////////////////////////////////////////////////
	// 14. magnificPopup img view
	$('.popup-image').magnificPopup({
		type: 'image',
		gallery: {
			enabled: true
		}
	});

	/* magnificPopup video view */
	$(".popup-video").magnificPopup({
		type: "iframe",
	});


	////////////////////////////////////////////////////
	// 15. Wow Js
	new WOW().init();


	/////////////////////////////////////////////
	// 16. Ecommerce js
	function tp_ecommerce() {
		$('.tp-cart-minus').on('click', function () {
			var $input = $(this).parent().find('input');
			var count = parseInt($input.val()) - 1;
			count = count < 1 ? 1 : count;
			$input.val(count);
			$input.change();
			return false;
		});

		$('.tp-cart-plus').on('click', function () {
			var $input = $(this).parent().find('input');
			$input.val(parseInt($input.val()) + 1);
			$input.change();
			return false;
		});


		$('.tp-checkout-payment-item label').on('click', function () {
			$(this).siblings('.tp-checkout-payment-desc').slideToggle(400);

		});


		$('.tp-color-variation-btn').on('click', function () {
			$(this).addClass('active').siblings().removeClass('active');
		});


		$('.tp-size-variation-btn').on('click', function () {
			$(this).addClass('active').siblings().removeClass('active');
		});

		////////////////////////////////////////////////////
		// 17. Show Login Toggle Js
		$('.tp-checkout-login-form-reveal-btn').on('click', function () {
			$('#tpReturnCustomerLoginForm').slideToggle(400);
		});

		////////////////////////////////////////////////////
		// 18. Show Coupon Toggle Js
		$('.tp-checkout-coupon-form-reveal-btn').on('click', function () {
			$('#tpCheckoutCouponForm').slideToggle(400);
		});

		////////////////////////////////////////////////////
		// 19. Create An Account Toggle Js
		$('#cbox').on('click', function () {
			$('#cbox_info').slideToggle(900);
		});

		////////////////////////////////////////////////////
		// 20. Shipping Box Toggle Js
		$('#ship-box').on('click', function () {
			$('#ship-box-info').slideToggle(1000);
		});

	}
	tp_ecommerce();


	////////////////////////////////////////////////////
	// 17. Line Animation Js
	if ($('#productTabMarker').length > 0) {
		function tp_tab_line_2() {
			var marker = document.querySelector('#productTabMarker');
			var item = document.querySelectorAll('.tp-product-tab button');
			var itemActive = document.querySelector('.tp-product-tab .nav-link.active');

			// rtl settings
			var tp_rtl = localStorage.getItem('tp_dir');
			let rtl_setting = tp_rtl == 'rtl' ? 'right' : 'left';

			function indicator(e) {
				marker.style.left = e.offsetLeft + "px";
				marker.style.width = e.offsetWidth + "px";
			}


			item.forEach(link => {
				link.addEventListener('click', (e) => {
					indicator(e.target);
				});
			});

			var activeNav = $('.nav-link.active');
			var activewidth = $(activeNav).width();
			var activePadLeft = parseFloat($(activeNav).css('padding-left'));
			var activePadRight = parseFloat($(activeNav).css('padding-right'));
			var totalWidth = activewidth + activePadLeft + activePadRight;

			var precedingAnchorWidth = anchorWidthCounter();


			$(marker).css('display', 'block');

			$(marker).css('width', totalWidth);

			function anchorWidthCounter() {
				var anchorWidths = 0;
				var a;
				var aWidth;
				var aPadLeft;
				var aPadRight;
				var aTotalWidth;
				$('.tp-product-tab button').each(function (index, elem) {
					var activeTest = $(elem).hasClass('active');
					marker.style.left = elem.offsetLeft + "px";
					if (activeTest) {
						// Break out of the each function.
						return false;
					}

					a = $(elem).find('button');
					aWidth = a.width();
					aPadLeft = parseFloat(a.css('padding-left'));
					aPadRight = parseFloat(a.css('padding-right'));
					aTotalWidth = aWidth + aPadLeft + aPadRight;

					anchorWidths = anchorWidths + aTotalWidth;

				});

				return anchorWidths;
			}
		}
		tp_tab_line_2();
	}


	////////////////////////////////////////////////////
	// 18. Counter Js
	new PureCounter();
	new PureCounter({
		filesizing: true,
		selector: ".filesizecount",
		pulse: 2,
	});


	//////////////////////////////////////////////////
	// 19. Header height
	if ($('.tp-header-height').length > 0) {
		var headerHeight = document.querySelector(".tp-header-height");
		var setHeaderHeight = headerHeight.offsetHeight;
		$(".tp-header-height").each(function () {
			$(this).css({
				'height': setHeaderHeight + 'px'
			});
		});
	}


	//////////////////////////////////////////////////
	// 20. Click btn Js
	(function () {
		var actions = $('.tpd-action-inexact-btn');
		actions.each(function () {
			var action = $(this),
				button = action.find('.click'),
				body = action.find('.tpd-action-click-tooltip');
			button.on('click', function (e) {
				e.stopPropagation();
				if (!action.hasClass('active')) {
					actions.removeClass('active');
					action.addClass('active');
				} else {
					actions.removeClass('active');
				}
			});
			body.on('click', function (e) {
				e.stopPropagation();
			});
			$('html, body').on('click', function () {
				actions.removeClass('active');
			});
		});
	})();


	////////////////////////////////////////////////////
	// 21. Password Toggle Js
	if ($('.password-show-toggle').length > 0) {

		var showBtn = $('.password-show-toggle');

		showBtn.each(function (e) {
			$(this).on('click', function (x) {
				let inputField = $(this).parent().find('input');
				if (inputField.attr('type') === "password") {
					inputField.attr('type', 'text')
					$(this).children('.open-eye-icon').css({
						'display': 'block'
					})
					$(this).children('.close-eye-icon').css({
						'display': 'none'
					})
				} else {
					inputField.attr('type', 'password')
					$(this).children('.open-eye-icon').css({
						'display': 'none'
					})
					$(this).children('.close-eye-icon').css({
						'display': 'block'
					})
				}
			})
		})
	}

	////////////////////////////////////////////////////
	// 22. Select 2 Js
	if ($('.tpd-select2').length > 0) {
		$(document).ready(function () {
			$('.tpd-select2').select2({
				placeholder: 'Search Course Category. ex. Design, Development, Business',
				allowClear: true,
				tags: true
			});
		});
	}

	////////////////////////////////////////////////////
	// 23. Date and time js
	flatpickr("input[name='datetime-local']", {
		dateFormat: "Y-m-d"
	});


	////////////////////////////////////////////////////
	// 24. Calernder js
	if ($('#calendar').length > 0) {
		document.addEventListener('DOMContentLoaded', function () {
			var calendarEl = document.getElementById('calendar');

			var calendar = new FullCalendar.Calendar(calendarEl, {
				height: '600px',
				expandRows: true,
				slotMinTime: '08:00',
				slotMaxTime: '20:00',
				headerToolbar: {
					left: 'prev,next',
					center: 'title',
					right: 'dayGridMonth,timeGridWeek,timeGridDay'
				},
				initialView: 'dayGridMonth',
				initialDate: new Date(),
				navLinks: true, // can click day/week names to navigate views
				editable: true,
				selectable: true,
			});

			calendar.render();
		});
	}

	////////////////////////////////////////////////////
	// 25. chart js
	if ($('#chart').length > 0) {

		var options = {
			chart: {
				type: 'line',
				toolbar: {
					show: false
				}
			},
			series: [{
				name: 'Profit',
				data: [30, 40, 35, 50, 49, 60, 70, 91, 125],
				color: '#556DF5'
			}],
			xaxis: {
				categories: [1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999]
			}
		}

		var chart = new ApexCharts(document.querySelector("#chart"), options);

		chart.render();
	}

	// postbox_gallery
	var postbox_gallery = new Swiper('.postbox__thumb-slider-active', {
		slidesPerView: 1,
		loop: true,
		autoplay: false,
		arrow: false,
		spaceBetween: 0,
		speed: 1000,
		effect: 'fade',
		breakpoints: {
			'1400': {
				slidesPerView: 1,
			},
			'1200': {
				slidesPerView: 1,
			},
			'992': {
				slidesPerView: 1,
			},
			'768': {
				slidesPerView: 1,
			},
			'576': {
				slidesPerView: 1,
			},
			'0': {
				slidesPerView: 1,
			},
		},
		a11y: false,

		pagination: {
			el: ".blog-sidebar-dot",
			clickable: true,
		},

		// Navigation arrows
		navigation: {
			prevEl: '.postbox-arrow-prev',
			nextEl: '.postbox-arrow-next',
		},

	});

	// related post
	var postRelated = new Swiper('.acadia-post-related-slider-active', {
		loop: true,
		slidesPerView: 3,
		spaceBetween: 30,
		speed: 1000,
		autoHeight: true,
		autoplay: {
			delay: 5000,
			disableOnInteraction: true,
		},
		pagination: {
			el: '.liko-post-related-dots',
			clickable: true,
		},
		breakpoints: {
			'1400': {
				slidesPerView: 3,
			},
			'1200': {
				slidesPerView: 3,
			},
			'992': {
				slidesPerView: 3,
			},
			'768': {
				slidesPerView: 3,
			},
			'576': {
				slidesPerView: 2,
			},
			'0': {
				slidesPerView: 1,
			},
		},
	});

	setTimeout(() => {
		$(".flex-control-thumbs").addClass("product-thumbnails");


		$('.product-thumbnails').slick({
			dots: false,
			arrows: false,
			prevArrow: '<div class="prev"><i class="far fa-angle-left"></i></div>',
			nextArrow: '<div class="next"><i class="far fa-angle-right"></i></div>',
			autoplay: false,
			Speed: 2000,
			slidesToShow: 5,
			slidesToScroll: 1,
		});
	}, 100);

	$('.woocommerce-product-gallery__image > a').magnificPopup({
		gallery: { enabled: true },
		type: 'image',
	});

	// wooRelatedProducts
	var wooRelatedProducts = new Swiper('.tp-woo-related-product-related-active', {
		loop: true,
		slidesPerView: 3,
		spaceBetween: 30,
		speed: 1000,
		autoHeight: true,
		autoplay: {
			delay: 3000,
		},
		breakpoints: {
			'992': {
				slidesPerView: 3,
			},
			'768': {
				slidesPerView: 2,
			},
			'576': {
				slidesPerView: 2,
			},
			'0': {
				slidesPerView: 1,
			},
		},
	});

	$('.woocommerce-product-gallery__image > a').magnificPopup({
		gallery: { enabled: true },
		type: 'image',
	});

	// password show hide
	if ($('.tp-login-input-eye').length > 0) {
		$('.tp-login-input-eye').each(function () {
			var $this = $(this)

			$this.find('.eye-close').on('click', function () {
				$this.parent().find('input[type="password"]').attr('type', 'text');
				$(this).css('display', 'none');
				$this.find('.eye-open').css('display', 'block');
			})

			$this.find('.eye-open').on('click', function () {
				$this.parent().find('input[type="text"]').attr('type', 'password');
				$(this).css('display', 'none');
				$this.find('.eye-close').css('display', 'block');
			})
		});
	}

	$("[data-course-filter-reset]").on('click', function () {
		var location = $(this).data('course-filter-reset');

		window.location.replace(location);

	})

	if ($('#course_details2_nav').length > 0) {
		$(document).ready(function () {
			$('#course_details2_nav').onePageNav();
		});
	}

	var slider = new Swiper('.acadia-course-related-active', {
		slidesPerView: 3,
		spaceBetween: 30,
		loop: true,
		autoplay: {
			delay: 5000,
		},
		breakpoints: {
			'1200': {
				slidesPerView: 3,
			},
			'992': {
				slidesPerView: 2,
			},
			'768': {
				slidesPerView: 2,
			},
			'576': {
				slidesPerView: 2,
			},
			'0': {
				slidesPerView: 1,
			},
		},
	});

	function tp_header_megamenu() {

		$('li.acadia-megamenu-width-1').each(function () {
			$(this).find('.tp-mega-menu').addClass('tp-megamenu-main tp-megamenu-container');
			$(this).find('.tp-mega-menu').removeClass('tp-submenu submenu tp-mega-menu');
		});

		$('li.acadia-megamenu-width-2').each(function () {
			$(this).find('.tp-mega-menu').addClass('tp-megamenu-main tp-megamenu-small');
			$(this).find('.tp-mega-menu').removeClass('tp-submenu submenu tp-mega-menu');
		});

		$('li.acadia-megamenu-width-3').each(function () {
			$(this).find('.tp-mega-menu').addClass('tp-megamenu-main tp-megamenu-fullwidth');
			$(this).find('.tp-mega-menu').removeClass('tp-submenu submenu tp-mega-menu');
		});

		$('li.acadia-megamenu-width-4').each(function () {
			$(this).find('.tp-mega-menu').addClass('tp-megamenu-main tp-megamenu-academics');
			$(this).find('.tp-mega-menu').removeClass('tp-submenu submenu tp-mega-menu');
		});

		$('li.acadia-megamenu-width-5').each(function () {
			$(this).find('.tp-mega-menu').addClass('tp-megamenu-main tp-megamenu-courses');
			$(this).find('.tp-mega-menu').removeClass('tp-submenu submenu tp-mega-menu');
		});
	}

	tp_header_megamenu();

	if ($('.filter-demo').length > 0) {
		$('.tp-header-2').addClass('tp-header-transparent');
	}


	function acadia_etn_date() {
		const second = 1000,
			minute = second * 60,
			hour = minute * 60,
			day = hour * 24;

		// Get the target date from the data attribute
		const countdownElement = $('.tp-event-details-countdown');
		const targetDate = countdownElement.data('date');

		// Convert the target date to a Date object
		const countDownDate = new Date(targetDate).getTime();

		// Update the countdown every 1 second
		const interval = setInterval(function () {
			const now = new Date().getTime(),
				distance = countDownDate - now;

			// Calculate days, hours, minutes, and seconds
			$('#days').text(Math.floor(distance / day));
			$('#hours').text(Math.floor((distance % day) / hour));
			$('#minutes').text(Math.floor((distance % hour) / minute));
			$('#seconds').text(Math.floor((distance % minute) / second));

			// If the countdown is finished, stop the timer
			if (distance < 0) {
				clearInterval(interval);
				$('#countdown').html("<span class='alert alert-danger'>Event Expired</span>");
			}
		}, 1000); // Update every second
	}
	acadia_etn_date();

	if ($('.tutor-lms').find('.default-breadcrumb').length > 0 && $('.tutor-lms-instructor-profile').length > 0) {
		$('.default-breadcrumb').closest('[data-elementor-type]').hide();
	}

	if ($('.tutor-lms').find('.default-breadcrumb').length > 0 && $('.tp-dashboard-body-bg').length > 0) {
		$('.default-breadcrumb').closest('[data-elementor-type]').hide();
	}



	// new js added

	// 26. Scroll nav class add
	if ($('#course_details2_nav').length > 0) {
		$(document).ready(function () {
			$('#course_details2_nav').onePageNav();
		});
	}

	// 27. Faq class add
	document.querySelectorAll('.faq-expend').forEach(button => {
		button.addEventListener('click', () => {
			const accordionItem = button.closest('.accordion-item');

			// Remove the 'expand' class from all accordion items
			document.querySelectorAll('.accordion-item').forEach(item => {
				item.classList.remove('expand');
			});

			// Add the 'expand' class to the clicked accordion item
			accordionItem.classList.add('expand');
		});
	});



	// 28. Show more/ Show less js
	if ($('.show-more-button').length > 0) {
		document.addEventListener('DOMContentLoaded', function () {
			const showMoreButton = document.querySelector('.show-more-button');
			const content = document.querySelector('.content');

			showMoreButton.addEventListener('click', function () {
				const svgIcon = showMoreButton.querySelector('.svg-icon');
				if (content.classList.contains('show')) {
					content.classList.remove('show');
					showMoreButton.innerHTML = '';
					svgIcon.innerHTML = `
						<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M6 1V11" stroke="#3C66F9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path d="M1 6H11" stroke="#3C66F9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
						</svg>
					`;
					showMoreButton.appendChild(svgIcon);
					showMoreButton.append('Show more');
				} else {
					content.classList.add('show');
					showMoreButton.innerHTML = '';
					svgIcon.innerHTML = `
						<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M1 6H11" stroke="#3C66F9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
						</svg>
					`;
					showMoreButton.appendChild(svgIcon);
					showMoreButton.append('Show less');
				}
			});
		});
	}

	$(document).ready(function () {
		$(".tp-filter-d").on("click", function () {
			$(".tp-filter-dropdown-wrapper-2").slideToggle(300);
		});
	});


	// 29. tp-testimonial-yoga-active
	var slider = new Swiper('.tp-testimonial-yoga-active', {
		slidesPerView: 1,
		spaceBetween: 10,
		loop: true,
		autoplay: {
			delay: 5000,
		},
		navigation: {
			nextEl: ".tp-testimonial-yoga-next",
			prevEl: ".tp-testimonial-yoga-prev",
		},
	});

	// 30. tp-classes-yoga-active

	var slider = new Swiper('.tp-classes-yoga-active', {
		slidesPerView: 4,
		spaceBetween: 27,
		loop: true,
		autoplay: {
			delay: 5000,
		},
		breakpoints: {
			'1400': {
				slidesPerView: 4,
			},
			'1200': {
				slidesPerView: 3,
			},
			'992': {
				slidesPerView: 3,
			},
			'768': {
				slidesPerView: 2,
			},
			'576': {
				slidesPerView: 1,
			},
			'0': {
				slidesPerView: 1,
			},
		},
	});


	// 31. Mouse Custom Cursor
	function tpCursor() {
		var myCursor = $(".mouseCursor");
		if (myCursor.length) {
			if ($("body").length > 0) {
				const $cursorInner = $(".cursor-inner");
				const $cursorOuter = $(".cursor-outer");

				let mouseX = 0,
					mouseY = 0,
					isMoving = false;

				$(window).on("mousemove", function (event) {
					if (!isMoving) {
						$cursorOuter.css("transform", `translate(${event.clientX}px, ${event.clientY}px)`);
						$cursorInner.css("transform", `translate(${event.clientX}px, ${event.clientY}px)`);
						mouseX = event.clientX;
						mouseY = event.clientY;
					}
				});

				$("body").on("mouseenter", "button, a, .cursor-pointer", function () {
					$cursorInner.addClass("cursor-hover");
					$cursorOuter.addClass("cursor-hover");
				});

				$("body").on("mouseleave", "button, a, .cursor-pointer", function () {
					if (!$(this).is("a, button") || !$(this).closest(".cursor-pointer").length) {
						$cursorInner.removeClass("cursor-hover");
						$cursorOuter.removeClass("cursor-hover");
					}
				});

				$cursorInner.css("visibility", "visible");
				$cursorOuter.css("visibility", "visible");
			}
		}
	}
	tpCursor();

	$(".tp-cursor-point-area").on("mouseenter", function () {
		$(".mouseCursor").addClass("cursor-big");
	}).on("mouseleave", function () {
		$(".mouseCursor").removeClass("cursor-big");
	});

	$(".tp-linksa").on("mouseenter", function () {
		$(".mouseCursor").addClass("cursor-hidden");
	}).on("mouseleave", function () {
		$(".mouseCursor").removeClass("cursor-hidden");
	});


	// 32. Parallax Js
	if ($('.scene').length > 0) {
		$('.scene').parallax({
			scalarX: 5.0,
			scalarY: 5.0,
		});
	};
	if ($('.scene-y').length > 0) {
		$('.scene-y').parallax({
			scalarY: 5.0,
			scalarX: 0,
		});
	};


	// 33. tp-brands-3-slider-active
	var tp_brand_slide = new Swiper(".tp-brands-chef-slider-active", {
		loop: true,
		freemode: true,
		slidesPerView: 'auto',
		spaceBetween: 0,
		centeredSlides: true,
		allowTouchMove: false,
		speed: 4000,
		autoplay: {
			delay: 1,
			disableOnInteraction: true,
		},
	});


	// 34. tp-courses-chef-active

	var tp_courses_slider = new Swiper('.tp-courses-chef-active', {
		slidesPerView: 3,
		spaceBetween: 27,
		loop: true,
		autoplay: {
			delay: 5000,
		},
		pagination: {
			el: ".tp-courses-chef-dot",
			clickable: true,
		},
		breakpoints: {
			'1400': {
				slidesPerView: 3,
			},
			'1200': {
				slidesPerView: 3,
			},
			'992': {
				slidesPerView: 2,
			},
			'768': {
				slidesPerView: 2,
			},
			'576': {
				slidesPerView: 1,
			},
			'0': {
				slidesPerView: 1,
			},
		},
	});

	////////////////////////////////////////
	// 35. tp-testimonial-chef-active
	var slider = new Swiper('.tp-testimonial-chef-active', {
		slidesPerView: 1,
		spaceBetween: 10,
		loop: true,
		speed: 1000,
		pagination: {
			el: ".tp-testimonial-chef-dot",
			clickable: true,
		},
	});

	////////////////////////////////////////////////////
	// 36. tp-brands-quran-slider-active
	var tp_brand_slide = new Swiper(".tp-brands-quran-slider-active", {
		loop: false,
		freemode: true,
		slidesPerView: 'auto',
		spaceBetween: 0,
		speed: 4000,
		breakpoints: {
			'1400': {
				slidesPerView: 8,
			},
			'1200': {
				slidesPerView: 6,
			},
			'992': {
				slidesPerView: 5,
			},
			'768': {
				slidesPerView: 4,
			},
			'576': {
				slidesPerView: 2,
			},
			'0': {
				slidesPerView: 1,
			},
		},
	});

	let tp_text_slide = new Swiper(".tp-text-slider-active", {
		loop: true,
		freemode: true,
		spaceBetween: 10,
		slidesPerView: 'auto',
		centeredSlides: true,
		allowTouchMove: false,
		speed: 7000,
		autoplay: {
			delay: 1,
			disableOnInteraction: true,
		},
	});

	function menu_pos() {
		let menu_pos = $("[data-menu]").data("menu");
		let menu_length = $(".tp-main-menu-content ul:first > li").length;
		let logo = $(".yoga-logo-wrap").html();

		let logo_html = `<li class="has-dropdown tp-header-yoga-logo d-none d-xl-inline-block">${logo}</li>`;

		menu_pos = menu_pos > menu_length ? menu_length : menu_pos;

		if (menu_pos == 0) {
			$(".tp-main-menu-content ul:first > li:first-child").before(logo_html);
		} else {
			$(".tp-main-menu-content ul:first > li:nth-child(" + menu_pos + ")").after(logo_html);
		}

	}

	// elementor fronted view
	$(window).on("elementor/frontend/init", function () {
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-slider.default", tp_main_slider
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-academic-programs.default", tp_academic_programs
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-testimonial-slider.default", tp_testimonial_slider
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-instagram.default", tp_instagram_slider
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-team.default", tp_team_slider
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-brand-slider.default", tp_brand_slider
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-slider-shop.default", tp_slider_shop
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-about-year-title.default", tp_about_year_slider
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-02.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-03.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-04.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-05.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-06.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-ecommerce.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-inner.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-yoga.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-kitchen.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-quran.default", tp_header_megamenu
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-header-yoga.default", menu_pos
		);

	});

})(jQuery);