<?php

/**
 * Breadcrumbs for Shofy theme.
 *
 * @package     Shofy
 * @author      Theme_Pure
 * @copyright   Copyright (c) 2023, Theme_Pure
 * @link        https://www.wphix.com
 * @since       acadia 1.0.0
 */

function acadia_breadcrumb_func()
{
    global $post;
    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    global $wp;

    $current_slug = add_query_arg(array(), $wp->request);


    if (is_front_page() && is_home()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'acadia'));
        $breadcrumb_class = 'home_front_page';
    } elseif (is_front_page()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'acadia'));
        $breadcrumb_show = 0;
    } elseif (is_home()) {
        if (get_option('page_for_posts')) {
            $title = get_the_title(get_option('page_for_posts'));
        }
    } elseif (is_single() && 'post' == get_post_type()) {
        $title = get_the_title();
    } elseif ('courses' == get_post_type()) {
        $title = esc_html__('All Courses', 'acadia');
    } elseif (is_single() && 'product' == get_post_type()) {
        $title = get_theme_mod('breadcrumb_product_details', __('Shop', 'acadia'));
    } elseif (is_single() && 'courses' == get_post_type()) {
        $title = esc_html__('Course Details', 'acadia');
    } elseif (is_search()) {
        $title = esc_html__('Search Results for : ', 'acadia') . get_search_query();
    } elseif (is_404()) {
        $title = esc_html__('Page not Found', 'acadia');
    } elseif (is_archive()) {
        $title = get_the_archive_title();
    } else {
        $title = get_dashboard_title($current_slug);
    }


    $_id = get_the_ID() ?? NULL;

    if (is_single() && 'product' == get_post_type()) {
        $_id = $post->ID;
    } elseif (function_exists("is_shop") and is_shop()) {
        $_id = wc_get_page_id('shop');
    } elseif (is_home() && get_option('page_for_posts')) {
        $_id = get_option('page_for_posts');
    }


    // hide breadcrumb on single post
    $hide_breadcrumb_on_single_from_customizer = get_theme_mod('breadcrumb_on_single', false);

    // hide breadcrumb on single course
    $hide_breadcrumb_on_single_courses = get_theme_mod('breadcrumb_on_single_courses', false);

    // hide breadcrumb on product single from customizer
    $hide_breadcrumb_on_product_single_from_customizer = get_theme_mod('acadia_shop_single_details_breadcrumb_hide', false);
    // product single style
    $product_single_style = get_theme_mod('acadia_shop_single_details_style', 'style_default');


    // hide breadcrumb on single post
    if ((is_single() && 'post' == get_post_type()) && ($hide_breadcrumb_on_single_from_customizer == false)) {
        return;
    }

    // hide breadcrumb on single course page
    if ((is_single() && 'courses' == get_post_type()) && ($hide_breadcrumb_on_single_courses == false)) {
        return;
    }

    // hide breadcrumb on product single
    if (is_single() && 'product' == get_post_type() && $hide_breadcrumb_on_product_single_from_customizer == false && $product_single_style == 'style_grid') {
        return;
    }


    // hide breadcrumb from page
    $check_breadcrumb_from_page = function_exists('tpmeta_field') ? tpmeta_field('acadia_is_breadcrumb_on', $_id ? $_id : NULL) : '';

    // hide breadcrumb from customizer globally
    $check_breadcrumb_from_customizer = get_theme_mod('breadcrumb_switch', true);


    // hide breadcrumb based on condition
    if ($check_breadcrumb_from_page == 'off' || $check_breadcrumb_from_customizer == false) {
        return;
    }

    // breadcrumb bg  from page start
    $bg_img_from_page = function_exists('tpmeta_image_field') ? tpmeta_image_field('acadia_breadcrumb_bg') : '';
    $hide_bg_img = function_exists('tpmeta_image_field') ? tpmeta_image_field('acadia_check_bredcrumb_img') : 'on';

    $bg_img = get_theme_mod('breadcrumb_background_setting' , get_template_directory_uri() . '/assets/img/breadcrumb/breadcrumb-bg.jpg');
    
    if ($hide_bg_img == 'off') {
        $bg_main_img = '';
    } else {
        $bg_main_img = !empty($bg_img_from_page) ? $bg_img_from_page['url'] : $bg_img;
    }


    if ($breadcrumb_show == 1) {
        $breadcrumb_attrs = array(
            'class' => 'breadcrumb__area include-bg grey-bg-2 pt-60 pb-60 tp-course-filter-area tp-course-filter-space tp-course-filter-bg p-relative acadia-lms-breadcrumb-padding  acadia-lms-single-breadcrumb ' . $breadcrumb_class,
        );

        $filter = isset($_GET['filter']) ? $_GET['filter'] : '';

        $filter_styles = ['style_1', 'style_2', 'style_3', 'no_sidebar'];

        $breadcrumb_desc_text = get_theme_mod('acadia_lms_course_breadcrumb_desc', 'We have a wide range of courses to help you achieve your goals.');

        if ('courses' == get_post_type() && in_array($filter, $filter_styles)) {
            
            ?>
            <section <?php acadia_html_attrs($breadcrumb_attrs) ?>>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tp-breadcrumb__content-filter mb-50">
                                <div class="tp-breadcrumb__list">
                                    <span>
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none"  xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"  d="M8.07207 0C8.19331 0 8.31107 0.0404348 8.40664 0.114882L16.1539 6.14233L15.4847 6.98713L14.5385 6.25079V12.8994C14.538 13.1843 14.4243 13.4574 14.2225 13.6589C14.0206 13.8604 13.747 13.9738 13.4616 13.9743H2.69231C2.40688 13.9737 2.13329 13.8603 1.93146 13.6588C1.72962 13.4573 1.61597 13.1843 1.61539 12.8994V6.2459L0.669148 6.98235L0 6.1376L7.7375 0.114882C7.83308 0.0404348 7.95083 0 8.07207 0ZM8.07694 1.22084L2.69231 5.40777V12.8994H13.4616V5.41341L8.07694 1.22084Z" fill="currentColor"></path>
                                            </svg>
                                        </a>
                                    </span>
                                    <span class="color"><?php esc_html_e('All Courses', 'acadia'); ?></span>
                                </div>
                                <h3 class="tp-breadcrumb__title"><?php echo acadia_kses($title); ?></h3>

                                <?php if(!empty($breadcrumb_desc_text)): ?>
                                <p><?php echo acadia_kses($breadcrumb_desc_text); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <?php
            return;
        }// end course if

        // get tutor archive page id -> "this code is from tutor plugin" (tutor->classes->Option_V2.php)
        $page_args = array(
            'post_type' => 'page',
            'post_status' => 'publish',
            'posts_per_page' => 1,
            'title' => 'Courses',
        );

        $page_posts = get_posts($page_args);
        $tutor_archive = (is_array($page_posts) && count($page_posts)) ? $page_posts[0] : null;


        // from page meta
        if ('courses' == get_post_type()) {
            $tp_breadcrumb_tabs = function_exists('tpmeta_field') ? tpmeta_field('acadia_breadcrumb_meta_tabs', $tutor_archive ? ($tutor_archive->ID ? $tutor_archive->ID : NULL) : NULL) : false;
            $elementor_breadcrumb_template_meta = function_exists('tpmeta_field') ? tpmeta_field('acadia_breadcrumb_meta_templates', $tutor_archive ? ($tutor_archive->ID ? $tutor_archive->ID : NULL) : false) : false;
        } else {
            $tp_breadcrumb_tabs = function_exists('tpmeta_field') ? tpmeta_field('acadia_breadcrumb_meta_tabs', $_id ? $_id : NULL) : false;
            $elementor_breadcrumb_template_meta = function_exists('tpmeta_field') ? tpmeta_field('acadia_breadcrumb_meta_templates', $_id ? $_id : NULL) : false;
        }


        // from customizer
        $acadia_breadcrumb_option_switch = get_theme_mod('acadia_breadcrumb_elementor_switch', false);
        $elementor_breadcrumb_templates_kirki = get_theme_mod('acadia_breadcrumb_templates_kirki');


        //breadcrumb bg  from page end


        if (($tp_breadcrumb_tabs == 'elementor' || $acadia_breadcrumb_option_switch) && !($tp_breadcrumb_tabs == 'custom')) {
            if ($elementor_breadcrumb_template_meta) {
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_breadcrumb_template_meta);
            } else {
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_breadcrumb_templates_kirki);
            }
        } else {

            ?>

        <!-- breadcrumb start -->
        <section <?php acadia_html_attrs($breadcrumb_attrs) ?>
            data-background="<?php print esc_attr(is_array($bg_main_img) && array_key_exists('background-image', $bg_main_img) ? $bg_main_img['background-image'] : $bg_main_img); ?>">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-sm-12">
                        <div class="tp-breadcrumb__content breadcrumb_content">
                            <div class="tp-breadcrumb__list">
                                <span>
                                    <a href="<?php print esc_url(home_url('/')); ?>">
                                        <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.07207 0C8.19331 0 8.31107 0.0404348 8.40664 0.114882L16.1539 6.14233L15.4847 6.98713L14.5385 6.25079V12.8994C14.538 13.1843 14.4243 13.4574 14.2225 13.6589C14.0206 13.8604 13.747 13.9738 13.4616 13.9743H2.69231C2.40688 13.9737 2.13329 13.8603 1.93146 13.6588C1.72962 13.4573 1.61597 13.1843 1.61539 12.8994V6.2459L0.669148 6.98235L0 6.1376L7.7375 0.114882C7.83308 0.0404348 7.95083 0 8.07207 0ZM8.07694 1.22084L2.69231 5.40777V12.8994H13.4616V5.41341L8.07694 1.22084Z"  fill="currentColor" />
                                        </svg>
                                    </a>
                                </span>
                                <span class="color">
                                    <?php echo acadia_kses($title); ?>
                                </span>
                            </div>

                            <?php if (!empty($title)): ?>
                            <h3 class="tp-breadcrumb__title white tp_acadia_breadcrumb__title breadcrumb__title">
                                <?php echo acadia_kses($title); ?>
                            </h3>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb end -->

<?php
        }
    }
}


add_action('acadia_before_main_content', 'acadia_breadcrumb_func');

function acadia_breadcrumb_func_2()
{
    global $post;
    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    global $wp;

    $current_slug = add_query_arg(array(), $wp->request);


    if (is_front_page() && is_home()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'acadia'));
        $breadcrumb_class = 'home_front_page';
    } elseif (is_front_page()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'acadia'));
        $breadcrumb_show = 0;
    } elseif (is_home()) {
        if (get_option('page_for_posts')) {
            $title = get_the_title(get_option('page_for_posts'));
        }
    } elseif (is_single() && 'post' == get_post_type()) {
        $title = get_the_title();
    } elseif ('courses' == get_post_type()) {
        $title = esc_html__('All Courses', 'acadia');
    } elseif (is_single() && 'product' == get_post_type()) {
        $title = get_theme_mod('breadcrumb_product_details', __('Shop', 'acadia'));
    } elseif (is_single() && 'courses' == get_post_type()) {
        $title = esc_html__('Course Details', 'acadia');
    } elseif (is_search()) {
        $title = esc_html__('Search Results for : ', 'acadia') . get_search_query();
    } elseif (is_404()) {
        $title = esc_html__('Page not Found', 'acadia');
    } elseif (is_archive()) {
        $title = get_the_archive_title();
    } else {
        $title = get_dashboard_title($current_slug);
    }

    $_id = get_the_ID() ?? NULL;

    if (is_single() && 'product' == get_post_type()) {
        $_id = $post->ID;
    } elseif (function_exists("is_shop") and is_shop()) {
        $_id = wc_get_page_id('shop');
    } elseif (is_home() && get_option('page_for_posts')) {
        $_id = get_option('page_for_posts');
    }


        // breadcrumb bg  from page start
        $bg_img_from_page = function_exists('tpmeta_image_field') ? tpmeta_image_field('acadia_breadcrumb_bg') : '';
        $hide_bg_img = function_exists('tpmeta_image_field') ? tpmeta_image_field('acadia_check_bredcrumb_img') : 'on';

        $bg_img = get_theme_mod('breadcrumb_background_setting' , get_template_directory_uri() . '/assets/img/breadcrumb/breadcrumb-bg.jpg');
        
        if ($hide_bg_img == 'off') {
            $bg_main_img = '';
        } else {
            $bg_main_img = !empty($bg_img_from_page) ? $bg_img_from_page['url'] : $bg_img;
        }
        

        $breadcrumb_attrs = array(
            'class' => 'breadcrumb__area include-bg grey-bg-2 pt-60 pb-60 acadia-breadcrumb-padding ' . $breadcrumb_class,
        );

        ?>
        <section <?php acadia_html_attrs($breadcrumb_attrs) ?>
            data-background="<?php print esc_attr(is_array($bg_main_img) && array_key_exists('background-image', $bg_main_img) ? $bg_main_img['background-image'] : $bg_main_img); ?>">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-sm-12">
                        <div class="tp-breadcrumb__content breadcrumb_content">
                            <div class="tp-breadcrumb__list">
                                <span>
                                    <a href="<?php print esc_url(home_url('/')); ?>">
                                        <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M8.07207 0C8.19331 0 8.31107 0.0404348 8.40664 0.114882L16.1539 6.14233L15.4847 6.98713L14.5385 6.25079V12.8994C14.538 13.1843 14.4243 13.4574 14.2225 13.6589C14.0206 13.8604 13.747 13.9738 13.4616 13.9743H2.69231C2.40688 13.9737 2.13329 13.8603 1.93146 13.6588C1.72962 13.4573 1.61597 13.1843 1.61539 12.8994V6.2459L0.669148 6.98235L0 6.1376L7.7375 0.114882C7.83308 0.0404348 7.95083 0 8.07207 0ZM8.07694 1.22084L2.69231 5.40777V12.8994H13.4616V5.41341L8.07694 1.22084Z"
                                                fill="currentColor" />
                                        </svg>
                                    </a>
                                </span>
                                <span class="color">
                                    <?php echo acadia_kses($title); ?>
                                </span>
                            </div>

                            <?php if (!empty($title)): ?>
                            <h3 class="tp-breadcrumb__title white tp_acadia_breadcrumb__title breadcrumb__title">
                                <?php echo acadia_kses($title); ?>
                            </h3>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }

// acadia_search_form
function acadia_search_form()
{ ?>

<!-- search area start -->
<div class="tp-search-area d-none">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="tp-search-form">
                    <div class="tp-search-close text-center mb-20">
                        <button class="tp-search-close-btn tp-search-close-btn"></button>
                    </div>
                    <form action="<?php print esc_url(home_url('/shop')); ?>">
                        <div class="tp-search-input mb-10">
                            <input class="search-input-field" type="text"
                                placeholder="<?php print esc_attr__('Search for product...', 'acadia'); ?>" name="s"
                                value="<?php print esc_attr(get_search_query()) ?>">
                            <button type="submit"><i class="flaticon-search-1"></i></button>
                        </div>
                        <?php if (class_exists('WooCommerce')):
                                $categories = get_terms('product_cat');
                                ?>
                        <div class="tp-search-category">
                            <?php if (!empty($categories) && !is_wp_error($categories)): ?>
                            <span><?php echo esc_html__('Search by :', 'acadia'); ?> </span>

                            <?php foreach ($categories as $key => $category):

                                            $category_link = get_term_link($category);

                                            $comma = $key == array_key_last($categories) ? '' : ',';
                                            ?>
                            <a
                                href="<?php echo esc_url($category_link); ?>"><?php echo esc_html($category->name); ?></a><?php echo esc_html($comma); ?>
                            <?php endforeach; ?>

                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- search area end -->


<?php
}