<?php

use \Etn\Utils\Helper;

function acadia_etn_breadcrumb_callback()
{
    //! Some variables are used in this function, but those can be used in the future.
    global $post;
    $single_event_id = get_the_id();
    $categories = get_the_terms($single_event_id, 'etn_category');
    $etn_terms = get_the_terms($single_event_id, 'etn_tags');
    $event_options = get_option("etn_event_options");
    $data = Helper::single_template_options($single_event_id);


    // Start Time
    $start_time = get_post_meta($single_event_id, 'etn_start_time', true);
    $start_time = DateTime::createFromFormat('g:i A', $start_time);
    $start_time = $start_time->format('H:i');

    // End Time
    $end_time = get_post_meta($single_event_id, 'etn_end_time', true);

    
    // start date + end date
    $etn_timezone = get_post_meta($single_event_id, 'event_timezone', true);
    $etn_start_date = get_post_meta($single_event_id, 'etn_start_date', true);
    $etn_end_date = get_post_meta($single_event_id, 'etn_end_date', true);

    // start date
    $acadia_start_raw = $etn_start_date;
    $acadia_start_date = DateTime::createFromFormat('Y-m-d', $acadia_start_raw);

    // current date
    $current_date = new DateTime();
    $current_date = DateTime::createFromFormat('Y-m-d', $current_date->format('Y-m-d'));


    $categories = get_the_terms(get_the_ID(), 'etn_category');
    $start_date = $etn_start_date;

    if ($start_date) {
        $datetime = DateTime::createFromFormat('Y-m-d H:i', "$start_date $start_time");
        $start_date = $datetime ? $datetime->format('F d, Y h:i A') : '';
    }
    ?>
    <section class="tp-event-details-breadcrumb-area pb-110 p-relative z-index-1 fix acadia-bg-blue"
        data-background="<?php echo esc_url(get_the_post_thumbnail_url()); ?>">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-7">
                    <div class="tp-breadcrumb__list tp-event-details-breadcrumb-list pb-120">
                        <span>
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M8.07207 0C8.19331 0 8.31107 0.0404348 8.40664 0.114882L16.1539 6.14233L15.4847 6.98713L14.5385 6.25079V12.8994C14.538 13.1843 14.4243 13.4574 14.2225 13.6589C14.0206 13.8604 13.747 13.9738 13.4616 13.9743H2.69231C2.40688 13.9737 2.13329 13.8603 1.93146 13.6588C1.72962 13.4573 1.61597 13.1843 1.61539 12.8994V6.2459L0.669148 6.98235L0 6.1376L7.7375 0.114882C7.83308 0.0404348 7.95083 0 8.07207 0ZM8.07694 1.22084L2.69231 5.40777V12.8994H13.4616V5.41341L8.07694 1.22084Z"
                                        fill="currentColor"></path>
                                </svg>
                            </a>
                        </span>
                        <span><?php echo __('Event', 'acadia'); ?></span>
                        <span><?php echo get_the_title(); ?></span>
                    </div>
                    <div class="tp-event-details-breadcrumb-content">
                        <?php if (!empty($categories[0]->name)): ?>
                            <span
                                class="tp-event-details-breadcrumb-subtitle"><?php echo esc_html($categories[0]->name); ?></span>
                        <?php endif; ?>
                        <h4 class="tp-event-details-breadcrumb-title"><?php echo get_the_title(); ?></h4>
                        <?php if ($acadia_start_date < $current_date): ?>
                            <span class="alert alert-danger" role="alert"><?php echo esc_html__('Event Expired', 'acadia'); ?></span>
                        <?php else: ?>
                            <div class="tp-event-details-countdown" data-date="<?php echo esc_attr($start_date); ?>">
                                <div class="tp-event-details-countdown-inner">
                                    <div id="countdown">
                                        <ul>
                                            <li><span id="days"></span><?php echo esc_html__('Days', 'acadia'); ?></li>
                                            <li><span id="hours"></span><?php echo esc_html__('Hours', 'acadia'); ?></li>
                                            <li><span id="minutes"></span><?php echo esc_html__('Minutes', 'acadia'); ?></li>
                                            <li><span id="seconds"></span><?php echo esc_html__('Seconds', 'acadia'); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>


                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
}

add_action('acadia_etn_breadcrumb', 'acadia_etn_breadcrumb_callback');