<?php

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function acadia_widgets_init()
{

    /**
     * blog sidebar
     */
    register_sidebar([
        'name'          => esc_html__('Blog Sidebar', 'acadia'),
        'id'            => 'blog-sidebar',
        'description'   => esc_html__('Set Your Blog Widget', 'acadia'),
        'before_widget' => '<div id="%1$s" class="tp-sidebar-widget sidebar__widget mb-50 %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="tp-sidebar-widget-title sidebar__widget-title">',
        'after_title'   => '</h3>',
    ]);

    /**
     * product sidebar
     */
    register_sidebar([
        'name'          => esc_html__('Product Sidebar', 'acadia'),
        'id'            => 'product-sidebar',
        'description'          => esc_html__('Set Your Product Widget', 'acadia'),
        'before_widget' => '<div id="%1$s" class="tp-shop-widget mb-35 %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="tp-shop-widget-title">',
        'after_title'   => '</h3>',
    ]);


    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    // footer default
    for ($num = 1; $num <= $footer_widgets; $num++) {
        register_sidebar([
            'name'          => sprintf(esc_html__('Footer %1$s', 'acadia'), $num),
            'id'            => 'footer-' . $num,
            'description'   => sprintf(esc_html__('Footer column %1$s', 'acadia'), $num),
            'before_widget' => '<div id="%1$s" class="tp-footer-widget tp-footer-2-widget mb-30 footer-col-2-' . $num . ' %2$s"> <div class="tp-footer-2-widget-menu">',
            'after_widget'  => '</div></div>',
            'before_title'  => '<h4 class="tp-footer-widget-title mb-15">',
            'after_title'   => '</h4>',
        ]);
    }
}
add_action('widgets_init', 'acadia_widgets_init');
