<?php
namespace LearnPress\TemplateHooks\Course;
use LearnPress\Models\Courses;
use LP_Course_Filter;

$course_cat = get_terms( array(
    'taxonomy'   => 'course_category',
    'hide_empty' => false,
) );

$instructors     = get_users(
    array(
        'role__in' => [ LP_TEACHER_ROLE, ADMIN_ROLE ],
        'fields'   => array( 'ID', 'display_name' ),
    )
);

// free
$filter_courses_free          = new LP_Course_Filter();
$filter_courses_free->sort_by = [];
$count_courses_free           = Courses::count_course_free( $filter_courses_free );


// paid
$filter_courses_price              = new LP_Course_Filter();
$filter_courses_price->query_count = true;
$filter_courses_price->sort_by     = [ 'on_paid' ];
$count_courses_paid                = 0;
Courses::get_courses( $filter_courses_price, $count_courses_paid );

$count_course_all = $count_courses_free + $count_courses_paid;

// lavels
$levels = lp_course_level();

$ac_lp_sort_sw = get_theme_mod( 'ac_lp_sort_sw', true );
$ac_lp_cat_sw = get_theme_mod( 'ac_lp_cat_sw', true );
$ac_lp_instructor_sw = get_theme_mod( 'ac_lp_instructor_sw', true );
$ac_lp_price_sw = get_theme_mod( 'ac_lp_price_sw', true );
$ac_lp_skill_sw = get_theme_mod( 'ac_lp_skill_sw', true );

?>
<div class="d-none d-md-block">
    <div class="tp-filter-dropdown-area tp-filter-dropdown-wrapper tp-filter-dropdown-wrapper-2">
        <div class="row row-cols-lg-5 row-cols-md-3 row-cols-sm-2 row-cols-1">
            <?php if( !empty( $ac_lp_sort_sw ) ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Sort by', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-radio">
                        <ul>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="latest"
                                        id="sort_latest" <?php checked(($args['sort_by'] == 'latest'), 1); ?>>
                                    <span><?php echo esc_html__( 'Latest', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="trending"
                                        id="sort_trending" <?php checked(($args['sort_by'] == 'trending'), 1); ?>>
                                    <span><?php echo esc_html__( 'Trending', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="popularity"
                                        id="sort_popular" <?php checked(($args['sort_by'] == 'popularity'), 1); ?>>
                                    <span><?php echo esc_html__( 'Popularity', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="low_high"
                                        id="sort_low_high" <?php checked(($args['sort_by'] == 'low_high'), 1); ?>>
                                    <span><?php echo esc_html__( 'Price: low to high', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="high_low"
                                        id="sort_high_low" <?php checked(($args['sort_by'] == 'high_low'), 1); ?>>
                                    <span><?php echo esc_html__( 'Price: high to low', 'acadia' ); ?></span>
                                </label>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( !empty( $ac_lp_cat_sw ) ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'All categories', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-checkbox">
                        <ul>
                            <?php foreach( $course_cat as $key => $cat ) : 
                                $name  = $cat->name;
                                $slug  = $cat->slug;
                                $count = $cat->count;
                                ?>
                            <li>
                                <label class="from-checkbox">
                                    <input id="<?php echo esc_attr( $slug ); ?>" name='categories'
                                        value="<?php echo esc_attr( $slug ); ?>" type="checkbox"
                                        <?php checked(in_array($slug, $args['categories']), 1)?>>
                                    <span><?php echo $name . ' (' . $count . ')';?></span>
                                </label>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( !empty( $ac_lp_instructor_sw ) ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Instructors', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-checkbox">
                        <ul>
                            <?php 
                                foreach ( $instructors as $instructor ) :
                                $total_course_of_instructor = 0;
                                $filter               = new LP_Course_Filter();
                                $filter->query_count  = true;
                                $filter->post_authors = [ $instructor->ID ];
                                Courses::get_courses( $filter, $total_course_of_instructor );
                                $value    = $instructor->ID;
                                $name  = $instructor->display_name;
                                $count = $total_course_of_instructor;
                                ?>
                            <li>
                                <label class="from-checkbox">
                                    <input id="<?php echo esc_attr( $value ); ?>" type="checkbox" name="instructors"
                                        value="<?php echo esc_html( $value ); ?>"
                                        <?php checked(in_array($value, $args['instructors']), 1)?>>
                                    <span><?php echo esc_html( ucwords( $name ) );  ?>
                                        (<?php echo esc_attr( $count ); ?>)</span>
                                </label>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( !empty( $ac_lp_price_sw ) ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Price', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-radio">
                        <ul>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" value='on_all' name="sort_by_price"
                                        id="sort_on_all" <?php checked(in_array('on_all', $args['sort_by_price']), 1)?>>
                                    <span>
                                        <?php echo esc_html__( 'All', 'acadia' ); ?>
                                        (<?php echo esc_attr( $count_course_all ); ?>)
                                    </span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" value='on_free' name="sort_by_price"
                                        id="sort_on_free" <?php checked(in_array('on_free', $args['sort_by_price']), 1)?>>
                                    <span>
                                        <?php echo esc_html__( 'Free', 'acadia' ); ?>
                                        (<?php echo esc_attr( $count_courses_free ); ?>)
                                    </span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" value='on_paid' name="sort_by_price"
                                        id="sort_on_paid" <?php checked(in_array('on_paid', $args['sort_by_price']), 1)?>>
                                    <span>
                                        <?php echo esc_html__( 'Paid', 'acadia' ); ?>
                                        (<?php echo esc_attr( $count_courses_paid ); ?>)
                                    </span>
                                </label>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( !empty( $ac_lp_skill_sw ) ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Skills Level', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-radio">
                        <ul>
                            <?php 
                                foreach( $levels as $key => $lavel ) : 
    
                                $filter = new LP_Course_Filter();
                                $filter->only_fields = [ 'DISTINCT(ID)' ];
                                $filter->query_count = true;
                                $filter->levels      = [ $key ];
                                $total_courses       = 0;
                                Courses::get_courses( $filter, $total_courses );
                                $name = $lavel;
                                $count = $total_courses;
                                $em_val = '';
                                if( '' == $key ){
                                    $em_val = 'all';
                                }
                                ?>
                            <li>
                                <label class="from-checkbox">
                                    <input id="<?php echo esc_attr( $lavel ); ?>" type="checkbox"
                                        value="<?php echo !empty( $em_val ) ? esc_attr( $em_val ) : esc_attr( $key ); ?>" name="skills"
                                        <?php checked(in_array($key, $args['skills']), 1)?>>
                                    <span><?php echo esc_html( $name ); ?>
                                        (<?php echo esc_html( $count ); ?>)</span>
                                </label>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

</div>