<?php
namespace LearnPress\TemplateHooks\Course;
use LearnPress\Models\Courses;
use LP_Course_Filter;

$course_cat = get_terms( array(
    'taxonomy'   => 'course_category',
    'hide_empty' => false,
) );

$instructors     = get_users(
    array(
        'role__in' => [ LP_TEACHER_ROLE, ADMIN_ROLE ],
        'fields'   => array( 'ID', 'display_name' ),
    )
);

// free
$filter_courses_free          = new LP_Course_Filter();
$filter_courses_free->sort_by = [];
$count_courses_free           = Courses::count_course_free( $filter_courses_free );

// paid
$filter_courses_price              = new LP_Course_Filter();
$filter_courses_price->query_count = true;
$filter_courses_price->sort_by     = [ 'on_paid' ];
$count_courses_paid                = 0;
Courses::get_courses( $filter_courses_price, $count_courses_paid );

// lavels
$levels = lp_course_level();

$ac_lp_cat_sw = get_theme_mod( 'ac_lp_cat_sw', true );
$ac_lp_instructor_sw = get_theme_mod( 'ac_lp_instructor_sw', true );
$ac_lp_price_sw = get_theme_mod( 'ac_lp_price_sw', true );
$ac_lp_skill_sw = get_theme_mod( 'ac_lp_skill_sw', true );
$ac_lp_rating_sw = get_theme_mod( 'ac_lp_rating_sw', true );

?>

<div class="tp-grid-sidebar-left">
    <div class="tp-grid-widget-box">
        <?php if( !empty( $ac_lp_cat_sw ) ) : ?>
        <div class="tp-grid-widget-item">
            <h4 class="tp-grid-widget-title"><?php echo esc_html__( 'All categories', 'acadia' ); ?></h4>
            <div class="tp-grid-widget-content">
                <div class="tp-grid-widget-checkbox">
                    <ul>
                        <?php foreach( $course_cat as $key => $cat ) : 
                        $name  = $cat->name;
                        $slug  = $cat->slug;
                        $count = $cat->count;
                        ?>
                        <li>
                            <label class="from-checkbox">
                                <input class="form-check-input" id="<?php echo esc_attr( $slug ); ?>" name='categories' value="<?php echo esc_attr( $slug ); ?>" type="checkbox" <?php checked(in_array($slug, $args['categories']), 1)?>><span><?php echo $name . ' (' . $count . ')';?></span>
                            </label>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if( !empty( $ac_lp_instructor_sw ) ) : ?>
        <div class="tp-grid-widget-item">
            <h4 class="tp-grid-widget-title"><?php echo esc_html__( 'Instructors', 'acadia' ); ?></h4>
            <div class="tp-grid-widget-content">
                <div class="tp-grid-widget-checkbox">
                    <ul>
                        <?php 
                        foreach ( $instructors as $instructor ) :
                        $total_course_of_instructor = 0;
                        $filter               = new LP_Course_Filter();
                        $filter->query_count  = true;
                        $filter->post_authors = [ $instructor->ID ];
                        Courses::get_courses( $filter, $total_course_of_instructor );
                        $value    = $instructor->ID;
                        $name  = $instructor->display_name;
                        $count = $total_course_of_instructor;
                        ?>
                        <li>
                            <label class="from-checkbox">
                                <input class="form-check-input" id="<?php echo esc_attr( $value ); ?>" type="checkbox" name="instructors" value="<?php echo esc_html( $value ); ?>" <?php checked(in_array($value, $args['ac_instructors']), 1)?>>
                                <span><?php echo esc_html( ucwords( $name ) );  ?> (<?php echo esc_attr( $count ); ?>)</span>
                            </label>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if( !empty( $ac_lp_price_sw ) ) : ?>
        <div class="tp-grid-widget-item">
            <h4 class="tp-grid-widget-title"><?php echo esc_html__( 'Price', 'acadia' ); ?></h4>
            <div class="tp-filter-widget-radio">
                <ul>
                    <li>
                        <label class="form-check">
                            <input class="form-check-input" type="checkbox" value='on_free' name="sort_by" id="sort_on_free" <?php checked(($args['sort_by'] == 'on_free'), 1); ?>>
                            <span>
                                <?php echo esc_html__( 'Free', 'acadia' ); ?> (<?php echo esc_attr( $count_courses_free ); ?>)
                            </span>
                        </label>
                    </li>
                    <li>
                        <label class="form-check">
                            <input class="form-check-input" type="checkbox" value='on_paid' name="sort_by" id="sort_on_paid" <?php checked(($args['sort_by'] == 'on_paid'), 1); ?>>
                            <span>
                                <?php echo esc_html__( 'Paid', 'acadia' ); ?> (<?php echo esc_attr( $count_courses_paid ); ?>)
                            </span>
                        </label>
                    </li>
                </ul>
            </div>
        </div>
        <?php endif; ?>
        <?php if( !empty( $ac_lp_skill_sw ) ) : ?>
        <div class="tp-grid-widget-item">
            <h4 class="tp-grid-widget-title"><?php echo esc_html__( 'Skill Level', 'acadia' ); ?></h4>
            <div class="tp-grid-widget-content">
                <div class="tp-grid-widget-checkbox">
                    <ul>

                        <?php 
                        foreach( $levels as $key => $lavel ) : 

                        $filter = new LP_Course_Filter();
                        $filter->only_fields = [ 'DISTINCT(ID)' ];
                        $filter->query_count = true;
                        $filter->levels      = [ $key ];
                        $total_courses       = 0;
                        Courses::get_courses( $filter, $total_courses );
                        $name = $lavel;
                        $count = $total_courses;
                        
                        ?>
                        <li>
                            <label class="from-checkbox">
                                <input class="form-check-input" id="<?php echo esc_attr( $lavel ); ?>" type="checkbox" value="<?php echo esc_attr( $key ); ?>" name="skills" <?php checked(in_array($key, $args['skills']), 1)?>>
                                <span><?php echo esc_html( $name ); ?> (<?php echo esc_html( $count ); ?>)</span>
                            </label>
                        </li>
                        <?php endforeach; ?>
                        
                    </ul>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if( !empty( $ac_lp_rating_sw ) ) : ?>
        <div class="tp-grid-widget-item">
            <h4 class="tp-grid-widget-title"><?php echo esc_html__( 'Course Rating', '' ); ?></h4>
            <div class="tp-grid-widget-content">
                <div class="tp-grid-widget-checkbox">
                    <ul>
                        <?php for ($i = 1; $i <= 5; $i++) : ?>
                        <li>
                            <label class="from-checkbox">
                                <input class="form-check-input" id="rating-<?php echo $i; ?>" type="checkbox" name="rating" value="<?php echo $i; ?>" <?php checked(($args['rating'] == $i), 1); ?>>
                                <span>
                                    <?php for ($j = 1; $j <= 5; $j++) : ?>
                                        <?php if ($j <= $i) : ?>
                                            <i class="fa-solid fa-star"></i>
                                        <?php else : ?>
                                            <i class="fa-regular fa-star"></i>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                </span> ( <?php echo esc_html( $i . ' Star' );  ?> )
                            </label>
                        </li>
                        <?php endfor; ?>
                    </ul>

                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <div class="tp-grid-widget-btn mt-15">
        <a href="javascript:void(0)" class="clear-filters"> <span>
            <svg width="10" height="10" viewBox="0 0 10 10" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                <path d="M9 1L1 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M1 1L9 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
        </span> <?php echo esc_html__( 'Clear all Filters', 'acadia' ); ?></a>
    </div>
</div>