<?php 

$get_lp_requirements = get_post_meta( $args['id'], '_lp_requirements', true );
$get_lp_target_audiences = get_post_meta( $args['id'], '_lp_target_audiences', true );
$get_lp_key_features = get_post_meta( $args['id'], '_lp_key_features', true );

?>

<?php
if( $get_lp_requirements || $get_lp_target_audiences || $get_lp_key_features ) : 
?>
<div class="tp-faq-box">
    <div class="tpd-accordion">
        <div class="accordion accordion-flush extra-info-tab" id="extraInfoAcordion">

            <?php if( !empty( $get_lp_requirements ) ) : ?>
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#requirements" aria-expanded="true" aria-controls="requirements">
                        <?php echo esc_html__( 'Requirements', 'acadia' ); ?>
                        <span class="accordion-btn"></span>
                    </button>
                </h2>
                <div id="requirements" class="accordion-collapse collapse" data-bs-parent="#extraInfoAcordion">
                    <div class="accordion-body">
                        <ul class="list-group">
                            <?php foreach( $get_lp_requirements as $key => $req ) : ?>
                            <li class="list-group-item"><span><?php echo esc_html( $req ); ?></span></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if( !empty( $get_lp_target_audiences ) ) : ?>
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#features" aria-expanded="false" aria-controls="features">
                        <?php echo esc_html__( 'Features', 'acadia' ); ?>
                        <span class="accordion-btn"></span>
                    </button>
                </h2>
                <div id="features" class="accordion-collapse collapse" data-bs-parent="#extraInfoAcordion">
                    <div class="accordion-body">
                        <ul class="list-group">
                            <?php foreach( $get_lp_target_audiences as $key => $audi ) : ?>
                            <li class="list-group-item"><span><?php echo esc_html( $audi ); ?></span></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if( !empty( $get_lp_key_features ) ) : ?>
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#audiences" aria-expanded="false" aria-controls="audiences">
                        <?php echo esc_html__( 'Target Audiences', 'acadia' ); ?>
                        <span class="accordion-btn"></span>
                    </button>
                </h2>
                <div id="audiences" class="accordion-collapse collapse" data-bs-parent="#extraInfoAcordion">
                    <div class="accordion-body">
                        <ul class="list-group">
                            <?php foreach( $get_lp_key_features as $key => $fea ) : ?>
                            <li class="list-group-item"><span><?php echo esc_html( $fea ); ?></span></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>

        </div>
    </div>
</div>
<?php endif; ?>