<?php
$deadline = '';
$course                  = LP_Global::course();
$acadia_course_video_url = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_video_url') : NULL;
$acadia_course_language = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_language') : NULL;
$acadia_course_deadline = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_deadline') : NULL;
if( !empty( $acadia_course_deadline ) ) {
    $deadline = date('d M Y', strtotime($acadia_course_deadline));;
}
$lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0; 
$quizzes  = $course->count_items( LP_QUIZ_CPT );
$students  = $course->get_users_enrolled();
$level = learn_press_get_post_level( get_the_ID() );
if(!empty($course->get_origin_price())) {
    $old_price = $course->get_origin_price();
}
if(!empty($course->get_price())) {
    $new_price = $course->get_price();
}

$get_lp_address = get_post_meta( get_the_ID(), '_lp_address', true );
$get_lp_deliver_type = get_post_meta( get_the_ID(), '_lp_deliver_type', true );
$get_lp_max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
$get_lp_offline_lesson_count = get_post_meta( get_the_ID(), '_lp_offline_lesson_count', true );

?>

<div class="tp-course-details-3-list sidebar-info-2-off">
    <?php if( !empty( $get_lp_address ) ) : ?>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Location', 'acadia' ); ?></span>
        <span><?php echo esc_html($get_lp_address); ?></span>
    </div>
    <?php endif; ?>
    <?php if( !empty( $get_lp_deliver_type ) ) : ?>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Delivery Type', 'acadia' ); ?></span>
        <span><?php echo esc_html($get_lp_deliver_type); ?></span>
    </div>
    <?php endif; ?>
    <?php if( !empty( $get_lp_max_students ) ) : ?>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Capacity', 'acadia' ); ?></span>
        <span><?php echo esc_html($get_lp_max_students); ?></span>
    </div>
    <?php endif; ?>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Lectures', 'acadia' ); ?></span>
        <span><?php echo esc_html($get_lp_offline_lesson_count); ?></span>
    </div>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Total Students', 'acadia' ); ?></span>
        <span><?php echo esc_html( $students ); ?></span>
    </div>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Duration', 'acadia' ); ?></span>
        <span><?php echo learn_press_get_post_translated_duration( get_the_id()); ?></span>
    </div>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Skill Level', 'acadia' ); ?></span>
        <span><?php echo esc_html( $level ); ?></span>
    </div>
    <?php if( !empty( $acadia_course_language ) ) : ?>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Language', 'acadia' ); ?></span>
        <span><?php echo esc_html( $acadia_course_language ); ?></span>
    </div>
    <?php endif; ?>
    <?php if( !empty( $deadline ) ) : ?>
    <div class="tp-course-details-3-list-item d-flex align-items-center justify-content-between">
        <span><?php echo esc_html__( 'Deadline', 'acadia' ); ?></span>
        <span><?php echo esc_html( $deadline ); ?></span>
    </div>
    <?php endif; ?>
</div>