<?php
$deadline = '';
$course                  = LP_Global::course();
$acadia_course_video_url = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_video_url') : NULL;
$acadia_course_language = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_language') : NULL;
$acadia_course_deadline = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_deadline') : NULL;
if( !empty( $acadia_course_deadline ) ) {
    $deadline = date('d M Y', strtotime($acadia_course_deadline));;
}
$lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0;
$students  = $course->get_users_enrolled();
$level = learn_press_get_post_level( get_the_ID() );
if(!empty($course->get_origin_price())) {
    $old_price = $course->get_origin_price();
}
if(!empty($course->get_price())) {
    $new_price = $course->get_price();
}

$get_lp_address = get_post_meta( get_the_ID(), '_lp_address', true );
$get_lp_deliver_type = get_post_meta( get_the_ID(), '_lp_deliver_type', true );
$get_lp_max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
$get_lp_offline_lesson_count = get_post_meta( get_the_ID(), '_lp_offline_lesson_count', true );
$acadia_lp_details_msg = get_theme_mod( 'acadia_lp_details_msg', esc_html__( '30-Day Money-Back Guarantee', 'acadia' ) );
?>
<div class="tp-course-details-2-widget">
    <?php if( has_post_thumbnail() ) : ?>
    <div class="tp-course-details-2-widget-thumb p-relative">
        <?php the_post_thumbnail( )?>
        <?php if( !empty( $acadia_course_video_url ) ) : ?>
        <a class="popup-video" href="<?php echo esc_url( $acadia_course_video_url ); ?>"><span><svg width="14" height="18" viewBox="0 0 14 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.83167C0 1.0405 0.875246 0.562658 1.54076 0.990487L12.6915 8.15882C13.3038 8.55246 13.3038 9.44754 12.6915 9.84118L1.54076 17.0095C0.875246 17.4373 0 16.9595 0 16.1683V1.83167Z" fill="#031F42" /></svg></span>
        </a>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    <div class="tp-course-details-2-widget-content">
        <div class="tp-course-details-2-widget-price">
            <?php if($course->is_free()): ?>
            <span><?php echo esc_html__('Free','acadia'); ?></span>
            <?php else: ?>
            <span><?php echo esc_html($course->get_price_html()); ?></span>
            <?php if ( $course->get_origin_price() != $course->get_price() ) : ?>
            <span><del><?php echo esc_html($course->get_origin_price_html()); ?></del></span>
            <?php endif; ?>
            <?php endif; ?>
        </div>
        <div class="tp-course-details-2-widget-btn">
            <?php do_action( 'learn-press/course-buttons' ); ?>
            <?php if( !empty( $acadia_lp_details_msg ) ) : ?>
            <p><?php echo esc_html( $acadia_lp_details_msg ); ?></p>
            <?php endif; ?>
        </div>
        <div class="tp-course-details-2-widget-list">
            <h5><?php echo esc_html__( 'This course includes:', 'acadia' ); ?></h5>

            <div class="tp-course-details-2-widget-list-item-wrapper">

                <?php if( !empty( $get_lp_address ) ) : ?>
                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span><i class="fa-regular fa-location-dot"></i> <?php echo esc_html__( 'Location', 'acadia' ); ?></span>
                    <span><?php echo esc_html( $get_lp_address ); ?></span>
                </div>
                <?php endif; ?>

                <?php if( !empty( $get_lp_deliver_type ) ) : ?>
                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span><i class="fa-sharp fa-regular fa-bookmark"></i> <?php echo esc_html__( 'Delivery type', 'acadia' ); ?></span>
                    <span><?php echo esc_html( $get_lp_deliver_type ); ?></span>
                </div>
                <?php endif; ?>

                <?php if( !empty( $get_lp_max_students ) ) : ?>
                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span><i class="fa-regular fa-users"></i> <?php echo esc_html__( 'Capacity', 'acadia' ); ?></span>
                    <span><?php echo esc_html( $get_lp_max_students ); ?></span>
                </div>
                <?php endif; ?>

                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span> <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M8.5 1C12.6415 1 16 4.35775 16 8.5C16 12.6423 12.6415 16 8.5 16C4.35775 16 1 12.6423 1 8.5C1 4.35775 4.35775 1 8.5 1Z"
                                stroke="#4F5158" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M10.8692 8.49618C10.8692 7.85581 7.58703 5.80721 7.2147 6.17556C6.84237 6.54391 6.80657 10.4137 7.2147 10.8168C7.62283 11.2213 10.8692 9.13655 10.8692 8.49618Z"
                                stroke="#4F5158" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg> <?php echo esc_html__( 'Lessons', 'acadia' ); ?></span>
                    <span><?php echo esc_html($get_lp_offline_lesson_count); ?></span>
                </div>

                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span><svg width="13" height="15" viewBox="0 0 13 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z" stroke="#4F5158" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14" stroke="#4F5158" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg> <?php echo esc_html__( 'Total Students', 'acadia' ); ?></span>
                    <span><?php echo esc_html( $students ); ?></span>
                </div>

                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span> <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M8 15C11.866 15 15 11.866 15 8C15 4.13401 11.866 1 8 1C4.13401 1 1 4.13401 1 8C1 11.866 4.13401 15 8 15Z"
                                stroke="#4F5158" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M8 3.80005V8.00005L10.8 9.40005" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                        </svg> <?php echo esc_html__( 'Duration', 'acadia' ); ?></span>
                    <span><?php echo learn_press_get_post_translated_duration( get_the_id()); ?></span>
                </div>
                
                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span> <svg width="11" height="14" viewBox="0 0 11 14" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M5.5 13V5.5" stroke="#4F5158" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M10 13V1" stroke="#4F5158" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M1 13V10" stroke="#4F5158" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </svg> <?php echo esc_html__( 'Skill Level', 'acadia' ); ?></span>
                    <span><?php echo esc_html( $level ); ?></span>
                </div>
                <?php if( !empty( $acadia_course_language ) ) : ?>
                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span> <svg width="16" height="17" viewBox="0 0 16 17" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M8 15.5C11.866 15.5 15 12.366 15 8.5C15 4.63401 11.866 1.5 8 1.5C4.13401 1.5 1 4.63401 1 8.5C1 12.366 4.13401 15.5 8 15.5Z"
                                stroke="#4F5158" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M1 8.5H15" stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path
                                d="M7.99727 1.5C9.74816 3.41685 10.7432 5.90442 10.7973 8.5C10.7432 11.0956 9.74816 13.5832 7.99727 15.5C6.24637 13.5832 5.25134 11.0956 5.19727 8.5C5.25134 5.90442 6.24637 3.41685 7.99727 1.5Z"
                                stroke="#4F5158" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg> <?php echo esc_html__( 'Language', 'acadia' ); ?></span>
                    <span><?php echo esc_html( $acadia_course_language ); ?></span>
                </div>
                <?php endif; ?>
                <?php if( !empty( $deadline ) ) : ?>
                <div class="tp-course-details-2-widget-list-item d-flex align-items-center justify-content-between">
                    <span> <svg width="15" height="16" viewBox="0 0 15 16" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path opacity="0.4" d="M1.06836 6.18286H13.5451" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path opacity="0.4" d="M10.4102 8.91675H10.4194" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path opacity="0.4" d="M7.30273 8.91675H7.312" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path opacity="0.4" d="M4.1875 8.91675H4.19676" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path opacity="0.4" d="M10.4102 11.6375H10.4194" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path opacity="0.4" d="M7.30273 11.6375H7.312" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path opacity="0.4" d="M4.1875 11.6375H4.19676" stroke="#4F5158" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M10.1289 1V3.30355" stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M4.47656 1V3.30355" stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M10.2668 2.10535H4.33967C2.28399 2.10535 1 3.2505 1 5.35547V11.6902C1 13.8283 2.28399 14.9999 4.33967 14.9999H10.2603C12.3225 14.9999 13.6 13.8481 13.6 11.7432V5.35547C13.6065 3.2505 12.329 2.10535 10.2668 2.10535Z"
                                stroke="#4F5158" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg> <?php echo esc_html__( 'Deadline', 'acadia' ); ?></span>
                    <span><?php echo esc_html( $deadline ); ?></span>
                </div>
                <?php endif; ?>

                <div class="tp-course-details-2-widget-share d-flex align-items-center justify-content-between">
                    <span class="share" >
                        <svg width="15" height="16" viewBox="0 0 15 16" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M11.5023 5.2C12.6621 5.2 13.6023 4.2598 13.6023 3.1C13.6023 1.9402 12.6621 1 11.5023 1C10.3425 1 9.40234 1.9402 9.40234 3.1C9.40234 4.2598 10.3425 5.2 11.5023 5.2Z"
                                stroke="#5169F1" stroke-width="1.5" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path
                                d="M3.1 10.1001C4.2598 10.1001 5.2 9.15994 5.2 8.00014C5.2 6.84035 4.2598 5.90015 3.1 5.90015C1.9402 5.90015 1 6.84035 1 8.00014C1 9.15994 1.9402 10.1001 3.1 10.1001Z"
                                stroke="#5169F1" stroke-width="1.5" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path
                                d="M11.5023 15C12.6621 15 13.6023 14.0598 13.6023 12.9C13.6023 11.7403 12.6621 10.8 11.5023 10.8C10.3425 10.8 9.40234 11.7403 9.40234 12.9C9.40234 14.0598 10.3425 15 11.5023 15Z"
                                stroke="#5169F1" stroke-width="1.5" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M4.91406 9.05701L9.69506 11.843" stroke="#5169F1" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.68806 4.15723L4.91406 6.94322" stroke="#5169F1" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <?php echo esc_html__( 'Share this course', 'acadia' ); ?>
                    </span>
                </div>
                <div class="acadia-course-share">
                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="lp-user-ico lp-icon-facebook"></i></a>
                    <a href="https://twitter.com/share?url=<?php the_permalink(); ?>"><i class="lp-user-ico lp-icon-twitter"></i></a>
                    <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>"><i class="lp-user-ico lp-icon-linkedin"></i></a>
                    <a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>"><i class="fa-brands fa-pinterest-p"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>