<?php
$course = LP_Global::course();
$instructor = $course->get_instructor();

$user = get_user_by( 'id', $instructor->get_id());
$pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
$base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
$profile_link =  $base_url.'/'.$pro_link;

$categories = get_the_terms(get_the_ID(), 'course_category');
$tags = get_the_terms(get_the_ID(), 'course_tag');
$modified = get_the_modified_date('j M, Y');
if( function_exists( 'learn_press_get_course_rate' ) ) {
$course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
}
$rated = $course_rate_res['rated'] ?? 0;

$acadia_course_video_url = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_video_url') : NULL;
$acadia_course_language = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_language') : NULL;
$acadia_course_deadline = function_exists('tpmeta_field') ? tpmeta_field('acadia_course_deadline') : NULL;
if( !empty( $acadia_course_deadline ) ) {
    $deadline = date('d M Y', strtotime($acadia_course_deadline));;
}
$lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0; 
$quizzes  = $course->count_items( LP_QUIZ_CPT );
$students  = $course->get_users_enrolled();
$level = learn_press_get_post_level( get_the_ID() );
if(!empty($course->get_origin_price())) {
    $old_price = $course->get_origin_price();
}
if(!empty($course->get_price())) {
    $new_price = $course->get_price();
}

if( !empty( $course->get_origin_price() && $course->get_price() ) && true != $course->is_free() ) {
    $discount_percentage = (($old_price - $new_price) / $old_price) * 100;
    $discount_percentage = round($discount_percentage, 2);
}
$get_lp_offline_course = get_post_meta( get_the_ID(), '_lp_offline_course', true );
$acadia_lp_details_msg = get_theme_mod( 'acadia_lp_details_msg', esc_html__( '30-Day Money-Back Guarantee', 'acadia' ) );

?>


<!-- course details breadcrumb start -->
<section class="tp-breadcrumb__area pt-110 pb-90 p-relative z-index-1">
    <div class="tp-breadcrumb__bg details3" <?php echo has_post_thumbnail() ? 'data-background="'. get_the_post_thumbnail_url() .'"' : ''; ?> ></div>
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <div class="tp-breadcrumb__content">
                    <div class="tp-breadcrumb__list inner-after">
                        <span class="white">
                            <?php
                                if( function_exists( 'acadia_learnpress_course_breadcrumb' ) ) {
                                    echo acadia_learnpress_course_breadcrumb();
                                }
                            ?>
                        </span>
                    </div>

                    <div class="tp-course-details-2-header">
                        <h3 class="tp-course-details-3-title"><?php the_title(); ?></h3>
                        <div class="tp-course-details-3-meta-wrapper d-flex align-items-center flex-wrap">

                            <?php if( !empty( $instructor ) ) : ?>
                            <div class="tp-course-details-2-meta ">
                                <div class="tp-course-details-2-author d-flex align-items-center">
                                    <div class="tp-course-details-2-author-avater">
                                        <?php echo acadia_kses($instructor->get_profile_picture()); ?>
                                    </div>
                                    <div class="tp-course-details-2-author-content">
                                        <span class="tp-course-details-2-author-designation"><?php echo esc_html__( 'Teacher', 'acadia' ); ?></span>
                                        <h3 class="tp-course-details-2-meta-title"><a href="<?php echo esc_url( $instructor->get_url_instructor() ); ?>"><?php echo esc_html($instructor->get_display_name()); ?></a></h3>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if( !empty( $categories ) ) : ?>
                            <div class="tp-course-details-2-meta">
                                <span class="tp-course-details-2-meta-subtitle"><?php echo esc_html__( 'Category', 'acadia' ); ?></span>
                                <h3 class="tp-course-details-2-meta-title">
                                    <?php 
                                    foreach( $categories as $key => $cat ) :
                                        $cot = ''; 
                                        $cat_count = count( $categories );
                                        if( $cat_count > $key+1 ) {
                                            $cot = ',';
                                        }
                                    ?>
                                    <?php echo esc_html( $cat->name . $cot ); ?>
                                    <?php endforeach; ?>
                                </h3>
                            </div>
                            <?php endif; ?>

                            <?php if( !empty( $modified ) ) : ?>
                            <div class="tp-course-details-2-meta">
                                <span class="tp-course-details-2-meta-subtitle"><?php echo esc_html__( 'Last updated', 'acadia' ); ?></span>
                                <h3 class="tp-course-details-2-meta-title"><?php echo esc_html( $modified ); ?></h3>
                            </div>
                            <?php endif; ?>
                            
                            <?php 
                            if( function_exists( 'learn_press_get_course_rate' ) ) {
                            ?>
                            <div class="tp-course-details-2-meta text-end">
                                <div class="tp-course-details-2-meta-rating-wrapper">
                                    <div class="tp-course-rating-icon">
                                        <?php
                                            LP_Addon_Course_Review_Preload::$addon->get_template(
                                                'rating-stars.php',
                                                array( 'rated' => $course_rate_res['rated'] )
                                            );
                                        ?>
                                    </div>
                                    <span class="tp-course-details-2-meta-subtitle"><?php echo esc_html__( 'Reviews', 'acadia' ); ?></span>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-5">
                <div class="tp-course-details-3-widget">
                    <?php if( has_post_thumbnail() ) : ?>
                    <div class="tp-course-details-2-widget-thumb p-relative">
                        <?php the_post_thumbnail( )?>
                        <?php if( !empty( $acadia_course_video_url ) ) : ?>
                        <a class="popup-video" href="<?php echo esc_url( $acadia_course_video_url ); ?>"><span><svg width="14" height="18" viewBox="0 0 14 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.83167C0 1.0405 0.875246 0.562658 1.54076 0.990487L12.6915 8.15882C13.3038 8.55246 13.3038 9.44754 12.6915 9.84118L1.54076 17.0095C0.875246 17.4373 0 16.9595 0 16.1683V1.83167Z" fill="#031F42" /></svg></span>
                        </a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    <div class="tp-course-details-3-widget-content">
                        <div class="tp-course-details-2-widget-price d-flex justify-content-between align-items-center">
                            <div class="price">
                                <?php if($course->is_free()): ?>
                                <span><?php echo esc_html__('Free','acadia'); ?></span>
                                <?php else: ?>
                                <span><?php echo esc_html($course->get_price_html()); ?></span>
                                <?php if ( $course->get_origin_price() != $course->get_price() ) : ?>
                                <span><del><?php echo esc_html($course->get_origin_price_html()); ?></del></span>
                                <?php endif; ?>
                                <?php endif; ?>
                                <?php if( !empty( $discount_percentage ) && 'free' != $course->is_free() ) : ?>
                                <p>-<?php echo esc_html( $discount_percentage . '% off' ); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="tp-course-details-2-widget-btn">
                            <?php do_action( 'learn-press/course-buttons' ); ?>
                            <?php if( !empty( $acadia_lp_details_msg ) ) : ?>
                            <p><?php echo esc_html( $acadia_lp_details_msg ); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="tp-course-details-2-instructor-social text-center">
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="lp-user-ico lp-icon-facebook"></i></a>
                            <a href="https://twitter.com/share?url=<?php the_permalink(); ?>"><i class="lp-user-ico lp-icon-twitter"></i></a>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>"><i class="lp-user-ico lp-icon-linkedin"></i></a>
                            <a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>"><i class="fa-brands fa-pinterest-p"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-7">

                <?php
                    if( 'yes' == $get_lp_offline_course ) {
                        get_template_part( 'learnpress/course-details/sidebar-info-2-off' ); 
                    } else {
                        get_template_part( 'learnpress/course-details/sidebar-info-2' ); 
                    }
                ?>

                <div class="tp-course-details-3-main">

                    <?php
                        if( 'yes' == $get_lp_offline_course ) {
                            get_template_part( 'learnpress/course-details/off-info-2' ); 
                        } else {
                            get_template_part( 'learnpress/course-details/tabs' ); 
                        }
                    ?>

                </div>
            </div>
        </div>
    </div>
</section>
<!-- course details breadcrumb end -->


<!-- course details area start -->
<section class="tp-course-details-2-related-area pb-80">
    <div class="container">
        <div class="tp-course-details-2-related-border"></div>
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-course-details-2-related-heading pt-80">
                    <h3 class="tp-course-details-2-related-title"><?php echo esc_html__( 'Related Courses', 'acadia' ); ?></h3>
                </div>
            </div>
        </div>
        <?php get_related_courses( get_the_ID() ); ?>
    </div>
</section>
<!-- course details area end -->