<?php 
    $post_id = get_the_ID();
    $course_data = apply_filters( 'masterstudy_course_page_header', 'default' ); 

    $is_course_coming_soon = STM_LMS_Helpers::masterstudy_lms_is_course_coming_soon( $post_id );
    $price      = get_post_meta( $post_id, 'price', true );
    $sale_price = STM_LMS_Course::get_sale_price( $post_id );

    if(!empty($price)) {
        $old_price = $price;
    }
    if(!empty($sale_price)) {
        $new_price = $sale_price;
    }
    
    if( !empty( $price && $sale_price ) ) {
        $discount_percentage = (($old_price - $new_price) / $old_price) * 100;
        $discount_percentage = round($discount_percentage, 2);
    }

    STM_LMS_Templates::show_lms_template(
        'components/course/expired',
        array(
            'course'         => $course_data['course'],
            'user_id'        => $course_data['current_user_id'],
            'is_coming_soon' => $course_data['is_coming_soon'],
        )
    );
?>
<main  class='ms-course-details-2'>

    <!-- course details breadcrumb start -->
    <section class="tp-breadcrumb__area pt-110 pb-90 p-relative z-index-1">
        <div class="tp-breadcrumb__bg details3" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/breadcrumb/breadcrumb-bg-3.jpg"></div>
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="tp-breadcrumb__content">
                        <div class="tp-breadcrumb__list inner-after">
                            <?php
                                if( function_exists( 'acadia_masterstudy_course_breadcrumb' ) ) {
                                    echo acadia_masterstudy_course_breadcrumb();
                                }
                            ?>
                        </div>

                        <div class="tp-course-details-2-header">
                            <h3 class="tp-course-details-3-title"><?php the_title(); ?></h3>
                            <?php 
                                if ( ! $course_data['is_coming_soon'] || $course_data['course']->coming_soon_details ) {
                                    ?>
                            <div class="masterstudy-single-course__info">
                                <div class="masterstudy-single-course__info-block">
                                    <?php
                                            STM_LMS_Templates::show_lms_template(
                                                'components/course/instructor',
                                                array(
                                                    'instructor' => $course_data['instructor'],
                                                    'course'     => $course_data['course'],
                                                )
                                            );
                                            ?>
                                </div>
                                <?php if ( ! empty( $course_data['course']->current_students ) ) { ?>
                                <div
                                    class="masterstudy-single-course__info-block masterstudy-single-course__info-block_students">
                                    <?php STM_LMS_Templates::show_lms_template( 'components/course/current-students', array( 'current_students' => $course_data['course']->current_students ) ); ?>
                                </div>
                                <?php
                                        }
                                        if ( ! empty( $course_data['course']->rate ) || ! empty( $course_data['course']->udemy_rate ) ) {
                                            ?>
                                <div class="masterstudy-single-course__info-block">
                                    <?php STM_LMS_Templates::show_lms_template( 'components/course/rating', array( 'course' => $course_data['course'] ) ); ?>
                                </div>
                                <?php } ?>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-5">
                    <div class="tp-course-details-3-widget">
                        <?php if( has_post_thumbnail() ) : ?>
                        <div class="tp-course-details-2-widget-thumb p-relative">
                            <?php the_post_thumbnail(); ?>
                        </div>
                        <?php endif; ?>
                        <div class="tp-course-details-3-widget-content">
                            <div
                                class="tp-course-details-2-widget-price d-flex justify-content-between align-items-center">
                                <div class="price">
                                    <?php
                                        if ( ! $is_course_coming_soon ) {
                                            do_action( 'stm_lms_archive_card_price', compact( 'price', 'sale_price', 'post_id' ) );
                                        }
                                    ?>
                                    <?php if( !empty( $discount_percentage ) ) : ?>
                                    <p class="discount">-<?php echo esc_html( $discount_percentage . '%' ); ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="share p-relative">
                                    <div class="tp-postbox-share">
                                        <button class="p-relative">
                                            <span>
                                                <svg width="14" height="16" viewBox="0 0 14 16" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M11 5.40002C12.1046 5.40002 13.0001 4.52697 13.0001 3.45001C13.0001 2.37305 12.1046 1.5 11 1.5C9.89545 1.5 9 2.37305 9 3.45001C9 4.52697 9.89545 5.40002 11 5.40002Z"
                                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M3.00005 9.95007C4.10464 9.95007 5.00009 9.07702 5.00009 8.00006C5.00009 6.9231 4.10464 6.05005 3.00005 6.05005C1.89545 6.05005 1 6.9231 1 8.00006C1 9.07702 1.89545 9.95007 3.00005 9.95007Z"
                                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M11 14.5001C12.1046 14.5001 13.0001 13.6271 13.0001 12.5501C13.0001 11.4731 12.1046 10.6001 11 10.6001C9.89545 10.6001 9 11.4731 9 12.5501C9 13.6271 9.89545 14.5001 11 14.5001Z"
                                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path d="M4.72656 8.98157L9.28 11.5686" stroke="currentColor"
                                                        stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path d="M9.27333 4.4314L4.72656 7.01841" stroke="currentColor"
                                                        stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                </svg>
                                            </span>
                                        </button>

                                        <ul class="tp-postbox-share-hover">
                                            <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="fab fa-facebook-f"></i> <b>Facebook</b></a></li>
                                            <li><a href="https://twitter.com/share?url=<?php the_permalink(); ?>"><i class="fab fa-twitter"></i> <b>Twitter</b></a></li>
                                            <li><a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>"><i class="fab fa-linkedin"></i> <b>Linkedin</b></a></li>
                                            <li><a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>"><i class="fab fa-pinterest"></i> <b>Pinterest</b></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="tp-course-details-2-widget-btn mb-0">
                                <?php
                                    STM_LMS_Templates::show_lms_template(
                                        'components/course/complete',
                                        array(
                                            'course_id'     => $course_data['course']->id,
                                            'user_id'       => $course_data['current_user_id'],
                                            'settings'      => $course_data['settings'],
                                            'block_enabled' => true,
                                        )
                                    );
                                    if ( ! $course_data['is_coming_soon'] || $course_data['course']->coming_soon_preorder ) {
                                ?>
                                <div class="masterstudy-single-course__cta">
                                    <?php
                                            STM_LMS_Templates::show_lms_template(
                                                'components/buy-button/buy-button',
                                                array(
                                                    'post_id'              => $course_data['course']->id,
                                                    'item_id'              => '',
                                                    'user_id'              => $course_data['current_user_id'],
                                                    'dark_mode'            => false,
                                                    'prerequisite_preview' => false,
                                                    'hide_group_course'    => false,
                                                )
                                            );
                                            ?>
                                </div>
                                <?php
                                        STM_LMS_Templates::show_lms_template( 'components/course/price-info', array( 'course' => $course_data['course'] ) );
                                    }
                                    if ( $course_data['is_coming_soon'] && $course_data['course']->coming_soon_price && ! $course_data['course']->coming_soon_preorder ) {
                                        ?>
                                <div class="masterstudy-single-course__cta">
                                    <?php STM_LMS_Templates::show_lms_template( 'components/course/coming-button' ); ?>
                                </div>
                                <?php
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="tp-course-details-3-list">
                        <?php

                            STM_LMS_Templates::show_lms_template(
                                'components/course/expired',
                                array(
                                    'course'         => $course_data['course'],
                                    'user_id'        => $course_data['current_user_id'],
                                    'is_coming_soon' => $course_data['is_coming_soon'],
                                )
                            );
                            STM_LMS_Templates::show_lms_template( 'components/course/details', array( 'course' => $course_data['course'] ) );
                            if ( $course_data['settings']['course_allow_basic_info'] ) {
                                STM_LMS_Templates::show_lms_template(
                                    'components/course/info',
                                    array(
                                        'course_id' => $course_data['course']->id,
                                        'content'   => $course_data['course']->basic_info,
                                        'title'     => esc_html__( 'Basic info', 'masterstudy-lms-learning-management-system' ),
                                    ),
                                );
                            }
                            if ( $course_data['settings']['course_allow_requirements_info'] ) {
                                STM_LMS_Templates::show_lms_template(
                                    'components/course/info',
                                    array(
                                        'course_id' => $course_data['course']->id,
                                        'content'   => $course_data['course']->requirements,
                                        'title'     => esc_html__( 'Course requirements', 'masterstudy-lms-learning-management-system' ),
                                    ),
                                );
                            }
                            if ( $course_data['settings']['course_allow_intended_audience'] ) {
                                STM_LMS_Templates::show_lms_template(
                                    'components/course/info',
                                    array(
                                        'course_id' => $course_data['course']->id,
                                        'content'   => $course_data['course']->intended_audience,
                                        'title'     => esc_html__( 'Intended audience', 'masterstudy-lms-learning-management-system' ),
                                    ),
                                );
                            }
                        ?>
                    </div>

                    <div class="tp-course-details-3-main">

                        <?php 
                            STM_LMS_Templates::show_lms_template(
                                'components/course/tabs',
                                array(
                                    'course'         => $course_data['course'],
                                    'course_preview' => $course_data['course_preview'] ?? '',
                                    'user_id'        => $course_data['current_user_id'],
                                    'style'          => 'underline',
                                    'with_image'     => true,
                                )
                            );
                        ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- course details breadcrumb end -->


    <!-- course details area start -->
    <section class="tp-course-details-2-related-area pb-80">
        <div class="container">
            <?php STM_LMS_Templates::show_lms_template( 'components/course/related-courses', array( 'course' => $course_data['course'] ) ); ?>
        </div>
    </section>
    <!-- course details area end -->


</main>