<?php
$ac_ms_load_more_sw   = get_theme_mod( 'ac_ms_load_more_sw', 'on' );
$course_order_by      = 'DESC';
$get_ac_ms_course_per = get_theme_mod( 'ac_ms_course_per', 12 );
$args                 = array( 
    'post_type'      => 'stm-courses',
    'orderby'        => 'modified',
    'order'          => $course_order_by,
    'posts_per_page' => $get_ac_ms_course_per,
    'status'         => 'publish'
);

$get_sort_by       = isset($_GET['sort_by']) ? sanitize_text_field( $_GET['sort_by'] ) : '';
$get_categories    = isset($_GET['categories']) ? explode( ',', sanitize_text_field( $_GET['categories'] ) ) : array();
$get_instructors   = isset($_GET['instructors']) ? explode( ',', sanitize_text_field( $_GET['instructors'] ) ) : array();
$get_sort_by_price = isset($_GET['sort_by_price']) ? sanitize_text_field( $_GET['sort_by_price'] ) : '';
$get_search_for    = isset($_GET['search_for']) ? sanitize_text_field( $_GET['search_for'] ) : '';
$get_skills        = isset($_GET['skills']) ? explode( ',', sanitize_text_field( $_GET['skills'] ) ) : array();

// latest
if( !empty( $get_sort_by ) && 'latest' == $get_sort_by ) {
    $args['orderby'] = 'date';
}
// trending
if( !empty( $get_sort_by ) && 'trending' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'current_students';
}
// popular
if( !empty( $get_sort_by ) && 'popularity' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'course_mark_average';
}
// low to high
if( !empty( $get_sort_by ) && 'low_high' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'price';
    $args['order'] = 'ASC';
}
// hight to low
if( !empty( $get_sort_by ) && 'high_low' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'price';
    $args['order'] = 'DESC';
}

// filter by course category
if( !empty( $get_categories ) ) {
    $args['tax_query'] = array(
        'relation' => 'OR',
        array(
            'taxonomy' => 'stm_lms_course_taxonomy',
            'field'    => 'slug',
            'terms'    => $get_categories
        )
    );
}

// filter by course instructor
if( !empty( $get_instructors ) ) {
    $args['author__in'] = $get_instructors;
}


// filter by price
if( !empty( $get_sort_by_price ) && 'on_all' != $get_sort_by_price[0] ) {
    $compare = ( $get_sort_by_price[0] == 'on_free' ) ? '=' : '!=';
    $args['meta_query'] = array(
        array(
            'key'     => 'price',
            'value'   => '',
            'compare' => $compare
        )
    );
}

// filter by skill
if( !empty( $get_skills ) ) {
    $args['meta_query'][] = array(
        array(
            'key'     => 'level',
            'value'   => $get_skills,
            'compare' => 'IN'
        )
    );
}

if(!empty($get_search_for)){
    $args['s'] = $get_search_for;
}

$query = new WP_Query($args);
$total = $query->found_posts;
if ( $total == 0 ) {
    $message = '<p class="message message-error">' . esc_html__( 'No courses found!', 'acadia' ) . '</p>';
    $index   = esc_html__( 'There are no available courses!', 'acadia' );
} elseif ( $total == 1 ) {
    $index = esc_html__( 'Showing only one result', 'acadia' );
} else {

    $course_per   = $get_ac_ms_course_per;
    $course_count = $total;

    if( $course_count <= $course_per ) {
        $index = sprintf(
            esc_html__( 'Showing all courses of %s results', 'acadia' ),
            $course_count
        );
    } else {
        $index = sprintf(
            esc_html__( 'Showing 1 - %s courses of %s results', 'acadia' ),
            $course_per,
            $course_count
        );
    }
}
$filter_args = array(
    'sort_by'       => $get_sort_by,
    'categories'    => $get_categories,
    'instructors'   => $get_instructors,
    'sort_by_price' => $get_sort_by_price,
    'skills'        => $get_skills,
    'index'        => $index,
);
?>
<?php acadia_breadcrumb_func_2(); ?>
<main class='ms-acadia-archive-filter-double'>

    <?php get_template_part('stm-lms-templates/courses/archive-filter-double/filter','features', $filter_args); ?>

    <!-- course grid area start -->
    <section class="">
        <div class="container">
            <?php get_template_part('stm-lms-templates/courses/archive-filter-double/filter','open', $filter_args); ?>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                    <div class="row" data-ac-course-filter-open-content>
                        <?php 
                            if($query->have_posts()):
                                while ($query->have_posts()) : $query->the_post();
                                    get_template_part('stm-lms-templates/courses/archive-filter-double/content-course','grid', $filter_args); 
                                endwhile;
                                wp_reset_postdata();
                            else:
                                echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                            endif;
                        ?>
                    </div>
                </div>
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab" data-ac-course-filter-open-content-list>
                    <?php 
                        if($query->have_posts()):
                            while ($query->have_posts()) : $query->the_post();
                                get_template_part('stm-lms-templates/courses/archive-filter-double/content-course','list', $filter_args); 
                            endwhile;
                            wp_reset_postdata();
                        else:
                            echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                        endif;
                    ?>
                </div>
            </div>
        </div>
    </section>
    <!-- course grid area end -->

    <?php if( $ac_ms_load_more_sw == 'on' ) : ?>
    <div class="col-lg-12">
        <div class="tp-event-inner-pagination pb-100">
            <div class="tp-dashboard-pagination pt-20">
                <div class="load-pagi-wrap text-center">
                    <input class="ac-lp-archive-load-more-3 tp-btn-round mt-20" type="button" value="Load More">
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

</main>