<?php
    $post_id = get_the_ID();
    $instructor_img = get_avatar( get_the_author_meta('ID') );
    $instructor_name = get_the_author_meta('display_name');
    $categories = get_the_terms( get_the_ID(), 'stm_lms_course_taxonomy' );
    $lectures    = STM_LMS_Course::curriculum_info( get_the_ID() );
    $lessons = $lectures['lessons'];
    $current_students = get_post_meta( get_the_ID(), 'current_students', true );
    $rating = get_post_meta(get_the_ID(), 'course_marks', true);
    if (!empty($rating)) {
        $rates = STM_LMS_Course::course_average_rate($rating);
        $average = $rates['average'];
        $percent = $rates['percent'];
        $total = count($rating);
    }
    $is_course_coming_soon = STM_LMS_Helpers::masterstudy_lms_is_course_coming_soon( $post_id );
    $price      = get_post_meta( $post_id, 'price', true );
    $sale_price = STM_LMS_Course::get_sale_price( $post_id );

?>
<div class="tp-course-filter-item mb-25 d-flex">
    <?php if( has_post_thumbnail() ) : ?>
    <div class="tp-course-filter-thumb">
        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
    </div>
    <?php endif; ?>
    <div class="tp-course-filter-content">
        <div class="tp-course-filter-tag d-flex align-items-center justify-content-between mb-10">
            <div class="c-cat">
                <?php foreach( $categories as $key => $cat ) : ?>
                <span class="tag-span"><?php echo esc_html( $cat->name ); ?></span>
                <?php endforeach; ?>
            </div>
            <?php if( !empty( $rating ) ) : ?>
            <div class="tp-course-rating-star">
                <p><?php echo esc_html( $average ); ?><span> <?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                <div class="tp-course-rating-icon">
                    <?php if( !empty( $rating ) ) : ?>
                    <div class="ms_lms_courses_card_item_info_rating_stars">
                        <div class="ms_lms_courses_card_item_info_rating_stars_filled" style="width: <?php echo floatval( $percent ); ?>%;"></div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php else : ?>
            <div class="tp-course-rating-star">
                <p><?php echo esc_html__( '0', 'acadia' ); ?><span> <?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                <div class="tp-course-rating-icon">
                    <i class="fa-regular fa-star"></i>
                    <i class="fa-regular fa-star"></i>
                    <i class="fa-regular fa-star"></i>
                    <i class="fa-regular fa-star"></i>
                    <i class="fa-regular fa-star"></i>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <h4 class="tp-course-filter-title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h4>
        <div class="tp-course-filter-meta">
            <span>
                <?php if( !empty( $instructor_img ) ) : ?>
                <?php echo $instructor_img; ?>
                <?php endif; ?>
                <?php echo !empty($instructor_name) ? ucwords( $instructor_name ) : ''; ?>
            </span>
            <span>
                <svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                    <path d="M7.46118 2.81787V12.4506" stroke="#94928E" stroke-width="1.2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
                <?php echo esc_html( $lessons ) . esc_html__( ' Lessons', 'acadia' ); ?>
            </span>
            <span>
                <svg width="13" height="15" viewBox="0 0 13 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                    <path
                        d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
                <?php echo esc_html( $current_students ) . esc_html__( ' Students', 'acadia' ); ?>
            </span>
        </div>
        <div class="tp-course-filter-p">
            <p><?php echo wp_trim_words( get_the_content(), 15, '...' ); ?></p>
        </div>
        <div class="tp-course-filter-pricing d-flex align-items-center justify-content-between">
            <span>
                <?php
                    $is_course_coming_soon = STM_LMS_Helpers::masterstudy_lms_is_course_coming_soon( $post_id );
                    if ( ! $is_course_coming_soon ) {
                        do_action( 'stm_lms_archive_card_price', compact( 'price', 'sale_price', 'post_id' ) );
                    }
                ?>
            </span>
            <div class="tp-course-filter-btn">
                <a href="<?php the_permalink(); ?>"><?php echo esc_html__( 'Preview This Course', 'acadia' ); ?></a>
            </div>
        </div>
    </div>
</div>
