<?php
$ac_ms_search_sw = get_theme_mod( 'ac_ms_search_sw', 'on' );
$ac_ms_sort_sw = get_theme_mod( 'ac_ms_sort_sw', 'on' );

stm_lms_register_style( 'courses_filters' );
stm_lms_register_script( 'courses_filters', array( 'stm-lms-courses' ) ); 
?>

<div class="tp-course-grid-sidebar p-relative">
	<div class="row">

		<div class="col-sm-7">
			<div class="tp-course-grid-sidebar-left d-flex align-items-center mb-30">
				<div class="tp-course-grid-sidebar-search p-relative mr-10 d-none d-lg-block">
					<div class="lms_courses search">
						<?php if( $ac_ms_search_sw == 'on' ) : ?>
						<?php STM_LMS_Templates::show_lms_template( 'courses/advanced_filters/filters/search' ); ?>
						<?php endif; ?>
					</div>
				</div>
				<div class="tp-course-grid-sidebar-tab tp-tab">
					<div class="courses_filters__activities">
						<div class="lms_courses sort">
							<div class="courses_filters__switcher">
								<i class="stmlms-grid stc active" data-view="grid"></i>
								<i class="stmlms-list stc" data-view="list"></i>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="col-sm-5">
			<div class="courses_filters mb-30">
				<div class="courses_filters__activities d-inline-block">
					<div class="lms_courses sort">
						<?php if( $ac_ms_sort_sw == 'on' ) : ?>
						<div class="stm_lms_courses_grid__sort">
							<span class="sort_label heading_font"><?php esc_html_e( 'Sort By:', 'masterstudy-lms-learning-management-system' ); ?></span>
							<select class="no-search">
								<option value="date_high"><?php esc_html_e( 'Release date (newest first)', 'masterstudy-lms-learning-management-system' ); ?></option>
								<option value="date_low"><?php esc_html_e( 'Release date (oldest first)', 'masterstudy-lms-learning-management-system' ); ?></option>
								<option value="price_high"><?php esc_html_e( 'Price high', 'masterstudy-lms-learning-management-system' ); ?></option>
								<option value="price_low"><?php esc_html_e( 'Price low', 'masterstudy-lms-learning-management-system' ); ?></option>
								<option value="rating"><?php esc_html_e( 'Overall Rating', 'masterstudy-lms-learning-management-system' ); ?></option>
								<option value="popular"><?php esc_html_e( 'Popular (most viewed)', 'masterstudy-lms-learning-management-system' ); ?></option>
							</select>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>

	</div>
</div>
