<?php

/**
 * Template part for displaying post btn
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package acadia
 */

$acadia_blog_btn = get_theme_mod('acadia_blog_btn', 'Read More');
$acadia_blog_btn_switch = get_theme_mod('acadia_blog_btn_switch', true);

?>

<?php if (!empty($acadia_blog_btn_switch)) : ?>
    <div class="postbox__read-more tp-postbox-btn">
        <a href="<?php the_permalink(); ?>" class="tp-btn-border-lg">
            <?php print esc_html($acadia_blog_btn); ?>
            <span>
                <svg width="8" height="12" viewBox="0 0 8 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1.5 11L6.5 6L1.5 1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                </svg>
            </span>
        </a>
    </div>

<?php endif; ?>